/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.Util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.logging.Logger;

public class WitsmlMarshal {
    private static final Logger LOG = Logger.getLogger(WitsmlMarshal.class.getName());

    public static <T> T deserialize(String witsml, Class witsmlClass) throws JAXBException {
        StringReader witsmlReader = new StringReader(witsml);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{witsmlClass});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (T)JAXBIntrospector.getValue((Object)jaxbUnmarshaller.unmarshal((Reader)witsmlReader));
    }

    public static String serialize(Object witsmlObj) throws JAXBException {
        StringWriter witsmlWriter = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{witsmlObj.getClass()});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.marshal(witsmlObj, (Writer)witsmlWriter);
        return witsmlWriter.toString();
    }

    public static <T> String serializeToJSON(T witsmlObj) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        om.setDateFormat((DateFormat)new StdDateFormat());
        return om.writerWithDefaultPrettyPrinter().writeValueAsString(witsmlObj);
    }

    public static <T> T deserializeFromJSON(String json, Class witsmlClass) throws IOException {
        ObjectMapper om = new ObjectMapper();
        om.setDateFormat((DateFormat)new StdDateFormat());
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (T)om.readValue(json, witsmlClass);
    }
}

