/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.Util.log;

import com.hashmapinc.tempus.WitsmlObjects.Util.log.AbstractDataTrace;
import com.hashmapinc.tempus.WitsmlObjects.Util.log.ColumnarDataTrace;
import com.hashmapinc.tempus.WitsmlObjects.Util.log.DepthLogTrace;
import com.hashmapinc.tempus.WitsmlObjects.Util.log.TimeLogTrace;
import com.hashmapinc.tempus.WitsmlObjects.v1411.CsLogCurveInfo;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjLog;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjLogs;
import java.util.ArrayList;
import java.util.List;

public class LogDataHelper {
    public static List<AbstractDataTrace> processData(ObjLogs log) {
        if (log.getLog().size() > 1) {
            throw new IllegalArgumentException("Object cannot contain more than one log per request");
        }
        ArrayList<AbstractDataTrace> curves = new ArrayList<AbstractDataTrace>();
        ObjLog logToProcess = log.getLog().get(0);
        for (int i = 0; i < logToProcess.getLogCurveInfo().size(); ++i) {
            if (i == 0) continue;
            curves.add(LogDataHelper.createDataTrace(logToProcess.getIndexType(), logToProcess.getLogCurveInfo().get(i)));
        }
        return LogDataHelper.fillTraceValues(logToProcess, curves);
    }

    public static List<ColumnarDataTrace> getColumnarDataPoints(ObjLogs log, boolean omitNulls) {
        if (log.getLog().size() > 1) {
            throw new IllegalArgumentException("Object cannot contain more than one log per request");
        }
        ArrayList<ColumnarDataTrace> traces = new ArrayList<ColumnarDataTrace>();
        ObjLog logToProcess = log.getLog().get(0);
        for (int i = 0; i < logToProcess.getLogCurveInfo().size(); ++i) {
            ColumnarDataTrace trace;
            if (i == 0 || (trace = LogDataHelper.createColumnarDataTrace(logToProcess.getIndexType(), logToProcess.getName(), logToProcess.getUid(), logToProcess.getLogCurveInfo().get(i), logToProcess.getUidWellbore(), logToProcess.getUidWell())) == null) continue;
            traces.add(trace);
        }
        return LogDataHelper.fillColumnarValues(logToProcess, traces, omitNulls);
    }

    public static List<ColumnarDataTrace> getColumnarDataPoints(ObjLogs log, boolean omitNulls, String typeConvertFilter) {
        if (log.getLog().size() > 1) {
            throw new IllegalArgumentException("Object cannot contain more than one log per request");
        }
        ArrayList<ColumnarDataTrace> traces = new ArrayList<ColumnarDataTrace>();
        ObjLog logToProcess = log.getLog().get(0);
        for (int i = 0; i < logToProcess.getLogCurveInfo().size(); ++i) {
            ColumnarDataTrace trace;
            if (i == 0 || (trace = LogDataHelper.createColumnarDataTrace(logToProcess.getIndexType(), logToProcess.getName(), logToProcess.getUid(), logToProcess.getLogCurveInfo().get(i), logToProcess.getUidWellbore(), logToProcess.getUidWell())) == null) continue;
            traces.add(trace);
        }
        return LogDataHelper.fillColumnarValues(logToProcess, traces, omitNulls, typeConvertFilter);
    }

    private static List<ColumnarDataTrace> fillColumnarValues(ObjLog log, List<ColumnarDataTrace> traces, boolean omitNulls, String typeConvertFilter) {
        log.getLogData().get(0).getData().forEach(logData -> {
            String[] data = logData.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            for (int i = 0; i < data.length - 1; ++i) {
                if (i == 0 || omitNulls && data[i].equals("")) continue;
                ((ColumnarDataTrace)traces.get(i)).createDataPoint(data[0], data[i], typeConvertFilter);
            }
        });
        return traces;
    }

    private static List<ColumnarDataTrace> fillColumnarValues(ObjLog log, List<ColumnarDataTrace> traces, boolean omitNulls) {
        log.getLogData().get(0).getData().forEach(logData -> {
            String[] data = logData.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            for (int i = 0; i < data.length - 1; ++i) {
                if (i == 0 || omitNulls && data[i].equals("")) continue;
                ((ColumnarDataTrace)traces.get(i)).createDataPoint(data[0], data[i]);
            }
        });
        return traces;
    }

    private static ColumnarDataTrace createColumnarDataTrace(String indexType, String logName, String logUid, CsLogCurveInfo info, String wellboreId, String wellId) {
        ColumnarDataTrace trace = null;
        if (indexType.equals("measured depth") || indexType.equals("vertical depth") || indexType.equals("length")) {
            switch (info.getTypeLogData()) {
                case "int": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "byte": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "long": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "float": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "short": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "double": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "string": 
                case "date time": 
                case "unknown": 
                case "string16": 
                case "string40": {
                    trace = new ColumnarDataTrace();
                }
            }
        } else if (indexType.equals("date time") || indexType.equals("elapsed time")) {
            switch (info.getTypeLogData()) {
                case "int": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "byte": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "long": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "float": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "short": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "double": {
                    trace = new ColumnarDataTrace();
                    break;
                }
                case "string": 
                case "date time": 
                case "unknown": 
                case "string16": 
                case "string40": {
                    trace = new ColumnarDataTrace();
                }
            }
        }
        if (trace == null) {
            return null;
        }
        trace.setLogName(logName);
        trace.setLogUid(logUid);
        trace.setMnemonic(info.getMnemonic().getValue());
        trace.setUnitOfMeasure(info.getUnit());
        trace.setWellboreUid(wellboreId);
        trace.setWellUid(wellId);
        return trace;
    }

    public static String getCSV(ObjLog log, Boolean withUnits) {
        StringBuilder builder = new StringBuilder();
        builder.append(log.getLogData().get(0).getMnemonicList()).append(System.lineSeparator());
        if (withUnits.booleanValue()) {
            builder.append(log.getLogData().get(0).getUnitList()).append(System.lineSeparator());
        }
        log.getLogData().get(0).getData().forEach(csLogData -> builder.append((String)csLogData).append(System.lineSeparator()));
        return builder.toString();
    }

    private static AbstractDataTrace createDataTrace(String indexType, CsLogCurveInfo info) {
        AbstractDataTrace trace = null;
        if ("measured depth".equals(indexType) || "vertical depth".equals(indexType) || "length".equals(indexType)) {
            switch (info.getTypeLogData()) {
                case "int": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "byte": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "long": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "float": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "short": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "double": {
                    trace = new DepthLogTrace();
                    break;
                }
                case "string": 
                case "date time": 
                case "unknown": 
                case "string16": 
                case "string40": {
                    trace = new DepthLogTrace();
                }
            }
        } else if ("date time".equals(indexType) || "elapsed time".equals(indexType)) {
            switch (info.getTypeLogData()) {
                case "int": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "byte": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "long": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "float": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "short": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "double": {
                    trace = new TimeLogTrace();
                    break;
                }
                case "string": 
                case "date time": 
                case "unknown": 
                case "string16": 
                case "string40": {
                    trace = new TimeLogTrace();
                }
            }
        }
        trace.setMneumoic(info.getMnemonic().getValue());
        trace.setUnitOfMeasure(info.getUnit());
        return trace;
    }

    private static List<AbstractDataTrace> fillTraceValues(ObjLog log, List<AbstractDataTrace> traces) {
        log.getLogData().get(0).getData().forEach(logData -> {
            String[] data = logData.split(",");
            for (int i = 0; i < data.length - 1; ++i) {
                if (i == 0) continue;
                ((AbstractDataTrace)traces.get(i)).getValues().put(data[0], data[i]);
            }
        });
        return traces;
    }
}

