/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import model2_1.SBdb;
import model2_1.Userdef;
import org.jdom2.Element;
import util.SB;
import util.SBException;

public class Audit
implements Comparable<Audit> {
    public static final String CREATOR = "creator";
    public static final String CREATED = "created";
    public static final String MODIFIER = "modifier";
    public static final String MODIFIED = "modified";
    public static final String UPDATER = "updater";
    public static final String UPDATED = "updated";
    int creator;
    Date created;
    int modifier;
    Date modified;
    int updater;
    Date updated;
    public static final String[] AUDIT_TABLES = new String[]{"ABNSCHME", "ANALY_HDR", "BCMMNTS", "CASING", "CMPSTD", "CORES", "ENV_SCH", "EVENTDIC", "EVENTS", "GENUS", "GROUPSET", "IGD", "IGD_DICT", "IGD_ENV", "IGD_HDR", "IGD_SCH", "INTCMMNTS", "INTERP", "LOC", "LOG_CURVE", "OVERLAY", "SAMPLES", "SBCHARTS", "SBSLITH", "SBSSR", "SBWLLST", "SMPDTL", "SPECIES", "SQPICK", "SURFACE", "TAXONOCC", "TXGROUP", "WELLS", "WELLSMARK", "CHART", "CHARTCORR", "CHTBLOCK", "CHTPANL", "CHRON", "IGD_DICT_LSTRAT", "IGD_LSTRAT"};
    static Date serverDate;

    public Audit(ResultSet rs) throws SQLException {
        this.creator = rs.getInt(CREATOR);
        this.created = rs.getTimestamp(CREATED);
        this.modifier = rs.getInt(MODIFIER);
        this.modified = rs.getTimestamp(MODIFIED);
        this.updater = rs.getInt(UPDATER);
        this.updated = rs.getTimestamp(UPDATED);
        if (this.updated == null) {
            this.updated = Calendar.getInstance().getTime();
        }
    }

    public Audit(ResultSet rs, String alias) throws SQLException {
        this.creator = rs.getInt(alias + CREATOR);
        this.created = rs.getTimestamp(alias + CREATED);
        this.modifier = rs.getInt(alias + MODIFIER);
        this.modified = rs.getTimestamp(alias + MODIFIED);
        this.updater = rs.getInt(alias + UPDATER);
        this.updated = rs.getTimestamp(alias + UPDATED);
    }

    public Audit(Audit rhs) {
        if (rhs == null) {
            return;
        }
        this.creator = rhs.creator;
        if (rhs.created != null) {
            this.created = new Date(rhs.created.getTime());
        }
        this.modifier = rhs.modifier;
        if (rhs.modified != null) {
            this.modified = new Date(rhs.modified.getTime());
        }
        this.updater = rhs.updater;
        if (rhs.updated != null) {
            this.updated = new Date(rhs.updated.getTime());
        }
    }

    public Audit(int creator, Date created, int modifier, Date modified) {
        this.creator = creator;
        this.created = created;
        this.modifier = modifier;
        this.modified = modified;
    }

    public Audit() {
    }

    public static String sqlFieldString() {
        return "creator,created,modifier,modified,updater,updated";
    }

    public static String sqlFieldString(String alias) {
        return alias + ".creator AS " + alias + "creator," + alias + ".created AS " + alias + "created," + alias + ".modifier AS " + alias + "modifier," + alias + ".modified AS " + alias + "modified," + alias + ".updater AS " + alias + "updater," + alias + ".updated AS " + alias + UPDATED;
    }

    public Audit(SBdb db, SBdb ws, Audit rhs) throws SQLException, SBException {
        if (rhs.creator > 0) {
            this.creator = Audit.getDBUserID(db, ws, rhs.creator);
        }
        this.created = rhs.created;
        if (rhs.modifier > 0) {
            this.modifier = Audit.getDBUserID(db, ws, rhs.modifier);
        }
        this.modified = rhs.modified;
    }

    static int getDBUserID(SBdb db, SBdb ws, int wsID) throws SBException, SQLException {
        int userID = 0;
        Userdef user = ws.getUser(wsID);
        if (user == null) {
            throw new SBException("No user found in workspace for user ID : " + wsID);
        }
        if (user.getLink() == null) {
            if ((user = db.getUser(user.getAbr())) != null) {
                userID = user.getUsrID();
            }
        } else {
            userID = user.getLink().getUsrID();
        }
        return userID;
    }

    public static void setServerDate(SBdb db, Statement stmt) throws SQLException {
        serverDate = stmt != null ? Audit.getDatabaseServerDate(db, stmt) : null;
    }

    public String sqlInsert(SBdb db, Statement stmt) throws SQLException {
        if (this.creator == 0) {
            this.creator = db.getUserID();
        }
        if (this.created == null) {
            this.created = new Date();
        }
        if (this.modifier == 0) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null) {
            this.modified = new Date();
        }
        this.updater = db.getUserID();
        this.updated = serverDate == null ? Audit.getDatabaseServerDate(db, stmt) : serverDate;
        return this.creator + ",'" + SB.DBdf.format(this.created) + "'," + this.modifier + ",'" + SB.DBdf.format(this.modified) + "'," + this.updater + ",'" + SB.DBdtf.format(this.updated) + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date getDatabaseServerDate(SBdb db, Statement stmt) throws SQLException {
        if (db.dbType == SBdb.DBType.SQLITE) {
            return new Date();
        }
        Object sql = "SELECT ";
        sql = db.dbType == SBdb.DBType.ORACLE ? (String)sql + "SYSDATE AS DT FROM DUAL" : (db.dbType == SBdb.DBType.MSSQLSERVER ? (String)sql + "getdate() as DT" : (String)sql + "now() AS DT");
        boolean createStatement = false;
        if (stmt == null) {
            stmt = db.getDatabase().createStatement();
            createStatement = true;
        }
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery((String)sql));
            Date date = new Date();
            if (rs.next()) {
                date = rs.getTimestamp("dt");
            }
            Date date2 = date;
            return date2;
        }
        finally {
            if (createStatement) {
                stmt.close();
            }
        }
    }

    public String sqlUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
        if (this.modifier == 0 || !preserveModification) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null || !preserveModification) {
            this.modified = new Date();
        }
        this.updater = db.getUserID();
        this.updated = Audit.getDatabaseServerDate(db, stmt);
        return "modifier=" + this.modifier + ",modified='" + SB.DBdf.format(this.modified) + "',updater=" + db.getUserID() + ",updated='" + SB.DBdtf.format(this.updated) + "'";
    }

    public AuditUpdate createUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
        return new AuditUpdate(db, stmt, preserveModification);
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent) throws IOException {
        return this.writeXML(out, indent, 0);
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent, int singleUserID) throws IOException {
        LinkedList<Integer> userIDList = new LinkedList<Integer>();
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<Audit>");
        if (this.created == null && this.creator == 0 && this.modifier == 0 && this.modified == null) {
            out.write("</Audit>\n");
            return userIDList;
        }
        out.write("\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        if (this.created != null) {
            out.write(ind2 + "<Created>" + SB.DBdf.format(this.created) + "</Created>\n");
        }
        if (this.creator > 0) {
            out.write(ind2 + "<Creator>" + (singleUserID > 0 ? singleUserID : this.creator) + "</Creator>\n");
            userIDList.add(this.creator);
        }
        if (this.modified != null) {
            out.write(ind2 + "<Modified>" + SB.DBdf.format(this.modified) + "</Modified>\n");
        }
        if (this.modifier > 0) {
            out.write(ind2 + "<Modifier>" + (singleUserID > 0 ? singleUserID : this.modifier) + "</Modifier>\n");
            userIDList.add(this.modifier);
        }
        out.write(ind1 + "</Audit>\n");
        return userIDList;
    }

    public Audit(SBdb db, Element xml) throws ParseException, SQLException, SBException {
        String strg = xml.getChildTextNormalize("Created");
        if (strg != null) {
            this.created = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Creator")) != null) {
            this.creator = Integer.parseInt(strg);
            if (db.getUser(this.creator) == null) {
                System.out.println("Warning: user not found for userID: " + this.creator + " in Audit 'creator' entry");
            }
        }
        if ((strg = xml.getChildTextNormalize("Modified")) != null) {
            this.modified = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Modifier")) != null) {
            this.modifier = Integer.parseInt(strg);
            if (db.getUser(this.modifier) == null) {
                System.out.println("Warning: user not found for userID: " + this.modifier + " in Audit 'modifier' entry");
            }
        }
    }

    public void fillWorkspace(SBdb db, SBdb ws) throws SQLException, SBException {
        assert (db.isConnected() && !ws.isConnected());
        if (this.creator > 0) {
            ws.fillUser(db, this.creator);
        }
        if (this.modifier > 0) {
            ws.fillUser(db, this.modifier);
        }
    }

    void setAnalyst(int analyst) {
        this.creator = analyst;
        this.modifier = analyst;
        this.updater = analyst;
    }

    public String toString(SBdb sbdb, boolean includeCreated) {
        Object label = "";
        if (includeCreated && this.created != null) {
            label = (String)label + "Created " + SB.df.format(this.created);
            if (this.creator > 0) {
                try {
                    label = (String)label + " by " + sbdb.getUser(this.creator).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        if (!(this.modified == null || this.created != null && this.modified.equals(this.created))) {
            if (!((String)label).isEmpty()) {
                label = (String)label + "; ";
            }
            label = (String)label + "Modified " + SB.df.format(this.modified);
            if (this.modifier > 0) {
                try {
                    label = (String)label + " by " + sbdb.getUser(this.modifier).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        return label;
    }

    public Date getCreated() {
        if (this.created != null) {
            return new Date(this.created.getTime());
        }
        return null;
    }

    public int getCreator() {
        return this.creator;
    }

    public Date getModified() {
        if (this.modified != null) {
            return new Date(this.modified.getTime());
        }
        return null;
    }

    public Date getUpdated() {
        if (this.updated != null) {
            return new Date(this.updated.getTime());
        }
        return null;
    }

    public int getModifier() {
        return this.modifier;
    }

    @Override
    public int compareTo(Audit comp) {
        if (comp.updated == null && this.updated == null) {
            return 0;
        }
        if (comp.updated == null) {
            return 1;
        }
        if (this.updated == null) {
            return -1;
        }
        return comp.updated.compareTo(this.updated);
    }

    public class AuditUpdate {
        private final int uModifier;
        private final int uUpdater;
        private final Date uModified;
        private final Date uUpdated;

        private AuditUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
            this.uModifier = Audit.this.modifier == 0 || !preserveModification ? db.getUserID() : Audit.this.modifier;
            this.uModified = Audit.this.modified == null || !preserveModification ? new Date() : Audit.this.modified;
            this.uUpdater = db.getUserID();
            this.uUpdated = Audit.getDatabaseServerDate(db, stmt);
        }

        public String getSql() {
            return "modifier=" + this.uModifier + ",modified='" + SB.DBdf.format(this.uModified) + "',updater=" + this.uUpdater + ",updated='" + SB.DBdtf.format(this.uUpdated) + "'";
        }

        public void doUpdate() {
            Audit.this.modified = this.uModified;
            Audit.this.modifier = this.uModifier;
            Audit.this.updated = this.uUpdated;
            Audit.this.updater = this.uUpdater;
        }
    }
}

