/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model2_1.AgeConfidence;
import model2_1.Audit;
import model2_1.CompositeStandardEvent;
import model2_1.DEXFile;
import model2_1.SBEvent;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Taxon;
import model2_1.Userdef;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsEdit;
import util.SbugsLink;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class CompositeStandard
extends SBRestrictable
implements SbugsStatus,
SbugsLink,
Comparable {
    private final SBdb sbdb;
    private final int stdID;
    private List<CompositeStandardEvent> events;
    private String name = null;
    private double minAge;
    private double maxAge;
    private double topCSU;
    private double baseCSU;
    private boolean isAgeScale = true;
    private int parentSchID;
    private Audit audit;
    private Color status = UNKNOWN;
    private CompositeStandard link;

    private CompositeStandard(SBdb sbdb, int stdID) {
        super("CMPSTD", "STD_ID", false, true);
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create composite with null model");
        }
        this.sbdb = sbdb;
        if (stdID <= 0) {
            throw new IllegalArgumentException("Attempt to create composite with illegal ID: " + stdID);
        }
        this.stdID = stdID;
    }

    CompositeStandard(SBdb sbdb, int stdID, String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent.Builder> builders, Audit audit, int parentSchID) throws InvalidFieldException, SQLException, SBPermissionException {
        super("CMPSTD", "STD_ID", false, true);
        if (name == null || name.isEmpty()) {
            throw new InvalidFieldException("Attempt to create composite with no name");
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create composite with null or disconnected model");
        }
        if (stdID <= 0) {
            throw new IllegalArgumentException("Attempt to create composite with illegal ID: " + stdID);
        }
        this.name = name;
        this.minAge = minAge;
        this.maxAge = maxAge;
        this.topCSU = topCSU;
        this.baseCSU = baseCSU;
        this.isAgeScale = ageScale;
        this.sbdb = sbdb;
        this.audit = audit == null ? new Audit() : audit;
        this.events = this.validateFields(builders);
        this.stdID = stdID;
        this.parentSchID = parentSchID;
        this.store();
        this.setAcm(0);
    }

    CompositeStandard(SBdb ws, CompositeStandard rhs) throws SQLException, SBException {
        super("CMPSTD", "STD_ID", false, true);
        this.copyPrimitives(rhs);
        this.stdID = rhs.stdID;
        this.sbdb = ws;
        this.audit = new Audit(rhs.audit);
        this.audit.fillWorkspace(rhs.sbdb, ws);
        this.link = rhs;
        this.events = new LinkedList<CompositeStandardEvent>();
        rhs.loadEvents();
        for (CompositeStandardEvent event : rhs.events) {
            this.events.add(CompositeStandard.copyEventToWorkspace(ws, rhs.sbdb, event));
        }
    }

    private static CompositeStandardEvent copyEventToWorkspace(SBdb ws, SBdb db, CompositeStandardEvent dbEvent) throws SQLException, SBException {
        CompositeStandardEvent.Builder builder = CompositeStandardEvent.Builder.copyOf(dbEvent);
        builder.event(ws.fillEvent(db, dbEvent.getEvent()));
        builder.audit.fillWorkspace(db, ws);
        return builder.build(ws);
    }

    CompositeStandard(CompositeStandard rhs, SBdb db) throws SQLException, SBException, SBPermissionException {
        super("CMPSTD", "STD_ID", false, true);
        this.sbdb = db;
        this.copyPrimitives(rhs);
        this.events = new LinkedList<CompositeStandardEvent>();
        for (CompositeStandardEvent event : rhs.events) {
            if (event.getEvent().getLink() == null) {
                throw new SBException("Cannot create composite standard: event not linked for: " + event);
            }
            this.events.add(new CompositeStandardEvent.Builder().event(event.getEvent().getLink()).csu(event.getCSU()).type(event.getType()).build(db));
        }
        this.audit = new Audit(db, rhs.sbdb, rhs.audit);
        this.status = NOTSTORED;
        this.link = null;
        this.stdID = db.nextControl("CMPSTD", "STD_ID");
        this.store();
        this.setAcm(0);
    }

    public boolean equalsCompositeEvents(List<CompositeStandardEvent.Builder> builders) {
        if (this.events.size() != builders.size()) {
            return false;
        }
        for (CompositeStandardEvent e : this.events) {
            boolean found = false;
            for (CompositeStandardEvent.Builder b : builders) {
                if (b.getEvent().getEvID() != e.getEvID() || b.getType() != e.getType() || !(Math.abs(b.getCSU() - e.getCSU()) < 1.0E-4) || !this.isFuncEquivalent(b.getErrPlus(), e.getErrPlus()) || !this.isFuncEquivalent(b.getErrMinus(), e.getErrMinus()) || b.getConfidence() != e.getConfidence() || !SB.equal((Object)b.getComments(), (Object)e.getComments())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isFuncEquivalent(Double f1, Double f2) {
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return false;
        }
        return Math.abs(f1 - f2) < 1.0E-4;
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public int getStdID() {
        return this.stdID;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object rhs) {
        return this.name.compareToIgnoreCase(rhs.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompositeStandard load(SBdb sbdb, int id, CompositeStandard cmpStd) throws SQLException, SBException {
        if (cmpStd != null && cmpStd.getStdID() != id) {
            throw new IllegalArgumentException("Attempt to refresh composite standard using different ID");
        }
        String sql = "SELECT name,minage,maxage,topcsu,basecsu,units," + Audit.sqlFieldString() + ",acm,parent FROM " + sbdb.DBTableName("CMPSTD") + " WHERE std_id=" + id;
        Statement stmt = sbdb.getDatabase().createStatement();
        CompositeStandard temp = new CompositeStandard(sbdb, id);
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                temp.name = rs.getString("name");
                temp.minAge = rs.getDouble("minage");
                temp.maxAge = rs.getDouble("maxage");
                temp.topCSU = rs.getDouble("topcsu");
                temp.baseCSU = rs.getDouble("basecsu");
                temp.isAgeScale = SB.getDBChar((ResultSet)rs, (String)"units") != 'C';
                temp.audit = new Audit(rs);
                temp.setAcm(rs.getInt("acm"));
                temp.parentSchID = rs.getInt("parent");
            }
            if (cmpStd != null) {
                cmpStd.name = temp.name;
                cmpStd.minAge = temp.minAge;
                cmpStd.maxAge = temp.maxAge;
                cmpStd.topCSU = temp.topCSU;
                cmpStd.baseCSU = temp.baseCSU;
                cmpStd.isAgeScale = temp.isAgeScale;
                cmpStd.audit = temp.audit;
                cmpStd.parentSchID = temp.parentSchID;
                cmpStd.setAcm(temp.getAcm());
            }
        }
        finally {
            stmt.close();
        }
        return cmpStd != null ? cmpStd : temp;
    }

    CompositeStandardEvent refresh(Statement stmt) throws SQLException, SBException {
        if (this.events == null) {
            return null;
        }
        Object sql = "SELECT ev_type,ev_id,updated FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID;
        sql = this.sbdb.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        CompositeStandardEvent notifier = null;
        HashSet<CallSite> keys = new HashSet<CallSite>();
        while (rs.next()) {
            String key = rs.getString("ev_type") + "_" + rs.getInt("ev_id");
            keys.add((CallSite)((Object)key));
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (CompositeStandardEvent o : this.events) {
                if (!(o.getEvType() + "_" + o.getEvID()).equals(key)) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                CompositeStandardEvent.loadEvent(this.sbdb, this.stdID, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = CompositeStandardEvent.loadEvent(this.sbdb, this.stdID, key, null);
            this.events.add(notifier);
        }
        if (keys.size() < this.events.size()) {
            Iterator<CompositeStandardEvent> it = this.events.iterator();
            while (it.hasNext()) {
                CompositeStandardEvent o = it.next();
                if (keys.contains(o.getEvType() + "_" + o.getEvID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    static List<CompositeStandard> loadAll(SBdb sbdb) throws SQLException {
        LinkedList<CompositeStandard> stds = new LinkedList<CompositeStandard>();
        String sql = "SELECT std_id,name,minage,maxage,topcsu,basecsu,units," + Audit.sqlFieldString() + ",acm,parent FROM " + sbdb.DBTableName("CMPSTD") + " ORDER BY name";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int id = rs.getInt("std_id");
                CompositeStandard std = new CompositeStandard(sbdb, id);
                std.status = STORED;
                std.name = rs.getString("name");
                std.minAge = rs.getDouble("minage");
                std.maxAge = rs.getDouble("maxage");
                std.topCSU = rs.getDouble("topcsu");
                std.baseCSU = rs.getDouble("basecsu");
                std.isAgeScale = SB.getDBChar((ResultSet)rs, (String)"units") != 'C';
                std.audit = new Audit(rs);
                std.setAcm(rs.getInt("acm"));
                std.parentSchID = rs.getInt("parent");
                stds.add(std);
            }
        }
        return stds;
    }

    public final void loadEvents() throws SQLException {
        if (this.events != null) {
            return;
        }
        this.events = new LinkedList<CompositeStandardEvent>();
        if (this.sbdb.isConnected()) {
            Object sql = "SELECT ev_id,ev_type,csu,confidence,comments,";
            if (this.sbdb.hasEventErrRange()) {
                sql = (String)sql + "csuplus,csuminus,";
            }
            sql = (String)sql + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID + " ORDER BY ev_id";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
                while (rs.next()) {
                    int evID = rs.getInt("ev_id");
                    SBEvent.EventType type = SBEvent.EventType.getType(rs.getString("ev_type"));
                    SBEvent sbEvent = this.sbdb.getSBEvent(evID);
                    if (sbEvent.getEvID() <= 0) continue;
                    CompositeStandardEvent.Builder builder = new CompositeStandardEvent.Builder();
                    builder.type(type).event(sbEvent).csu(rs.getDouble("csu")).confidence(AgeConfidence.getConfidence(rs.getInt("confidence"))).comment(rs.getString("comments"));
                    if (this.sbdb.hasEventErrRange()) {
                        Double f = rs.getDouble("csuplus");
                        if (!rs.wasNull()) {
                            builder.errPlus(f);
                        }
                        f = rs.getDouble("csuminus");
                        if (!rs.wasNull()) {
                            builder.errMinus(f);
                        }
                    }
                    builder.audit(new Audit(rs));
                    CompositeStandardEvent e = builder.build(this.sbdb);
                    e.setStatus(STORED);
                    this.events.add(e);
                }
            }
        }
    }

    private void copyPrimitives(CompositeStandard rhs) {
        this.name = rhs.name;
        this.minAge = rhs.minAge;
        this.maxAge = rhs.maxAge;
        this.topCSU = rhs.topCSU;
        this.baseCSU = rhs.baseCSU;
        this.isAgeScale = rhs.isAgeScale;
    }

    public double getCSU(double age) {
        if (this.isAgeScale) {
            return age;
        }
        if (this.maxAge - this.minAge == 0.0) {
            return 0.0;
        }
        return SB.round((double)(age * (this.baseCSU - this.topCSU) / (this.maxAge - this.minAge) - this.minAge), (int)6);
    }

    public double getAge(double CSU) {
        return CompositeStandard.getAge(CSU, this.isAgeScale, this.minAge, this.maxAge, this.topCSU, this.baseCSU);
    }

    public static double getAge(double CSU, boolean isAgeScale, double minAge, double maxAge, double topCSU, double baseCSU) {
        if (isAgeScale) {
            return CSU;
        }
        if (baseCSU - topCSU == 0.0) {
            return 0.0;
        }
        return SB.round((double)((CSU - topCSU) * (maxAge - minAge) / (baseCSU - topCSU) + minAge), (int)6);
    }

    public double getAge(int evID, SBEvent.EventType type) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != evID || event.getType() != type) continue;
            return this.getAge(event.getCSU());
        }
        return -1.0;
    }

    public double getMinAge(int evID, SBEvent.EventType type) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != evID || event.getType() != type) continue;
            if (this.sbdb.hasEventErrRange() && event.getErrMinus() != null) {
                return this.getAge(event.getCSU() - event.getErrMinus());
            }
            return this.getAge(event.getCSU());
        }
        return -1.0;
    }

    public double getMaxAge(int evID, SBEvent.EventType type) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != evID || event.getType() != type) continue;
            if (this.sbdb.hasEventErrRange() && event.getErrPlus() != null) {
                return this.getAge(event.getCSU() + event.getErrPlus());
            }
            return this.getAge(event.getCSU());
        }
        return -1.0;
    }

    public double getSpecAge(int specID, SBEvent.EventType evType) throws SBException {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvent().getSpecID() != specID || !event.getEvent().isGenerate() || evType != event.getType()) continue;
            return this.getAge(event.getCSU());
        }
        return -1.0;
    }

    void sort(int sort) {
        CompositeStandardEvent.sort(this.events, sort);
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    private void store() throws SQLException, SBPermissionException {
        if (this.stdID <= 0 || this.sbdb == null) {
            throw new IllegalStateException("Attempt to store composite with no ID or model");
        }
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "composite standard", true));
                }
                String sql = "INSERT INTO " + this.sbdb.DBTableName("CMPSTD") + " (std_id,name,minage,maxage,topcsu,basecsu,units,parent," + Audit.sqlFieldString() + ") VALUES (" + this.stdID + "," + SB.DBString((String)this.name) + "," + this.minAge + "," + this.maxAge + "," + (Serializable)(this.isAgeScale ? "NULL" : Double.valueOf(this.topCSU)) + "," + (Serializable)(this.isAgeScale ? "NULL" : Double.valueOf(this.baseCSU)) + "," + SB.DBChar((char)(this.isAgeScale ? (char)'A' : 'C')) + "," + (Serializable)(this.parentSchID > 0 ? Integer.valueOf(this.parentSchID) : "NULL") + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                for (CompositeStandardEvent event : this.events) {
                    sql = "INSERT INTO " + this.sbdb.DBTableName("CMPSTDEV") + " (std_id,ev_id,ev_type,csu,";
                    if (this.sbdb.hasEventErrRange()) {
                        if (event.getErrPlus() != null) {
                            sql = sql + "csuplus,";
                        }
                        if (event.getErrMinus() != null) {
                            sql = sql + "csuminus,";
                        }
                    }
                    sql = sql + "confidence,comments," + Audit.sqlFieldString() + ") VALUES (" + this.stdID + "," + event.getEvID() + "," + SB.DBChar((char)event.getType().getChar()) + "," + event.getCSU();
                    if (this.sbdb.hasEventErrRange()) {
                        if (event.getErrPlus() != null) {
                            sql = sql + "," + event.getErrPlus();
                        }
                        if (event.getErrMinus() != null) {
                            sql = sql + "," + event.getErrMinus();
                        }
                    }
                    sql = sql + "," + event.getConfidence().getDBint() + "," + SB.DBString((String)event.getComments()) + "," + event.getAuditObj().sqlInsert(this.sbdb, stmt) + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    event.setStatus(STORED);
                }
            }
        }
    }

    void delete() throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "composite standard", true));
            }
            String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " set std_id=NULL where std_id=" + this.stdID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE from " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE from " + this.sbdb.DBTableName("CMPSTD") + " WHERE std_id=" + this.stdID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
        this.setChanged();
    }

    public void deleteEvents(LinkedList<CompositeStandardEvent> toKill) throws SQLException, SBPermissionException {
        if (toKill == null || toKill.isEmpty()) {
            return;
        }
        this.loadEvents();
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "composite standard", true));
                }
                for (CompositeStandardEvent e : toKill) {
                    String sql = "DELETE from " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID + " AND ev_id=" + e.getEvID() + " AND ev_type" + (String)(e.getType().isSingle() ? " IS NULL" : "=" + SB.DBChar((char)e.getType().getChar()));
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
                String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTD") + " set " + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + this.getID();
                stmt.executeUpdate(sql);
            }
        }
        for (CompositeStandardEvent e : toKill) {
            this.events.remove(e);
        }
    }

    public List<CompositeStandardEvent> getEventsByCSU(boolean isIncreasing) {
        if (isIncreasing) {
            this.sort(2);
        } else {
            this.sort(1);
        }
        return this.getEvents();
    }

    public List<CompositeStandardEvent> getEventsByAlpha() {
        this.sort(0);
        return this.getEvents();
    }

    public List<CompositeStandardEvent> getEvents() {
        if (this.events == null) {
            return null;
        }
        return new LinkedList<CompositeStandardEvent>(this.events);
    }

    public String getName() {
        return this.name;
    }

    public double getMinAge() {
        return this.minAge;
    }

    public double getMaxAge() {
        return this.maxAge;
    }

    public double getTopCSU() {
        return this.topCSU;
    }

    public double getBaseCSU() {
        return this.baseCSU;
    }

    public boolean isAgeScale() {
        return this.isAgeScale;
    }

    CompositeStandard(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        super("CMPSTD", "STD_ID", false, true);
        this.sbdb = ws;
        this.stdID = Integer.parseInt(xml.getChildTextNormalize("ID"));
        this.name = xml.getChildText("Name");
        System.out.println("constructing standard, name is: " + this.name);
        String strg = xml.getChildTextNormalize("MinAge");
        if (strg != null) {
            this.minAge = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("MaxAge")) != null) {
            this.maxAge = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("TopCSU")) != null) {
            this.topCSU = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseCSU")) != null) {
            this.baseCSU = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("Units")) != null && strg.length() > 0) {
            this.isAgeScale = strg.charAt(0) != 'C';
        }
        this.events = new LinkedList<CompositeStandardEvent>();
        for (Element xmlEv : xml.getChildren("CompositeStandardEvent")) {
            this.events.add(CompositeStandardEvent.parse(ws, xmlEv).build(ws));
        }
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for event: " + this);
        }
        this.status = NOTSTORED;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException, SQLException, SBException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<CompositeStandard Name=\"" + this.getName() + "\">\n");
        out.write((String)ind + "<Name>" + this.getName() + "</Name>\n");
        out.write((String)ind + "<ID>" + this.stdID + "</ID>\n");
        if (Math.abs(this.minAge) > (double)0.0029f || Math.abs(this.maxAge) > (double)0.0029f) {
            out.write((String)ind + "<MinAge>" + this.minAge + "</MinAge>\n");
            out.write((String)ind + "<MaxAge>" + this.maxAge + "</MaxAge>\n");
        }
        if (!this.isAgeScale) {
            out.write((String)ind + "<TopCSU>" + this.topCSU + "</TopCSU>\n");
            out.write((String)ind + "<BaseCSU>" + this.baseCSU + "</BaseCSU>\n");
            out.write((String)ind + "<Units>CSU</Units>\n");
        }
        this.loadEvents();
        for (CompositeStandardEvent event : this.events) {
            out.write((String)ind + "<CompositeStandardEvent Name=\"" + SB.getXMLstring((String)event.toString()) + "\">\n");
            event.writeXML(out, (String)ind + (String)ind);
            out.write((String)ind + "</CompositeStandardEvent>\n");
        }
        this.audit.writeXML(out, indent);
        out.write("</CompositeStandard>\n");
    }

    private void checkBuilder(CompositeStandardEvent.Builder builder, boolean checkCSURange) throws InvalidFieldException {
        block7: {
            block8: {
                if (this.events == null) {
                    throw new IllegalStateException("Cannot insert into null events list");
                }
                if (!checkCSURange) break block7;
                if (builder.getCSU() < (this.isAgeScale ? this.minAge : this.topCSU)) break block8;
                double d = builder.getCSU();
                double d2 = this.isAgeScale ? this.maxAge : this.baseCSU;
                if (!(d > d2)) break block7;
            }
            throw new InvalidFieldException("New " + (this.isAgeScale ? "age" : "CSU") + " falls outside range of section");
        }
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != builder.getEvent().getEvID()) continue;
            if (event.getType() == builder.getType()) {
                throw new InvalidFieldException("Cannot insert duplicate event into composite: " + event.toString());
            }
            if (builder.getType() == SBEvent.EventType.TOP && builder.getCSU() > event.getCSU()) {
                throw new InvalidFieldException("Top event cannot be older than existing base event for: " + event.toString());
            }
            if (builder.getType() != SBEvent.EventType.BASE || !(builder.getCSU() < event.getCSU())) continue;
            throw new InvalidFieldException("Base event cannot be younger than existing top event for: " + event.toString());
        }
    }

    public boolean checkCSU(CompositeStandardEvent cmpStdEvent, double csu) {
        if (this.events == null) {
            throw new IllegalStateException("Cannot check against null events list");
        }
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != cmpStdEvent.getEvID() || event.getEvType() == cmpStdEvent.getEvType()) continue;
            if (cmpStdEvent.getEvType() == 'F' && csu > event.getCSU()) {
                return false;
            }
            if (cmpStdEvent.getEvType() != 'L' || !(csu < event.getCSU())) continue;
            return false;
        }
        return true;
    }

    public boolean checkCSU(CompositeStandardEvent.Builder builder) {
        return CompositeStandard.checkCSU(builder, this.events);
    }

    private static boolean checkCSU(CompositeStandardEvent.Builder builder, List<CompositeStandardEvent> events) {
        double csu = builder.getCSU();
        if (events == null) {
            throw new IllegalStateException("Cannot check csu against null events list");
        }
        for (CompositeStandardEvent event : events) {
            if (event.getEvID() != builder.getEvent().getEvID() || event.getType() == builder.getType()) continue;
            if (builder.getType() == SBEvent.EventType.TOP && csu > event.getCSU()) {
                return false;
            }
            if (builder.getType() != SBEvent.EventType.BASE || !(csu < event.getCSU())) continue;
            return false;
        }
        return true;
    }

    public boolean hasEvent(CompositeStandardEvent.Builder builder, CompositeStandardEvent orig) {
        if (this.events == null) {
            throw new IllegalStateException("Cannot check hasEvent with null events list");
        }
        for (CompositeStandardEvent event : this.events) {
            if (orig != null && event == orig || event.getEvID() != builder.getEvent().getEvID() || event.getType() != builder.getType()) continue;
            return true;
        }
        return false;
    }

    public List<String> getOccs() throws SQLException, SBException {
        ArrayList<String> occs = new ArrayList<String>();
        String sql = "SELECT l.name, p.descr FROM " + this.sbdb.DBTableName("CHTPANL") + " p LEFT JOIN " + this.sbdb.DBTableName("SBWLLST") + " l ON  p.proj_id=l.id WHERE p.std_id=" + this.stdID + " ORDER BY name,descr";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                String proj = rs.getString("name");
                if (proj == null || proj.isEmpty()) {
                    proj = "Global";
                }
                occs.add("Template Panels: " + proj + ", " + rs.getString("descr"));
            }
        }
        return occs;
    }

    private List<CompositeStandardEvent> validateFields(List<CompositeStandardEvent.Builder> builders) throws InvalidFieldException {
        LinkedList<CompositeStandardEvent> newEvents = null;
        if (builders == null) {
            return newEvents;
        }
        if (this.events == null || !this.equalsCompositeEvents(builders)) {
            newEvents = CompositeStandard.validateBuilders(builders, this.sbdb);
        }
        if (this.isAgeScale) {
            this.topCSU = 0.0;
            this.baseCSU = 0.0;
        }
        for (CompositeStandardEvent event : newEvents != null ? newEvents : this.events) {
            double d = event.getCSU();
            double d2 = this.isAgeScale ? this.minAge : this.topCSU;
            if (d < d2) {
                if (this.isAgeScale) {
                    this.minAge = event.getCSU();
                } else {
                    this.topCSU = event.getCSU();
                }
            }
            double d3 = event.getCSU();
            double d4 = this.isAgeScale ? this.maxAge : this.baseCSU;
            if (!(d3 > d4)) continue;
            if (this.isAgeScale) {
                this.maxAge = event.getCSU();
                continue;
            }
            this.baseCSU = event.getCSU();
        }
        return newEvents;
    }

    public static LinkedList<CompositeStandardEvent> validateBuilders(List<CompositeStandardEvent.Builder> builders, SBdb sbdb) throws InvalidFieldException {
        LinkedList<CompositeStandardEvent> newEvents = new LinkedList<CompositeStandardEvent>();
        block0: for (CompositeStandardEvent.Builder b : builders) {
            b.verify();
            for (CompositeStandardEvent.Builder b2 : builders) {
                if (b2 == b || b2.getEvent().getEvID() != b.getEvent().getEvID() || b2.getType() != b.getType()) continue;
                if (sbdb == null || sbdb.isConnected()) {
                    throw new InvalidFieldException("Duplicate event: " + b.getEvent().getName());
                }
                System.out.println("Rejecting duplicate event: " + b.getEvent().getName());
                continue block0;
            }
            if (!CompositeStandard.checkCSU(b, newEvents)) {
                String msg = b.getType() == SBEvent.EventType.TOP ? "Top is older than base for '" + b.getEvent() + "'" : "Base is younger than top for '" + b.getEvent() + "'";
                if (sbdb == null || sbdb.isConnected()) {
                    throw new InvalidFieldException(msg);
                }
                System.out.println("Rejecting event: " + msg);
                continue;
            }
            newEvents.add(b.build(sbdb));
        }
        return newEvents;
    }

    public void update(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent.Builder> builders, int parentSchID) throws InvalidFieldException, SQLException, SBPermissionException {
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "composite standard", true));
        }
        List<CompositeStandardEvent> newEvents = this.validateFields(builders);
        this.updateFields(name, minAge, maxAge, topCSU, baseCSU, ageScale, newEvents, parentSchID);
    }

    private void updateFields(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent> newEvents, int parentSchID) throws InvalidFieldException, SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTD") + " SET name=" + SB.DBString((String)name) + ",minage=" + minAge + ",maxage=" + maxAge + ",topcsu=" + (Serializable)(this.isAgeScale ? "NULL" : Double.valueOf(topCSU)) + ",basecsu=" + (Serializable)(this.isAgeScale ? "NULL" : Double.valueOf(baseCSU)) + ",units=" + SB.DBString((String)(this.isAgeScale ? "A" : "C")) + ",parent=" + (Serializable)(parentSchID > 0 ? Integer.valueOf(parentSchID) : "NULL") + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + this.stdID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (newEvents != null) {
                sql = "DELETE FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                for (CompositeStandardEvent event : newEvents) {
                    sql = "INSERT INTO " + this.sbdb.DBTableName("CMPSTDEV") + " (std_id,ev_id,ev_type,csu,confidence,comments,";
                    if (this.sbdb.hasEventErrRange()) {
                        sql = sql + "csuplus,csuminus,";
                    }
                    sql = sql + Audit.sqlFieldString() + ") VALUES (" + this.stdID + "," + event.getEvID() + "," + SB.DBChar((char)event.getType().getChar()) + "," + event.getCSU() + "," + event.getConfidence().getDBint() + "," + SB.DBString((String)event.getComments()) + ",";
                    if (this.sbdb.hasEventErrRange()) {
                        sql = sql + event.getErrPlus() + ",";
                        sql = sql + event.getErrMinus() + ",";
                    }
                    sql = sql + event.getAudit().sqlInsert(this.sbdb, stmt) + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
        }
        this.name = name;
        this.minAge = minAge;
        this.maxAge = maxAge;
        this.topCSU = topCSU;
        this.baseCSU = baseCSU;
        this.isAgeScale = ageScale;
        this.parentSchID = parentSchID;
        if (newEvents != null) {
            this.events = newEvents;
        }
        this.setChanged();
    }

    public boolean equals(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent.Builder> builders) {
        if (!this.name.equals(name) || this.isAgeScale != ageScale) {
            return false;
        }
        if (Math.abs(this.minAge - minAge) > 0.01 || Math.abs(this.maxAge - maxAge) > 0.01 || Math.abs(this.topCSU - topCSU) > 0.01 || Math.abs(this.baseCSU - baseCSU) > 0.01) {
            return false;
        }
        return this.equalsCompositeEvents(builders);
    }

    public void addEvents(List<CompositeStandardEvent.Builder> builders) throws InvalidFieldException, SQLException, SBException {
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBException(this.getDeniedReason(this.sbdb, "composite standard", true));
        }
        for (CompositeStandardEvent.Builder b : builders) {
            if (this.hasEvent(b, null)) {
                throw new InvalidFieldException("Composite already has event: " + b.getEvent());
            }
            this.checkBuilder(b, true);
        }
        for (CompositeStandardEvent e : this.events) {
            builders.add(CompositeStandardEvent.Builder.copyOf(e).event(e.getEvent()));
        }
        List<CompositeStandardEvent> newEvents = this.validateFields(builders);
        this.updateFields(this.name, this.minAge, this.maxAge, this.topCSU, this.baseCSU, this.isAgeScale, newEvents, this.parentSchID);
    }

    public CompositeStandardEvent addEvent(CompositeStandardEvent.Builder builder) throws SQLException, InvalidFieldException, SBPermissionException {
        this.loadEvents();
        if (this.hasEvent(builder, null)) {
            throw new InvalidFieldException("Event is already in composite standard");
        }
        CompositeStandardEvent cmpStdEv = builder.build(this.sbdb);
        this.checkBuilder(builder, true);
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "composite standard", true));
                }
                String sql = "INSERT INTO " + this.sbdb.DBTableName("CMPSTDEV") + " (std_id,ev_id,ev_type,csu,confidence,comments," + Audit.sqlFieldString() + ") VALUES (" + this.stdID + "," + builder.getEvent().getEvID() + "," + SB.DBChar((char)builder.getType().getChar()) + "," + builder.getCSU() + "," + builder.getConfidence().getDBint() + "," + SB.DBString((String)builder.getComments()) + "," + builder.audit.sqlInsert(this.sbdb, stmt) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.events.add(cmpStdEv);
        this.setChanged();
        return cmpStdEv;
    }

    public CompositeStandardEvent getEvent(int evID, SBEvent.EventType type) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != evID || event.getType() != type) continue;
            return event;
        }
        return null;
    }

    public void updateEventComment(CompositeStandardEvent cmpStdEvt, String comment) throws InvalidFieldException, SQLException, SBPermissionException {
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "update event comment", "composite standard", true));
        }
        String error = "Can't update event: ";
        cmpStdEvt.updateComments(this.stdID, comment);
        this.setChanged();
    }

    public void updateCsu(CompositeStandardEvent cmpStdEvt, double csu, Double errPlus, Double errMinus, AgeConfidence conf) throws InvalidFieldException, SQLException, SBPermissionException {
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "update event age", "composite standard", true));
        }
        String error = "Can't update event: ";
        if (this.getAge(csu) > this.maxAge || this.getAge(csu) < this.minAge) {
            throw new InvalidFieldException("New CSU falls outside range of section");
        }
        if (cmpStdEvt.getType() == SBEvent.EventType.TOP) {
            if (!this.checkCSU(cmpStdEvt, csu)) {
                throw new InvalidFieldException(error + "New top's age/csu cannot be older than existing base");
            }
        } else if (cmpStdEvt.getType() == SBEvent.EventType.BASE && !this.checkCSU(cmpStdEvt, csu)) {
            throw new InvalidFieldException(error + "New base's age/csu cannot be younger than existing top");
        }
        cmpStdEvt.updateCsu(this.stdID, csu, errPlus, errMinus, conf);
        this.setChanged();
    }

    public EventEdit updateEventCsu(CompositeStandardEvent event, double newCsu) throws SQLException, SBException, InvalidFieldException {
        EventEdit edit;
        block4: {
            edit = new EventEdit(event, newCsu);
            try {
                edit.doEdit();
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof SBException) {
                    throw (SBException)re.getCause();
                }
                if (re.getCause() instanceof SQLException) {
                    throw (SQLException)re.getCause();
                }
                if (!(re.getCause() instanceof InvalidFieldException)) break block4;
                throw (InvalidFieldException)re.getCause();
            }
        }
        return edit;
    }

    public CompositeStandard getLink() {
        return this.link;
    }

    public void setLink(CompositeStandard cmpStd) {
        this.link = cmpStd;
        this.updateStatus();
    }

    public void updateStatus() {
        this.status = NOTSTORED;
        if (this.link == null) {
            for (CompositeStandardEvent evt : this.events) {
                evt.setStatus(NOTSTORED);
            }
            return;
        }
        for (CompositeStandardEvent evt : this.events) {
            evt.setStatus(NOTSTORED);
            for (CompositeStandardEvent e : this.link.getEvents()) {
                if (!evt.getSortEntry().equals(e.getSortEntry())) continue;
                if (!(Math.abs(evt.getCSU() - e.getCSU()) < (double)0.0029f)) break;
                evt.setStatus(STORED);
                double d = evt.getErrMinus() == null ? 0.0 : evt.getErrMinus();
                double d2 = e.getErrMinus() == null ? 0.0 : e.getErrMinus();
                if (Math.abs(d - d2) > (double)0.0029f) {
                    evt.setStatus(CONFLICT);
                    break;
                }
                double d3 = evt.getErrPlus() == null ? 0.0 : evt.getErrPlus();
                double d4 = e.getErrPlus() == null ? 0.0 : e.getErrPlus();
                if (Math.abs(d3 - d4) > (double)0.0029f) {
                    evt.setStatus(CONFLICT);
                    break;
                }
                if (evt.getComments() == null || evt.getComments().isEmpty()) break;
                if (e.getComments() == null || e.getComments().isEmpty()) {
                    evt.setStatus(PARTSTORED);
                    break;
                }
                if (!evt.getComments().equals(e.getComments() == null ? "" : e.getComments())) {
                    evt.setStatus(CONFLICT);
                    break;
                }
                if (evt.getComments().length() <= 255) break;
                evt.setStatus(CONFLICT);
                break;
            }
            this.status = MergeStatus.merge((Color)this.status, (Color)evt.getStatus());
        }
    }

    public AgeRange getAgeRange(Taxon taxon) {
        Double min = null;
        Double max = null;
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvent().getTaxon() == null || event.getEvent().getTaxon().getSpecID() != taxon.getSpecID()) continue;
            if (event.getType() == SBEvent.EventType.BASE) {
                max = this.getAge(event.getCSU());
            } else {
                min = this.getAge(event.getCSU());
            }
            if (min == null || max == null) continue;
            return new AgeRange(min, max);
        }
        if (min != null || max != null) {
            return new AgeRange(min, max);
        }
        return null;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for compoiste standard: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
        this.loadEvents();
        for (CompositeStandardEvent event : this.events) {
            event.setAnalyst(analyst);
        }
    }

    @Override
    public int getID() {
        return this.stdID;
    }

    public int getParentSchID() {
        return this.parentSchID;
    }

    public void excludeEvents(SBdb ws) throws SQLException {
        if (this.events == null) {
            return;
        }
        Iterator<CompositeStandardEvent> it = this.events.iterator();
        while (it.hasNext()) {
            CompositeStandardEvent ev = it.next();
            if (ws.getSBEvent(ev.getEvID()) != null) continue;
            it.remove();
        }
    }

    public HashSet<Taxon> getTaxa() {
        HashSet<Taxon> set = new HashSet<Taxon>();
        for (CompositeStandardEvent event : this.events) {
            Taxon taxon = event.getEvent().getTaxon();
            if (taxon == null) continue;
            set.add(taxon);
        }
        return set;
    }

    public boolean hasTaxon(int specID) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvent().getSpecID() != specID) continue;
            return true;
        }
        return false;
    }

    public boolean hasEvent(int evID) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvent().getEvID() != evID) continue;
            return true;
        }
        return false;
    }

    CompositeStandard(SBdb db, DEXFile.DEXsection section) throws SQLException, SBException {
        super("CMPSTD", "STD_ID", false, true);
        this.sbdb = db;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Event") && sepChar == '=') break;
            if (label.equalsIgnoreCase("Name")) {
                this.name = value;
                continue;
            }
            if (label.equalsIgnoreCase("Top")) {
                this.minAge = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base")) {
                this.maxAge = Float.parseFloat(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Units") || value.length() <= 0 || value.toUpperCase().equalsIgnoreCase("Ma")) continue;
            this.isAgeScale = false;
            this.topCSU = this.minAge;
            this.baseCSU = this.maxAge;
        }
        Object evname = null;
        String evDesc = null;
        char evExtent = '\u0000';
        float evTop = 0.0f;
        float evBase = 0.0f;
        Date created = null;
        int creator = 0;
        Taxon taxon = null;
        int donorID = 0;
        boolean isSingle = false;
        boolean generate = true;
        Object event = null;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Event") && sepChar == '=') {
                if (this.name != null) {
                    SBEvent.Builder builder = new SBEvent.Builder().name(this.name).taxon(taxon).isSingle(isSingle).isGenerate(generate).desc(evDesc).evExtent(evExtent);
                    if (creator > 0 && this.sbdb.getUser(creator) != null) {
                        builder.audit(new Audit(creator, created, creator, created));
                    }
                    SBEvent sbEvent = this.sbdb.addSBEvent(builder, donorID);
                    if (evTop > 0.0f) {
                        this.events.add(new CompositeStandardEvent.Builder().event(sbEvent).type(isSingle ? SBEvent.EventType.SINGLE : SBEvent.EventType.TOP).csu(evTop).build(this.sbdb));
                    }
                    if (evBase > 0.0f) {
                        this.events.add(new CompositeStandardEvent.Builder().event(sbEvent).type(isSingle ? SBEvent.EventType.SINGLE : SBEvent.EventType.BASE).csu(evBase).build(this.sbdb));
                    }
                }
                this.name = value;
                evExtent = '\u0000';
                evDesc = null;
                evBase = 0.0f;
                evTop = 0.0f;
                created = null;
                creator = 0;
                taxon = null;
                donorID = 0;
                isSingle = false;
                generate = true;
                continue;
            }
            if (label.equalsIgnoreCase("ID")) {
                donorID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Species id")) {
                int donorSpecID = Integer.parseInt(value);
                taxon = this.sbdb.getTaxon(donorSpecID);
                continue;
            }
            if (label.equalsIgnoreCase("Paired")) {
                isSingle = !value.equalsIgnoreCase("true");
                continue;
            }
            if (label.equalsIgnoreCase("Use as top or base")) {
                generate = value.equalsIgnoreCase("true");
                continue;
            }
            if (label.equalsIgnoreCase("Extent")) {
                evExtent = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("Description")) {
                evDesc = value;
                continue;
            }
            if (label.equalsIgnoreCase("Created")) {
                try {
                    created = SB.df.parse(value);
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (label.equalsIgnoreCase("Creator")) {
                creator = this.sbdb.getAddUserID(value);
                continue;
            }
            if (label.equalsIgnoreCase("Top") && sepChar == ':') {
                evTop = Float.parseFloat(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Base") || sepChar != ':') continue;
            evBase = Float.parseFloat(value);
        }
        if (event != null) {
            this.events.add((CompositeStandardEvent)event);
        }
        this.stdID = 0;
    }

    public class EventEdit
    extends SbugsEdit {
        private final CompositeStandardEvent event;
        private double age;
        private final String presentationName = "edit event age";

        public EventEdit(CompositeStandardEvent event, double prevAge) {
            this.event = event;
            this.age = prevAge;
        }

        public void undo() {
            try {
                double redoAge = CompositeStandard.this.getAge(this.event.getCSU());
                CompositeStandard.this.updateCsu(this.event, CompositeStandard.this.getCSU(this.age), this.event.getErrPlus(), this.event.getErrMinus(), this.event.getConfidence());
                CompositeStandard.this.notifyObservers();
                this.age = redoAge;
            }
            catch (Exception e) {
                throw new RuntimeException("Error undoing event age edit", e);
            }
            super.undo();
        }

        public void redo() {
            try {
                double undoAge = CompositeStandard.this.getAge(this.event.getCSU());
                CompositeStandard.this.updateCsu(this.event, CompositeStandard.this.getCSU(this.age), this.event.getErrPlus(), this.event.getErrMinus(), this.event.getConfidence());
                CompositeStandard.this.notifyObservers();
                this.age = undoAge;
            }
            catch (Exception e) {
                throw new RuntimeException("Error doing event age edit", e);
            }
        }

        public void doEdit() throws SBException, SQLException {
            this.redo();
        }

        public String getPresentationName() {
            return "edit event age";
        }
    }

    public class AgeRange {
        Double minAge;
        Double maxAge;

        AgeRange(Double minAge, Double maxAge) {
            this.minAge = minAge;
            this.maxAge = maxAge;
        }

        public Double getMinAge() {
            return this.minAge;
        }

        public Double getMaxAge() {
            return this.maxAge;
        }
    }
}

