/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import model2_1.AgeConfidence;
import model2_1.Audit;
import model2_1.CompositeStandardEventBase;
import model2_1.EventCompareCSU;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Userdef;
import model2_1.api.Discipline;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class CompositeStandardEvent
implements Comparable,
SortEntry,
SbugsStatus,
CompositeStandardEventBase {
    private final SBdb sbdb;
    private SBEvent sbEvent;
    private double csu;
    private Double errPlus = null;
    private Double errMinus = null;
    private SBEvent.EventType type;
    private Audit audit = new Audit();
    private Color status = UNKNOWN;
    private String comments;
    public static final int MAX_COMMENT_LENGTH = 255;
    private AgeConfidence confidence;
    static final int SORTALPHA = 0;
    static final int SORTCSU_UP = 1;
    static final int SORTCSU_DOWN = 2;

    public char getEvType() {
        return this.type.getChar();
    }

    public String getEvTypeString() {
        return CompositeStandardEvent.getEvTypeString(this.type);
    }

    public static String getEvTypeString(SBEvent.EventType type) {
        return type.toString(false);
    }

    public int getEvID() {
        return this.sbEvent.getEvID();
    }

    @Override
    public double getCSU() {
        return this.csu;
    }

    @Override
    public double getMinCSU() {
        if (this.errMinus != null) {
            return this.csu - this.errMinus;
        }
        return this.csu;
    }

    @Override
    public double getMaxCSU() {
        if (this.errPlus != null) {
            return this.csu + this.errPlus;
        }
        return this.csu;
    }

    @Override
    public Double getErrPlus() {
        return this.errPlus;
    }

    @Override
    public Double getErrMinus() {
        return this.errMinus;
    }

    public String getName() {
        return this.sbEvent.getName();
    }

    @Override
    public SBEvent getEvent() {
        return this.sbEvent;
    }

    @Override
    public SBEvent.EventType getType() {
        return this.type;
    }

    public AgeConfidence getConfidence() {
        return this.confidence;
    }

    public String getComments() {
        return this.comments;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    Audit getAuditObj() {
        return this.audit;
    }

    Date getUpdated() {
        return new Date(this.audit.updated.getTime());
    }

    public String toString() {
        return this.toString(true, true, false, false, false);
    }

    public String toStringName() {
        return this.toString(true, false, false, false, false);
    }

    public String toString(boolean type, boolean csu, boolean confidence, boolean abr, boolean eventName) {
        Object strg = "";
        if (type && this.type != SBEvent.EventType.SINGLE) {
            strg = (String)strg + this.type.toString(false) + " ";
        }
        strg = (String)strg + this.sbEvent.toString(abr, eventName);
        if (csu) {
            strg = this.csu + " " + (String)strg;
        }
        if (confidence && this.confidence != AgeConfidence.CONFIDENT) {
            strg = (String)strg + " (" + this.confidence + ")";
        }
        return strg;
    }

    public int compareTo(Object o) {
        CompositeStandardEvent rhs = (CompositeStandardEvent)o;
        return this.sbEvent.compareTo(rhs.sbEvent);
    }

    public static void sort(List<CompositeStandardEvent> events, int sort) {
        switch (sort) {
            case 0: {
                Collections.sort(events);
                break;
            }
            case 1: {
                Collections.sort(events, new EventCompareCSU(false));
                break;
            }
            case 2: {
                Collections.sort(events, new EventCompareCSU(true));
            }
        }
    }

    static Builder parse(SBdb ws, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        Builder builder = new Builder();
        String strg = xml.getChildTextNormalize("EventID");
        if (strg != null) {
            int eventID = Integer.parseInt(strg);
            builder.event(ws.getSBEvent(eventID));
        }
        if ((strg = xml.getChildTextNormalize("CSU")) != null) {
            builder.csu(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("CSUPLUS")) != null) {
            builder.errPlus(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("CSUMINUS")) != null) {
            builder.errMinus(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            builder.type(SBEvent.EventType.getType(strg));
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null && strg.length() > 0) {
            builder.comment(strg);
        }
        if ((strg = xml.getChildTextNormalize("Uncertainty")) != null && strg.length() > 0) {
            builder.confidence(AgeConfidence.getConfidence(Integer.parseInt(strg)));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        }
        return builder;
    }

    void writeXML(BufferedWriter out, String ind) throws IOException {
        out.write(ind + "<EventID>" + this.sbEvent.getEvID() + "</EventID>\n");
        out.write(ind + "<CSU>" + this.csu + "</CSU>\n");
        if (this.errPlus != null) {
            out.write(ind + "<CSUPLUS>" + this.errPlus + "</CSUPLUS>\n");
        }
        if (this.errMinus != null) {
            out.write(ind + "<CSUMINUS>" + this.errMinus + "</CSUMINUS>\n");
        }
        out.write(ind + "<Type>" + this.type.name() + "</Type>\n");
        if (this.comments != null && !this.comments.isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        if (this.confidence.getDBint() > 0) {
            out.write(ind + "<Uncertainty>" + this.confidence.getDBint() + "</Uncertainty>\n");
        }
        this.audit.writeXML(out, ind.length());
    }

    public void setCsu(double csu, Double errPlus, Double errMinus) throws SBException {
        if (this.sbdb != null) {
            throw new SBException("Attempt to set CSU for event: " + this);
        }
        this.csu = csu;
        this.errPlus = errPlus;
        this.errMinus = errMinus;
    }

    void updateCsu(int stdID, double csu, Double errPlus, Double errMinus, AgeConfidence conf) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET csu=" + csu;
            if (this.sbdb.hasEventErrRange()) {
                sql = sql + ",csuplus=" + errPlus;
                sql = sql + ",csuminus=" + errMinus;
            }
            sql = sql + ",confidence=" + conf.getDBint() + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + stdID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ev_type=" + SB.DBChar((char)this.type.getChar());
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.csu = csu;
        this.errPlus = errPlus;
        this.errMinus = errMinus;
        this.confidence = conf;
    }

    static boolean updateType(SBdb db, int evID, boolean single, Boolean updateSingleToTops) throws SQLException {
        assert (single || updateSingleToTops != null);
        try (Statement stmt = db.getDatabase().createStatement();){
            Audit audit = new Audit();
            String sql = "UPDATE " + db.DBTableName("CMPSTDEV") + " SET ev_type=" + SB.DBChar((char)(single ? 83 : (updateSingleToTops != false ? 70 : 76))) + "," + audit.sqlUpdate(db, stmt, false) + " WHERE ev_id=" + evID;
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            boolean bl = nRows > 0;
            return bl;
        }
    }

    void setUpdated(int updater, Date updated) {
        this.audit.updater = updater;
        this.audit.updated = updated;
    }

    void updateComments(int stdID, String comments) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET comments=" + SB.DBString((String)comments);
            sql = sql + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + stdID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ev_type=" + SB.DBChar((char)this.type.getChar());
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.comments = comments;
    }

    void setSBEvent(SBEvent event) {
        this.sbEvent = event;
    }

    void setType(SBEvent.EventType type) {
        this.type = type;
    }

    public String getSortEntry() {
        return this.sbEvent.getName().toUpperCase() + "-" + this.type.getChar();
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        return this.toString();
    }

    public Discipline getDisc() {
        if (this.sbEvent.getTaxon() == null) {
            return null;
        }
        return this.sbEvent.getTaxon().getDisc();
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for composite standard event: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private CompositeStandardEvent(Builder builder, SBdb sbdb) {
        this.sbdb = sbdb;
        this.sbEvent = builder.sbEvent;
        this.type = builder.type;
        this.csu = builder.csu;
        this.errPlus = builder.errPlus;
        this.errMinus = builder.errMinus;
        this.confidence = builder.confidence;
        this.comments = builder.comments;
        this.audit = builder.audit;
        this.status = NOTSTORED;
    }

    static CompositeStandardEvent loadEvent(SBdb sbdb, int stdID, String key, CompositeStandardEvent o) throws SQLException {
        String evType = "" + key.charAt(0);
        int evID = Integer.parseInt(key.substring(2));
        Object sql = "SELECT csu,confidence,comments,";
        if (sbdb.hasEventErrRange()) {
            sql = (String)sql + "csuplus,csuminus,";
        }
        sql = (String)sql + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + stdID + " AND ev_id=" + evID + " AND ev_type=" + SB.DBString((String)evType);
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
            if (rs.next()) {
                SBEvent.EventType type = SBEvent.EventType.getType(evType);
                SBEvent sbEvent = sbdb.getSBEvent(evID);
                if (sbEvent.getEvID() > 0) {
                    Builder builder = new Builder();
                    builder.type(type).event(sbEvent).csu(rs.getDouble("csu")).confidence(AgeConfidence.getConfidence(rs.getInt("confidence"))).comment(rs.getString("comments"));
                    if (sbdb.hasEventErrRange()) {
                        Double f = rs.getDouble("csuplus");
                        if (!rs.wasNull()) {
                            builder.errPlus(f);
                        }
                        f = rs.getDouble("csuminus");
                        if (!rs.wasNull()) {
                            builder.errMinus(f);
                        }
                    }
                    builder.audit(new Audit(rs));
                    CompositeStandardEvent e = builder.build(sbdb);
                    if (o != null) {
                        o.csu = e.csu;
                        o.errPlus = e.errPlus;
                        o.errMinus = e.errMinus;
                        o.comments = e.comments;
                        o.confidence = e.confidence;
                        o.audit = e.audit;
                        CompositeStandardEvent compositeStandardEvent = o;
                        return compositeStandardEvent;
                    }
                    CompositeStandardEvent compositeStandardEvent = e;
                    return compositeStandardEvent;
                }
            }
        }
        return null;
    }

    public static class Builder
    implements CompositeStandardEventBase {
        private SBEvent sbEvent;
        private SBEvent.EventType type;
        private double csu;
        private Double errPlus = null;
        private Double errMinus = null;
        private String comments;
        private AgeConfidence confidence = AgeConfidence.CONFIDENT;
        Audit audit = new Audit();

        CompositeStandardEvent build(SBdb sbdb) {
            this.verify();
            return new CompositeStandardEvent(this, sbdb);
        }

        public void verify() {
            if (this.sbEvent == null) {
                throw new IllegalStateException("Attempt to build CmpStdEvent with null event");
            }
            if (this.type == null) {
                if (this.sbEvent.isSingle()) {
                    this.type = SBEvent.EventType.SINGLE;
                } else {
                    throw new IllegalStateException("Attempt to build CmpStdEvent with no type");
                }
            }
            if (this.sbEvent.isSingle() != this.type.isSingle()) {
                if (this.sbEvent.isSingle()) {
                    this.type = SBEvent.EventType.SINGLE;
                } else {
                    throw new IllegalStateException("Attempt to build CmpStdEvent: " + this.sbEvent.getName() + ", ID=" + this.sbEvent.getEvID() + " with invalid event type");
                }
            }
        }

        public static Builder copyOf(CompositeStandardEvent rhs) {
            return new Builder().type(rhs.type).csu(rhs.csu).audit(new Audit(rhs.audit)).comment(rhs.comments).confidence(rhs.confidence).errPlus(rhs.errPlus).errMinus(rhs.errMinus);
        }

        public Builder event(SBEvent event) {
            this.sbEvent = event;
            return this;
        }

        public Builder csu(double csu) {
            if (csu >= 0.0) {
                this.csu = csu;
            }
            return this;
        }

        public Builder errPlus(Double errPlus) {
            this.errPlus = errPlus;
            return this;
        }

        public Builder errMinus(Double errMinus) {
            this.errMinus = errMinus;
            return this;
        }

        public Builder type(SBEvent.EventType type) {
            this.type = type;
            return this;
        }

        public Builder comment(String comment) {
            this.comments = comment != null && !comment.trim().isEmpty() ? comment.trim() : null;
            return this;
        }

        public Builder confidence(AgeConfidence confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public void clearAuditModifier() {
            if (this.audit != null) {
                this.audit.modified = null;
                this.audit.modifier = 0;
            }
        }

        @Override
        public SBEvent getEvent() {
            return this.sbEvent;
        }

        @Override
        public SBEvent.EventType getType() {
            return this.type;
        }

        @Override
        public double getCSU() {
            return this.csu;
        }

        @Override
        public double getMinCSU() {
            return this.errMinus != null ? this.csu - this.errMinus : this.csu;
        }

        @Override
        public double getMaxCSU() {
            return this.errPlus != null ? this.csu + this.errPlus : this.csu;
        }

        @Override
        public Double getErrPlus() {
            return this.errPlus;
        }

        @Override
        public Double getErrMinus() {
            return this.errMinus;
        }

        public AgeConfidence getConfidence() {
            return this.confidence;
        }

        public String getComments() {
            return this.comments;
        }

        public Date getModified() {
            return this.audit.getModified();
        }

        public String getModifier(SBdb sbdb) {
            try {
                if (this.audit.modifier > 0) {
                    return sbdb.getUser(this.audit.modifier).getAbr();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return "";
        }
    }
}

