/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model2_1.CompositeStandardEvent;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Surface;
import model2_1.WellInterp;
import model2_1.WsWell;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class GenericReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    Set dataTypes;
    int depthColumn = 0;
    int splitFactorColumn = -1;
    int sampleTypeColumn = -1;
    int sampleWeightColumn = -1;
    int taxaColumn = 1;
    SBdb ws;

    public GenericReaderXLS(SBdb ws, String fileName, Set dataTypes) throws SBException, FileNotFoundException, IOException, SQLException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        FileInputStream istream = new FileInputStream(fileName);
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(fileName));
        WsWell well = ws.addWellToWorkspace(0, fileName);
        well.loadInterps();
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        dataTypes.clear();
        block6: for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            System.out.println("processing sheet: " + wb.getSheetName(j) + "\n");
            switch (j) {
                case 0: {
                    this.parseBiofaciesSheet(sheet, well);
                    continue block6;
                }
                case 1: {
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
    }

    void parseSurfaceSheet(HSSFSheet sheet, int schID, String title) throws SBException, SQLException {
        IGDScheme scheme = new IGDScheme(this.ws, 10, title, null, IGDScheme.SequenceType.DEPOSITIONAL, 0);
        scheme.setSchID(schID);
        this.ws.addIGDScheme(scheme);
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell(0);
            cell = row.getCell(1);
            String surfaceName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                surfaceName = cell.getStringCellValue();
            }
            if ((cell = row.getCell(2)) != null && cell.getCellType() != CellType.BLANK) {
                age = cell.getNumericCellValue();
            }
            if (surfaceName.startsWith("0MY_")) {
                surfaceName = surfaceName.substring(11);
            }
            if ((surfaceName = surfaceName.replace("'", "`")).trim().length() == 0) continue;
            try {
                Surface.SurfaceType type = Surface.SurfaceType.SB;
                if (surfaceName.endsWith("MFS")) {
                    type = Surface.SurfaceType.MFS;
                }
                scheme.addSurface(new Surface.Builder(this.ws).name(surfaceName).age(age).type(type));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding surface: " + surfaceName + " (age=" + age + ")");
            }
        }
    }

    void parseLithoStratSheet(HSSFSheet sheet) throws SBException, SQLException {
        IGDScheme scheme = this.ws.addIGDScheme(3, "Nexen Lithostratigraphy");
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell(0);
            int hier = -1;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                String hierString = cell.getStringCellValue();
                if (hierString.length() > 1) {
                    hier = Integer.parseInt(hierString.substring(1));
                } else {
                    throw new SBException("Unrecognised hierarchy string: " + hierString);
                }
            }
            cell = row.getCell(1);
            String unitName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                unitName = cell.getStringCellValue();
            }
            if ((cell = row.getCell(2)) != null && cell.getCellType() != CellType.BLANK) {
                age = cell.getNumericCellValue();
            }
            if (unitName.startsWith("0MY_")) {
                unitName = unitName.substring(11);
            }
            if ((unitName = unitName.replace("'", "`")).trim().length() == 0) continue;
            if (unitName.contains("BASE_")) {
                IGDUnit unit = scheme.findUnit(unitName = unitName.replace("BASE_", ""));
                if (unit != null) {
                    unit.setLage(age);
                    continue;
                }
                System.out.println("No unit found for base: " + unitName + " age=" + age);
                continue;
            }
            try {
                scheme.addUnit(new IGDUnit.Builder(scheme.getDatabase()).age(age, age).name(unitName).hier(hier));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding unit: " + unitName + " (age=" + age + ")");
            }
        }
    }

    void parseChronoStratSheet(HSSFSheet sheet) throws SBException, SQLException {
        IGDScheme scheme = this.ws.addIGDScheme(3, "Nexen Chronostratigraphy");
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell(0);
            int hier = -1;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                hier = (int)cell.getNumericCellValue();
            }
            cell = row.getCell(1);
            String unitName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                unitName = cell.getStringCellValue();
            }
            if ((cell = row.getCell(2)) != null && cell.getCellType() != CellType.BLANK) {
                age = cell.getNumericCellValue();
            }
            if (unitName.startsWith("0MY_")) {
                unitName = unitName.substring(11);
            }
            if ((unitName = unitName.replace("'", "`")).trim().length() == 0) continue;
            if (unitName.contains("BASE_")) {
                IGDUnit unit = scheme.findUnit(unitName = unitName.replace("BASE_", ""));
                if (unit != null) {
                    unit.setLage(age);
                    continue;
                }
                System.out.println("No unit found for base: " + unitName + " age=" + age);
                continue;
            }
            try {
                scheme.addUnit(new IGDUnit.Builder(scheme.getDatabase()).age(age, age).name(unitName).hier(hier));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding unit: " + unitName + " (age=" + age + ")");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseBiofaciesSheet(HSSFSheet sheet, WsWell well) throws SBException, SQLException {
        IGDScheme scheme = this.ws.addIGDScheme(4, "Biofacies");
        this.addDataType(11);
        Sample zoneTop = null;
        Sample zoneBase = null;
        String lastZone = null;
        WellInterp interp = well.getInterp(0);
        int nRow = 0;
        while (true) {
            block28: {
                String subZone;
                String zone;
                int baseNo;
                int topNo;
                double base;
                double top;
                String strg;
                double value;
                HSSFRow row;
                block29: {
                    block26: {
                        block27: {
                            if (nRow > sheet.getLastRowNum()) break block26;
                            System.out.println("Row: " + nRow);
                            row = sheet.getRow(nRow);
                            if (nRow != 0) break block27;
                            System.out.println("Read title row");
                            break block28;
                        }
                        if (row == null) break block28;
                        System.out.print("Data in row: " + nRow);
                        value = 0.0;
                        strg = "";
                        top = 0.0;
                        base = 0.0;
                        topNo = 0;
                        baseNo = 0;
                        zone = null;
                        subZone = "";
                        break block29;
                    }
                    if (zoneTop == null) return;
                    IGDIntervalZone.Builder zb = new IGDIntervalZone.Builder(this.ws, 4, zoneTop, zoneBase, 2, scheme.getID());
                    this.addInf(zb, lastZone);
                    try {
                        interp.addZone(zb, well);
                        return;
                    }
                    catch (InvalidFieldException ex) {
                        System.out.println("Invalid: " + ex.toString());
                    }
                    return;
                }
                block19: for (int col = 0; col < 6; ++col) {
                    HSSFCell cell = row.getCell(col);
                    if (cell == null) continue;
                    switch (cell.getCellType()) {
                        case BLANK: {
                            continue block19;
                        }
                        case NUMERIC: {
                            value = cell.getNumericCellValue();
                            break;
                        }
                        case STRING: {
                            if (col < 4) {
                                value = Double.parseDouble(cell.getStringCellValue());
                                break;
                            }
                            strg = cell.getStringCellValue();
                        }
                    }
                    switch (col) {
                        case 0: {
                            top = value;
                            continue block19;
                        }
                        case 1: {
                            topNo = (int)value;
                            continue block19;
                        }
                        case 2: {
                            base = value;
                            continue block19;
                        }
                        case 3: {
                            baseNo = (int)value;
                            continue block19;
                        }
                        case 4: {
                            zone = strg;
                            continue block19;
                        }
                        case 5: {
                            subZone = strg;
                            continue block19;
                        }
                    }
                }
                try {
                    IGDIntervalZone.Builder zb;
                    Sample baseSample;
                    Sample topSample = well.getSample((Double)DepthUtils.convToM((double)top, (char)'F'), null, SampleType.CO);
                    if (topSample == null) {
                        Sample.Builder builder = new Sample.Builder().topDepth(DepthUtils.convToM((double)top, (char)'F')).type(SampleType.CO).label("" + topNo);
                        topSample = well.addSample(builder, 0, null);
                    }
                    if ((baseSample = well.getSample((Double)DepthUtils.convToM((double)base, (char)'F'), null, SampleType.CO)) == null) {
                        Sample.Builder builder = new Sample.Builder().topDepth(DepthUtils.convToM((double)base, (char)'F')).type(SampleType.CO).label("" + baseNo);
                        baseSample = well.addSample(builder, 0, null);
                    }
                    if (zone != null && !zone.isEmpty()) {
                        if (zoneTop != null) {
                            zb = new IGDIntervalZone.Builder(this.ws, 4, zoneTop, zoneBase, 2, scheme.getID());
                            this.addInf(zb, lastZone);
                            interp.addZone(zb, well);
                        }
                        lastZone = zone;
                        zoneTop = topSample;
                    }
                    zoneBase = baseSample;
                    if (subZone != null && !subZone.isEmpty()) {
                        zb = new IGDIntervalZone.Builder(this.ws, 4, topSample, baseSample, 3, scheme.getID());
                        this.addInf(zb, subZone);
                        interp.addZone(zb, well);
                    }
                }
                catch (SBPermissionException ex) {
                    System.out.println("PermissionException: " + ex.toString());
                }
                catch (InvalidFieldException ex) {
                    System.out.println("Invalid: " + ex.toString());
                }
            }
            ++nRow;
        }
    }

    void addInf(IGDIntervalZone.Builder zb, String inf) {
        if (inf.length() > 160) {
            System.out.println("Warning: can't add zone: " + inf);
        }
        if (inf.length() > 80) {
            String[] s = inf.split(" ");
            Object uinf = "";
            Object linf = "";
            for (int i = 0; i < s.length; ++i) {
                if (((String)uinf + s[i]).length() < 81) {
                    uinf = (String)uinf + s[i] + " ";
                    continue;
                }
                if (((String)linf + s[i]).length() < 81) {
                    linf = (String)linf + s[i] + " ";
                    continue;
                }
                System.out.println("Can't fit string: " + s[i]);
            }
            zb.uppInf((String)uinf).lowInf((String)linf);
        } else {
            zb.uppInf(inf);
        }
    }

    void parseEventSheet(HSSFSheet sheet) throws SBException, SQLException, InvalidFieldException, SBPermissionException {
        this.ws.getSBEvents(true);
        LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
        for (int nRow = 2; nRow <= sheet.getLastRowNum(); ++nRow) {
            System.out.println("Row: " + nRow);
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell(1);
            String eventName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                eventName = cell.getStringCellValue();
            }
            if ((cell = row.getCell(2)) != null && cell.getCellType() != CellType.BLANK) {
                age = cell.getNumericCellValue();
            }
            if (eventName.startsWith("0MY_")) {
                eventName = eventName.substring(4);
            }
            System.out.println("Read event: " + eventName + " at age: " + age);
            eventName = eventName.replace("'", "`");
            SBEvent event = this.ws.getSBEvent(eventName);
            if (event == null) {
                event = this.ws.addSBEvent(new SBEvent.Builder().name(eventName).isSingle(true).desc("Nexen Std.").isGenerate(false));
            }
            builders.add(new CompositeStandardEvent.Builder().event(event).type(SBEvent.EventType.SINGLE).csu(age));
        }
        this.ws.addCompositeStandard("Nexen std. events", 0.0, 542.0, 0.0, 0.0, true, builders, null, 0);
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

