/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import model2_1.Audit;
import model2_1.DEXFile;
import model2_1.EnvScheme;
import model2_1.IGDInterval;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Well;
import model2_1.WsWell;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SortEntry;
import util.status.SbugsStatus;

public class IGDIntervalEnv
extends IGDInterval
implements SortEntry {
    private int schID;
    private int up;
    private int ud;
    private int lp;
    private int ld;
    private int qual;

    IGDIntervalEnv(SBdb ws, IGDIntervalEnv dbEnv, Well wsWell) throws SQLException, SBException, SBPermissionException {
        super(ws, dbEnv, wsWell);
        this.copyPrimitives(dbEnv);
        this.schID = dbEnv.schID;
        EnvScheme scheme = ws.getEnvScheme(this.schID);
        if (scheme == null) {
            scheme = EnvScheme.createCopy(dbEnv.sbdb.getEnvScheme(dbEnv.schID), ws);
            ws.addEnvScheme(scheme);
        }
        this.status = STORED;
    }

    IGDIntervalEnv(SBdb db, IGDIntervalEnv wsEnv) throws SBException, SQLException {
        super(db, wsEnv);
        this.igdType = wsEnv.igdType;
        if (wsEnv.schID <= 0) {
            throw new SBException("Workspace env has no scheme for: " + this);
        }
        EnvScheme wsScheme = wsEnv.getScheme();
        if (wsScheme.getLink() == null) {
            throw new SBException("Palaeoenvironment scheme not matched for: " + this);
        }
        EnvScheme dbScheme = wsScheme.getLink();
        this.schID = dbScheme.getID();
        this.up = wsEnv.up;
        this.ud = wsEnv.ud;
        this.lp = wsEnv.lp;
        this.ld = wsEnv.ld;
        this.qual = wsEnv.qual;
        this.status = NOTSTORED;
    }

    static IGDIntervalEnv parse(SBdb ws, WsWell well, Element xml) throws SBException, SQLException, ParseException {
        Element el;
        int sampID;
        Sample topSample = null;
        Sample baseSample = null;
        String strg = xml.getChildTextNormalize("TopSampleID");
        if (strg != null && (topSample = well.getSample(sampID = Integer.parseInt(strg), true)) == null) {
            throw new SBException("Cannot find Top Sample in Biostrat Comment for ID: " + sampID);
        }
        strg = xml.getChildTextNormalize("BaseSampleID");
        if (strg != null && (baseSample = well.getSample(sampID = Integer.parseInt(strg), true)) == null) {
            throw new SBException("Cannot find Base Sample in Biostrat Comment for ID: " + sampID);
        }
        strg = xml.getChildTextNormalize("EnvironmentSchemeID");
        if (strg == null) {
            throw new SBException("Cannot find Scheme ID for env interval: " + topSample + "-" + baseSample);
        }
        int schID = Integer.parseInt(strg);
        EnvScheme scheme = ws.getEnvScheme(schID);
        if (scheme == null) {
            throw new SBException("No Env Scheme found for ID: " + schID);
        }
        Builder builder = new Builder(ws, topSample, baseSample, schID);
        strg = xml.getChildTextNormalize("UpperProximalUnit");
        if (strg != null) {
            builder.up(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("UpperDistalUnit")) != null) {
            builder.ud(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("LowerProximalUnit")) != null) {
            builder.lp(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("LowerDistalUnit")) != null) {
            builder.ld(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("EnvironmentQualifier")) != null) {
            builder.qual(scheme.getTermIndex(strg));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        } else {
            System.out.println("Warning: no audit info for IGDInterval: " + builder);
        }
        builder.status = NOTSTORED;
        return builder.build();
    }

    final void copyPrimitives(IGDIntervalEnv rhs) {
        this.igdType = rhs.igdType;
        this.up = rhs.up;
        this.ud = rhs.ud;
        this.lp = rhs.lp;
        this.ld = rhs.ld;
        this.qual = rhs.qual;
    }

    public String getSortEntry() {
        return this.topSample.getSortEntry() + "-" + this.baseSample.getSortEntry();
    }

    public EnvScheme getScheme() {
        if (this.sbdb != null) {
            try {
                return this.sbdb.getEnvScheme(this.schID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    static IGDIntervalEnv load(SBdb sbdb, int topID, int interpID, Well well, IGDIntervalEnv e) throws SQLException, SBException {
        String sql = "SELECT base_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_ENV") + " WHERE  interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND top_id=" + topID;
        Builder builder = null;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                int baseID = rs.getInt("base_id");
                int schID = rs.getInt("envsch_id");
                builder = new Builder(sbdb, well.getSample(topID), well.getSample(baseID), schID);
                builder.up(rs.getInt("up"));
                builder.ud(rs.getInt("ud"));
                builder.lp(rs.getInt("lp"));
                builder.ld(rs.getInt("ld"));
                builder.qual(rs.getInt("qual"));
                builder.audit(new Audit(rs));
            }
        }
        if (builder == null) {
            return null;
        }
        if (e == null) {
            return builder.build();
        }
        if (e.getTopSample() != builder.getTopSample() || e.getSchID() != builder.schID) {
            throw new SBException("Attempt to copy fields to unequivalent env interval object");
        }
        builder.validate();
        e.baseSample = builder.baseSample;
        e.up = builder.up;
        e.lp = builder.lp;
        e.ud = builder.ud;
        e.ld = builder.ld;
        e.qual = builder.qual;
        e.audit = builder.audit;
        return e;
    }

    static IGDIntervalEnv parse(DEXFile.DEXsection section, SBdb ws, Well well, HashMap<Integer, Sample> dups) throws SQLException, SBException {
        Sample baseSample;
        EnvScheme scheme = null;
        int topID = 0;
        int baseID = 0;
        int up = 0;
        int ud = 0;
        int lp = 0;
        int ld = 0;
        int qual = 0;
        Audit audit = new Audit();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Top sample ID")) {
                topID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base sample ID")) {
                baseID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Environment Scheme ID")) {
                int schID = Integer.parseInt(value);
                scheme = ws.getEnvScheme(schID);
                if (scheme != null || schID != 1) continue;
                scheme = ws.getEnvScheme(1);
                continue;
            }
            if (label.equalsIgnoreCase("Upper proximal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                up = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper distal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                ud = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower proximal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                lp = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower distal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                ld = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Environment qualifier")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                qual = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Modified")) {
                try {
                    audit.modified = SB.df.parse(value);
                }
                catch (ParseException ex) {
                    audit.modified = new Date();
                }
                continue;
            }
            if (!label.equalsIgnoreCase("Modifier")) continue;
            audit.modifier = ws.getAddUserID(value);
        }
        Sample topSample = well.getSample(topID);
        if (topSample == null) {
            topSample = dups.get(topID);
        }
        if ((baseSample = well.getSample(baseID)) == null) {
            baseSample = dups.get(baseID);
        }
        Builder builder = new Builder(ws, topSample, baseSample, scheme.getID());
        builder.up(up).lp(lp).ud(ud).ld(ld).qual(qual);
        if (audit.modified == null) {
            audit.modified = new Date();
        }
        if (audit.modifier == 0) {
            // empty if block
        }
        builder.audit(audit);
        return builder.build();
    }

    @Override
    public int getSchID() {
        return this.schID;
    }

    public Color getColour() {
        try {
            return this.sbdb.getEnvScheme(this.schID).getColour(this.up);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Color getColourDistal() {
        try {
            return this.sbdb.getEnvScheme(this.schID).getColour(this.ld);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getUp() {
        return this.up;
    }

    public int getUd() {
        return this.ud;
    }

    public int getLd() {
        return this.ld;
    }

    public int getLp() {
        return this.lp;
    }

    public int getQual() {
        return this.qual;
    }

    void store(Statement stmt, int wellID, int interpID) throws SQLException, SBException {
        this.store(stmt, wellID, interpID, this.topSample.getSampID(), this.baseSample.getSampID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Statement stmt, int wellID, int interpID, int topID, int baseID) throws SQLException, SBException {
        if (this.status == NOTSTORED) {
            boolean createStatement = false;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
                createStatement = true;
            }
            String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_ENV") + " (well_id,top_id,base_id,interp_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + topID + "," + baseID + "," + interpID + "," + this.schID + "," + this.up + "," + this.ud + "," + this.lp + "," + this.ld + "," + this.qual + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                if (createStatement) {
                    stmt.close();
                }
            }
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update IGDEnv");
        }
    }

    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to environment interval deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE well_id=" + wellID + " AND top_id=" + this.topSample.getSampID() + " AND base_id=" + this.baseSample.getSampID() + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
    }

    @Override
    public void delete(int wellID, int interpID, Statement stmt) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        EnvScheme scheme = null;
        try {
            scheme = this.sbdb.getEnvScheme(this.schID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scheme == null) {
            return this.up + "," + this.ud + "," + this.lp + "," + this.ld;
        }
        Object strg = scheme.getTerm(this.up);
        if (this.up != this.ud) {
            strg = (String)strg + "/" + scheme.getTerm(this.ud);
        }
        if (this.lp != this.up || this.ld != this.ud) {
            strg = (String)strg + " - " + scheme.getTerm(this.lp);
            if (this.ld != this.lp) {
                strg = (String)strg + "/" + scheme.getTerm(this.ld);
            }
        }
        return strg;
    }

    public String getConflictReason() {
        if (this.conflictReason == null) {
            return "";
        }
        return this.conflictReason;
    }

    void updateStatus(List igdList) throws SQLException, SBException {
        this.status = NOTSTORED;
        this.conflictReason = "";
        int nzTD = (int)(100.0 * this.topSample.getDepth('M'));
        int nzBD = (int)(100.0 * this.baseSample.getDepth('M'));
        for (IGDIntervalEnv zone : igdList) {
            int cBD;
            if (zone == this) continue;
            if (this.isFuncEquivalent(zone)) {
                this.status = STORED;
                if (this.up != zone.up) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper proximal conflict";
                }
                if (this.ud != zone.ud) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper distal conflict";
                }
                if (this.lp != zone.lp) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower proximal conflict";
                }
                if (this.ld != zone.ld) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower distal conflict";
                }
                if (this.qual != zone.qual) {
                    this.status = CONFLICT;
                    this.conflictReason = "Qualifier conflict: " + this.qual + ", existing: " + zone.qual;
                }
                if (this.sbdb.getEnvScheme(this.schID).getLink() == null || this.sbdb.getEnvScheme(this.schID).getLink().getID() != zone.schID) {
                    this.status = CONFLICT;
                    this.conflictReason = "Scheme conflict";
                }
                if (this.status == CONFLICT) break;
                break;
            }
            int cTD = (int)(100.0 * zone.topSample.getDepth('M'));
            if (this.checkDepthBracketing(cTD, cBD = (int)(100.0 * zone.baseSample.getDepth('M')), nzTD, nzBD)) continue;
            break;
        }
    }

    @Deprecated
    int getAnySchID() {
        return this.schID;
    }

    @Override
    public void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        out.write("[INTERVAL " + this.topSample.getDepth(units) + " - " + this.baseSample.getDepth(units) + "]" + eol);
        out.write("Palaeoenvironment = " + this.toString() + eol);
        if (this.getSchID() > 0) {
            out.write("Environment scheme ID : " + this.getSchID() + eol);
        }
        EnvScheme scheme = this.sbdb.getEnvScheme(this.schID);
        out.write("Top sample : " + this.topSample.toString() + eol);
        out.write("Base sample : " + this.baseSample.toString() + eol);
        out.write("Top sample ID : " + this.topSample.getSampID() + eol);
        out.write("Base sample ID : " + this.baseSample.getSampID() + eol);
        out.write("Upper proximal unit : " + scheme.getTerm(this.up) + eol);
        out.write("Upper distal unit : " + scheme.getTerm(this.ud) + eol);
        out.write("Lower proximal unit : " + scheme.getTerm(this.lp) + eol);
        out.write("Lower distal unit : " + scheme.getTerm(this.ld) + eol);
        if (this.qual > 0) {
            out.write("Environment qualifier : " + scheme.getTerm(this.qual) + eol);
        }
        if (this.audit.modified != null) {
            out.write("Modified = " + df.format(this.audit.modified) + eol);
        }
        if (this.audit.modifier > 0) {
            out.write("Modifier = " + this.sbdb.getUser(this.audit.modifier).getAbr() + eol);
        }
        out.write(eol);
    }

    @Override
    public LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind1 = SB.getXMLIndent((int)indent);
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind1 + "<EnvironmentInterval Depth=\"" + SB.getDepthString((double)this.topSample.getDepth(), (char)units, (int)2) + " - " + SB.getDepthString((double)this.baseSample.getDepth(), (char)units, (int)2) + "\">\n");
        if (this.toString() != null && this.toString().length() > 0) {
            out.write(ind + "<" + IGDInterval.getIGDName(5) + ">" + SB.getXMLstring((String)this.toString()) + "</" + IGDInterval.getIGDName(5) + ">\n");
        }
        out.write(ind + "<EnvironmentSchemeID>" + this.schID + "</EnvironmentSchemeID>\n");
        out.write(ind + "<TopSampleID>" + this.topSample.getSampID() + "</TopSampleID>\n");
        out.write(ind + "<BaseSampleID>" + this.baseSample.getSampID() + "</BaseSampleID>\n");
        EnvScheme scheme = this.sbdb.getEnvScheme(this.schID);
        out.write(ind + "<UpperProximalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.up)) + "</UpperProximalUnit>\n");
        out.write(ind + "<UpperDistalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.ud)) + "</UpperDistalUnit>\n");
        out.write(ind + "<LowerProximalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.lp)) + "</LowerProximalUnit>\n");
        out.write(ind + "<LowerDistalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.ld)) + "</LowerDistalUnit>\n");
        if (this.qual > 0) {
            out.write(ind + "<EnvironmentQualifier>" + SB.getXMLstring((String)scheme.getTerm(this.qual)) + "</EnvironmentQualifier>\n");
        }
        userIDs.addAll(this.audit.writeXML(out, indent + 3));
        out.write(ind1 + "</EnvironmentInterval>\n");
        return userIDs;
    }

    void updateFromLink(int linkUp, int linkUd, int linkLp, int linkLd, int linkQual) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Cannot update database Env interval from link");
        }
        if (linkUd == 0) {
            linkUd = linkUp;
        }
        if (linkLp == 0) {
            linkLp = linkUp;
        }
        if (linkLd == 0) {
            linkLd = linkLp;
        }
        if (linkUp > linkUd || linkLp > linkLd) {
            int tmp;
            if (linkUp > linkUd) {
                tmp = linkUd;
                linkUd = linkUp;
                linkUp = tmp;
            }
            if (linkLp > linkLd) {
                tmp = linkLd;
                linkLd = linkLp;
                linkLp = tmp;
            }
        }
        this.up = linkUp;
        this.ud = linkUd;
        this.lp = linkLp;
        this.ld = linkLd;
        this.qual = linkQual;
    }

    void update(IGDIntervalEnv ws, int wellID, int interpID) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            this.audit.modified = ws.audit.modified;
            this.audit.modifier = ws.sbdb.getUser(ws.audit.modifier).getLink().getUsrID();
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET up=" + ws.up + ",ud=" + ws.ud + ",lp=" + ws.lp + ",ld=" + ws.ld + ",qual=" + ws.qual + this.audit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND interp_id=" + interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.up = ws.up;
            this.lp = ws.lp;
            this.ud = ws.ud;
            this.ud = ws.ud;
            this.qual = ws.qual;
            this.status = STORED;
        }
    }

    @Override
    public void move(int wellID, int interpID, int newInterpID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit tempAudit = new Audit(this.audit);
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND interp_id=" + interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.audit = tempAudit;
        }
    }

    @Override
    public boolean mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        if (this.topSample == donor) {
            this.topSample = target;
            hasChanged = true;
        }
        if (this.baseSample == donor) {
            this.baseSample = target;
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof IGDIntervalEnv) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            IGDIntervalEnv comp = (IGDIntervalEnv)e;
            if (this.topSample.isFuncEquivalent(comp.topSample) && this.baseSample.isFuncEquivalent(comp.baseSample)) {
                return true;
            }
        }
        return false;
    }

    private IGDIntervalEnv(Builder builder) {
        super(builder);
        this.schID = builder.schID;
        this.up = builder.up;
        this.ld = builder.ld;
        this.ud = builder.ud;
        this.lp = builder.lp;
        this.qual = builder.qual;
    }

    @Override
    public String getItemDesc() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDescPlural() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class Builder
    extends IGDInterval.Builder {
        public static final String EXCEPTION_PREFIX = "Attempt to build env interval";
        private final int schID;
        private int qual = 0;
        private int up;
        private int ud;
        private int lp;
        private int ld;

        public Builder(SBdb sbdb, Sample topSample, Sample baseSample, int schID) {
            super(sbdb, 5, topSample, baseSample);
            this.schID = schID;
        }

        public static Builder copyOf(IGDIntervalEnv env) throws SBException {
            Builder builder = new Builder(env.sbdb, env.topSample, env.baseSample, env.schID);
            builder.up(env.up).ud(env.ud).lp(env.lp).ld(env.ld).qual(env.qual);
            return builder;
        }

        public static Builder copyOf(IGDIntervalEnv env, Sample topSample, Sample baseSample) throws SBException {
            Builder builder = new Builder(env.sbdb, topSample, baseSample, env.schID);
            builder.up(env.up).ud(env.ud).lp(env.lp).ld(env.ld).qual(env.qual).audit(new Audit(env.audit));
            return builder;
        }

        public IGDIntervalEnv build() {
            this.validate();
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new IGDIntervalEnv(this);
        }

        @Override
        void validate() {
            super.validate();
            if (this.schID <= 0) {
                throw new IllegalStateException("Attempt to build IGDIntervalZone with illegal scheme ID: " + this.schID);
            }
            if (this.up == 0) {
                throw new IllegalStateException("Attempt to build env interval with no upper proximal");
            }
            if (this.ud == 0) {
                throw new IllegalStateException("Attempt to build env interval with no upper distal");
            }
            if (this.lp == 0) {
                throw new IllegalStateException("Attempt to build env interval with no lower proximal");
            }
            if (this.ld == 0) {
                throw new IllegalStateException("Attempt to build env interval with no lower distal");
            }
            if (this.ud < this.up) {
                System.out.println("Changed ud in IGDIntervalEnv.Builder");
                this.ud = this.up;
            }
            if (this.ld < this.lp) {
                System.out.println("Changed ld in IGDIntervalEnv.Builder");
                this.ld = this.lp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IGDIntervalEnv build(int wellID, int interpID, Statement stmt) throws SQLException, SBException {
            IGDIntervalEnv env = this.build();
            boolean createdStatement = false;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
                createdStatement = true;
            }
            try {
                env.store(stmt, wellID, interpID);
            }
            finally {
                if (createdStatement) {
                    stmt.close();
                }
            }
            return env;
        }

        Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        public Builder up(int up) {
            this.up = up;
            return this;
        }

        public Builder ud(int ud) {
            this.ud = ud;
            return this;
        }

        public Builder lp(int lp) {
            this.lp = lp;
            return this;
        }

        public Builder ld(int ld) {
            this.ld = ld;
            return this;
        }

        public Builder qual(int qual) {
            this.qual = qual;
            return this;
        }
    }
}

