/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import model2_1.Audit;
import model2_1.DEXFile;
import model2_1.IGDInterval;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.IGDUnitBase;
import model2_1.InterpHdr;
import model2_1.LithostratUnit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WellInterp;
import model2_1.WsWell;
import model2_1.api.Discipline;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class IGDIntervalZone
extends IGDInterval
implements SortEntry {
    public static final int INHERITED = 0;
    public static final int POSS = 1;
    public static final int PROB = 2;
    public static final int CONF = 3;
    public static final int UNCF = 4;
    public static final int QUNCF = 5;
    public static final int FAULT = 6;
    public static final int QFAULT = 7;
    public static final int RFAULT = 8;
    public static final String[] bnds = new String[]{"Possible", "Probable", "Confident", "Unconformable", "?Unconformable", "Fault", "?Fault", "ReverseFault"};
    private static final HashMap<Integer, String[]> defaultHierNames = new HashMap();
    private static final HashMap<Integer, String[]> defaultHierNamesExtended;
    private int topBnd = 2;
    private int baseBnd = 2;
    private int schID = 0;
    private int hier;
    private boolean qUzone = false;
    private int uppZone = 0;
    private String uppInf = "";
    private String sep = "-";
    private boolean qLzone = false;
    private int lowZone = 0;
    private String lowInf = "";
    private int topAnalyst;
    private int baseAnalyst;
    private static HashMap<Integer, String[]> hierNames;

    @Override
    public String getItemDesc() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDescPlural() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isUnconformableBnd(int bnd) {
        return bnd == 4 || bnd == 5;
    }

    public static boolean isDisconformableBnd(int bnd) {
        return IGDIntervalZone.isUnconformableBnd(bnd) || IGDIntervalZone.isFaultBnd(bnd);
    }

    public static boolean isFaultBnd(int bnd) {
        return bnd == 6 || bnd == 7 || bnd == 8;
    }

    public static boolean isQuestionableBnd(int bnd) {
        return bnd == 5 || bnd == 7;
    }

    static IGDIntervalZone load(SBdb sbdb, int igdType, int topID, int schID, int interpID, Well well, int hier, IGDIntervalZone z) throws SQLException, SBException {
        String sql = "SELECT base_id," + (igdType == 2 ? "" : "top_analy,base_analy,") + "top_bnd,base_bnd,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,sep," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE igd_type=" + igdType + " AND  interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND sch_id=" + schID + " AND top_id=" + topID + " AND hier=" + hier;
        Builder builder = null;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                Sample baseSample = well.getSample(rs.getInt("base_id"));
                builder = new Builder(sbdb, igdType, well.getSample(topID), baseSample, hier, schID);
                if (igdType != 2) {
                    builder.topAnalyst(rs.getInt("top_analy"));
                    builder.baseAnalyst(rs.getInt("base_analy"));
                }
                builder.topBnd(rs.getInt("top_bnd"));
                builder.baseBnd(rs.getInt("base_bnd"));
                String strg = rs.getString("q_uzone");
                builder.qUzone(strg != null && strg.charAt(0) == 'Y');
                builder.uppZone(rs.getInt("upp_zone"));
                builder.uppInf(rs.getString("upp_inf"));
                strg = rs.getString("q_lzone");
                builder.qLzone(strg != null && strg.charAt(0) == 'Y');
                builder.lowZone(rs.getInt("low_zone"));
                builder.lowInf(rs.getString("low_inf"));
                builder.sep(rs.getString("sep"));
                builder.audit(new Audit(rs));
            }
        }
        if (builder == null) {
            return null;
        }
        if (z == null) {
            return builder.build();
        }
        if (z.igdType != builder.igdType || z.topSample != builder.topSample || z.hier != builder.hier || z.schID != builder.schID) {
            throw new SBException("Attempt to copy fields to unequivalent Interval Zone object");
        }
        builder.validateFields();
        z.baseSample = builder.baseSample;
        z.topAnalyst = builder.topAnalyst;
        z.baseAnalyst = builder.baseAnalyst;
        z.topBnd = builder.topBnd;
        z.baseBnd = builder.baseBnd;
        z.qUzone = builder.qUzone;
        z.qLzone = builder.qLzone;
        z.uppZone = builder.uppZone;
        z.lowZone = builder.lowZone;
        z.uppInf = builder.uppInf;
        z.lowInf = builder.lowInf;
        z.sep = builder.sep;
        z.audit = builder.audit;
        return z;
    }

    IGDIntervalZone(SBdb ws, IGDIntervalZone dbZone, Well wsWell) throws SQLException, SBException {
        super(ws, dbZone, wsWell);
        this.copyPrimitives(dbZone);
        this.schID = dbZone.schID;
        if (ws.getIGDScheme(this.schID) == null) {
            IGDScheme dbScheme = dbZone.sbdb.getIGDScheme(dbZone.schID);
            dbScheme.loadUnits();
            ws.addIGDScheme(IGDScheme.copyToWorkspace(ws, dbScheme));
        }
        this.uppZone = dbZone.uppZone;
        this.lowZone = dbZone.lowZone;
        if (dbZone.topAnalyst > 0) {
            this.topAnalyst = dbZone.topAnalyst;
            ws.fillUser(dbZone.sbdb, this.topAnalyst);
        }
        if (dbZone.baseAnalyst > 0) {
            this.baseAnalyst = dbZone.baseAnalyst;
            ws.fillUser(dbZone.sbdb, this.baseAnalyst);
        }
        this.status = STORED;
    }

    IGDIntervalZone(SBdb db, IGDIntervalZone wsZone) throws SBException, SQLException {
        super(db, wsZone);
        IGDUnitBase wsUnit;
        this.copyPrimitives(wsZone);
        IGDScheme wsScheme = wsZone.sbdb.getIGDScheme(wsZone.schID);
        if (wsScheme == null) {
            throw new SBException("ws scheme is null - schID: " + this.schID + "  zone: " + wsZone);
        }
        if (wsScheme.getLink() == null) {
            throw new SBException("Zone scheme not linked: " + this);
        }
        this.schID = wsScheme.getLink().getSchID();
        if (wsZone.lowZone > 0 && (wsUnit = wsScheme.findUnitBase(wsZone.lowZone)) != null && wsUnit.link != null) {
            this.lowZone = wsUnit.link.getUnitID();
        }
        if (wsZone.uppZone > 0 && (wsUnit = wsScheme.findUnitBase(wsZone.uppZone)) != null && wsUnit.link != null) {
            this.uppZone = wsUnit.link.getUnitID();
        }
        if (wsZone.topAnalyst > 0) {
            this.topAnalyst = Audit.getDBUserID(db, wsZone.sbdb, wsZone.topAnalyst);
        }
        if (wsZone.baseAnalyst > 0) {
            this.baseAnalyst = Audit.getDBUserID(db, wsZone.sbdb, wsZone.baseAnalyst);
        }
        this.status = NOTSTORED;
    }

    IGDIntervalZone(SBdb ws, DEXFile.DEXsection section, Well well, HashMap<Integer, Sample> dups) throws SQLException, SBException {
        super(ws);
        String biozoneDataName = null;
        int topID = 0;
        int baseID = 0;
        this.hier = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Type")) {
                this.igdType = IGDInterval.getIGDType(value);
                continue;
            }
            if (label.equalsIgnoreCase("Biozone data")) {
                biozoneDataName = value;
                continue;
            }
            if (label.equalsIgnoreCase("Top sample ID")) {
                topID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base sample ID")) {
                baseID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Top analyst")) {
                if (this.sbdb.getUser(value) == null) {
                    this.topAnalyst = this.sbdb.getAddUserID(value);
                    continue;
                }
                this.topAnalyst = this.sbdb.getUser(value).getUsrID();
                continue;
            }
            if (label.equalsIgnoreCase("Base analyst")) {
                if (this.sbdb.getUser(value) == null) {
                    this.baseAnalyst = this.sbdb.getAddUserID(value);
                    continue;
                }
                this.baseAnalyst = this.sbdb.getUser(value).getUsrID();
                continue;
            }
            if (label.equalsIgnoreCase("Scheme ID")) {
                this.schID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper boundary")) {
                this.topBnd = IGDIntervalZone.getBoundaryTypeFromString(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower boundary")) {
                this.baseBnd = IGDIntervalZone.getBoundaryTypeFromString(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper unit")) {
                if (this.uppInf.length() != 0) continue;
                this.uppInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Upper dictionary ID")) {
                this.uppZone = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower unit")) {
                if (this.lowInf.length() != 0) continue;
                this.lowInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Lower dictionary ID")) {
                this.lowZone = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper informal unit")) {
                this.uppInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Lower informal unit")) {
                this.lowInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Upper questionable")) {
                this.qUzone = value.equalsIgnoreCase("YES");
                continue;
            }
            if (label.equalsIgnoreCase("Lower questionable")) {
                this.qLzone = value.equalsIgnoreCase("YES");
                continue;
            }
            if (this.hier == 0) {
                if (this.igdType == 3 && label.equalsIgnoreCase("Period/Epoch")) {
                    label = "Epoch";
                }
                this.hier = IGDIntervalZone.getHierNumber(this.igdType, label, true);
                if (this.igdType != 4 || !label.equalsIgnoreCase("Scheme")) continue;
                this.hier = 2;
                continue;
            }
            if (label.equalsIgnoreCase("Modified")) {
                try {
                    this.audit.modified = SB.df.parse(value);
                }
                catch (ParseException ex) {
                    this.audit.modified = new Date();
                }
                this.audit.created = this.audit.modified;
                continue;
            }
            if (!label.equalsIgnoreCase("Modifier")) continue;
            this.audit.modifier = this.sbdb.getUser(value) == null ? this.sbdb.getAddUserID(value) : this.sbdb.getUser(value).getUsrID();
            this.audit.creator = this.audit.modifier;
        }
        this.topSample = well.getSample(topID);
        if (this.topSample == null) {
            this.topSample = dups.get(topID);
            if (this.topSample == null) {
                System.out.println("Top sample (ID=" + topID + ") null for interval: " + this + " in well: " + well);
            } else {
                System.out.println("Duplicate sample ID fixed: " + topID);
            }
        }
        this.baseSample = well.getSample(baseID);
        if (this.baseSample == null) {
            this.baseSample = dups.get(baseID);
            if (this.baseSample == null) {
                System.out.println("Base sample (ID=" + baseID + ") null for interval: " + this + " in well: " + well);
            } else {
                System.out.println("Duplicate sample ID fixed: " + topID);
            }
        }
        if (this.igdType == 4) {
            if (this.topSample != null && this.topAnalyst == 0 && this.topSample.donorAnalyst != null && this.topSample.donorAnalyst.length() > 0) {
                this.topAnalyst = this.sbdb.getUser(this.topSample.donorAnalyst).getUsrID();
            }
            if (this.baseSample != null && this.baseAnalyst == 0 && this.baseSample.donorAnalyst != null && this.baseSample.donorAnalyst.length() > 0) {
                this.baseAnalyst = this.sbdb.getUser(this.baseSample.donorAnalyst).getUsrID();
            }
        }
        IGDScheme scheme = null;
        if (this.schID == 0 && biozoneDataName != null) {
            scheme = this.sbdb.getIGDScheme(biozoneDataName, this.igdType);
            if (scheme != null) {
                this.schID = scheme.getID();
            } else {
                Discipline disc = biozoneDataName.toUpperCase().contains("MICRO") ? Discipline.MICRO : (biozoneDataName.toUpperCase().contains("NANNO") ? Discipline.NANNO : (biozoneDataName.toUpperCase().contains("MACRO") ? Discipline.MACRO : Discipline.PALY));
                scheme = new IGDScheme(this.sbdb, this.igdType, biozoneDataName, disc, null, 0);
                this.schID = 999;
                while (this.sbdb.getIGDScheme(this.schID) != null && this.schID > 0) {
                    --this.schID;
                }
                scheme.setSchID(this.schID);
                this.sbdb.addIGDScheme(scheme);
            }
        }
        if (this.schID > 0) {
            scheme = this.sbdb.getIGDScheme(this.schID);
            if (scheme == null && biozoneDataName != null && (scheme = this.sbdb.getIGDScheme(biozoneDataName, this.igdType)) != null) {
                this.schID = scheme.getID();
            }
            if (scheme == null) {
                Object name = IGDInterval.getIGDName(this.igdType) + " scheme not in DEX file, ID=" + this.schID;
                if (biozoneDataName != null) {
                    scheme = this.sbdb.getIGDScheme(biozoneDataName, this.igdType);
                    name = biozoneDataName;
                }
                if (scheme == null) {
                    Discipline disc = this.igdType == 4 ? Discipline.MICRO : null;
                    IGDScheme.SequenceType sqType = this.igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null;
                    scheme = new IGDScheme(this.sbdb, this.igdType, (String)name, disc, sqType, 0);
                    scheme.setSchID(this.schID);
                    this.sbdb.addIGDScheme(scheme);
                }
            }
        }
        if (scheme != null) {
            IGDUnitBase.Builder builder;
            IGDUnitBase unit;
            if (this.uppZone > 0 && (unit = scheme.findUnitBase(this.uppZone)) == null && (unit = scheme.findUnitBase(this.uppInf)) == null) {
                try {
                    switch (scheme.getIGDType()) {
                        case 2: {
                            builder = new LithostratUnit.Builder(this.sbdb);
                            break;
                        }
                        default: {
                            builder = new IGDUnit.Builder(this.sbdb);
                        }
                    }
                    scheme.addUnit(builder.name(this.uppInf).hier(this.hier), this.uppZone);
                }
                catch (InvalidFieldException e) {
                    e.printStackTrace();
                }
            }
            if (this.lowZone > 0 && (unit = scheme.findUnitBase(this.lowZone)) == null && (unit = scheme.findUnitBase(this.lowInf)) == null) {
                try {
                    switch (scheme.getIGDType()) {
                        case 2: {
                            builder = new LithostratUnit.Builder(this.sbdb);
                            break;
                        }
                        default: {
                            builder = new IGDUnit.Builder(this.sbdb);
                        }
                    }
                    scheme.addUnit(builder.name(this.lowInf).hier(this.hier), this.lowZone);
                }
                catch (InvalidFieldException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public int getSchID() {
        return this.schID;
    }

    public boolean getQUzone() {
        return this.qUzone;
    }

    public boolean getQLzone() {
        return this.qLzone;
    }

    public int getHier() {
        return this.hier;
    }

    public String getHierString() {
        return IGDIntervalZone.getHierName(this.igdType, this.hier);
    }

    public String getSortEntry() {
        String schemeName = "";
        try {
            schemeName = this.getSchemeName(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.igdType + "-" + this.topSample.getSortEntry() + "-" + this.hier + "-" + this.baseSample.getSortEntry() + "-" + schemeName;
    }

    public String getSchemeName() throws SQLException, SBException {
        return this.getSchemeName(false);
    }

    public String getSchemeName(boolean useLink) throws SQLException, SBException {
        if (this.schID > 0) {
            IGDScheme scheme;
            if (this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.schID)) != null) {
                if (useLink && scheme.getLink() != null) {
                    return scheme.getLink().toString();
                }
                return scheme.toString();
            }
            return "Scheme ID = " + this.schID;
        }
        return "";
    }

    public IGDUnit getUppUnit(boolean useLink) throws SQLException {
        IGDScheme scheme;
        if (this.schID > 0 && this.uppZone > 0 && this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.schID)) != null) {
            if (useLink && scheme.getLink() != null) {
                return scheme.getLink().findUnit(this.uppZone);
            }
            return scheme.findUnit(this.uppZone);
        }
        return null;
    }

    public IGDUnit getLowUnit(boolean useLink) throws SQLException {
        IGDScheme scheme;
        if (this.schID > 0 && this.lowZone > 0 && this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.schID)) != null) {
            if (useLink && scheme.getLink() != null) {
                return scheme.getLink().findUnit(this.lowZone);
            }
            return scheme.findUnit(this.lowZone);
        }
        return null;
    }

    public Color getUnitColour(boolean upper) throws SQLException {
        IGDScheme scheme;
        if ((upper && this.uppZone > 0 || !upper && this.lowZone > 0) && this.schID > 0 && this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.schID)) != null) {
            scheme.loadUnits();
            IGDUnitBase zoneUnit = scheme.findUnitBase(upper ? this.uppZone : this.lowZone);
            if (zoneUnit != null) {
                return zoneUnit.getColour();
            }
        }
        return null;
    }

    public String getTopAnalystString() throws SQLException, SBException {
        if (this.topAnalyst > 0) {
            Userdef user = this.sbdb.getUser(this.topAnalyst);
            if (user == null) {
                return "" + this.topAnalyst;
            }
            return user.getAbr();
        }
        return "";
    }

    public String getBaseAnalystString() throws SQLException, SBException {
        if (this.baseAnalyst > 0) {
            Userdef user = this.sbdb.getUser(this.baseAnalyst);
            if (user == null) {
                return "" + this.baseAnalyst;
            }
            return user.getAbr();
        }
        return "";
    }

    public int getUppZone() {
        return this.uppZone;
    }

    public int getLowZone() {
        return this.lowZone;
    }

    public String getUppInf() {
        return this.uppInf;
    }

    public String getLowInf() {
        return this.lowInf;
    }

    public int getTopAnalyst() {
        return this.topAnalyst;
    }

    public int getBaseAnalyst() {
        return this.baseAnalyst;
    }

    public String getTopBnd() {
        return IGDIntervalZone.getBoundary(this.topBnd);
    }

    public String getBaseBnd() {
        return IGDIntervalZone.getBoundary(this.baseBnd);
    }

    public int getTopBndInt() {
        return this.topBnd;
    }

    public int getBaseBndInt() {
        return this.baseBnd;
    }

    public static int getBoundaryTypeFromString(String bnd) {
        for (int i = 0; i < bnds.length; ++i) {
            if (!bnd.equalsIgnoreCase(bnds[i])) continue;
            return i + 1;
        }
        return 2;
    }

    static int getBoundaryTypeFromAbr(String bnd) {
        if ((bnd = bnd.toUpperCase()).compareTo("POSS") == 0) {
            return 1;
        }
        if (bnd.compareTo("PROB") == 0) {
            return 2;
        }
        if (bnd.compareTo("CONF") == 0) {
            return 3;
        }
        if (bnd.compareTo("UNCF") == 0) {
            return 4;
        }
        if (bnd.compareTo("QUNC") == 0) {
            return 5;
        }
        if (bnd.compareTo("FAULT") == 0) {
            return 6;
        }
        if (bnd.compareTo("QFAULT") == 0) {
            return 7;
        }
        return 3;
    }

    public static String getBoundary(int bnd) {
        if (--bnd >= 0 && bnd < bnds.length) {
            return bnds[bnd];
        }
        return "Unknown";
    }

    public static int getNHier(int igdType, boolean extendedSet) {
        if (extendedSet && defaultHierNamesExtended.containsKey(igdType)) {
            return defaultHierNamesExtended.get(igdType).length;
        }
        if (defaultHierNames.containsKey(igdType)) {
            return defaultHierNames.get(igdType).length;
        }
        return 1;
    }

    public static int getHierNumber(int igdType, String hier, boolean extendedSet) {
        String[] names = hierNames.get(igdType);
        for (int i = 0; i < names.length; ++i) {
            if ((igdType != 3 || extendedSet) && hier.equalsIgnoreCase(names[i])) {
                return i + 1;
            }
            if (!hier.equalsIgnoreCase(IGDIntervalZone.getDefaultHierName(igdType, i + 1, extendedSet))) continue;
            return i + 1;
        }
        return 0;
    }

    public static int getDefaultHier(int igdType) throws SBException {
        switch (igdType) {
            case 3: {
                return 5;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 1;
            }
            case 26: {
                return 2;
            }
        }
        throw new SBException("Invalid igdType: " + igdType + " passed to getDefaultHier");
    }

    public static void loadHierNames(SBdb sbdb) throws SQLException {
        if (hierNames != null) {
            return;
        }
        hierNames = new HashMap();
        int[] igdtypes = new int[]{3, 2, 4, 10, 26};
        if (sbdb.isConnected()) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                int[] nArray = igdtypes;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = nArray[i];
                    String[] names = new String[IGDIntervalZone.getNHier(i2, true)];
                    String sql = "SELECT name,hier from " + sbdb.DBTableName("IGD_DEF") + " WHERE parent=" + i2;
                    ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                    while (rs.next()) {
                        String name = rs.getString("name");
                        int hier = rs.getInt("hier");
                        if (hier <= 0 || hier > names.length) continue;
                        names[hier - 1] = name;
                    }
                    hierNames.put(i2, names);
                }
            }
        }
        for (int i : igdtypes) {
            if (!hierNames.containsKey(i)) {
                hierNames.put(i, new String[IGDIntervalZone.getNHier(i, true)]);
            }
            String[] names = hierNames.get(i);
            for (int j = 0; j < names.length; ++j) {
                if (names[j] != null) continue;
                names[j] = IGDIntervalZone.getDefaultHierName(i, j + 1, true);
            }
        }
    }

    public static void updateHierNames(SBdb sbdb, HashMap<Integer, String[]> newNames) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            for (Map.Entry<Integer, String[]> entry : newNames.entrySet()) {
                if (Arrays.equals(hierNames.get(entry.getKey()), entry.getValue())) continue;
                if (entry.getValue().length != IGDIntervalZone.getNHier(entry.getKey(), true)) {
                    throw new IllegalStateException("Wrong number of hier for igd type " + entry.getKey());
                }
                String sqlBase = "UPDATE " + sbdb.DBTableName("IGD_DEF") + " SET name=";
                String sqlEnd = " WHERE igd_type=" + entry.getKey() + " AND hier=";
                for (int i = 0; i < entry.getValue().length; ++i) {
                    String sql = sqlBase + SB.DBString((String)entry.getValue()[i]) + sqlEnd + (i + 1);
                    int n = stmt.executeUpdate(sbdb.modQuery(sql));
                    if (n != 0) continue;
                    sql = "INSERT INTO " + sbdb.DBTableName("IGD_DEF") + " (name,igd_type,parent,hier) VALUES (" + SB.DBString((String)entry.getValue()[i]) + "," + entry.getKey() + "," + entry.getKey() + "," + (i + 1) + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                }
                hierNames.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static String getDefaultHierName(int igdType, int hier, boolean extendedSet) {
        String[] names = extendedSet && defaultHierNamesExtended.containsKey(igdType) ? defaultHierNamesExtended.get(igdType) : (defaultHierNames.containsKey(igdType) ? defaultHierNames.get(igdType) : new String[]{});
        if (hier > 0 && hier <= names.length) {
            return names[hier - 1];
        }
        return "";
    }

    public static String getHierName(int igdType, int hier) {
        return hierNames.get(igdType)[hier - 1];
    }

    public static String[] getHierNames(int igdType) {
        String[] names = new String[IGDIntervalZone.getNHier(igdType, true)];
        for (int i = 0; i < IGDIntervalZone.getNHier(igdType, true); ++i) {
            names[i] = IGDIntervalZone.getHierName(igdType, i + 1);
        }
        return names;
    }

    private void copyPrimitives(IGDIntervalZone rhs) {
        this.igdType = rhs.igdType;
        this.hier = rhs.hier;
        this.topBnd = rhs.topBnd;
        this.baseBnd = rhs.baseBnd;
        this.qUzone = rhs.qUzone;
        this.uppInf = rhs.uppInf;
        this.sep = rhs.sep;
        this.qLzone = rhs.qLzone;
        this.lowInf = rhs.lowInf;
    }

    final void store(int wellID, int interpID) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            this.store(wellID, interpID, stmt, this.getTopID(), this.getBaseID());
        }
    }

    private void store(int wellID, int interpID, Statement stmt, int topID, int baseID) throws SQLException, SBException {
        if (this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " (well_id,igd_type,hier,top_id,base_id,interp_id,top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone" + (this.lowInf == null || this.lowInf.equals(this.uppInf) ? "" : ",low_inf") + ",sep," + (this.igdType == 2 ? "" : "top_analy,base_analy,") + Audit.sqlFieldString() + " ) VALUES (" + wellID + "," + this.igdType + "," + this.hier + "," + topID + "," + baseID + "," + interpID + "," + this.topBnd + "," + this.baseBnd + "," + this.schID + "," + (this.qUzone ? "'Y'," : "'N',") + (Serializable)(this.uppZone > 0 ? Integer.valueOf(this.uppZone) : "NULL") + "," + SB.DBString((String)this.uppInf) + "," + (this.qLzone && this.lowInf != null && !this.lowInf.equals(this.uppInf) ? "'Y'," : "'N',");
            sql = this.lowZone == 0 || this.lowZone == this.uppZone ? sql + "NULL," : sql + this.lowZone + ",";
            if (this.lowInf != null && !this.lowInf.equals(this.uppInf)) {
                sql = sql + SB.DBString((String)this.lowInf) + ",";
            }
            sql = sql + "'" + this.sep + "',";
            if (this.igdType != 2) {
                sql = sql + (Serializable)(this.topAnalyst > 0 ? Integer.valueOf(this.topAnalyst) : "NULL") + ",";
                sql = sql + (Serializable)(this.baseAnalyst > 0 ? Integer.valueOf(this.baseAnalyst) : "NULL") + ",";
            }
            sql = sql + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            JOptionPane.showMessageDialog(null, "Attempt to update IGDzone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int wellID, int interpID, Statement stmt) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to interval deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE well_id=" + wellID + " AND igd_type=" + this.igdType + " AND top_id=" + this.getTopID() + " AND base_id=" + this.getBaseID() + " AND interp_id=" + interpID + " AND hier=" + this.hier + " AND sch_id=" + this.schID;
        Statement statement = stmt != null ? stmt : this.sbdb.getDatabase().createStatement();
        try {
            int n = statement.executeUpdate(this.sbdb.modQuery(sql));
            if (n != 1) {
                throw new SBException("Error deleting interval: " + this);
            }
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.status = NOTSTORED;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        String strg = (this.qUzone ? "?" : "") + this.uppInf;
        if (this.lowInf != null && this.lowInf.length() > 0 && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
            strg = strg + " " + (this.sep != null ? this.sep : "-") + " " + (this.qLzone ? "?" : "") + this.lowInf;
        }
        return strg;
    }

    public String toVertString() {
        Object strg = "";
        if (this.lowInf != null && this.lowInf.length() > 0 && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
            strg = (this.qLzone ? "?" : "") + this.lowInf;
            strg = (String)strg + " " + (this.sep != null ? this.sep : "-") + " ";
        }
        strg = (String)strg + (this.qUzone ? "?" : "") + this.uppInf;
        return strg;
    }

    public String toString(boolean useAbrs) throws SQLException {
        if (useAbrs) {
            Object strg = this.qUzone ? "?" : "";
            IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
            IGDUnitBase uppUnit = scheme.findUnitBase(this.uppZone);
            strg = uppUnit != null && !uppUnit.getAbr().isEmpty() ? (String)strg + uppUnit.getAbr() : (String)strg + this.uppInf;
            if (!this.lowInf.isEmpty() && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
                strg = (String)strg + " " + (this.sep != null ? this.sep : "-") + " " + (this.qLzone ? "?" : "");
                IGDUnitBase lowUnit = scheme.findUnitBase(this.lowZone);
                strg = lowUnit != null && !lowUnit.getAbr().isEmpty() ? (String)strg + lowUnit.getAbr() : (String)strg + this.lowInf;
            }
            return strg;
        }
        return this.toString();
    }

    public String toVertString(boolean useAbrs) throws SQLException, SBException {
        if (useAbrs) {
            IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
            Object strg = "";
            if (!this.lowInf.isEmpty() && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
                strg = (String)strg + (this.qLzone ? "?" : "");
                IGDUnitBase lowUnit = scheme.findUnitBase(this.lowZone);
                strg = lowUnit != null && !lowUnit.getAbr().isEmpty() ? (String)strg + lowUnit.getAbr() : (String)strg + this.lowInf;
                strg = (String)strg + " " + (this.sep != null ? this.sep : "-") + " ";
            }
            strg = (String)strg + (this.qUzone ? "?" : "");
            IGDUnitBase uppUnit = scheme.findUnitBase(this.uppZone);
            strg = uppUnit != null && !uppUnit.getAbr().isEmpty() ? (String)strg + uppUnit.getAbr() : (String)strg + this.uppInf;
            return strg;
        }
        return this.toVertString();
    }

    void updateStatus(List igdList) throws SQLException, SBException {
        this.status = NOTSTORED;
        this.conflictReason = "";
        int nzTD = (int)Math.round(100.0 * this.topSample.getDepth('M'));
        int nzBD = (int)Math.round(100.0 * this.baseSample.getDepth('M'));
        for (IGDIntervalZone zone : igdList) {
            int cBD;
            if (zone == this) continue;
            if (this.igdType == 4) {
                IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
                IGDScheme linkScheme = zone.sbdb.getIGDScheme(zone.schID);
                if (scheme != null && linkScheme != null && scheme != linkScheme && scheme.getLink() != linkScheme) continue;
            }
            if (this.isFuncEquivalent(zone)) {
                this.status = STORED;
                if (this.topBnd != zone.topBnd) {
                    this.status = CONFLICT;
                    this.conflictReason = "Top boundary conflict";
                }
                if (this.baseBnd != zone.baseBnd) {
                    this.status = CONFLICT;
                    this.conflictReason = "Base boundary conflict";
                }
                if (!this.uppInf.equalsIgnoreCase(zone.uppInf)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper informal name conflict";
                }
                if (this.lowInf == null) {
                    this.lowInf = "";
                }
                if (zone.lowInf == null) {
                    zone.lowInf = "";
                }
                if (!this.lowInf.equalsIgnoreCase(zone.lowInf) && !this.lowInf.equals(this.uppInf)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower informal name conflict with: " + zone;
                }
                if (this.sep == null || this.sep.length() == 0) {
                    this.sep = "-";
                }
                if (zone.sep == null || zone.sep.length() == 0) {
                    zone.sep = "-";
                }
                if (!this.sep.equals(zone.sep)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Zone separator conflict with: " + zone;
                }
                if (this.qUzone != zone.qUzone) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper informal 'questionable' conflict with: " + zone;
                }
                if (this.qLzone != zone.qLzone) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower informal 'questionable' conflict with: " + zone;
                }
                if (this.getTopAnalystString() != null && !this.getTopAnalystString().equals(zone.getTopAnalystString())) {
                    this.status = CONFLICT;
                    this.conflictReason = "Top sample analyst conflict: " + this.getTopAnalystString() + " vs. " + zone.getTopAnalystString();
                }
                if (this.getBaseAnalystString() != null && !this.getBaseAnalystString().equals(zone.getBaseAnalystString())) {
                    this.status = CONFLICT;
                    this.conflictReason = "Base sample analyst conflict: " + this.getBaseAnalystString() + " vs. " + zone.getBaseAnalystString();
                }
                if (this.status == CONFLICT) break;
                break;
            }
            if (zone.hier != this.hier) continue;
            int cTD = (int)Math.round(100.0 * zone.topSample.getDepth('M'));
            if (!this.checkDepthBracketing(cTD, cBD = (int)Math.round(100.0 * zone.baseSample.getDepth('M')), nzTD, nzBD)) {
                this.conflictReason = this.conflictReason + zone;
                break;
            }
            float diff = Math.abs(cBD - nzTD);
            if ((double)diff < 1.0E-4 && zone.baseBnd != this.topBnd) {
                this.status = CONFLICT;
                this.conflictReason = "New zone top boundary type conflicts with base of existing data: " + zone;
                break;
            }
            diff = Math.abs(cTD - nzBD);
            if ((double)diff < 1.0E-4 && zone.topBnd != this.baseBnd) {
                this.status = CONFLICT;
                this.conflictReason = "New zone base boundary type conflicts with top of existing data: " + zone;
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    public String getConflictReason() {
        if (this.status != CONFLICT) {
            return "";
        }
        if (this.conflictReason == null) {
            return "<no reason set>";
        }
        return this.conflictReason;
    }

    public String getLinkString() {
        Object linkString;
        Object object = linkString = this.uppZone == 0 ? "No" : "Yes";
        if (this.lowZone != 0 && this.lowZone != this.uppZone) {
            linkString = (String)linkString + (this.lowZone == 0 ? "/No" : "/Yes");
        }
        while (((String)linkString).length() < 30) {
            linkString = (String)linkString + " ";
        }
        linkString = (String)linkString + "(sch=" + this.schID + ")";
        return linkString;
    }

    @Override
    public void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        IGDUnitBase unit;
        super.writeDEX(out, eol, units);
        IGDScheme scheme = null;
        if (this.schID > 0) {
            scheme = this.sbdb.getIGDScheme(this.schID);
        }
        if (this.igdType == 4) {
            out.write("Type = Biozone" + eol);
            if (scheme != null) {
                out.write("Biozone data = " + scheme.toString() + eol);
            }
        } else {
            out.write("Type = " + IGDIntervalZone.getIGDName(this.igdType) + eol);
        }
        int plotPos = this.hier;
        if (this.igdType == 3) {
            plotPos = this.hier < 7 ? 1 : 2;
        }
        out.write(IGDIntervalZone.getDefaultHierName(this.igdType, plotPos, false) + " = " + this.toString() + eol);
        if (scheme != null) {
            out.write("  Scheme ID : " + this.schID + eol);
        }
        out.write("  Top sample : " + this.topSample.toString() + eol);
        out.write("  Base sample : " + this.baseSample.toString() + eol);
        out.write("  Top sample ID : " + this.topSample.getSampID() + eol);
        out.write("  Base sample ID : " + this.baseSample.getSampID() + eol);
        if (this.topAnalyst > 0) {
            out.write("  Top analyst : " + this.sbdb.getUser(this.topAnalyst).getAbr() + eol);
        }
        if (this.baseAnalyst > 0) {
            out.write("  Base analyst : " + this.sbdb.getUser(this.baseAnalyst).getAbr() + eol);
        }
        if (this.sep != null && this.sep.length() > 0) {
            out.write("  Separator : " + this.sep + eol);
        }
        boolean writeInformal = true;
        if (this.getUppZone() > 0 && scheme != null) {
            out.write("  Upper dictionary ID : " + this.getUppZone() + eol);
            unit = null;
            if (unit == null) {
                unit = scheme.findUnitBase(this.uppZone);
            }
            if (unit != null && !this.uppInf.equals(unit.getName())) {
                out.write("  Upper informal unit : " + this.uppInf + eol);
                out.write("  Upper unit : " + unit.getName() + eol);
                writeInformal = false;
            }
        }
        if (writeInformal) {
            out.write("  Upper unit : " + this.uppInf + eol);
        }
        writeInformal = true;
        if (this.getLowZone() > 0 && scheme != null) {
            out.write("  Lower dictionary ID : " + this.getLowZone() + eol);
            unit = null;
            if (unit == null) {
                unit = scheme.findUnitBase(this.lowZone);
            }
            if (unit != null && this.lowInf != null && !this.lowInf.equals(unit.getName())) {
                out.write("  Lower informal unit : " + this.lowInf + eol);
                out.write("  Lower unit : " + unit.getName() + eol);
                writeInformal = false;
            }
        }
        if (writeInformal && this.lowInf != null && this.lowInf.length() > 0) {
            out.write("  Lower unit : " + this.lowInf + eol);
        }
        out.write("  Upper boundary : " + IGDIntervalZone.getBoundary(this.topBnd) + eol);
        out.write("  Lower boundary : " + IGDIntervalZone.getBoundary(this.baseBnd) + eol);
        out.write("  Upper questionable : " + (this.qUzone ? "Yes" : "No") + eol);
        out.write("  Lower questionable : " + (this.qLzone ? "Yes" : "No") + eol);
        if (this.audit.modified != null) {
            out.write("Modified = " + df.format(this.audit.modified) + eol);
        }
        if (this.audit.modifier > 0) {
            out.write("Modifier = " + this.sbdb.getUser(this.audit.modifier).getAbr() + eol);
        }
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units, SBdb SBdb2) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind1 = SB.getXMLIndent((int)indent);
        String ind = SB.getXMLIndent((int)(indent + 3));
        super.writeXML(out, indent, units);
        out.write(ind + "<Type>" + IGDIntervalZone.getIGDName(this.igdType) + "</Type>\n");
        out.write(ind + "<Level>" + IGDIntervalZone.getDefaultHierName(this.igdType, this.hier, true) + "</Level>\n");
        IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
        if (scheme != null) {
            out.write(ind + "<SchemeID>" + this.getSchID() + "</SchemeID>\n");
        }
        if (this.topSample.getSampID() > 0) {
            out.write(ind + "<TopSampleID>" + this.topSample.getSampID() + "</TopSampleID>\n");
        }
        if (this.baseSample.getSampID() > 0) {
            out.write(ind + "<BaseSampleID>" + this.baseSample.getSampID() + "</BaseSampleID>\n");
        }
        if (this.topAnalyst > 0) {
            out.write(ind + "<TopAnalyst>" + this.topAnalyst + "</TopAnalyst>\n");
            userIDs.add(this.topAnalyst);
        }
        if (this.baseAnalyst > 0) {
            out.write(ind + "<BaseAnalyst>" + this.baseAnalyst + "</BaseAnalyst>\n");
            userIDs.add(this.baseAnalyst);
        }
        if (this.sep != null && this.sep.length() > 0) {
            out.write(ind + "<Separator>" + SB.getXMLstring((String)this.sep) + "</Separator>\n");
        }
        boolean writeInformal = true;
        if (this.uppZone > 0 && scheme != null) {
            out.write(ind + "<UpperDictionaryID>" + this.uppZone + "</UpperDictionaryID>\n");
            IGDUnitBase uppUnit = scheme.findUnitBase(this.uppZone);
            if (uppUnit != null && !this.uppInf.equals(uppUnit.getName())) {
                out.write(ind + "<UpperInformalUnit>" + SB.getXMLstring((String)this.uppInf) + "</UpperInformalUnit>\n");
                out.write(ind + "<UpperUnit>" + SB.getXMLstring((String)uppUnit.getName()) + "</UpperUnit>\n");
                writeInformal = false;
            }
        }
        if (writeInformal && this.uppInf != null && this.uppInf.length() > 0) {
            out.write(ind + "<UpperUnit>" + SB.getXMLstring((String)this.uppInf) + "</UpperUnit>\n");
        }
        writeInformal = true;
        if (this.lowZone > 0 && scheme != null) {
            out.write(ind + "<LowerDictionaryID>" + this.lowZone + "</LowerDictionaryID>\n");
            IGDUnitBase lowUnit = scheme.findUnitBase(this.lowZone);
            if (lowUnit != null && this.lowInf != null && !this.lowInf.equals(lowUnit.getName())) {
                out.write(ind + "<LowerInformalUnit>" + SB.getXMLstring((String)this.lowInf) + "</LowerInformalUnit>\n");
                out.write(ind + "<LowerUnit>" + SB.getXMLstring((String)lowUnit.getName()) + "</LowerUnit>\n");
                writeInformal = false;
            }
        }
        if (writeInformal && this.lowInf != null && this.lowInf.length() > 0) {
            out.write(ind + "<LowerUnit>" + SB.getXMLstring((String)this.lowInf) + "</LowerUnit>\n");
        }
        if (IGDIntervalZone.getBoundary(this.topBnd) != null && IGDIntervalZone.getBoundary(this.topBnd).length() > 0) {
            out.write(ind + "<UpperBoundary>" + IGDIntervalZone.getBoundary(this.topBnd) + "</UpperBoundary>\n");
        }
        if (IGDIntervalZone.getBoundary(this.baseBnd) != null && IGDIntervalZone.getBoundary(this.baseBnd).length() > 0) {
            out.write(ind + "<LowerBoundary>" + IGDIntervalZone.getBoundary(this.baseBnd) + "</LowerBoundary>\n");
        }
        if (this.qUzone) {
            out.write(ind + "<UpperQuestionable>" + (this.qUzone ? "Yes" : "No") + "</UpperQuestionable>\n");
        }
        if (this.qLzone) {
            out.write(ind + "<LowerQuestionable>" + (this.qLzone ? "Yes" : "No") + "</LowerQuestionable>\n");
        }
        userIDs.addAll(this.audit.writeXML(out, indent + 3));
        out.write(ind1 + "</IGDInterval>\n");
        return userIDs;
    }

    IGDIntervalZone(SBdb db, WsWell well, Element xml) throws SBException, ParseException, SQLException {
        super(db);
        Element el;
        int sampID;
        String strg = xml.getChildTextNormalize("TopSampleID");
        if (strg != null) {
            sampID = Integer.parseInt(strg);
            this.topSample = well.getSample(sampID, true);
            if (this.topSample == null) {
                throw new SBException("Cannot find Top Sample in Biostrat Comment for ID: " + sampID);
            }
        }
        if ((strg = xml.getChildTextNormalize("BaseSampleID")) != null) {
            sampID = Integer.parseInt(strg);
            this.baseSample = well.getSample(sampID, true);
            if (this.baseSample == null) {
                throw new SBException("Cannot find Base Sample in Biostrat Comment for ID: " + sampID);
            }
        }
        if ((strg = xml.getChildTextNormalize("TopAnalyst")) != null) {
            this.topAnalyst = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseAnalyst")) != null) {
            this.baseAnalyst = Integer.parseInt(strg);
        }
        this.uppInf = xml.getChildText("UpperUnit");
        strg = xml.getChildText("UpperInformalUnit");
        if (strg != null) {
            this.uppInf = strg;
        }
        this.lowInf = xml.getChildText("LowerUnit");
        strg = xml.getChildText("LowerInformalUnit");
        if (strg != null) {
            this.lowInf = strg;
        }
        if ((strg = xml.getChildTextNormalize("SchemeID")) == null) {
            throw new SBException("Cannot find IGD Scheme for interval: " + this.uppInf);
        }
        this.schID = Integer.parseInt(strg);
        IGDScheme scheme = db.getIGDScheme(this.schID);
        if (scheme == null) {
            System.out.println("No IGD Scheme found for ID: " + this.schID);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.igdType = IGDIntervalZone.getIGDType(strg);
        }
        if ((strg = xml.getChildTextNormalize("Level")) != null) {
            this.hier = IGDIntervalZone.getHierNumber(this.igdType, strg, true);
        }
        if ((strg = xml.getChildTextNormalize("UpperDictionaryID")) != null) {
            this.uppZone = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("LowerDictionaryID")) != null) {
            this.lowZone = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("LowerDictionaryID")) != null) {
            this.lowZone = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("UpperBoundary")) != null) {
            this.topBnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
        }
        if ((strg = xml.getChildTextNormalize("LowerBoundary")) != null) {
            this.baseBnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
        }
        if ((strg = xml.getChildTextNormalize("Separator")) != null) {
            this.sep = strg;
        }
        if ((strg = xml.getChildTextNormalize("UpperQuestionable")) != null) {
            this.qUzone = strg.equalsIgnoreCase("Yes");
        }
        if ((strg = xml.getChildTextNormalize("LowerQuestionable")) != null) {
            this.qLzone = strg.equalsIgnoreCase("Yes");
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for IGDInterval: " + this);
        }
    }

    static int loadAll(SBdb SB2, HashMap<Integer, Well> wells, HashMap<Integer, InterpHdr> interps, boolean lithostrat) throws SQLException, SBException {
        int nInt = 0;
        String sql = "SELECT well_id,igd_type,interp_id,hier,top_id,base_id," + (lithostrat ? "" : "top_analy,base_analy,") + "top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,sep," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName(lithostrat ? "IGD_LSTRAT" : "IGD");
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                Well well;
                int wellID = rs.getInt("well_id");
                int igdType = rs.getInt("igd_type");
                int interpID = rs.getInt("interp_id");
                int hier = rs.getInt("hier");
                int topID = rs.getInt("top_id");
                int baseID = rs.getInt("base_id");
                int topAnalyst = lithostrat ? 0 : rs.getInt("top_analy");
                int baseAnalyst = lithostrat ? 0 : rs.getInt("base_analy");
                int topBnd = rs.getInt("top_bnd");
                int baseBnd = rs.getInt("base_bnd");
                int schID = rs.getInt("sch_id");
                String quzone = rs.getString("q_uzone");
                boolean qUzone = quzone != null && quzone.charAt(0) == 'Y';
                int uppZone = rs.getInt("upp_zone");
                if (uppZone < 0) {
                    uppZone = 0;
                }
                String uppInf = rs.getString("upp_inf");
                String strg = rs.getString("q_lzone");
                boolean qLzone = strg != null && strg.charAt(0) == 'Y';
                int lowZone = rs.getInt("low_zone");
                if (lowZone < 0) {
                    lowZone = 0;
                }
                String lowInf = rs.getString("low_inf");
                String sep = rs.getString("sep");
                if (sep == null) {
                    sep = "-";
                }
                if ((well = wells.get(wellID)) == null) {
                    System.out.println("Well null for wellID: " + wellID + " In IGDIntervalZone.loadAll.");
                    continue;
                }
                Builder builder = new Builder(SB2, igdType, well.getSample(topID), well.getSample(baseID), hier, schID);
                builder.topAnalyst(topAnalyst).baseAnalyst(baseAnalyst).topBnd(topBnd).baseBnd(baseBnd);
                builder.uppZone(uppZone).uppInf(uppInf).lowZone(lowZone).lowInf(lowInf).qUzone(qUzone).qLzone(qLzone).sep(sep);
                builder.status = STORED;
                try {
                    IGDIntervalZone zone = builder.audit(new Audit(rs)).build();
                    well.loadInterps();
                    WellInterp interp = well.getAddInterp(interpID, interps);
                    if (interp == null) {
                        System.out.println("Interp null for wellID: " + wellID + ", interp_id: " + interpID + " In IGDIntervalZone.loadAll.");
                        continue;
                    }
                    zone.topSample = well.getSample(topID);
                    zone.baseSample = well.getSample(baseID);
                    interp.insertZone(zone);
                    ++nInt;
                }
                catch (IllegalStateException ex) {
                    System.out.println("Exception from loading IGDInterval: " + ex + " Well: " + well.toString() + " interval: " + builder.getName());
                }
            }
        }
        return nInt;
    }

    public boolean isQUzone() {
        return this.qUzone;
    }

    public String getSep() {
        return this.sep;
    }

    public boolean isQLzone() {
        return this.qLzone;
    }

    public boolean isSpotZone() {
        return this.topSample.getSampID() == this.baseSample.getSampID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(IGDIntervalZone ws, int wellID, int interpID) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        this.audit.modified = ws.audit.modified;
        this.audit.modifier = ws.sbdb.getUser(ws.audit.modifier).getLink().getUsrID();
        String sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET top_bnd=" + ws.topBnd + ",base_bnd=" + ws.baseBnd + ",q_uzone=" + (ws.qUzone ? "'Y'," : "'N',") + ",q_lzone=" + (ws.qLzone ? "'Y'," : "'N',") + ",upp_zone=" + (Serializable)(ws.uppZone > 0 ? Integer.valueOf(ws.uppZone) : "NULL") + ",low_zone=" + (Serializable)(ws.lowZone > 0 ? Integer.valueOf(ws.lowZone) : "NULL") + ",upp_inf=" + SB.DBString((String)ws.uppInf) + (String)(ws.lowInf == null || ws.lowInf.equals(ws.uppInf) ? "" : ",low_inf=" + SB.DBString((String)ws.lowInf)) + ",sep=" + ws.sep + (String)(this.igdType != 2 && ws.topAnalyst > 0 ? ",top_analy=" + ws.sbdb.getUser(ws.topAnalyst).getLink().getUsrID() : "") + (String)(this.igdType != 2 && ws.baseAnalyst > 0 ? ",base_analy=" + ws.sbdb.getUser(ws.baseAnalyst).getLink().getUsrID() : "") + this.audit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND igd_type=" + this.igdType + " AND hier=" + this.hier + " AND interp_id=" + interpID + " AND sch_id=" + this.schID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.topBnd = ws.topBnd;
        this.baseBnd = ws.baseBnd;
        this.qUzone = ws.qUzone;
        this.qLzone = ws.qLzone;
        this.uppZone = ws.uppZone;
        this.uppInf = ws.uppInf;
        this.lowZone = ws.lowZone;
        this.lowInf = ws.lowInf;
        this.sep = ws.sep;
        if (this.igdType != 2) {
            this.topAnalyst = ws.topAnalyst > 0 ? ws.sbdb.getUser(ws.topAnalyst).getLink().getUsrID() : 0;
            this.baseAnalyst = ws.baseAnalyst > 0 ? ws.sbdb.getUser(ws.baseAnalyst).getLink().getUsrID() : 0;
        }
        System.out.println("Need to deal with db/ws scheme linkages");
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(int wellID, int interpID, int newInterpID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND hier = " + this.hier + " AND igd_type=" + this.igdType + " AND interp_id=" + interpID + " AND sch_id=" + this.schID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    boolean checkDepthBracketing(IGDIntervalZone zone) throws SBException {
        int nzTD = (int)Math.round(100.0 * zone.topSample.getDepth('M'));
        int nzBD = (int)Math.round(100.0 * zone.baseSample.getDepth('M'));
        int cTD = (int)Math.round(100.0 * this.topSample.getDepth('M'));
        int cBD = (int)Math.round(100.0 * this.baseSample.getDepth('M'));
        if (nzBD > cTD) {
            return nzTD >= cBD;
        }
        if (nzTD < cBD) {
            return nzBD <= cTD;
        }
        return true;
    }

    void setTopBnd(SBdb SB2, int wellID, int interpID, int igdType, int topBnd) throws SQLException {
        String sql = "UPDATE " + SB2.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET top_bnd=" + topBnd + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND top_id=" + this.topSample.getSampID() + " AND igd_type=" + igdType + " AND sch_id=" + this.getSchID() + " AND hier=" + this.getHier();
        try (Statement stmt = SB2.getDatabase().createStatement();){
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        this.topBnd = topBnd;
    }

    void setBaseBnd(SBdb SB2, int wellID, int interpID, int igdType, int baseBnd) throws SQLException {
        String sql = "UPDATE " + SB2.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET base_bnd=" + baseBnd + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND base_id=" + this.baseSample.getSampID() + " AND igd_type=" + igdType + " AND sch_id=" + this.getSchID() + " AND hier=" + this.getHier();
        try (Statement stmt = SB2.getDatabase().createStatement();){
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        this.baseBnd = baseBnd;
    }

    public void setHier(int hier) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set database IGDIntervalZone hierarchy");
        }
        this.hier = hier;
    }

    @Override
    public boolean mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        if (this.topSample == donor) {
            this.topSample = target;
            hasChanged = true;
        }
        if (this.baseSample == donor) {
            this.baseSample = target;
            hasChanged = true;
        }
        return hasChanged;
    }

    public void setSchID(int id) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set database IGDIntervalZone");
        }
        this.schID = id;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        if (e instanceof IGDIntervalZone) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            IGDIntervalZone comp = (IGDIntervalZone)e;
            if (this.topSample.isFuncEquivalent(comp.topSample) && this.baseSample.isFuncEquivalent(comp.baseSample) && this.igdType == comp.igdType && this.hier == comp.getHier() && this.getSchemeName(true).equals(comp.getSchemeName(true))) {
                return true;
            }
        }
        return false;
    }

    public void setUppInf(String newUppInf) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set upper informal name on database zone: " + this);
        }
        this.uppInf = newUppInf;
    }

    public void setLowInf(String newLowInf) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set lower informal name on database zone: " + this);
        }
        this.lowInf = newLowInf;
    }

    public void setUppZone(int newUppZone) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set upper link unit on database zone: " + this);
        }
        this.uppZone = newUppZone;
    }

    public void setLowZone(int newLowZone) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set upper link unit on database zone: " + this);
        }
        this.lowZone = newLowZone;
    }

    public void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database zone: " + this);
        }
        if (this.topAnalyst > 0) {
            this.topAnalyst = analyst.getUsrID();
        }
        if (this.baseAnalyst > 0) {
            this.baseAnalyst = analyst.getUsrID();
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private IGDIntervalZone(Builder builder) {
        super(builder);
        this.hier = builder.hier;
        this.schID = builder.schID;
        this.topBnd = builder.topBnd;
        this.baseBnd = builder.baseBnd;
        this.qUzone = builder.qUzone;
        this.uppInf = builder.uppInf;
        this.uppZone = builder.uppZone;
        this.sep = builder.sep;
        this.qLzone = builder.qLzone;
        this.lowZone = builder.lowZone;
        this.lowInf = builder.lowInf;
        this.topAnalyst = builder.topAnalyst;
        this.baseAnalyst = builder.baseAnalyst;
        this.status = builder.status;
    }

    static {
        defaultHierNames.put(3, new String[]{"Period/Epoch", "Age"});
        defaultHierNames.put(2, new String[]{"Group", "Formation", "Member", "Bed"});
        defaultHierNames.put(4, new String[]{"Super Zone", "Zone", "Sub Zone"});
        defaultHierNames.put(10, new String[]{"Sequence", "Sub Sequence"});
        defaultHierNames.put(26, new String[]{"Series", "Chron", "Sub Chron"});
        defaultHierNamesExtended = new HashMap();
        defaultHierNamesExtended.put(3, new String[]{"Eon", "Era", "Period", "Sub Period", "Epoch", "Sub Epoch", "Age", "Sub Age"});
    }

    public static class Builder
    extends IGDInterval.Builder {
        private final int hier;
        private final int schID;
        private int topBnd = 2;
        private int baseBnd = 2;
        private int topAnalyst;
        private int baseAnalyst;
        private String uppInf = "";
        private int uppZone = 0;
        private boolean qUzone = false;
        private String sep = "-";
        private int lowZone = 0;
        private String lowInf = "";
        private boolean qLzone = false;
        static final String RESET_UNITS_PREFIX = "Reset Units: ";

        public Builder(SBdb sbdb, int igdType, Sample topSample, Sample baseSample, int hier, int schID) {
            super(sbdb, igdType, topSample, baseSample);
            this.hier = hier;
            this.schID = schID;
        }

        public static Builder copyOf(IGDIntervalZone zone) throws SBException {
            Builder builder = new Builder(zone.sbdb, zone.igdType, zone.topSample, zone.baseSample, zone.hier, zone.schID);
            Builder.copy(builder, zone);
            return builder;
        }

        public static Builder copyOf(IGDIntervalZone zone, int newSchID) throws SBException {
            Builder builder = new Builder(zone.sbdb, zone.igdType, zone.topSample, zone.baseSample, zone.hier, newSchID);
            Builder.copy(builder, zone);
            return builder;
        }

        public static Builder copyOf(IGDIntervalZone zone, Sample topSample, Sample baseSample) throws SBException {
            Builder builder = new Builder(zone.sbdb, zone.igdType, topSample, baseSample, zone.hier, zone.schID);
            Builder.copy(builder, zone);
            return builder;
        }

        private static Builder copy(Builder builder, IGDIntervalZone zone) {
            builder.topBnd(zone.topBnd).baseBnd(zone.baseBnd).topAnalyst(zone.topAnalyst).baseAnalyst(zone.baseAnalyst);
            builder.uppInf(zone.uppInf).uppZone(zone.uppZone).qUzone(zone.qUzone).sep(zone.sep);
            builder.lowInf(zone.lowInf).lowZone(zone.lowZone).qLzone(zone.qLzone).audit(new Audit(zone.audit));
            return builder;
        }

        IGDIntervalZone build() throws SBException, SQLException {
            this.validateFields();
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new IGDIntervalZone(this);
        }

        IGDIntervalZone build(int wellID, int interpID) throws SBException, SQLException {
            IGDIntervalZone zone = this.build();
            zone.store(wellID, interpID);
            return zone;
        }

        void validateFields() throws SQLException, SBException {
            super.validate();
            if (this.uppZone == 0 && this.uppInf.isEmpty()) {
                throw new IllegalStateException("Attempt to build zone with no upper unit or informal name.");
            }
            if (this.schID <= 0) {
                throw new IllegalStateException("Attempt to build zone with illegal scheme ID: " + this.schID);
            }
            IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
            if (this.uppZone > 0 && scheme.findUnitBase(this.uppZone) == null) {
                throw new IllegalStateException("Reset Units: Attempt to build zone: " + this.uppInf + " where upper unit: " + this.uppZone + " is not in scheme: " + this.schID);
            }
            if (this.lowZone > 0 && this.uppZone > 0 && this.lowZone == this.uppZone) {
                this.lowZone = 0;
            }
            if (!this.lowInf.isEmpty() && !this.uppInf.isEmpty() && this.lowInf.equals(this.uppInf)) {
                this.lowInf = "";
            }
            if (this.lowZone > 0 && scheme.findUnitBase(this.lowZone) == null) {
                throw new IllegalStateException("Reset Units: Attempt to build zone: " + this.lowInf + " where lower unit: " + this.lowZone + " is not in scheme: " + this.schID);
            }
            if (this.uppInf.isEmpty()) {
                this.uppInf = scheme.findUnitBase(this.uppZone).getName();
            }
            if (this.lowZone > 0 && this.lowInf.isEmpty()) {
                this.lowInf = scheme.findUnitBase(this.lowZone).getName();
            }
            if (!this.lowInf.isEmpty() && this.sep.isEmpty()) {
                this.sep = "-";
            }
            if (this.lowInf.isEmpty() && this.qLzone) {
                this.qLzone = false;
            }
        }

        Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        public Builder topBnd(int topBnd) {
            this.topBnd = topBnd;
            return this;
        }

        public Builder baseBnd(int baseBnd) {
            this.baseBnd = baseBnd;
            return this;
        }

        public Builder qUzone(boolean qUzone) {
            this.qUzone = qUzone;
            return this;
        }

        public Builder uppInf(String uppInf) {
            if (uppInf != null) {
                this.uppInf = uppInf;
            }
            return this;
        }

        public Builder uppZone(int uppZone) {
            if (uppZone >= 0) {
                this.uppZone = uppZone;
            }
            return this;
        }

        public Builder zones(IGDUnitBase uppZone, IGDUnitBase lowZone) {
            if (uppZone != null) {
                this.uppZone = uppZone.getUnitID();
            }
            if (lowZone != null) {
                this.lowZone = lowZone.getUnitID();
            }
            return this;
        }

        public Builder sep(String sep) {
            if (sep != null) {
                this.sep = sep;
            }
            return this;
        }

        public Builder qLzone(boolean qLzone) {
            this.qLzone = qLzone;
            return this;
        }

        public Builder lowZone(int lowZone) {
            if (lowZone >= 0) {
                this.lowZone = lowZone;
            }
            return this;
        }

        public Builder lowInf(String lowInf) {
            if (lowInf != null) {
                this.lowInf = lowInf;
            }
            return this;
        }

        public Builder topAnalyst(int topAnalyst) {
            if (this.igdType == 4) {
                this.topAnalyst = topAnalyst;
            }
            return this;
        }

        public Builder baseAnalyst(int baseAnalyst) {
            if (this.igdType == 4) {
                this.baseAnalyst = baseAnalyst;
            }
            return this;
        }

        public int getHier() {
            return this.hier;
        }

        String getName() {
            return this.uppInf + (this.lowInf != null ? this.lowInf : "");
        }

        public int getSchID() {
            return this.schID;
        }

        int getTopBndInt() {
            return this.topBnd;
        }

        int getBaseBndInt() {
            return this.baseBnd;
        }

        public int getUppZone() {
            return this.uppZone;
        }
    }

    public static enum BoundaryType {
        TOP("Top"),
        BASE("Base");

        String descr;

        private BoundaryType(String descr) {
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }

    public static enum Boundary {
        POSS("Possible", false, false),
        PROB("Probable", false, false),
        CONF("Confident", false, false),
        UNCF("Unconformable", true, true),
        QUNCF("?Unconformable", true, true),
        FAULT("Fault", false, true),
        QFAULT("?Fault", false, true),
        RFAULT("ReverseFault", false, true);

        private final String descr;
        private final boolean unconformable;
        private final boolean disconformable;

        private Boundary(String descr, boolean uncnf, boolean discnf) {
            this.descr = descr;
            this.unconformable = uncnf;
            this.disconformable = discnf;
        }

        public int getBndInt() {
            return this.ordinal() + 1;
        }

        public static Boundary getBnd(int bndInt) {
            if (--bndInt > -1 && bndInt < Boundary.values().length) {
                return Boundary.values()[bndInt];
            }
            return null;
        }

        public static Boundary getBnd(String bnd) {
            for (Boundary b : Boundary.values()) {
                if (!b.descr.equalsIgnoreCase(bnd)) continue;
                return b;
            }
            return CONF;
        }

        public String toString() {
            return this.descr;
        }

        public boolean isUnconformable() {
            return this.unconformable;
        }

        public boolean isDisconformable() {
            return this.disconformable;
        }

        public boolean isFault() {
            return this == FAULT || this == RFAULT || this == QFAULT;
        }
    }
}

