/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2_1.AgeConfidence;
import model2_1.IGDAge;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.IGDUnitBase;
import model2_1.LithostratUnit;
import model2_1.SBdb;
import model2_1.api.Discipline;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.SBException;

public class IGDSchemeXLSReader {
    private IGDSchemeXLSReader() {
    }

    public static List<IGDUnitBase.Builder> read(SBdb ws, File file, int igdType) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        LinkedList<SchemeUnitBuilder> unitBuilders = new LinkedList<SchemeUnitBuilder>();
        IGDSchemeXLSReader.parseSheet(ws, wb.getSheetAt(0), igdType, unitBuilders);
        return SchemeUnitBuilder.getBuilders(unitBuilders);
    }

    public static void read(SBdb ws, File file, int igdType, boolean addToWs) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        IGDScheme scheme = new IGDScheme(ws, igdType, wb.getSheetName(0), igdType == 4 ? Discipline.MICRO : null, null, 0);
        scheme.setSchID(1);
        scheme = IGDSchemeXLSReader.parseSheet(ws, wb.getSheetAt(0), igdType, scheme);
        if (!(scheme == null || scheme.getUnitsX().isEmpty() && scheme.getLithostratUnits().isEmpty())) {
            ws.addIGDScheme(scheme);
        }
    }

    private static void parseSheet(SBdb ws, Sheet sheet, int igdType, LinkedList<SchemeUnitBuilder> unitBuilders) throws SBException, FileNotFoundException, IOException, SQLException {
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null");
            return;
        }
        String[] colNames = new String[30];
        int maxCol = 0;
        for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= colNames.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) continue;
            colNames[cellNum] = cell.getStringCellValue();
            maxCol = cellNum;
        }
        ColType[] columns = new ColType[maxCol + 1];
        for (int i = 0; i <= maxCol; ++i) {
            try {
                if (colNames[i] == null) {
                    columns[i] = null;
                    continue;
                }
                columns[i] = ColType.getColumnType(colNames[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                columns[i] = null;
            }
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            SchemeUnitBuilder b;
            Row row = sheet.getRow(nRow);
            if (row == null || (b = IGDSchemeXLSReader.parseIGDUnit(ws, igdType, row, columns)) == null) continue;
            unitBuilders.add(b);
        }
    }

    private static IGDScheme parseSheet(SBdb ws, Sheet sheet, int igdType, IGDScheme scheme) throws SBException, FileNotFoundException, IOException, SQLException {
        int titleRowNum = 0;
        Row titleRow = sheet.getRow(titleRowNum);
        if (titleRow == null) {
            System.out.println("column titles in row 1 are null");
            return null;
        }
        Cell topLeft = titleRow.getCell(0);
        System.out.println("Contents of topLeft: " + topLeft);
        if (topLeft != null && topLeft.getCellType() == CellType.STRING && !topLeft.getStringCellValue().trim().equalsIgnoreCase("strat_column")) {
            LinkedList<SchemeUnitBuilder> unitBuilders = new LinkedList<SchemeUnitBuilder>();
            IGDSchemeXLSReader.parseSheet(ws, sheet, igdType, unitBuilders);
            String lastScheme = null;
            for (SchemeUnitBuilder builder : unitBuilders) {
                try {
                    if (lastScheme == null) {
                        lastScheme = builder.schemeName;
                        if (builder.schemeName != null && !builder.schemeName.isEmpty()) {
                            scheme.setName(builder.schemeName);
                        }
                    } else if (!lastScheme.equals(builder.schemeName)) {
                        if (!scheme.getUnitsX().isEmpty() || !scheme.getLithostratUnits().isEmpty()) {
                            ws.addIGDScheme(scheme);
                        }
                        int schID = scheme.getID();
                        scheme = new IGDScheme(ws, igdType, builder.schemeName, null, null, 0);
                        scheme.setSchID(++schID);
                        lastScheme = builder.schemeName;
                    }
                    scheme.addUnit(builder.builder);
                }
                catch (Exception ex) {
                    System.out.println("Failed to add unit: " + ex.toString());
                }
            }
        } else {
            titleRowNum = 2;
            titleRow = sheet.getRow(titleRowNum);
            if (titleRow == null) {
                System.out.println("column titles in row 3 are null");
                return null;
            }
            for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
                Cell cell = titleRow.getCell((int)cellNum);
                if (cell == null) continue;
                String title = cell.getStringCellValue();
                if (title.equalsIgnoreCase("Group")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, title, true));
                    continue;
                }
                if (title.toLowerCase().startsWith("formation")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Formation", true));
                    continue;
                }
                if (title.toLowerCase().startsWith("member")) {
                    IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Member", true));
                    continue;
                }
                if (!title.toLowerCase().startsWith("bed")) continue;
                IGDSchemeXLSReader.parseColumns(ws, sheet, scheme, titleRowNum, cellNum, IGDIntervalZone.getHierNumber(igdType, "Bed", true));
            }
        }
        return scheme;
    }

    private static void parseColumns(SBdb ws, Sheet sheet, IGDScheme scheme, int titleRowNum, short nameColNum, int hier) {
        for (int nRow = titleRowNum + 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String name;
            Cell nameCell;
            Row row = sheet.getRow(nRow);
            if (row == null || (nameCell = row.getCell((int)nameColNum)) == null || (name = nameCell.getStringCellValue()) == null || (name = name.trim()).isEmpty()) continue;
            IGDUnit.Builder builder = null;
            LithostratUnit.Builder lsBuilder = null;
            if (scheme.getIGDType() == 2) {
                lsBuilder = new LithostratUnit.Builder(ws);
                lsBuilder.hier(hier).name(name);
            } else {
                builder = new IGDUnit.Builder(ws);
                builder.hier(hier).name(name);
            }
            double top = -1.0;
            double base = -1.0;
            block12: for (int i = 1; i < 4; i = (int)((short)(i + 1))) {
                Cell cell = row.getCell(nameColNum + i);
                if (cell == null) continue;
                switch (i) {
                    case 1: {
                        top = IGDSchemeXLSReader.getNumericCell(cell);
                        continue block12;
                    }
                    case 2: {
                        base = IGDSchemeXLSReader.getNumericCell(cell);
                        continue block12;
                    }
                    case 3: {
                        Object abr = null;
                        switch (cell.getCellType()) {
                            case NUMERIC: {
                                abr = "" + cell.getNumericCellValue();
                                break;
                            }
                            case STRING: {
                                abr = cell.getStringCellValue();
                            }
                        }
                        if (abr == null || ((String)abr).trim().isEmpty()) continue block12;
                        if (scheme.getIGDType() == 2) {
                            lsBuilder.abr((String)abr);
                            continue block12;
                        }
                        builder.abr((String)abr);
                    }
                }
            }
            if (base < 0.0) {
                base = top;
            }
            if (top < 0.0) {
                top = base;
            }
            if (top >= 0.0 && base >= 0.0) {
                if (scheme.getIGDType() == 2) {
                    lsBuilder.age(1, top);
                    lsBuilder.age(0, top);
                    lsBuilder.age(2, base);
                    lsBuilder.age(3, base);
                } else {
                    builder.age(top, base);
                }
            }
            try {
                if (scheme.getIGDType() == 2) {
                    scheme.addUnit(lsBuilder);
                    continue;
                }
                scheme.addUnit(builder);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Failed to add unit: " + ex.toString());
            }
        }
    }

    private static Double getNumericCell(Cell cell) {
        double number = 0.0;
        switch (cell.getCellType()) {
            case NUMERIC: {
                number = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                String sBase = cell.getStringCellValue().trim();
                if (sBase == null || sBase.length() == 0) break;
                sBase = sBase.replace(',', '.');
                number = Double.parseDouble(sBase);
            }
        }
        return number;
    }

    private static SchemeUnitBuilder parseIGDUnit(SBdb ws, int igdType, Row row, ColType[] columns) throws SBException, SQLException {
        IGDUnitBase.Builder builder = igdType == 2 ? new LithostratUnit.Builder(ws) : new IGDUnit.Builder(ws);
        SchemeUnitBuilder sBuilder = new SchemeUnitBuilder(null, builder);
        block21: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null || columns[cellNum] == null) continue;
            switch (columns[cellNum]) {
                case SCHEME_NAME: {
                    sBuilder.schemeName = cell.getStringCellValue();
                    continue block21;
                }
                case NAME: {
                    builder.name(cell.getStringCellValue());
                    continue block21;
                }
                case TYPE: {
                    String unitTypeString = cell.getStringCellValue();
                    int hier = IGDIntervalZone.getHierNumber(igdType, unitTypeString, true);
                    builder.hier(hier);
                    continue block21;
                }
                case U_AGE: {
                    double uage = IGDSchemeXLSReader.getNumericCell(cell);
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).age(2, uage);
                        ((LithostratUnit.Builder)builder).age(3, uage);
                        ((LithostratUnit.Builder)builder).age(0, uage);
                        ((LithostratUnit.Builder)builder).age(1, uage);
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).age(true, new IGDAge(uage));
                    continue block21;
                }
                case L_AGE: {
                    double lage = IGDSchemeXLSReader.getNumericCell(cell);
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).age(2, lage);
                        ((LithostratUnit.Builder)builder).age(3, lage);
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).age(false, new IGDAge(lage));
                    continue block21;
                }
                case ABR: {
                    Object abr;
                    try {
                        abr = cell.getStringCellValue();
                    }
                    catch (Exception ex) {
                        abr = "" + cell.getNumericCellValue();
                    }
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).abr((String)abr);
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).abr((String)abr);
                    continue block21;
                }
                case U_CONF: {
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).bnd(true, IGDIntervalZone.Boundary.getBnd(cell.getStringCellValue()));
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).getigdAge(true).setConfidence(AgeConfidence.getConfidence(cell.getStringCellValue()));
                    continue block21;
                }
                case L_CONF: {
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).bnd(false, IGDIntervalZone.Boundary.getBnd(cell.getStringCellValue()));
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).getigdAge(false).setConfidence(AgeConfidence.getConfidence(cell.getStringCellValue()));
                    continue block21;
                }
                case COLOUR: {
                    Color colour = null;
                    try {
                        switch (cell.getCellType()) {
                            case NUMERIC: {
                                int colourInt = (int)cell.getNumericCellValue();
                                colour = new Color(colourInt);
                                break;
                            }
                            case STRING: {
                                try {
                                    colour = Color.decode(cell.getStringCellValue());
                                    break;
                                }
                                catch (NumberFormatException ne) {
                                    colour = Color.decode("#" + cell.getStringCellValue());
                                }
                            }
                        }
                    }
                    catch (NumberFormatException ne) {
                        System.out.println("Can't decode colour string: " + cell.getStringCellValue());
                    }
                    if (colour == null) continue block21;
                    if (igdType == 2) {
                        ((LithostratUnit.Builder)builder).colour(colour);
                        continue block21;
                    }
                    ((IGDUnit.Builder)builder).colour(colour);
                }
            }
        }
        if (builder.getName().isEmpty()) {
            System.out.println("Didn't build: '" + builder.getName());
            return null;
        }
        return sBuilder;
    }

    private static class SchemeUnitBuilder {
        String schemeName;
        IGDUnitBase.Builder builder;

        SchemeUnitBuilder(String s, IGDUnitBase.Builder b) {
            this.schemeName = s;
            this.builder = b;
        }

        public static List<IGDUnitBase.Builder> getBuilders(List<SchemeUnitBuilder> list) {
            LinkedList<IGDUnitBase.Builder> unitBuilders = new LinkedList<IGDUnitBase.Builder>();
            for (SchemeUnitBuilder s : list) {
                unitBuilders.add(s.builder);
            }
            return unitBuilders;
        }
    }

    private static enum ColType {
        SCHEME_NAME(new String[]{"STRAT_COLUMN"}),
        NAME(new String[]{"NAME", "UNIT_NAME", "UNIT NAME"}),
        TYPE(new String[]{"TYPE", "UNIT TYPE", "HIER", "STRAT_UNIT_KIND"}),
        U_AGE(new String[]{"U_AGE", "TOP", "YOUNGEST", "AGE_AT_TOP"}),
        L_AGE(new String[]{"L_AGE", "BASE", "OLDEST", "AGE_AT_BASE"}),
        ABR(new String[]{"ABBREV", "ABR", "LOCAL_NAME"}),
        U_CONF(new String[]{"TOP CONFIDENCE", "TOP CONF"}),
        L_CONF(new String[]{"BASE CONFIDENCE", "BASE CONF"}),
        COLOUR(new String[]{"COLOUR", "COLOR", "UNIT_COLOUR"});

        private final String[] titles;

        private ColType(String[] titles) {
            this.titles = titles;
        }

        static ColType getColumnType(String title) {
            if ((title = title.trim()).isEmpty()) {
                return null;
            }
            title = title.trim().toUpperCase();
            for (ColType col : ColType.values()) {
                for (int i = 0; i < col.titles.length; ++i) {
                    if (!title.equals(col.titles[i])) continue;
                    return col;
                }
            }
            throw new IllegalArgumentException("Unrecognised column title: " + title);
        }
    }
}

