/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model2_1.Biocom;
import model2_1.IGDInterval;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.Intcom;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Surface;
import model2_1.Well;
import model2_1.WellEvent;
import model2_1.WsWell;
import model2_1.api.Discipline;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class IGDXLSReader {
    List nonInserts = new LinkedList();
    Set dataTypes;
    SBdb ws;
    char defaultUnits;
    File file;
    public static final String MICRO_COMMENTS_SHEET = "Micro Comments";
    public static final String PALY_COMMENTS_SHEET = "Paly Comments";
    public static final String NANO_COMMENTS_SHEET = "Nanno Comments";
    public static final String INTERVAL_COMMENTS_SHEET = "Interval Comments";
    public static final String EVENTS_SHEET = "Events";
    public static final String SEQUENCE_SHEET = "Sequence";
    public static final String AGE_SHEET = "Age";
    public static final String BIOZONE_SHEET = "Biozone";
    public static final String GROUP_SHEET = "Group";
    public static final String FORMATION_SHEET = "Formation";
    public static final String MEMBER_SHEET = "Member";
    public static final String BED_SHEET = "Bed";

    public IGDXLSReader(SBdb ws, File file, Set dataTypes, char units) throws SBException, SQLException, IOException, InvalidFormatException {
        Workbook wb;
        this.dataTypes = dataTypes;
        this.ws = ws;
        this.defaultUnits = units;
        this.file = file;
        try (FileInputStream is = new FileInputStream(file);){
            wb = WorkbookFactory.create((InputStream)is);
        }
        Object exceptionMessage = "";
        for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            Sheet sheet = wb.getSheetAt(j);
            System.out.println("processing sheet: " + wb.getSheetName(j) + "\n");
            try {
                this.parseSheet(wb.getSheetName(j), sheet);
                continue;
            }
            catch (RuntimeException e) {
                if (!((String)exceptionMessage).isEmpty()) {
                    exceptionMessage = (String)exceptionMessage + "\n";
                }
                exceptionMessage = (String)exceptionMessage + "Error reading sheet '" + wb.getSheetName(j) + "': " + e.getMessage();
                e.printStackTrace();
                System.out.println("Continuing after sheet error.\n\n");
            }
        }
        Iterator<Well> it = ws.getWellIterator();
        while (it.hasNext()) {
            WsWell well = (WsWell)it.next();
            well.updateStatus();
        }
        if (!((String)exceptionMessage).isEmpty()) {
            throw new SBException((String)exceptionMessage);
        }
    }

    private void parseSheet(String sheetName, Sheet sheet) throws SBException, FileNotFoundException, IOException, SQLException {
        String[] columns = new String[20];
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + sheetName);
            return;
        }
        for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= columns.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            columns[cellNum] = cell.getStringCellValue();
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            System.out.println("Parsing row number: " + (nRow + 1));
            if (sheetName.equalsIgnoreCase(AGE_SHEET) || sheetName.equalsIgnoreCase("Chronostratigraphy")) {
                this.parseZone(3, 7, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(BIOZONE_SHEET)) {
                this.parseZone(4, 2, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(GROUP_SHEET)) {
                this.parseZone(2, 1, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(FORMATION_SHEET) || sheetName.equalsIgnoreCase("Lithostratigraphy")) {
                this.parseZone(2, 2, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(MEMBER_SHEET)) {
                this.parseZone(2, 3, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(BED_SHEET)) {
                this.parseZone(2, 4, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(SEQUENCE_SHEET)) {
                this.parseSQPick(row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(PALY_COMMENTS_SHEET)) {
                this.parseBiocom(Discipline.PALY, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(MICRO_COMMENTS_SHEET)) {
                this.parseBiocom(Discipline.MICRO, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(NANO_COMMENTS_SHEET)) {
                this.parseBiocom(Discipline.NANNO, row, columns);
                continue;
            }
            if (sheetName.equalsIgnoreCase(INTERVAL_COMMENTS_SHEET)) {
                this.parseIntcom(row, columns);
                continue;
            }
            if (sheetName.toUpperCase().contains("EVENTS")) {
                this.parseWellEvents(sheetName, row, columns);
                continue;
            }
            System.out.println("Cannot parse row in sheet called: " + sheetName);
        }
    }

    WsWell getWell(String wellName, String wellCode) {
        WsWell well = null;
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            Well w = it.next();
            if (wellName == null && wellCode == null) {
                well = (WsWell)w;
                break;
            }
            if (wellCode != null) {
                if (!w.getWellCode().equals(wellCode)) continue;
                well = (WsWell)w;
                break;
            }
            if (!w.getWellName().equals(wellName)) continue;
            well = (WsWell)w;
            break;
        }
        if (well == null) {
            try {
                well = this.ws.addWellToWorkspace(0, this.file.getPath());
                if (wellCode != null) {
                    well.getHeader().setWellCode(wellCode);
                } else if (wellName != null) {
                    well.getHeader().setWellCode(Well.makeCode(wellName));
                }
                if (wellName != null) {
                    well.getHeader().setWellName(wellName);
                } else if (wellCode != null) {
                    well.getHeader().setWellName(wellCode);
                }
                well.loadInterps();
            }
            catch (SQLException | SBException sqle) {
                sqle.printStackTrace();
            }
        }
        return well;
    }

    void parseZone(int igdType, int hier, Row row, String[] columns) throws SBException, SQLException {
        IGDScheme scheme;
        Sample topSample = null;
        Sample baseSample = null;
        Cell topSampleCell = null;
        Cell baseSampleCell = null;
        int units = this.defaultUnits;
        int topBnd = -1;
        int baseBnd = -1;
        String uppInf = "";
        String lowInf = "";
        boolean qUzone = false;
        boolean qLzone = false;
        Discipline disc = null;
        String wellName = null;
        String wellCode = null;
        block11: for (short cellNum = row.getFirstCellNum(); cellNum >= 0 && cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null || columns[cellNum] == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case WELLNAME: {
                    wellName = cell.getStringCellValue();
                    continue block11;
                }
                case WELLCODE: {
                    wellCode = cell.getStringCellValue();
                    continue block11;
                }
                case TOPDEPTH: {
                    topSampleCell = cell;
                    units = columns[cellNum].contains("ft") ? 70 : (int)this.defaultUnits;
                    continue block11;
                }
                case BASEDEPTH: {
                    baseSampleCell = cell;
                    units = columns[cellNum].contains("ft") ? 70 : (int)this.defaultUnits;
                    continue block11;
                }
                case TOPBND: {
                    topBnd = this.parseBnd(cell.getStringCellValue());
                    continue block11;
                }
                case BASEBND: {
                    baseBnd = this.parseBnd(cell.getStringCellValue());
                    continue block11;
                }
                case LEGEND: {
                    String text = cell.getStringCellValue();
                    if (text.indexOf(" - ") > 0) {
                        uppInf = text.substring(0, text.indexOf(" - ")).trim();
                        lowInf = text.substring(text.indexOf(" - ") + 3).trim();
                    } else {
                        uppInf = text;
                    }
                    if (uppInf.startsWith("?")) {
                        qUzone = true;
                        uppInf = uppInf.substring(1).trim();
                    }
                    if (!lowInf.startsWith("?")) continue block11;
                    qLzone = true;
                    lowInf = lowInf.substring(1).trim();
                    continue block11;
                }
                case HIER: {
                    String htext = cell.getStringCellValue();
                    int h = IGDIntervalZone.getHierNumber(igdType, htext, true);
                    if (h <= 0) continue block11;
                    hier = h;
                    continue block11;
                }
                case DISCIPLINE: {
                    disc = Discipline.parseDisc(cell.getStringCellValue());
                }
            }
        }
        Object schemeName = "Unassigned ";
        if (disc != null) {
            schemeName = (String)schemeName + disc.getAdj() + " ";
        }
        if ((scheme = this.ws.getIGDScheme((String)(schemeName = (String)schemeName + IGDInterval.getIGDName(igdType)), igdType)) == null) {
            scheme = this.ws.addIGDScheme(igdType, (String)schemeName);
        }
        WsWell well = this.getWell(wellName, wellCode);
        if (topSampleCell != null) {
            topSample = this.parseSample(well, topSampleCell, "LOG", true, (char)units);
        }
        if (baseSampleCell != null) {
            baseSample = this.parseSample(well, baseSampleCell, "LOG", true, (char)units);
        }
        if (topSample == null || baseSample == null || topBnd == -1 || baseBnd == -1) {
            this.nonInserts.add(uppInf);
            System.out.println("Cannot insert zone: " + uppInf);
        } else {
            System.out.println("Adding well: " + well + " topSample: " + topSample + ", baseSample: " + baseSample + " Inf: " + uppInf + " TopBnd: " + topBnd + " BaseBnd: " + baseBnd);
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, igdType, topSample, baseSample, hier, scheme.getSchID()).topBnd(topBnd).baseBnd(baseBnd);
            builder.uppInf(uppInf).lowInf(lowInf).qUzone(qUzone).qLzone(qLzone);
            well.getAddInterp(this.ws.getInterp(0)).getIGDList(igdType).add(builder.build());
            this.addDataType(IGDInterval.igdType2dType(igdType));
        }
    }

    void parseSQPick(Row row, String[] columns) throws SBException, SQLException {
        Surface surface;
        Sample sample = null;
        Cell sampleCell = null;
        String wellName = null;
        String wellCode = null;
        int bnd = -1;
        String name = "";
        boolean qUzone = false;
        int units = this.defaultUnits;
        block11: for (short cellNum = row.getFirstCellNum(); cellNum >= 0 && cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case WELLNAME: {
                    wellName = cell.getStringCellValue();
                    continue block11;
                }
                case WELLCODE: {
                    wellCode = cell.getStringCellValue();
                    continue block11;
                }
                case TOPDEPTH: {
                    sampleCell = cell;
                    units = columns[cellNum].contains("ft") ? 70 : (int)this.defaultUnits;
                    continue block11;
                }
                case LEGEND: {
                    String text = cell.getStringCellValue();
                    name = text.indexOf(" - ") > 0 ? text.substring(0, text.indexOf(" - ")).trim() : text;
                    if (!name.startsWith("?")) continue block11;
                    qUzone = true;
                    name = name.substring(1).trim();
                    continue block11;
                }
                case TOPBND: {
                    bnd = this.parseBnd(cell.getStringCellValue());
                }
            }
        }
        WsWell well = this.getWell(wellName, wellCode);
        sample = this.parseSample(well, sampleCell, "LOG", true, (char)units);
        IGDScheme scheme = this.ws.getIGDScheme("Unassigned " + IGDInterval.getIGDName(10), 10);
        if (scheme == null) {
            scheme = this.ws.addIGDScheme(10, "Unassigned " + IGDInterval.getIGDName(10));
        }
        if ((surface = scheme.getSurface(name, null)) == null) {
            try {
                surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(name).type(Surface.SurfaceType.parseType(name, Surface.SurfaceType.SB)));
            }
            catch (InvalidFieldException e) {
                e.printStackTrace();
            }
        }
        if (sample == null) {
            this.nonInserts.add(name);
            System.out.println("Cannot insert sequence pick: " + name);
        } else {
            try {
                well.getAddInterp(this.ws.getInterp(0)).addSQPick(well, sample, surface, name, qUzone, bnd);
                this.addDataType(14);
            }
            catch (InvalidFieldException | SBPermissionException ex) {
                System.out.println("Exception inserting sequence pick: " + ex.toString());
                this.nonInserts.add(name);
            }
        }
    }

    private void parseBiocom(Discipline discID, Row row, String[] columns) throws SQLException, SBException, FileNotFoundException, IOException {
        Sample topSample = null;
        Cell sampleCell = null;
        String sampleType = "CU";
        String text = null;
        boolean isFeetColumn = false;
        String wellName = null;
        String wellCode = null;
        block7: for (short cellNum = row.getFirstCellNum(); cellNum >= 0 && cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn col = XLSColumn.getColumnType(columns[cellNum]);
            switch (col) {
                case WELLNAME: {
                    wellName = cell.getStringCellValue();
                    continue block7;
                }
                case WELLCODE: {
                    wellCode = cell.getStringCellValue();
                    continue block7;
                }
                case TYPE: {
                    sampleType = cell.getStringCellValue();
                    continue block7;
                }
                case DEPTH: {
                    sampleCell = cell;
                    isFeetColumn = columns[cellNum].contains("ft");
                    continue block7;
                }
                case LEGEND: {
                    text = cell.getStringCellValue();
                }
            }
        }
        WsWell well = this.getWell(wellName, wellCode);
        if (sampleCell != null) {
            topSample = this.parseSample(well, sampleCell, sampleType, false, isFeetColumn ? (char)'F' : (char)this.defaultUnits);
        }
        if (text == null) {
            if (topSample != null) {
                this.nonInserts.add(topSample.toString());
            }
            return;
        }
        if (topSample == null) {
            this.nonInserts.add(text);
        } else {
            int userID = this.ws.getUserID();
            if (userID == 0) {
                userID = this.ws.getAddUserID("ANON");
            }
            if (text.length() > 255) {
                System.out.println("Truncating string: " + text + "\nRemoving: " + text.substring(255));
                text = text.substring(0, 255);
                this.nonInserts.add(text);
            }
            Biocom biocom = new Biocom.Builder(this.ws, discID, userID, topSample, text).build();
            well.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
            this.addDataType(SBdb.did2comType(discID.getChar()));
        }
    }

    private void parseIntcom(Row row, String[] columns) throws SQLException, SBException, FileNotFoundException, IOException {
        Cell topDepthCell = null;
        Cell baseDepthCell = null;
        String text = null;
        boolean isFeetColumn = false;
        Double topDepth = null;
        Double baseDepth = null;
        String wellName = null;
        String wellCode = null;
        block7: for (short cellNum = row.getFirstCellNum(); cellNum >= 0 && cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn col = XLSColumn.getColumnType(columns[cellNum]);
            switch (col) {
                case WELLNAME: {
                    wellName = cell.getStringCellValue();
                    continue block7;
                }
                case WELLCODE: {
                    wellCode = cell.getStringCellValue();
                    continue block7;
                }
                case TOPDEPTH: {
                    topDepthCell = cell;
                    isFeetColumn = columns[cellNum].contains("ft");
                    continue block7;
                }
                case BASEDEPTH: {
                    baseDepthCell = cell;
                    isFeetColumn = columns[cellNum].contains("ft");
                    continue block7;
                }
                case LEGEND: {
                    text = cell.getStringCellValue();
                }
            }
        }
        WsWell well = this.getWell(wellName, wellCode);
        if (topDepthCell != null) {
            topDepth = this.parseDepth(topDepthCell, isFeetColumn ? (char)'F' : (char)this.defaultUnits);
        }
        if (baseDepthCell != null) {
            baseDepth = this.parseDepth(baseDepthCell, isFeetColumn ? (char)'F' : (char)this.defaultUnits);
        }
        if (topDepth == null || baseDepth == null) {
            this.nonInserts.add(text);
        } else {
            int userID = this.ws.getUserID();
            if (userID == 0) {
                userID = this.ws.getAddUserID("ANON");
            }
            if (text.length() > 255) {
                System.out.println("Truncating string: " + text + "\nRemoving: " + text.substring(255));
                text = text.substring(0, 255);
                this.nonInserts.add(text);
            }
            Intcom intcom = new Intcom.Builder(this.ws, 0, topDepth).comments(text).baseDepth(baseDepth).build();
            well.getAddInterp(this.ws.getInterp(0)).getIntcoms(0);
            well.getAddInterp(this.ws.getInterp(0)).insert(intcom);
            this.addDataType(18);
        }
    }

    void parseWellEvents(String sheetName, Row row, String[] columns) throws SBException, SQLException {
        Sample sample = null;
        Cell sampleCell = null;
        String name = "";
        String eventType = "";
        int units = this.defaultUnits;
        String wellName = null;
        String wellCode = null;
        String disc = sheetName.substring(0, sheetName.toUpperCase().indexOf("EVENTS")).trim();
        Discipline discipline = Discipline.getDisc(disc);
        block14: for (short cellNum = row.getFirstCellNum(); cellNum >= 0 && cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            XLSColumn type = XLSColumn.getColumnType(columns[cellNum]);
            switch (type) {
                case WELLNAME: {
                    wellName = cell.getStringCellValue();
                    continue block14;
                }
                case WELLCODE: {
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            wellCode = Long.toString((long)cell.getNumericCellValue());
                            continue block14;
                        }
                        case STRING: {
                            wellCode = cell.getStringCellValue();
                            continue block14;
                        }
                    }
                    throw new SBException("Unrecognised cell format for well code in row: " + row.toString());
                }
                case TOPDEPTH: 
                case BASEDEPTH: 
                case DEPTH: {
                    sampleCell = cell;
                    units = columns[cellNum].contains("ft") ? 70 : (int)this.defaultUnits;
                    continue block14;
                }
                case TYPE: {
                    eventType = cell.getStringCellValue();
                    continue block14;
                }
                case LEGEND: {
                    String text;
                    name = text = cell.getStringCellValue();
                    continue block14;
                }
                case DISCIPLINE: {
                    discipline = Discipline.parseDisc(cell.getStringCellValue());
                }
            }
        }
        WsWell well = this.getWell(wellName, wellCode);
        sample = this.parseSample(well, sampleCell, "CU", true, (char)units);
        if (sample == null) {
            this.nonInserts.add(name);
            System.out.println("Cannot insert sequence wellEvent: " + name);
        } else {
            System.out.println("Parsing event at sample: " + sample.toString() + ", Name: " + name);
            SBEvent.EventType evType = SBEvent.EventType.getType(eventType);
            SBEvent sbEvent = this.ws.getSBEvent(name);
            if (sbEvent == null) {
                try {
                    sbEvent = this.ws.addSBEvent(new SBEvent.Builder().name(name).isGenerate(true).isSingle(evType == SBEvent.EventType.SINGLE));
                }
                catch (SBPermissionException e) {
                    throw new SBException(e.getMessage());
                }
            }
            WellEvent.Builder eventBuilder = new WellEvent.Builder().sample(sample).event(sbEvent).type(evType).discID(discipline);
            well.getAddInterp(this.ws.getInterp(0)).insertEvent(eventBuilder.build(this.ws));
            this.addDataType(16);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Double parseDepth(Cell cell, char units) throws SBException, SQLException {
        Object text;
        if (cell.getCellType() == CellType.STRING) {
            text = cell.getStringCellValue();
            if (text == null) return null;
            text = ((String)text).trim();
        } else {
            if (!(cell.getNumericCellValue() > 0.0)) return null;
            text = "" + cell.getNumericCellValue();
        }
        double depth = DepthUtils.parseDepthString((String)text, (char)units);
        return new Double(depth);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sample parseSample(WsWell well, Cell cell, String type, boolean useAnyType, char units) throws SBException, SQLException {
        Object text;
        if (cell.getCellType() == CellType.STRING) {
            text = cell.getStringCellValue();
            if (text == null) return null;
            if (!((String)(text = ((String)text).trim())).matches("[0-9.]")) {
                Pattern p = Pattern.compile("[a-zA-Z]+");
                Matcher m = p.matcher((CharSequence)text);
                while (m.find()) {
                    String sType = m.group();
                    SampleType sampleType = SampleType.parseType(sType);
                    if (sampleType == null) continue;
                    type = sampleType.toString();
                    break;
                }
                if (((String)text).indexOf(32) > 0) {
                    text = ((String)text).substring(0, ((String)text).indexOf(32));
                }
            }
        } else {
            text = "" + cell.getNumericCellValue();
        }
        well.getSamples();
        SampleType sampleType = SampleType.parseType(type);
        type = sampleType != null ? sampleType.toString() : null;
        double depth = DepthUtils.parseDepthString((String)text, (char)units);
        Sample sample = well.getSample(depth, type, useAnyType);
        if (sample != null) return sample;
        if (type == null) {
            throw new SBException("Unrecognised sample type at depth: " + (String)text);
        }
        try {
            sample = well.addSample(depth, SampleType.parseType(type), "");
        }
        catch (SBPermissionException pe) {
            throw new IllegalStateException("Unexpected permission exception in workspace");
        }
        sample.displayUnits = units == 'F' ? units : DepthUnits.parseDepthUnitsFromString((String)text).getChar();
        well.getHeader().setWellUnits(sample.displayUnits);
        return sample;
    }

    private int parseBnd(String bnd) throws SBException {
        if ((bnd = bnd.trim()) == null || bnd.isEmpty()) {
            return -1;
        }
        if (bnd.endsWith(".")) {
            bnd = bnd.substring(0, bnd.length() - 2);
        }
        for (int i = 0; i < IGDIntervalZone.bnds.length; ++i) {
            String compare = IGDIntervalZone.bnds[i];
            if (bnd.length() < compare.length()) {
                compare = compare.substring(0, bnd.length());
            }
            if (!compare.equalsIgnoreCase(bnd)) continue;
            return i + 1;
        }
        if (bnd.equalsIgnoreCase("absent")) {
            return -1;
        }
        throw new SBException("Unrecognised boundary type: " + bnd);
    }

    private void addDataType(int dType) {
        this.dataTypes.add(dType);
        this.dataTypes.add(1);
    }

    private static enum XLSColumn {
        WELLNAME(new String[]{"WELL NAME", "WELL_NAME", "WELL"}),
        WELLCODE(new String[]{"WELL CODE", "WELL_CODE", "API"}),
        TOPDEPTH(new String[]{"TOP DEPTH"}),
        BASEDEPTH(new String[]{"BASE DEPTH", "BOTTOM DEPTH"}),
        TOPBND(new String[]{"TOP BOUNDARY"}),
        BASEBND(new String[]{"BASE BOUNDARY", "BOTTOM BOUNDARY", "LOWER BOUNDARY"}),
        LEGEND(new String[]{"TEXT", "UNIT", "AGE", "LEGEND", "COMMENT", "EVENT"}),
        HIER(new String[]{"HIER", "LEVEL"}),
        DISCIPLINE(new String[]{"DISCIPLINE", "DISC_ID", "ZONE TYPE"}),
        DEPTH(new String[]{"DEPTH", "MD", "SAMPLE"}),
        TYPE(new String[]{"TYPE", "SAMPLE TYPE"}),
        NULLCOLUMN(new String[]{"XXXXXXXXXXXXXXXXXXX"});

        private final String[] titles;

        private XLSColumn(String[] titles) {
            this.titles = titles;
        }

        static XLSColumn getColumnType(String title) {
            if (title == null || title.trim().isEmpty()) {
                return NULLCOLUMN;
            }
            title = title.toUpperCase().trim();
            for (XLSColumn col : XLSColumn.values()) {
                for (String title1 : col.titles) {
                    if (!title.equals(title1)) continue;
                    return col;
                }
            }
            for (XLSColumn col : XLSColumn.values()) {
                for (String title1 : col.titles) {
                    if (!title.startsWith(title1)) continue;
                    return col;
                }
            }
            throw new IllegalArgumentException("Unrecognised column title: " + title);
        }
    }
}

