/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.undo.UndoableEdit;
import model2_1.Audit;
import model2_1.CompositeStandard;
import model2_1.IGDIntervalZone;
import model2_1.LOCNode;
import model2_1.SBdb;
import model2_1.Userdef;
import org.jdom2.Element;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.status.SbugsStatus;

public class LOC
extends SBObservable
implements SbugsStatus {
    private final SBdb sbdb;
    Color status = UNKNOWN;
    String conflictReason;
    private Color colour = Color.BLACK;
    private float lineWidth = 0.5f;
    private String comments;
    private Audit audit = new Audit();
    private LinkedList<LOCNode> nodes = new LinkedList();
    private Integer prefStdID = null;

    LOC(LOC loc, SBdb db) throws SQLException, SBException {
        this.sbdb = db;
        this.copyPrimitives(loc);
        this.audit = new Audit(this.sbdb, loc.sbdb, loc.audit);
        for (LOCNode node : loc.nodes) {
            this.nodes.add(new LOCNode(node));
        }
        this.status = NOTSTORED;
    }

    LOC(LOC loc) {
        this.colour = loc.colour;
        this.lineWidth = loc.lineWidth;
        this.comments = loc.comments;
        this.sbdb = loc.sbdb;
        this.audit = new Audit(loc.audit);
        for (LOCNode node : loc.nodes) {
            this.nodes.add(new LOCNode(node));
        }
        this.status = NOTSTORED;
    }

    public LOCNode getNode(int index) {
        if (this.nodes == null) {
            return null;
        }
        return this.nodes.get(index);
    }

    public int getSize() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    LOC(SBdb ws, LOC rhs) throws SQLException, SBException {
        this.sbdb = ws;
        this.copyPrimitives(rhs);
        for (LOCNode node : rhs.nodes) {
            this.nodes.add(new LOCNode(node));
        }
        this.audit = new Audit(rhs.audit);
        this.audit.fillWorkspace(rhs.sbdb, ws);
        this.status = STORED;
    }

    private void copyPrimitives(LOC rhs) {
        this.colour = new Color(rhs.getColour().getRed(), rhs.getColour().getGreen(), rhs.getColour().getBlue());
        this.lineWidth = rhs.lineWidth;
        this.comments = rhs.comments;
    }

    public void setColour(Color locColour, int wellID, int interpID) throws SQLException {
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET red=" + locColour.getRed() + ",green=" + locColour.getGreen() + ",blue=" + locColour.getBlue() + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.colour = locColour;
        this.updateAudit(wellID, interpID);
    }

    public void setWeight(float weight, int wellID, int interpID) throws SQLException {
        if ((double)Math.abs(this.lineWidth - weight) < 0.1) {
            return;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET linewidth=" + weight + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.lineWidth = weight;
        this.updateAudit(wellID, interpID);
    }

    double getTopDepth() {
        double topDepth = 99999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.depth < topDepth)) continue;
            topDepth = node.depth;
        }
        return topDepth;
    }

    double getBaseDepth() {
        double baseDepth = -99999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.depth > baseDepth)) continue;
            baseDepth = node.depth;
        }
        return baseDepth;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    LOC(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        Element elc;
        this.sbdb = ws;
        String strg = xml.getChildTextNormalize("LineWidth");
        if (strg != null) {
            this.lineWidth = Float.parseFloat(strg);
        }
        if ((elc = xml.getChild("Colour")) != null) {
            this.colour = SB.parseColour((Element)elc);
        }
        if ((strg = xml.getChildTextNormalize("Comment")) != null) {
            this.comments = strg;
        }
        for (Element xmlNode : xml.getChildren("Node")) {
            strg = xmlNode.getChildTextNormalize("Depth");
            if (strg == null) continue;
            double depth = Double.parseDouble(strg);
            strg = xmlNode.getChildTextNormalize("CSU");
            if (strg == null) continue;
            double csu = Double.parseDouble(strg);
            int bnd = 3;
            strg = xmlNode.getChildTextNormalize("Boundary");
            if (strg != null) {
                bnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
            }
            this.nodes.add(new LOCNode(depth, csu, bnd));
        }
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for LOC: " + this);
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException, SQLException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<LOC>\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind2 + "<LineWidth>" + this.lineWidth + "</LineWidth>\n");
        SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind2);
        if (this.comments != null && !this.comments.isEmpty()) {
            out.write(ind2 + "<Comments>" + this.comments + "</Comments>");
        }
        String ind3 = SB.getXMLIndent((int)(indent + 3 + 3));
        for (LOCNode node : this.nodes) {
            out.write(ind2 + "<Node>\n");
            out.write(ind3 + "<Depth>" + node.depth + "</Depth>\n");
            out.write(ind3 + "<CSU>" + node.getAge() + "</CSU>\n");
            out.write(ind3 + "<Boundary>" + node.getBoundaryType() + "</Boundary>\n");
            out.write(ind2 + "</Node>\n");
        }
        this.audit.writeXML(out, indent + 3);
        out.write(ind1 + "</LOC>\n");
    }

    public int getBoundary(double depth) {
        if (this.nodes == null || this.nodes.size() == 0) {
            return -1;
        }
        LOCNode node1 = null;
        Object node2 = null;
        for (LOCNode node : this.nodes) {
            if (Math.abs(depth - node.depth) < 0.01) {
                return node.bnd;
            }
            if (node.depth < depth) {
                node1 = node;
            }
            if (!(node.depth > depth)) continue;
            if (node1 == null) break;
            return node1.bnd;
        }
        return -1;
    }

    void setUncf(int wellID, int interpID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (int i = 0; i < this.nodes.size() - 1; ++i) {
                LOCNode node = this.nodes.get(i);
                LOCNode next = this.nodes.get(i + 1);
                if (!(Math.abs(next.depth - node.depth) < (double)0.0029f)) continue;
                int bnd = 4;
                String sql = "UPDATE " + this.sbdb.DBTableName("LOCNODE") + " SET bnd=" + bnd + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND node_key='" + node.getKey() + "'";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                node.bnd = bnd;
            }
        }
    }

    LOC(SBdb sbdb, CompositeStandard std, int wellID, int interpID, double depth1, double depth2, double csu1, double csu2) throws SQLException {
        this.sbdb = sbdb;
        this.addNode(depth1, csu1, 3, true);
        this.addNode(depth2, csu2, 3, true);
        if (std != null) {
            this.prefStdID = std.getStdID();
        }
        this.store(wellID, interpID);
    }

    public LOC(SBdb SB2, int stdID, int interpID, int wellID, Color colour, float lineWidth) {
        this.sbdb = SB2;
        this.colour = colour;
        this.lineWidth = lineWidth;
        if (stdID > 0) {
            this.prefStdID = stdID;
        }
        this.status = NOTSTORED;
    }

    LOC(SBdb SB2, int stdID, int interpID, int wellID, Color colour, float lineWidth, String comment, Audit audit) throws SBException, SQLException {
        this.sbdb = SB2;
        this.colour = colour;
        this.lineWidth = lineWidth;
        this.audit = audit;
        this.comments = comment;
        this.loadNodes(wellID, interpID);
        this.prefStdID = stdID;
        this.status = STORED;
    }

    LOC(SBdb sbdb, int wellID, int interpID) throws SQLException {
        this.sbdb = sbdb;
        String sql = "SELECT std_id,red,green,blue,linewidth,comments," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("LOC") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                this.prefStdID = rs.getInt("std_id");
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                this.colour = new Color(r, g, b);
                this.lineWidth = rs.getFloat("linewidth");
                this.comments = rs.getString("comments");
                this.audit = new Audit(rs);
                this.loadNodes(wellID, interpID);
            }
        }
    }

    public void setPrefStd(CompositeStandard std, int wellID, int interpID) throws SQLException {
        int id;
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.setCompositeStandard: wellID is " + wellID + ", interpID is " + interpID);
        }
        int n = id = std != null ? std.getStdID() : 0;
        if (this.prefStdID == null || id != this.prefStdID) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET std_id=" + (Serializable)(id == 0 ? "NULL" : Integer.valueOf(id)) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.setChanged();
            this.prefStdID = id;
        }
    }

    private void loadNodes(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to method: wellID is " + wellID + ", interpID is " + interpID);
        }
        String sql = "SELECT depth,age,bnd,node_key FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int bnd;
                double age;
                double depth = rs.getDouble("depth");
                LOCNode node = this.addNode(depth, age = rs.getDouble("age"), bnd = rs.getInt("bnd"), true);
                if (node == null) continue;
                node.setDatabaseKey(rs.getString("node_key"));
            }
        }
    }

    public final void addNode(double depth, double age, int bnd, int wellID, int interpID, boolean sort) throws SQLException {
        LOCNode node = this.addNode(depth, age, bnd, sort);
        if (node == null) {
            return;
        }
        try {
            node.store(this.sbdb, wellID, interpID);
        }
        catch (SQLException e) {
            this.nodes.remove(node);
            throw e;
        }
        this.updateAudit(wellID, interpID);
    }

    public final LOCNode addNode(double depth, double age, int bnd, boolean sort) {
        for (LOCNode node : this.nodes) {
            if (!node.getKey().equals(LOCNode.getNodeKey(depth, age))) continue;
            return null;
        }
        LOCNode node = new LOCNode(depth, age, bnd);
        this.nodes.add(node);
        if (sort) {
            Collections.sort(this.nodes);
        }
        this.setChanged();
        return node;
    }

    LOCNodeEdit addNode(int bnd, double depth, double age, int wellID, int interpID) throws InvalidFieldException, SQLException {
        for (LOCNode node : this.nodes) {
            if (!node.getKey().equals(LOCNode.getNodeKey(depth, age))) continue;
            throw new InvalidFieldException("This node already exists");
        }
        LOCNode node = new LOCNode(depth, age, bnd);
        LOCNodeEdit edit = new LOCNodeEdit(wellID, interpID, null, node);
        edit.doEdit();
        return edit;
    }

    SbugsCompoundEdit deleteNode(int wellID, int interpID, LOCNode node) throws SQLException, InvalidFieldException, SBException {
        if (!this.nodes.contains(node)) {
            return null;
        }
        SbugsCompoundEdit cEdit = new SbugsCompoundEdit("delete node");
        cEdit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, node, null)));
        LOCNode prevNode = null;
        LOCNode nextNode = null;
        Iterator<LOCNode> it = this.getNodeIterator();
        while (it.hasNext()) {
            LOCNode n = it.next();
            if (n == node) {
                if (!it.hasNext()) break;
                nextNode = it.next();
                break;
            }
            prevNode = n;
        }
        if (prevNode != null && IGDIntervalZone.isDisconformableBnd(prevNode.getBnd()) && (nextNode == null || nextNode.getDepth() > node.getDepth())) {
            cEdit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, prevNode, new LOCNode(prevNode.getDepth(), prevNode.getAge(), 3))));
        }
        cEdit.doEdits();
        this.updateAudit(wellID, interpID);
        this.setChanged();
        this.notifyObservers();
        return cEdit;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return "Line of Correlation";
    }

    public Color getStatus() {
        return this.status;
    }

    private void updateAudit(int wellID, int interpID) throws SQLException {
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET " + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.audit = temp;
    }

    UndoableEdit updateNode(double depth, double age, int bnd, LOCNode node, int wellID, int interpID) throws InvalidFieldException, SBException, SQLException {
        if (bnd != node.bnd && (int)(node.getDepth() * 1000.0) == (int)(depth * 1000.0) && IGDIntervalZone.isDisconformableBnd(node.bnd) ^ IGDIntervalZone.isDisconformableBnd(bnd)) {
            throw new InvalidFieldException(IGDIntervalZone.isDisconformableBnd(node.bnd) ? "New boundary must be disconformable type" : "Only horizontal sections can be disconformable");
        }
        if (depth < node.depth) {
            LOCNode comp;
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext() && (comp = (LOCNode)iterator.next()) != node) {
                if (!(comp.depth > depth)) continue;
                if (Math.abs(comp.depth - depth) < (double)0.0029f) {
                    depth = comp.depth;
                    break;
                }
                throw new InvalidFieldException("Cannot change node depth to above previous node.");
            }
        } else if (depth > node.depth) {
            boolean found = false;
            for (LOCNode n : this.nodes) {
                if (n == node) {
                    found = true;
                    continue;
                }
                if (!found || !(n.depth + (double)0.0029f < depth)) continue;
                System.out.println("n.depth=" + n.depth + ",depth=" + depth);
                throw new InvalidFieldException("Cannot change node depth to below next node.");
            }
        }
        if (this.checkForDuplicateNodeInList(node, depth, age)) {
            throw new InvalidFieldException("Cannot change node, a node with that depth and age already exists.");
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update node");
        bnd = this.updateUncnfs(node, depth, bnd, wellID, interpID, edit);
        edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, node, new LOCNode(depth, age, bnd))));
        edit.doEdits();
        this.updateAudit(wellID, interpID);
        this.setChanged();
        this.notifyObservers();
        return edit;
    }

    private boolean checkForDuplicateNodeInList(LOCNode editedNode, double depth, double age) {
        boolean duplicate = false;
        for (LOCNode n : this.nodes) {
            if (n == editedNode || n.depth != depth || n.age != age) continue;
            duplicate = true;
        }
        return duplicate;
    }

    UndoableEdit updateDisconf(double depth, double newDepth, int wellID, int interpID) throws InvalidFieldException, SBException, SQLException {
        LOCNode n1 = null;
        LOCNode n2 = null;
        for (LOCNode node : this.nodes) {
            if (n1 != null) {
                if (!(Math.abs(node.getDepth() - depth) < (double)0.0029f)) break;
                n2 = node;
                break;
            }
            if (!(Math.abs(node.getDepth() - depth) < (double)0.0029f) || !IGDIntervalZone.isDisconformableBnd(node.getBnd())) continue;
            n1 = node;
        }
        if (n1 != null && n2 != null) {
            SbugsCompoundEdit edit = null;
            if (newDepth < depth && this.nodes.indexOf(n1) > 0) {
                LOCNode nodeBefore = this.nodes.get(this.nodes.indexOf(n1) - 1);
                if (Math.abs(nodeBefore.depth - newDepth) < (double)0.0029f) {
                    newDepth = nodeBefore.depth;
                    edit = new SbugsCompoundEdit("Update disconformity");
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, nodeBefore, new LOCNode(nodeBefore.depth, nodeBefore.age, n1.bnd))));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n1, null)));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n2, new LOCNode(newDepth, n2.age, n2.bnd))));
                } else if (nodeBefore.depth > newDepth) {
                    throw new InvalidFieldException("Cannot change node depth to above previous node.");
                }
            } else if (newDepth > depth && this.nodes.indexOf(n2) < this.nodes.size() - 1) {
                LOCNode nodeAfter = this.nodes.get(this.nodes.indexOf(n2) + 1);
                if (Math.abs(nodeAfter.depth - newDepth) < (double)0.0029f) {
                    newDepth = nodeAfter.depth;
                    edit = new SbugsCompoundEdit("Update disconformity");
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n1, new LOCNode(newDepth, n1.age, n1.bnd))));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n2, null)));
                } else if (nodeAfter.depth < newDepth) {
                    throw new InvalidFieldException("Cannot change node depth to below next node.");
                }
            }
            if (edit == null) {
                edit = new SbugsCompoundEdit("Update disconformity");
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n1, new LOCNode(newDepth, n1.age, n1.bnd))));
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, n2, new LOCNode(newDepth, n2.age, n2.bnd))));
            }
            edit.doEdits();
            this.updateAudit(wellID, interpID);
            this.setChanged();
            this.notifyObservers();
            return edit;
        }
        return null;
    }

    private int updateUncnfs(LOCNode node, double newDepth, int newBnd, int wellID, int interpID, SbugsCompoundEdit edit) {
        boolean sameDepth;
        int index = this.nodes.indexOf(node);
        if (index < 0) {
            return newBnd;
        }
        if (index > 0) {
            LOCNode previous = this.nodes.get(index - 1);
            boolean bl = sameDepth = Math.abs(previous.getDepth() - newDepth) < 0.001;
            if (IGDIntervalZone.isDisconformableBnd(previous.bnd) && !sameDepth) {
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, previous, new LOCNode(previous.getDepth(), previous.getAge(), 3))));
            } else if (!IGDIntervalZone.isDisconformableBnd(previous.bnd) && sameDepth) {
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(wellID, interpID, previous, new LOCNode(previous.getDepth(), previous.getAge(), 4))));
            }
        }
        if (index < this.nodes.size() - 1) {
            LOCNode next = this.nodes.get(index + 1);
            boolean bl = sameDepth = Math.abs(next.getDepth() - newDepth) < 0.001;
            if (IGDIntervalZone.isDisconformableBnd(newBnd) && !sameDepth) {
                newBnd = 3;
            } else if (!IGDIntervalZone.isDisconformableBnd(newBnd) && sameDepth) {
                newBnd = 4;
            }
        }
        return newBnd;
    }

    public boolean equals(LOC rhs) throws SQLException {
        if (rhs.nodes == null) {
            return false;
        }
        if (this.nodes.size() != rhs.nodes.size()) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            LOCNode node = this.nodes.get(i);
            if (node.getKey().equals(rhs.nodes.get(i).getKey())) continue;
            return false;
        }
        return true;
    }

    public final void store(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.store: wellID is " + wellID + ", interpID is " + interpID);
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("LOC") + " (well_id,interp_id,std_id,red,green,blue,linewidth,comments," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + (Serializable)(this.prefStdID != null ? this.prefStdID : "NULL") + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.lineWidth + "," + SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (LOCNode node : this.nodes) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("LOCNODE") + " (well_id,interp_id,node_key,depth,age,bnd) VALUES (" + wellID + "," + interpID + ",'" + node.getKey() + "'," + node.depth + "," + node.getAge() + "," + node.bnd + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.status = STORED;
    }

    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.delete: wellID is " + wellID + ", interpID is: " + interpID);
        }
        String sqlNodes = "DELETE FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        String sql = "DELETE FROM " + this.sbdb.DBTableName("LOC") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sqlNodes));
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
    }

    void updateStatus(LOC loc) throws SQLException {
        this.status = STORED;
        if (loc == null || loc.nodes.isEmpty()) {
            this.status = NOTSTORED;
            this.conflictReason = "";
            return;
        }
        if (!this.colour.equals(loc.colour)) {
            this.status = CONFLICT;
            this.conflictReason = "Colour different";
            return;
        }
        if (this.lineWidth != loc.lineWidth) {
            this.status = CONFLICT;
            this.conflictReason = "Line width different";
        }
        if (this.nodes.size() != loc.nodes.size()) {
            this.status = CONFLICT;
            this.conflictReason = "Number of nodes different";
        } else {
            for (LOCNode node : this.nodes) {
                boolean found = false;
                for (LOCNode cmpNode : loc.nodes) {
                    if (!node.getKey().equals(cmpNode.getKey())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.status = CONFLICT;
                this.conflictReason = "Node at: " + node.getDepth() + "m conflicts";
                break;
            }
        }
    }

    public String getConflictReason() {
        return this.conflictReason;
    }

    public void writeDEX(FileWriter out, DecimalFormat nFormat, String eol, char units, String wellName) throws IOException {
        out.write("[LOC]" + eol);
        out.write("Well = " + wellName + eol);
        out.write("Line width = " + this.lineWidth + eol);
        out.write("Colour = " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        out.write(eol);
    }

    public boolean checkDepthBracketing(int cTD, int cBD, int nzTD, int nzBD) {
        if (nzTD == nzBD) {
            if (nzTD > cTD && nzTD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC lies inside existing data";
                return false;
            }
            if (nzTD == cTD && nzTD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths same as existing data";
                return false;
            }
        } else {
            if (nzTD < cTD && nzBD > cTD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD < cBD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depth overlap existing data";
                return false;
            }
            if (nzTD > cTD && nzBD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are overlapped by existing data";
                return false;
            }
            if (nzTD < cTD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD == cTD && nzBD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are the same as existing data";
                return false;
            }
        }
        return true;
    }

    public double getAge(double depth, boolean extrapolate) {
        if (this.nodes == null || this.nodes.size() == 0) {
            return -1.0;
        }
        LOCNode node1 = null;
        LOCNode node2 = null;
        if (extrapolate) {
            if (depth >= this.nodes.getLast().depth) {
                node1 = this.nodes.get(this.nodes.size() - 2);
                node2 = this.nodes.getLast();
            } else if (depth <= this.nodes.getFirst().depth) {
                node1 = this.nodes.getFirst();
                node2 = this.nodes.get(1);
            }
        }
        if (node1 == null && node2 == null) {
            for (LOCNode node : this.nodes) {
                if (depth >= (double)((float)node.depth)) {
                    node1 = node;
                }
                if (!(depth < node.depth) || node2 != null) continue;
                node2 = node;
            }
        }
        if (node1 != null && node2 != null) {
            if (node1 == node2 || Math.abs(node1.depth - node2.depth) < (double)0.0029f) {
                return node1.getAge();
            }
            return node1.getAge() + (depth - node1.depth) * (node2.getAge() - node1.getAge()) / (node2.depth - node1.depth);
        }
        return -1.0;
    }

    public double getAge(float depth, boolean minPref) {
        if (this.nodes == null || this.nodes.size() < 2) {
            return -1.0;
        }
        LOCNode node1 = null;
        LOCNode node2 = null;
        if (depth >= (float)this.nodes.getLast().depth) {
            node1 = this.nodes.get(this.nodes.size() - 2);
            node2 = this.nodes.getLast();
        } else if (depth <= (float)this.nodes.getFirst().depth) {
            node1 = this.nodes.getFirst();
            node2 = this.nodes.get(1);
        }
        if (node1 == null && node2 == null) {
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                LOCNode node = (LOCNode)it.next();
                if (IGDIntervalZone.isDisconformableBnd(node.bnd) && Math.abs(node.depth - (double)depth) < 0.001) {
                    node1 = node;
                    node2 = (LOCNode)it.next();
                    break;
                }
                if (depth >= (float)node.depth) {
                    node1 = node;
                }
                if (!((double)depth < node.depth) || node2 != null) continue;
                node2 = node;
            }
        }
        if (node1 != null && node2 != null) {
            if (node1 == node2 || Math.abs(node1.depth - node2.depth) < (double)0.0029f) {
                return minPref ? Math.min(node1.getAge(), node2.getAge()) : Math.max(node1.getAge(), node2.getAge());
            }
            return node1.getAge() + ((double)depth - node1.depth) * (node2.getAge() - node1.getAge()) / (node2.depth - node1.depth);
        }
        return -1.0;
    }

    public double getDepth(double age, Double minDepth, Double maxDepth, boolean first) {
        Double d = this.getDepthOfAge(age, minDepth, maxDepth, first);
        if (d == null) {
            return -1.0;
        }
        return d;
    }

    public Double getDepthOfAge(double age, Double minDepth, Double maxDepth, boolean first) {
        if (Double.isNaN(age)) {
            return null;
        }
        if (minDepth == null ^ maxDepth == null) {
            throw new IllegalArgumentException("Only one depth bracket specified in LOC.getDepth");
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            return null;
        }
        ListIterator it = this.nodes.listIterator();
        if (!first) {
            while (it.hasNext()) {
                it.next();
            }
        }
        LOCNode last = null;
        while (first ? it.hasNext() : it.hasPrevious()) {
            LOCNode node = (LOCNode)(first ? it.next() : it.previous());
            if (Math.abs(node.age - age) < 0.001) {
                return node.depth;
            }
            if (last != null && age > Math.min(node.age, last.age) && age <= Math.max(node.age, last.age)) {
                LOCNode node1 = node;
                LOCNode node2 = last;
                double depth = LOC.getDepth(age, node1, node2);
                if (minDepth == null || depth >= minDepth && depth <= maxDepth) {
                    return depth;
                }
            }
            last = node;
        }
        return null;
    }

    public float[] getAgeLimits(float fromDepth, float toDepth) {
        if (this.nodes.isEmpty()) {
            return new float[]{-1.0f, -1.0f};
        }
        float[] limits = new float[2];
        double age1 = this.getAge(fromDepth, true);
        double age2 = this.getAge(toDepth, false);
        limits[0] = (float)Math.min(age1, age2);
        limits[1] = (float)Math.max(age1, age2);
        for (LOCNode node : this.nodes) {
            if (node.getDepth() < (double)fromDepth) continue;
            if (node.getDepth() > (double)toDepth) break;
            if (node.getAge() < (double)limits[0]) {
                limits[0] = (float)node.getAge();
            }
            if (!(node.getAge() > (double)limits[1])) continue;
            limits[1] = (float)node.getAge();
        }
        return limits;
    }

    private static double getDepth(double age, LOCNode node1, LOCNode node2) {
        if (node1 == null || node2 == null) {
            return -1.0;
        }
        if (!(age >= Math.min(node1.age, node2.age)) || !(age <= Math.max(node1.age, node2.age))) {
            assert (false);
            return -1.0;
        }
        if (node1 == node2 || Math.abs(node1.depth - node2.depth) < (double)0.0029f) {
            return node1.depth;
        }
        if (Math.abs(age - node1.getAge()) < (double)0.0029f) {
            return node1.depth;
        }
        if (Math.abs(node2.getAge() - age) < (double)0.0029f) {
            return node2.depth;
        }
        if (node1.depth > node2.depth) {
            LOCNode temp = node1;
            node1 = node2;
            node2 = temp;
        }
        boolean normal = node1.getAge() < node2.getAge();
        return node1.depth + (node2.depth - node1.depth) / (normal ? node2.getAge() - node1.getAge() : node1.getAge() - node2.getAge()) * (normal ? age - node1.getAge() : node1.getAge() - age);
    }

    public double[] getDepths(double age) {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        if (age < this.getMinAge()) {
            return null;
        }
        if (age > this.getMaxAge()) {
            return null;
        }
        LinkedList<Double> depths = new LinkedList<Double>();
        LOCNode lastNode = null;
        for (LOCNode node : this.nodes) {
            LOCNode older;
            if (lastNode == null) {
                lastNode = node;
                continue;
            }
            LOCNode younger = lastNode.getAge() < node.getAge() ? lastNode : node;
            LOCNode lOCNode = older = younger == lastNode ? node : lastNode;
            if (age > younger.getAge() && age <= older.getAge()) {
                boolean normal;
                LOCNode node1 = lastNode.depth < node.depth ? lastNode : node;
                LOCNode node2 = node1 == lastNode ? node : lastNode;
                boolean bl = normal = node1.getAge() < node2.getAge();
                if (Math.abs(node1.depth - node2.depth) < 0.01) {
                    depths.add(node1.depth);
                } else {
                    depths.add(node1.depth + (node2.depth - node1.depth) / (normal ? node2.getAge() - node1.getAge() : node1.getAge() - node2.getAge()) * (normal ? age - node1.getAge() : node1.getAge() - age));
                }
            }
            lastNode = node;
        }
        if (!depths.isEmpty()) {
            double[] d = new double[depths.size()];
            for (int i = 0; i < depths.size(); ++i) {
                d[i] = (Double)depths.get(i);
            }
            return d;
        }
        return null;
    }

    public Boolean isAgeIncreasing(double depth) throws SBException {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        Iterator it = this.nodes.iterator();
        LOCNode node1 = null;
        LOCNode node2 = null;
        while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (depth >= (double)((float)node.depth)) {
                node1 = node;
                continue;
            }
            if (!(depth < node.depth)) continue;
            node2 = node;
            break;
        }
        if (node1 != null && node2 != null) {
            if (node2.getAge() < node1.getAge()) {
                return false;
            }
            return true;
        }
        if (node2 == null && Math.abs(this.nodes.getLast().depth - node1.depth) < 0.001) {
            return this.nodes.getLast().getAge() > node1.getAge();
        }
        return null;
    }

    public double getMaxDepth() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return 0.0;
        }
        return this.nodes.getLast().getDepth();
    }

    public double getMinDepth() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return 0.0;
        }
        return this.nodes.getFirst().getDepth();
    }

    public float getSedimentationRate(double depth) {
        if (this.nodes == null || this.nodes.size() == 0) {
            return -1.0f;
        }
        LOCNode node1 = null;
        LOCNode node2 = null;
        if (depth >= (double)((float)this.nodes.getLast().depth)) {
            node1 = this.nodes.get(this.nodes.size() - 2);
            node2 = this.nodes.getLast();
        } else if (depth <= (double)((float)this.nodes.getFirst().depth)) {
            node1 = this.nodes.getFirst();
            node2 = this.nodes.get(1);
        }
        if (node1 == null && node2 == null) {
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                LOCNode node = (LOCNode)it.next();
                if ((node.bnd == 4 || node.bnd == 5) && Math.abs(node.depth - depth) < 0.001) {
                    node1 = node;
                    node2 = (LOCNode)it.next();
                    break;
                }
                if (depth >= (double)((float)node.depth)) {
                    node1 = node;
                }
                if (!(depth < node.depth) || node2 != null) continue;
                node2 = node;
            }
        }
        if (node1 != null && node2 != null) {
            return (float)((node2.depth - node1.depth) / (node2.getAge() - node1.getAge()));
        }
        return -1.0f;
    }

    public int getStdIDPref() {
        if (this.prefStdID != null) {
            return this.prefStdID;
        }
        return 0;
    }

    public Color getColour() {
        return this.colour;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public String getComment() {
        return this.comments;
    }

    public LinkedList<LOCNode> getNodes() {
        return this.nodes;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public void updateComment(String newComment, int wellID, int interpID) throws SQLException {
        if ((newComment = newComment.trim()).isEmpty()) {
            newComment = null;
        }
        if (SB.equal((Object)newComment, (Object)this.comments)) {
            return;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET comments=" + (newComment == null ? "NULL" : SB.DBString((String)newComment)) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.comments = newComment;
        this.updateAudit(wellID, interpID);
    }

    public Iterator<LOCNode> getNodeIterator() {
        return this.nodes.iterator();
    }

    public double getMinAge() {
        double age = 9999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getAge() < age)) continue;
            age = node.getAge();
        }
        if (age > 9000.0) {
            return 0.0;
        }
        return age;
    }

    public double getMaxAge() {
        double age = 0.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getAge() > age)) continue;
            age = node.getAge();
        }
        return age;
    }

    public double getMaxAge(Double maxDepth) {
        double age = 0.0;
        for (LOCNode node : this.nodes) {
            if (node.getAge() > age && (maxDepth == null || node.getDepth() <= maxDepth)) {
                age = node.getAge();
            }
            if (maxDepth == null || !(node.getDepth() > maxDepth)) continue;
            break;
        }
        return age;
    }

    public double getMinAge(double minDepth) {
        double age = this.getMaxAge();
        ListIterator<LOCNode> it = this.nodes.listIterator(this.nodes.size() - 1);
        while (it.hasPrevious()) {
            LOCNode node = it.previous();
            if (node.getDepth() < minDepth) {
                return age;
            }
            if (!(node.getAge() < age)) continue;
            age = node.getAge();
        }
        return age;
    }

    public Point2D getAgeRange(double minDepth, double maxDepth) {
        assert (minDepth < maxDepth);
        double age1 = this.getAge(minDepth, false);
        double age2 = this.getAge(maxDepth, false);
        if (age1 < 0.0) {
            age1 = this.nodes.get((int)0).age;
        }
        if (age2 < 0.0) {
            age2 = this.nodes.get((int)(this.nodes.size() - 1)).age;
        }
        double min = Math.min(age1, age2);
        double max = Math.max(age1, age2);
        for (LOCNode node : this.nodes) {
            if (node.depth < minDepth) continue;
            if (node.depth > maxDepth) break;
            if (node.age < min) {
                min = node.age;
            }
            if (!(node.age > max)) continue;
            max = node.age;
        }
        assert (min >= 0.0 && max >= 0.0);
        return new Point2D.Double(min, max);
    }

    public Point2D getDepthRange(double minAge, double maxAge) {
        assert (minAge < maxAge);
        double depth1 = this.getDepth(minAge, null, null, true);
        double depth2 = this.getDepth(maxAge, null, null, false);
        if (depth1 < 0.0) {
            depth1 = this.nodes.get((int)0).depth;
        }
        if (depth2 < 0.0) {
            depth2 = this.nodes.get((int)(this.nodes.size() - 1)).depth;
        }
        double min = Math.min(depth1, depth2);
        double max = Math.max(depth1, depth2);
        for (LOCNode node : this.nodes) {
            if (!(node.age >= minAge) || !(node.age <= maxAge)) continue;
            if (node.depth < min) {
                min = node.depth;
            }
            if (!(node.depth > max)) continue;
            max = node.depth;
        }
        assert (min >= 0.0 && max >= 0.0);
        return new Point2D.Double(min, max);
    }

    public Disconformity[] getDisconformities() {
        LinkedList<Disconformity> discnfNodes = new LinkedList<Disconformity>();
        Iterator it = this.nodes.iterator();
        block0: while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (!IGDIntervalZone.isDisconformableBnd(node.bnd)) continue;
            double age1 = node.getAge();
            LOCNode node2 = null;
            while (node2 == null || IGDIntervalZone.isDisconformableBnd(node2.bnd)) {
                if (!it.hasNext()) break block0;
                node2 = (LOCNode)it.next();
            }
            double age2 = node2.getAge();
            double[] ages = new double[]{Math.min(age1, age2), Math.max(age1, age2)};
            double depth = node.depth;
            discnfNodes.add(new Disconformity(ages, depth, age2 > age1, node.bnd));
        }
        if (discnfNodes.isEmpty()) {
            return null;
        }
        return discnfNodes.toArray(new Disconformity[discnfNodes.size()]);
    }

    public double[][] getReversals() {
        ListIterator it = this.nodes.listIterator();
        LOCNode lastNode = null;
        LinkedList<double[]> revs = new LinkedList<double[]>();
        double[] rev = null;
        while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (lastNode == null) {
                lastNode = node;
                continue;
            }
            if (node.getAge() < lastNode.getAge()) {
                if (rev == null) {
                    rev = new double[2];
                    rev[0] = lastNode.depth;
                }
            } else if (rev != null) {
                rev[1] = lastNode.depth;
                revs.add(rev);
                rev = null;
            }
            lastNode = node;
        }
        if (rev != null) {
            rev[1] = lastNode.depth;
            revs.add(rev);
        }
        if (revs.isEmpty()) {
            return null;
        }
        double[][] depths = new double[revs.size()][];
        for (int i = 0; i < revs.size(); ++i) {
            depths[i] = (double[])revs.get(i);
        }
        return depths;
    }

    public void verifyNodes() {
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for LOC");
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public String getRateString(LOCNode node, char units, AgeFormat af) {
        LOCNode n = null;
        Iterator<LOCNode> it = this.getNodeIterator();
        while (it.hasNext()) {
            LOCNode itNode = it.next();
            if (itNode != node) continue;
            n = it.next();
            break;
        }
        if (n == null) {
            return "";
        }
        if (IGDIntervalZone.isDisconformableBnd(node.getBnd())) {
            return SB.roundToSignificantFigures((double)((n.getAge() - node.getAge()) * af.getMultiplyer()), (int)3) + " " + af.getDescr();
        }
        Object sedRate = "";
        if (Math.abs(n.getAge() - node.getAge()) < 0.001) {
            sedRate = (String)sedRate + "\u221e";
        } else {
            double r = (DepthUtils.convFromM((double)n.getDepth(), (char)units) - DepthUtils.convFromM((double)node.getDepth(), (char)units)) / (n.getAge() - node.getAge());
            sedRate = (String)sedRate + SB.roundToSignificantFigures((double)(r /= af.getMultiplyer()), (int)3);
        }
        return (String)sedRate + " " + DepthUnits.getUnits((char)units).getAbr() + "/" + af.getDescr();
    }

    public AgeFormat getAgeFormatIdeal() {
        if (this.getMaxAge() < 5.0) {
            return AgeFormat.KA;
        }
        return AgeFormat.MA;
    }

    public class LOCNodeEdit
    extends SbugsEdit {
        private final String presentationName;
        private final int wellID;
        private final int interpID;
        private final LOCNode originalNode;
        private final LOCNode newNode;

        private LOCNodeEdit(int wellID, int interpID, LOCNode originalNode, LOCNode newNode) {
            Object s;
            this.wellID = wellID;
            this.interpID = interpID;
            this.originalNode = originalNode;
            this.newNode = newNode;
            if (originalNode != null && newNode != null) {
                s = "update node ";
                if (originalNode.bnd != newNode.bnd) {
                    s = (String)s + "line style";
                }
            } else {
                s = originalNode != null ? "delete node" : "new node";
            }
            this.presentationName = s;
        }

        public void doEdit() throws SQLException {
            block3: {
                try {
                    this.redo();
                }
                catch (RuntimeException re) {
                    if (re.getCause() == null) break block3;
                    if (re.getCause() instanceof SQLException) {
                        throw (SQLException)re.getCause();
                    }
                    throw re;
                }
            }
        }

        private void insertActionDB(LOCNode node) throws SQLException {
            node.store(LOC.this.sbdb, this.wellID, this.interpID);
        }

        private void insertActionModel(LOCNode node) {
            LOC.this.nodes.add(node);
            Collections.sort(LOC.this.nodes);
        }

        private void deleteActionDB(LOCNode node) throws SQLException {
            node.delete(LOC.this.sbdb, this.wellID, this.interpID);
        }

        private void deleteActionModel(LOCNode node) {
            LOC.this.nodes.remove(node);
        }

        public void undo() {
            try {
                if (this.newNode != null) {
                    this.deleteActionDB(this.newNode);
                }
                if (this.originalNode != null) {
                    this.insertActionDB(this.originalNode);
                }
                LOC.this.sbdb.commit();
            }
            catch (SQLException e) {
                LOC.this.sbdb.doRollback();
                throw new RuntimeException("SQL Error undoing LOCNode edit", e);
            }
            if (this.newNode != null) {
                this.deleteActionModel(this.newNode);
            }
            if (this.originalNode != null) {
                this.insertActionModel(this.originalNode);
            }
            LOC.this.setChanged();
            LOC.this.notifyObservers();
            super.undo();
        }

        public void redo() {
            try {
                if (this.originalNode != null) {
                    this.deleteActionDB(this.originalNode);
                }
                if (this.newNode != null) {
                    this.insertActionDB(this.newNode);
                }
                LOC.this.sbdb.commit();
            }
            catch (SQLException e) {
                LOC.this.sbdb.doRollback();
                throw new RuntimeException("SQL Error redoing LOCNode edit", e);
            }
            if (this.originalNode != null) {
                this.deleteActionModel(this.originalNode);
            }
            if (this.newNode != null) {
                this.insertActionModel(this.newNode);
            }
            LOC.this.setChanged();
            LOC.this.notifyObservers();
            super.redo();
        }

        public String getPresentationName() {
            return this.presentationName;
        }
    }

    public static class Disconformity {
        private final double[] ages;
        private final double depth;
        private final boolean normal;
        private final int bnd;

        Disconformity(double[] ages, double depth, boolean normal, int bnd) {
            this.depth = depth;
            this.ages = ages;
            this.normal = normal;
            this.bnd = bnd;
        }

        public double[] getAges() {
            return this.ages;
        }

        public double getDepth() {
            return this.depth;
        }

        public boolean getNormal() {
            return this.normal;
        }

        public int getBnd() {
            return this.bnd;
        }
    }
}

