/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.SQLException;
import java.sql.Statement;
import model2_1.IGDIntervalZone;
import model2_1.SBdb;

public class LOCNode
implements Comparable {
    double depth;
    double age;
    int bnd;
    private String databaseKey = null;

    public LOCNode(double depth, double csu, int bnd) {
        this.depth = depth;
        this.age = csu;
        this.bnd = bnd;
    }

    final void store(SBdb sbdb, int wellID, int interpID) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("LOCNODE") + " (well_id,interp_id,node_key,depth,age,bnd) VALUES (" + wellID + "," + interpID + ",'" + this.getKey() + "'," + this.depth + "," + this.age + "," + this.bnd + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    final void delete(SBdb sbdb, int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.deleteNode: wellID is " + wellID + ", interpID is: " + interpID);
        }
        String sql = "DELETE FROM " + sbdb.DBTableName("LOCNODE") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID + " AND node_key='" + this.getDeletionKey() + "'";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    LOCNode(LOCNode rhs) {
        this.depth = rhs.depth;
        this.age = rhs.age;
        this.bnd = rhs.bnd;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getAge() {
        return this.age;
    }

    String getKey() {
        return LOCNode.getNodeKey(this.depth, this.age);
    }

    public int getBnd() {
        return this.bnd;
    }

    public void setDatabaseKey(String key) {
        this.databaseKey = key;
    }

    String getDeletionKey() {
        if (this.databaseKey == null || this.databaseKey.isEmpty()) {
            return this.getKey();
        }
        return this.databaseKey;
    }

    public String getBoundaryType() {
        return IGDIntervalZone.getBoundary(this.bnd);
    }

    public int compareTo(Object o) {
        LOCNode node = (LOCNode)o;
        if (this.depth < node.depth) {
            return -1;
        }
        if (this.depth > node.depth) {
            return 1;
        }
        if (node.getKey().equals(this.getKey())) {
            return 0;
        }
        if ((int)(node.getDepth() * 1000.0) == (int)(this.depth * 1000.0)) {
            if (!IGDIntervalZone.isDisconformableBnd(this.bnd) && !IGDIntervalZone.isDisconformableBnd(node.bnd)) {
                return this.age > node.getAge() ? 1 : -1;
            }
            if (IGDIntervalZone.isDisconformableBnd(node.bnd)) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    static String getNodeKey(double depth, double age) {
        String ageSuffix = String.format("%06d", Math.round(age * 1000.0));
        return Math.round(depth * 1000.0 + 10000.0) + "-" + ageSuffix;
    }
}

