/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import util.DepthUtils;
import util.SB;
import util.SBException;

public class LogFile {
    int nCurves;
    int FIELD_WIDTH = 10;
    int headerType = 0;
    boolean isLAS = false;
    String filePath;
    char depthUnits = '\u0000';
    double nullValue = -999.25;
    private boolean hasFormatException = false;
    boolean hasUnreadColumns = false;
    TreeSet<LogValue> records = new TreeSet(new CompareLogValue());
    List fileHeaders = new LinkedList();
    ArrayList<CurveHeader> curveHeaders = new ArrayList();
    final int CURVE_INFORMATION = 1;
    final int PARAMETERS = 2;
    final int WELL_INFORMATION = 3;
    final int VERSION_INFORMATION = 4;

    public String getPath() {
        return this.filePath;
    }

    public String getMnem(int curve) {
        return this.curveHeaders.get(curve).getMnem();
    }

    public Iterator<CurveHeader> getCurveHeaders() {
        return this.curveHeaders.iterator();
    }

    public int getNcurves() {
        return this.curveHeaders.size();
    }

    public CurveHeader getCurveAt(int i) {
        if (i < this.curveHeaders.size()) {
            return this.curveHeaders.get(i);
        }
        return null;
    }

    public char getDepthUnits() {
        return this.depthUnits;
    }

    public TreeSet<LogValue> getRecords() {
        return this.records;
    }

    public boolean hasformatException() {
        return this.hasFormatException;
    }

    public boolean hasUnreadColumns() {
        return this.hasUnreadColumns;
    }

    public String getUnreadColumns() {
        Object s = "";
        for (CurveHeader c : this.curveHeaders) {
            if (c.canReadFormat) continue;
            if (!((String)s).isEmpty()) {
                s = (String)s + ", ";
            }
            s = (String)s + c.mnem;
        }
        return s;
    }

    public LogFile(File file) throws IOException {
        String buff;
        this.filePath = file.getPath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((buff = in.readLine()) != null) {
            if (buff.trim().length() == 0) continue;
            if (buff.startsWith("~V")) {
                this.isLAS = true;
                in.close();
                this.readLAS(file);
                break;
            }
            if (buff.startsWith("#")) continue;
            in.close();
            this.readFlat(file);
            break;
        }
    }

    private void readLAS(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            Object buff;
            boolean dataBlock = false;
            int curveCounter = 0;
            String delimiter = null;
            LogValue logValue = null;
            boolean hasDepth = false;
            while ((buff = in.readLine()) != null) {
                if (!dataBlock) {
                    if (((String)buff).length() <= 0) continue;
                    block5 : switch (((String)buff).charAt(0)) {
                        case '~': {
                            if (((String)buff).substring(1).toLowerCase().startsWith("c")) {
                                this.headerType = 1;
                                break;
                            }
                            if (((String)buff).substring(1).toLowerCase().startsWith("p")) {
                                this.headerType = 2;
                                break;
                            }
                            if (((String)buff).substring(1).toLowerCase().startsWith("w")) {
                                this.headerType = 3;
                                break;
                            }
                            if (((String)buff).substring(1).toLowerCase().startsWith("v")) {
                                this.headerType = 4;
                                break;
                            }
                            if (((String)buff).substring(1).toLowerCase().startsWith("a")) {
                                this.headerType = 0;
                                dataBlock = true;
                                break;
                            }
                            this.headerType = 0;
                            break;
                        }
                        case '#': {
                            break;
                        }
                        default: {
                            switch (this.headerType) {
                                case 1: {
                                    CurveHeader header = new CurveHeader();
                                    int dotInd = ((String)buff).indexOf(46);
                                    int colonInd = ((String)buff).indexOf(58);
                                    try {
                                        header.mnem = ((String)buff).substring(0, dotInd).trim();
                                        header.units = ((String)buff).substring(dotInd + 1, dotInd + 7).trim();
                                        if (header.units != null) {
                                            header.units = header.units.toUpperCase();
                                        }
                                        header.SPIcodes = ((String)buff).substring(dotInd + 7, colonInd).trim();
                                        header.description = ((String)buff).substring(colonInd + 1).trim();
                                        if (header.description.matches(".*\\{.*\\}$")) {
                                            if (header.description.matches(".*\\{[FI][0-9.]*\\}$")) {
                                                header.canReadFormat = true;
                                            } else {
                                                header.canReadFormat = false;
                                                this.hasUnreadColumns = true;
                                            }
                                        } else {
                                            header.canReadFormat = true;
                                        }
                                    }
                                    catch (StringIndexOutOfBoundsException ex) {
                                        System.out.println("Out of bounds exception for string: " + (String)buff);
                                    }
                                    if (header.mnem == null || !header.isDepth() || hasDepth) {
                                        this.curveHeaders.add(header);
                                        ++this.nCurves;
                                        break block5;
                                    }
                                    if (header.units != null) {
                                        if (header.units.startsWith("F")) {
                                            this.depthUnits = (char)70;
                                        } else if (header.units.startsWith("M")) {
                                            this.depthUnits = (char)77;
                                        }
                                    }
                                    hasDepth = true;
                                    break block5;
                                }
                                default: {
                                    break block5;
                                }
                                case 3: {
                                    if (((String)buff).trim().toUpperCase().startsWith("STRT")) {
                                        String units = ((String)buff).substring("STRT".length()).trim();
                                        if (units.startsWith(".F")) {
                                            this.depthUnits = (char)70;
                                            break block5;
                                        }
                                        if (!units.startsWith(".M")) break block5;
                                        this.depthUnits = (char)77;
                                        break block5;
                                    }
                                    if (!((String)buff).trim().toUpperCase().startsWith("NULL")) break block5;
                                    String nullValueString = ((String)buff).trim().substring("NULL".length()).trim();
                                    if (nullValueString.startsWith(".")) {
                                        nullValueString = nullValueString.substring(1).trim();
                                    }
                                    if (nullValueString.contains(":")) {
                                        nullValueString = nullValueString.substring(0, nullValueString.indexOf(":")).trim();
                                    }
                                    try {
                                        this.nullValue = Double.parseDouble(nullValueString);
                                    }
                                    catch (NumberFormatException ex) {
                                        System.out.println("Error from reading null value string: " + nullValueString + " : " + ex.getMessage());
                                    }
                                    break block5;
                                }
                                case 4: {
                                    if (((String)buff).trim().toUpperCase().startsWith("WRAP")) {
                                        buff = ((String)buff).replaceFirst("YES", "NO ");
                                        break block5;
                                    }
                                    if (!((String)buff).trim().toUpperCase().startsWith("DLM") || ((String)buff).indexOf(46) <= 0 || ((String)buff).length() <= ((String)buff).indexOf(46) + 1) break block5;
                                    String delim = ((String)buff).substring(((String)buff).indexOf(46) + 1).trim();
                                    if (delim.toUpperCase().startsWith("COMMA")) {
                                        delimiter = ",";
                                        break block5;
                                    }
                                    if (!delim.toUpperCase().startsWith("TAB")) break block5;
                                    delimiter = "\t";
                                }
                            }
                        }
                    }
                    if (dataBlock) continue;
                    this.fileHeaders.add(buff);
                    continue;
                }
                try {
                    String endString;
                    while (((String)buff).indexOf(34) > 0 && (endString = ((String)buff).substring(((String)buff).indexOf(34) + 1)).indexOf(34) >= 0) {
                        buff = ((String)buff).substring(0, ((String)buff).indexOf(34)) + "0.0" + endString.substring(endString.indexOf(34) + 1);
                    }
                    StringTokenizer tok = delimiter == null ? new StringTokenizer((String)buff) : new StringTokenizer((String)buff, delimiter);
                    while (tok.hasMoreTokens()) {
                        String valueString = tok.nextToken().trim();
                        double value = curveCounter > 0 && curveCounter <= this.nCurves && !this.curveHeaders.get((int)(curveCounter - 1)).canReadFormat ? this.nullValue : (valueString.toUpperCase().contains("NULL") ? this.nullValue : Double.parseDouble(valueString));
                        if (curveCounter > 0 && curveCounter <= this.nCurves) {
                            logValue.values[curveCounter - 1] = value;
                        } else {
                            curveCounter = 0;
                            logValue = new LogValue();
                            logValue.depth = value;
                            this.records.add(logValue);
                        }
                        ++curveCounter;
                    }
                }
                catch (NumberFormatException ex) {
                    this.hasFormatException = true;
                    System.out.println("Problem reading line: " + (String)buff + ", error=" + ex.getMessage());
                }
            }
        }
    }

    private void readFlat(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String buff;
            boolean dataBlock = false;
            int curveCounter = 0;
            LogValue logValue = null;
            while ((buff = in.readLine()) != null) {
                if (!dataBlock) {
                    String[] toks;
                    if (buff.length() <= 0) continue;
                    boolean first = true;
                    String[] stringArray = toks = buff.split("[ ,;\t]");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String strg = stringArray[i];
                        if (strg.isEmpty()) continue;
                        CurveHeader header = new CurveHeader();
                        header.mnem = strg;
                        if (!first) {
                            this.curveHeaders.add(header);
                            ++this.nCurves;
                        } else if (header.mnem.toUpperCase().contains("F")) {
                            this.depthUnits = (char)70;
                        } else if (header.mnem.toUpperCase().contains("M")) {
                            this.depthUnits = (char)77;
                        }
                        first = false;
                    }
                    dataBlock = true;
                    continue;
                }
                curveCounter = 0;
                try {
                    String[] toks;
                    for (String strg : toks = buff.split("[ ,;\t]")) {
                        double value;
                        block21: {
                            if (strg.isEmpty()) continue;
                            try {
                                value = Double.parseDouble(strg);
                            }
                            catch (NumberFormatException nf) {
                                if (strg.toUpperCase().indexOf(70) > 0 || strg.indexOf(39) > 0) {
                                    this.depthUnits = (char)70;
                                }
                                value = DepthUtils.parseDepthString((String)strg);
                                if (this.depthUnits != 'F') break block21;
                                value = DepthUtils.convFromM((double)value, (char)this.depthUnits);
                            }
                        }
                        if (curveCounter > 0 && curveCounter <= this.nCurves) {
                            logValue.values[curveCounter - 1] = value;
                        } else {
                            curveCounter = 0;
                            logValue = new LogValue();
                            logValue.depth = value;
                            this.records.add(logValue);
                        }
                        ++curveCounter;
                    }
                }
                catch (NumberFormatException | SBException ex) {
                    this.hasFormatException = true;
                    System.out.println("Problem reading line: " + buff + ", error=" + ex.getMessage());
                }
            }
        }
    }

    void writeLAS(String filePath) throws IOException, SBException {
        if (!this.isLAS) {
            throw new SBException("Cannot write LAS file from non-LAS source file");
        }
        try (FileWriter out = new FileWriter(filePath);){
            String eol = "\r\n";
            Iterator ith = this.fileHeaders.iterator();
            while (ith.hasNext()) {
                out.write(ith.next() + eol);
            }
            out.write("~A   DEPTH");
            for (CurveHeader h : this.curveHeaders) {
                out.write(this.pad(h.mnem));
            }
            out.write(eol);
            for (LogValue logValue : this.records) {
                out.write(this.pad(SB.floatString((double)logValue.depth, (int)3)));
                for (int j = 0; j < this.nCurves; ++j) {
                    out.write(this.pad(SB.floatString((double)logValue.values[j], (int)3)));
                }
                out.write(eol);
            }
        }
    }

    private String pad(String s) {
        while (((String)s).length() < this.FIELD_WIDTH) {
            s = " " + (String)s;
        }
        return s;
    }

    public class CurveHeader {
        String mnem;
        String units;
        String SPIcodes;
        String description;
        boolean canReadFormat = true;

        public String getMnem() {
            return this.mnem;
        }

        boolean isDepth() {
            String m = this.mnem.toUpperCase();
            return m.startsWith("DEPT") || m.equals("MD") || m.equals("TDEP");
        }
    }

    class CompareLogValue
    implements Comparator {
        CompareLogValue() {
        }

        public int compare(Object l1, Object l2) {
            LogValue log1 = (LogValue)l1;
            LogValue log2 = (LogValue)l2;
            if (log1.depth < log2.depth) {
                return -1;
            }
            if (log1.depth > log2.depth) {
                return 1;
            }
            return 0;
        }
    }

    public class LogValue {
        double depth;
        double[] values;

        public LogValue() {
            this.values = new double[LogFile.this.nCurves];
            for (int i = 0; i < LogFile.this.nCurves; ++i) {
                this.values[i] = LogFile.this.nullValue;
            }
        }
    }
}

