/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import model2_1.SBdb;

public class NextControl {
    private final boolean hasControlTable;
    static final String CONTROL_TABLE_NAME = "CONTROL";
    private static final String CONTROL_TABLE_COL_TABLENAME = "table_name";
    private static final String CONTROL_TABLE_COL_CONVAL = "next_id";

    public NextControl(boolean hasControlTable) {
        this.hasControlTable = hasControlTable;
    }

    public int nextControl(SBdb db, String tableName, String columnName, Statement statement) throws SQLException {
        if (this.hasControlTable) {
            return NextControl.getNextControlFromControlTable(db, tableName, columnName, statement);
        }
        return NextControl.getNextControlAsMaxId(db, tableName, columnName, statement);
    }

    private static int getNextControlAsMaxId(SBdb db, String tableName, String columnName, Statement stmt) throws SQLException {
        int maxId = 0;
        String sql = "SELECT max(" + columnName + ") as conval FROM " + db.DBTableName(tableName);
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            maxId = rs.getInt("conval");
        }
        return ++maxId;
    }

    private static int getNextControlFromControlTable(SBdb db, String tableName, String columnName, Statement stmt) throws SQLException {
        String updateConvalQuery;
        int nRows;
        Integer conval = null;
        String findRowQuery = "SELECT next_id as conval FROM " + db.DBTableName(CONTROL_TABLE_NAME) + " WHERE table_name='" + tableName + "'";
        ResultSet rs = stmt.executeQuery(findRowQuery);
        if (rs.next()) {
            conval = rs.getInt("conval");
        }
        int nextControlAsMaxID = NextControl.getNextControlAsMaxId(db, tableName, columnName, stmt);
        if (conval == null) {
            String insertConvalQuery = "INSERT INTO " + db.DBTableName(CONTROL_TABLE_NAME) + " (table_name,next_id) VALUES ('" + tableName + "'," + (nextControlAsMaxID + 1) + ")";
            stmt.executeUpdate(insertConvalQuery);
            return nextControlAsMaxID;
        }
        int nextID = conval;
        if (nextControlAsMaxID > conval) {
            nextID = nextControlAsMaxID;
            String updateConvalQuery2 = "UPDATE " + db.DBTableName(CONTROL_TABLE_NAME) + " SET next_id=" + (nextID + 1) + " WHERE table_name='" + tableName + "'";
            stmt.executeUpdate(updateConvalQuery2);
            return nextID;
        }
        int timesToTry = 10;
        for (int i = 0; i < timesToTry && (nRows = stmt.executeUpdate(updateConvalQuery = "UPDATE " + db.DBTableName(CONTROL_TABLE_NAME) + " SET next_id=" + (nextID + 1) + " WHERE table_name='" + tableName + "' AND next_id=" + nextID)) != 1; ++i) {
            ++nextID;
        }
        return nextID;
    }
}

