/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import javax.swing.JOptionPane;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WsWell;
import util.SBException;
import util.SBPermissionException;
import util.status.MergeStatus;

public final class OccFileReader {
    Set dataTypes;
    char discID;
    char units;
    SBdb ws;
    int specID = 1;

    public OccFileReader(SBdb ws, String fileName, Set dataTypes, char discID, char units, Userdef analyst) throws SBException, SQLException {
        this.dataTypes = dataTypes;
        this.discID = discID;
        this.units = units;
        Userdef wsAnalyst = ws.getUser(ws.getAddUserID(analyst.getAbr()));
        wsAnalyst.setLink(analyst);
        this.ws = ws;
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            String buff;
            WsWell well = ws.addWellToWorkspace(0, fileName);
            well.loadInterps();
            well.getAddInterp(ws.getInterp(0));
            String wellCode = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf(46));
            well.getHeader().setWellName(wellCode);
            well.getHeader().setWellCode(Well.makeCode(wellCode));
            well.getHeader().setWellUnits(units);
            AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
            well.getSamples();
            Smpdtl smpdtl = null;
            while ((buff = in.readLine()) != null) {
                boolean isSample = false;
                try {
                    double d;
                    if (buff.contains("-")) {
                        double d2 = Double.parseDouble(buff.substring(0, buff.indexOf(45)));
                        if (d2 > 0.0) {
                            isSample = true;
                        }
                    } else if (buff.length() < 10 && (d = Double.parseDouble(buff.trim())) > 0.0) {
                        isSample = true;
                    }
                }
                catch (NumberFormatException d) {
                    // empty catch block
                }
                if (isSample) {
                    smpdtl = this.parseSample(buff, discID, in, well, analyHdr, false);
                    continue;
                }
                if (smpdtl == null) continue;
                this.parseOcc(buff, smpdtl, well.getWellID());
            }
            for (Sample sample : well.getSamples()) {
                if (sample.analyses.isEmpty()) continue;
                Smpdtl d = sample.analyses.get(0);
                sample.status = MergeStatus.merge((Color)sample.status, (Color)d.status);
            }
            if (well.getSamples().size() > 0) {
                well.getHeader().setTD(well.getSamples().get(well.getSamples().size() - 1).getDepth('M'));
            }
            well.updateStatus(dataTypes);
            this.addDataType(1);
            this.addDataType(SBdb.did2dtype(discID));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Can't open or read file: " + ex.toString());
            ex.printStackTrace();
        }
    }

    Smpdtl parseSample(String buff, char discID, BufferedReader in, Well well, AnalystHeader analyHdr, boolean useSampleTops) throws IOException, SBException, SQLException {
        Sample sample;
        Sample.Builder builder = Sample.parseDepthString(buff, this.units, false, useSampleTops);
        builder.type(SampleType.CU);
        try {
            sample = well.addSample(builder, 0, null);
        }
        catch (SBPermissionException pe) {
            throw new IllegalStateException("Unexpected permission exception in workspace");
        }
        sample.displayUnits = this.units;
        Smpdtl smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
        sample.insert(smpdtl);
        if (sample.getBaseDepth('M') > well.getTD()) {
            well.getHeader().setTD(sample.getBaseDepth('M'));
        }
        return smpdtl;
    }

    void parseOcc(String buff, Smpdtl smpdtl, int wellID) throws SQLException, SBException {
        if (smpdtl == null) {
            throw new SBException("Cannot read file correctly - invalid sample around line: " + buff);
        }
        System.out.println("Parsing occ line: " + buff);
        if (buff.trim().toLowerCase().equals("barren")) {
            smpdtl.updateBarren(wellID, Smpdtl.AnalysisType.BARREN, false);
        } else {
            int space = buff.indexOf(32);
            if (space > 0) {
                int counts = Integer.parseInt(buff.substring(0, space));
                Taxon taxonRef = this.parseTaxon(buff.substring(space).trim());
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, false, false, 0);
                builder = builder.count(counts);
                try {
                    smpdtl.insertOccurrence(builder, wellID, false);
                }
                catch (SBException ex) {
                    throw new SBException(ex.getMessage() + " in Sample: " + smpdtl.toString());
                }
            }
        }
    }

    Taxon parseTaxon(String strg) {
        Taxon t = this.ws.getTaxon(strg, this.specID, true);
        if (t.getSpecID() == this.specID) {
            ++this.specID;
        }
        return t;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

