/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;
import model2_1.Biocom;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.WellEvent;
import model2_1.WellHeader;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;

public class PDIReader {
    Connection connection;
    SBdb ws;
    Set dataTypes;

    public PDIReader(SBdb ws, Set dataTypes, String path) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, SBException {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
        String driverString = "jdbc:odbc:" + SBdb.getHostName(path);
        System.out.println("Connecting to PDI with: " + driverString);
        this.connection = DriverManager.getConnection(driverString);
        this.ws = ws;
        this.dataTypes = dataTypes;
        this.parseDB();
    }

    private void parseDB() throws SQLException, SBException {
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT [RECORD #], API, WELL_LETTER, WELL_NUMBER, SIDETRACK, BYPASS, OPERATOR, LEASE, AREA, BLOCK_LETTER, BLOCK_NUMBER, SURFLAT, SURFLONG, RPTYPE, REPORT_DATE, REVISION_DATE, RELEASED, RELEASE_DATE FROM tblCLIENT_WELL";
        ResultSet rs = stmt.executeQuery(sql);
        HashMap<Integer, String> PDIWells = new HashMap<Integer, String>();
        HashMap<Integer, Character> PDIWellDisc = new HashMap<Integer, Character>();
        block26: while (rs.next()) {
            int PDIwellID = rs.getInt("RECORD #");
            String wellCode = rs.getString("API");
            if (this.ws.getWell(wellCode) == null) {
                int bypass;
                WsWell wsWell = this.ws.addWellToWorkspace(0, null);
                wsWell.getSamples();
                wsWell.loadInterps();
                Object h = wsWell.getHeader();
                Object wellName = rs.getString("AREA");
                wellName = (String)wellName + " " + rs.getString("BLOCK_NUMBER");
                String operator = rs.getString("OPERATOR");
                wellName = (String)wellName + " " + this.codeOperator(operator);
                wellName = (String)wellName + " #" + rs.getString("WELL_NUMBER");
                int sideTrack = rs.getInt("SIDETRACK");
                if (sideTrack > 0) {
                    wellName = (String)wellName + "ST" + sideTrack;
                }
                if ((bypass = rs.getInt("BYPASS")) > 0) {
                    wellName = (String)wellName + "BP" + bypass;
                }
                ((WellHeader)h).setWellName((String)wellName);
                ((WellHeader)h).setWellCode(wellCode);
                ((WellHeader)h).setWellUnits('F');
                ((WellHeader)h).setCountry("USA");
                ((WellHeader)h).setDatum(1);
                ((WellHeader)h).setOper(operator);
                String latString = rs.getString("SURFLAT");
                try {
                    ((WellHeader)h).setLat(Double.parseDouble(latString));
                }
                catch (NumberFormatException ne) {
                    System.out.println("Can't parse lat: " + latString);
                }
                String longString = rs.getString("SURFLONG");
                try {
                    ((WellHeader)h).setLong(Double.parseDouble(longString));
                }
                catch (NumberFormatException ne) {
                    System.out.println("Can't parse long: " + longString);
                }
            }
            PDIWells.put(PDIwellID, wellCode);
            String discipline = rs.getString("RPTYPE");
            switch (discipline) {
                default: {
                    PDIWellDisc.put(PDIwellID, Character.valueOf('M'));
                    continue block26;
                }
                case "NANNO": {
                    PDIWellDisc.put(PDIwellID, Character.valueOf('N'));
                    continue block26;
                }
                case "PALY": 
            }
            PDIWellDisc.put(PDIwellID, Character.valueOf('P'));
        }
        sql = "SELECT record, mdepth, fauna, age, eco, comments, source FROM tblCLIENT_PALEO ORDER BY record, mdepth";
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int wellID = rs.getInt("record");
            double depth = rs.getDouble("mdepth");
            String fauna = rs.getString("fauna");
            Double age = rs.getDouble("age");
            Float eco = Float.valueOf(rs.getFloat("eco"));
            String comments = rs.getString("comments");
            String source = rs.getString("source");
            Discipline discipline = Discipline.getDisc(((Character)PDIWellDisc.get(wellID)).charValue());
            WsWell wsWell = (WsWell)this.ws.getWell((String)PDIWells.get(wellID));
            if (wsWell == null) {
                System.out.println("Can't find well for ID: " + wellID);
                continue;
            }
            Sample sample = wsWell.getSample(depth = DepthUtils.convToM((double)depth, (char)'F'), "CU", true);
            if (sample == null) {
                sample = this.ws.useSampleTops() ? wsWell.addSample((Double)depth, null, "CU", null) : wsWell.addSample(null, (Double)depth, "CU", null);
            }
            this.dataTypes.add(1);
            if (fauna != null && !fauna.isEmpty()) {
                SBEvent event = null;
                try {
                    event = this.ws.getSBEvent(fauna);
                }
                catch (Exception ex) {
                    System.out.println("Error getting event: " + ex.getMessage());
                    continue;
                }
                if (event == null) {
                    try {
                        event = this.ws.addSBEvent(new SBEvent.Builder().name(fauna).isGenerate(true).isSingle(false));
                        this.dataTypes.add(16);
                    }
                    catch (SBPermissionException pe) {
                        throw new SBException(pe.getMessage());
                    }
                }
                WellEvent wellEvent = new WellEvent.Builder().sample(sample).type(SBEvent.EventType.TOP).event(event).discID(discipline).build(this.ws);
                try {
                    wsWell.getAddInterp(this.ws.getInterp(0)).insertEvent(wellEvent);
                }
                catch (Exception ex) {
                    System.out.println("Cannot insert event: " + wellEvent + " into well: " + wsWell + ". Reason: " + ex.toString());
                }
            }
            if (comments == null || comments.isEmpty()) continue;
            if (comments.length() > 256) {
                comments = comments.substring(0, 255);
            }
            Biocom biocom = new Biocom.Builder(this.ws, discipline, this.ws.getAddUserID("PDI"), sample, comments).build();
            try {
                wsWell.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
                switch (discipline) {
                    case MICRO: {
                        this.dataTypes.add(3);
                        break;
                    }
                    case NANNO: {
                        this.dataTypes.add(5);
                        break;
                    }
                    case PALY: {
                        this.dataTypes.add(7);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Cannot insert biocom: " + biocom + " into well: " + wsWell + ". Reason: " + ex.toString());
            }
        }
        stmt.close();
    }

    private String codeOperator(String o) {
        switch (o) {
            case "MURPHY": {
                return "MUR";
            }
            case "DEVON": {
                return "DEV";
            }
            case "WALTER OIL & GAS": {
                return "WAL";
            }
            case "HESS CORPORATION": {
                return "HES";
            }
            case "MCMORAN OIL & GAS": {
                return "FCX";
            }
        }
        return o;
    }
}

