/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import model2_1.Audit;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import util.SB;
import util.SBObservable;
import util.SBPermissionException;

public class Project
extends SBObservable
implements Comparable {
    private final int ID;
    private String name;
    private Audit audit;

    Project(int projID, String name, Audit audit) {
        assert (projID > 0);
        assert (name != null && !name.isEmpty());
        assert (audit != null);
        this.ID = projID;
        this.name = name;
        this.audit = audit;
    }

    Project(SBdb sbdb, int projID) throws SQLException {
        this.ID = projID;
        String sql = "SELECT name," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("SBWLLST") + " WHERE id=" + projID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                this.name = rs.getString("name").trim();
                this.audit = new Audit(rs);
            }
        }
        if (this.name == null) {
            this.name = "<none>";
        }
    }

    public String getName() {
        return this.name;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public void update(SBdb sbdb, String name) throws SQLException, SBPermissionException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Attempt to change project name to " + name);
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("SBWLLST") + " SET name=" + SB.DBString((String)name) + "," + temp.sqlUpdate(sbdb, stmt, false) + " WHERE id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.name = name;
            this.audit = temp;
            this.setChanged();
        }
    }

    void updateAudit(SBdb sbdb) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("SBWLLST") + " SET " + temp.sqlUpdate(sbdb, stmt, false) + " WHERE id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.audit = temp;
            this.setChanged();
        }
    }

    void copy(Project rhs) {
        this.name = rhs.name;
        this.audit = new Audit(rhs.audit);
    }

    public int getID() {
        return this.ID;
    }

    public String toString() {
        return this.name;
    }

    void store(SBdb sbdb) throws SQLException, SBPermissionException {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalStateException("Attempt to store well list with no name");
        }
        if (this.ID <= 0) {
            throw new IllegalStateException("Attempt to store well list with illegal ID: " + this.ID);
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("SBWLLST") + " (ID,name," + Audit.sqlFieldString() + ") VALUES (" + this.ID + "," + SB.DBString((String)this.name) + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    void delete(SBdb sbdb) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "DELETE FROM " + sbdb.DBTableName("SBWLMB") + " WHERE id=" + this.ID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName("SBWLLST") + " WHERE id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Project) {
            return this.name.compareToIgnoreCase(((Project)o).name);
        }
        return 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.ID;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.ID == other.ID;
    }
}

