/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JOptionPane;
import model2_1.AbnScheme;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.SBException;
import util.SBPermissionException;

public final class SISSbugsReader {
    Set<Integer> dataTypes;
    String dataSource;
    static final int WELL = 1;
    static final int FSSABND = 2;
    WsWell well = null;
    int abnSchID = 1;
    LinkedHashMap abnSchemes = new LinkedHashMap();
    SBdb ws;

    public SISSbugsReader(String fileName, SBdb ws, Set dataTypes, String analyst) throws SBException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (buff.length() < 2 || !buff.substring(0, 2).equals("**")) {
                    throw new SBException("Not a SIS \"StrataBugs\" format file");
                }
                this.dataSource = buff.substring(25).trim();
                buff = in.readLine();
                if (!buff.substring(0, 1).equals("*")) {
                    throw new SBException("Error reading line :" + buff);
                }
                this.well = ws.addWellToWorkspace(0, fileName);
                this.well.loadInterps();
                boolean hasWellDetails = false;
                block10: while (buff != null) {
                    switch (this.decodeRecordType(buff.substring(1))) {
                        case 1: {
                            buff = this.parseWell(in.readLine(), in);
                            hasWellDetails = true;
                            continue block10;
                        }
                        case 2: {
                            buff = this.parseFssabnd(buff, analyst, in);
                            continue block10;
                        }
                        case -1: {
                            buff = null;
                            continue block10;
                        }
                    }
                    buff = in.readLine();
                }
                if (!hasWellDetails) {
                    this.well.getHeader().setWellName(fileName.substring(0, fileName.lastIndexOf(".")));
                    if (this.well.getHeader().getWellName().length() > 25) {
                        this.well.getHeader().setWellName(this.well.getWellName().substring(this.well.getWellName().length() - 25));
                    }
                }
                this.well.updateStatus(dataTypes);
            }
            catch (SBException eio) {
                JOptionPane.showMessageDialog(null, "Problem processing file: " + eio.getMessage());
                eio.printStackTrace();
            }
            catch (SQLException eio) {
                JOptionPane.showMessageDialog(null, "SQL Error: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (IOException fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
        }
    }

    String parseWell(String buff, BufferedReader in) throws IOException, SBException {
        this.well.getHeader().setWellName(buff.substring(0, buff.indexOf(9)));
        buff = buff.substring(buff.indexOf(9) + 1);
        this.well.getHeader().setWellCode(buff.substring(0, buff.indexOf(9)));
        buff = in.readLine();
        return buff;
    }

    String parseFssabnd(String buff, String analyst, BufferedReader in) throws IOException, SBException, SQLException {
        char discID = 'P';
        Discipline disc = Discipline.getDisc(discID);
        if (buff.length() >= 10 && (disc = Discipline.getDisc(discID = buff.charAt(9))) == null) {
            throw new SBException("Not a valid discipline in line: " + buff);
        }
        buff = in.readLine();
        if (buff.trim().equals("ABNSSCHME")) {
            buff = this.parseAbnscheme(disc, in);
        } else if (buff.trim().equals("ABNSCHME")) {
            throw new SBException("This appears to be a genuine StrataBugs format file!");
        }
        if (buff.trim().startsWith("TAXA")) {
            buff = this.parseTaxa(disc, buff, in);
        }
        if (buff.trim().equals("SAMPLES")) {
            buff = this.parseSamples(discID, analyst, in);
        }
        return buff;
    }

    String parseAbnscheme(Discipline discID, BufferedReader in) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        AbnScheme abnScheme = new AbnScheme(this.abnSchID);
        while (!buff.startsWith("TAXA")) {
            abnScheme.addClass(buff.substring(0, 4).trim(), buff.substring(4, 29).trim(), Integer.parseInt(buff.substring(29).trim()), 0);
            buff = in.readLine();
        }
        abnScheme.setName("SISSbugsReader " + discID.getNoun() + " Scheme");
        this.abnSchemes.put(Character.valueOf(discID.getChar()), this.abnSchID);
        ++this.abnSchID;
        try {
            this.ws.addAbnScheme(abnScheme);
        }
        catch (SBPermissionException pe) {
            throw new SBException("PermissionException parsing AbnScheme: " + pe.getMessage(), (Throwable)pe);
        }
        return buff;
    }

    String parseTaxa(Discipline discID, String buff, BufferedReader in) throws IOException, SBException {
        int nTaxa = Integer.parseInt(buff.substring(5));
        for (int i = 0; i < nTaxa; ++i) {
            buff = in.readLine();
            int donorID = Integer.parseInt(buff.substring(0, 8).trim());
            String donorString = buff.substring(8).trim();
            buff = in.readLine();
            String cat_mnem = buff.substring(0, 8).trim();
            this.ws.getTaxon(donorString, donorID, true);
            this.ws.setTaxonCat(donorID, cat_mnem);
        }
        buff = in.readLine();
        return buff;
    }

    String parseSamples(char discID, String analyst, BufferedReader in) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        Sample sample = null;
        TaxonOcc fss = null;
        this.well.getSamples();
        while (buff != null && buff.length() > 0) {
            if (buff.charAt(0) == 'S') {
                double baseDepth = Float.parseFloat(buff.substring(1, 8).trim());
                SampleType sampleType = SampleType.parseType(buff.substring(9, 19).trim());
                sample = this.well.getSample(null, baseDepth, sampleType, false);
                if (sample == null) {
                    sample = this.well.addSample(null, (Double)baseDepth, sampleType.getAbr(), "");
                    this.addDataType(1);
                }
            } else if (buff.charAt(0) == 'D') {
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                Smpdtl smpdtl = sample.getSmpdtl(discID, analyst, 1);
                if (smpdtl == null) {
                    AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                    if (this.ws.getAbnSchemes().size() > 0) {
                        analyHdr.setAbnScheme((Integer)this.abnSchemes.get(Character.valueOf(discID)));
                    }
                    smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), buff.charAt(2) == 'Y' ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtl);
                    this.addDataType(SBdb.did2dtype(discID));
                } else {
                    System.out.println("Duplicate sample info for discipline: " + discID + " for sample: " + sample.toString());
                }
            } else if (buff.charAt(0) == 'T') {
                if (sample == null) {
                    throw new SBException("Sample record missing for line " + buff);
                }
                int donorID = Integer.parseInt(buff.substring(1, 9).trim());
                if (donorID > 0) {
                    Taxon t = this.ws.getTaxon(donorID);
                    if (t == null) {
                        throw new SBException("Cannot find taxon record for line: " + buff);
                    }
                    String occType = buff.substring(9, 19).trim();
                    boolean reworked = false;
                    boolean questionable = false;
                    if (occType.indexOf(82) >= 0) {
                        reworked = true;
                    }
                    if (occType.indexOf(63) >= 0) {
                        questionable = true;
                    }
                    TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, t, reworked, questionable, 0);
                    if (buff.length() < 26) {
                        System.out.println("Warning: null abundance for line: " + buff);
                    } else {
                        Smpdtl smpdtl;
                        String abund = buff.substring(20, 26).trim();
                        try {
                            builder.count(Integer.parseInt(abund));
                        }
                        catch (NumberFormatException ne) {
                            builder.subjAbund(abund);
                        }
                        if (buff.length() >= 27 && buff.charAt(26) == 'C') {
                            builder.caved(true);
                        }
                        if ((smpdtl = sample.getSmpdtl(discID, analyst, 1)) == null) {
                            AnalystHeader analyHdr = this.well.getAnalystHeader(analyst, discID, 1, true);
                            if (this.ws.getAbnSchemes().size() > 0) {
                                analyHdr.setAbnScheme((Integer)this.abnSchemes.get(Character.valueOf(discID)));
                            }
                            smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                            sample.insert(smpdtl);
                        }
                        fss = smpdtl.insertOccurrence(builder, this.well.getWellID(), false);
                    }
                } else {
                    System.out.println("Warning: blank taxon ID in line: " + buff);
                }
            } else {
                if (buff.charAt(0) != 'A') break;
                if (fss == null) {
                    throw new SBException("Taxon record null for occurrence detail record: " + buff);
                }
                fss.setPreservation(buff.substring(1, buff.indexOf(9)));
                buff = buff.substring(buff.indexOf(9) + 1);
                fss.setColour(buff.substring(1, buff.indexOf(9)));
                fss.setComment(buff.substring(buff.indexOf(9) + 1));
            }
            buff = in.readLine();
        }
        return buff;
    }

    int decodeRecordType(String buff) {
        if (buff.equals("WELL")) {
            return 1;
        }
        if (buff.startsWith("FSSABND")) {
            return 2;
        }
        if (buff.contains("999") || buff.contains("EOF")) {
            return -1;
        }
        return 0;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

