/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import model2_1.Audit;
import model2_1.DEXFile;
import model2_1.Markers;
import model2_1.SBdb;
import model2_1.Userdef;
import org.jdom2.Element;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class SeismicMarker
implements SbugsStatus,
SortEntry {
    SeismicMarker link = null;
    private double depth;
    private String name = "";
    private Color colour;
    private Audit audit = new Audit();
    Color status = SbugsStatus.UNKNOWN;

    public SeismicMarker(double depth, String name, Color colour) {
        this.depth = depth;
        this.name = name;
        this.colour = colour;
        this.status = NOTSTORED;
    }

    SeismicMarker(double depth, String name, Color colour, Audit audit) {
        this.depth = depth;
        this.name = name;
        this.colour = colour;
        this.audit = audit;
        this.status = STORED;
    }

    public SeismicMarker(SeismicMarker rhs) {
        this.copy(rhs);
    }

    SeismicMarker(DEXFile.DEXsection section) throws SBException {
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Marker")) {
                this.name = value;
                continue;
            }
            if (!label.equalsIgnoreCase("Depth")) continue;
            this.depth = DepthUtils.parseDepthString((String)value);
        }
    }

    SeismicMarker(SBdb SB2, SBdb ws, int wellID, SeismicMarker wsMarker) throws SQLException, SBException {
        this.copy(wsMarker);
        this.status = wsMarker.status;
        this.audit = new Audit(SB2, ws, wsMarker.audit);
        this.store(SB2, wellID);
    }

    SeismicMarker(SBdb ws, Element xml) throws SBException, ParseException, SQLException {
        Element el;
        String strg = xml.getChildTextNormalize("Name");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("Depth")) != null) {
            this.depth = DepthUtils.parseDepthString((String)strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for SeismicMarker: " + this);
        }
        el = xml.getChild("Colour");
        if (el != null) {
            this.colour = SB.parseColour((Element)el);
        }
    }

    public double getDepth() {
        return this.depth;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, int wellID) throws SQLException {
        if (this.status == NOTSTORED) {
            Statement stmt = SB2.getDatabase().createStatement();
            String sql = "INSERT INTO " + SB2.DBTableName("WELLSMARK") + " (well_id,depth,name,red,green,blue," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + this.depth + ",'" + this.name + "'," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.audit.sqlInsert(SB2, stmt) + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, int wellID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID + " AND depth > " + (this.depth - 0.01) + " AND depth < " + (this.depth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
    }

    public void updateStatus(Markers oldData) {
        int nzD = (int)(this.depth * 100.0);
        this.status = NOTSTORED;
        for (int i = 0; i < oldData.getSize(); ++i) {
            int cD;
            SeismicMarker marker = oldData.get(i);
            if (marker == this || (cD = (int)(marker.depth * 100.0)) != nzD) continue;
            this.status = STORED;
            if (this.name.equalsIgnoreCase(marker.name) && this.colour.equals(marker.colour)) continue;
            this.status = CONFLICT;
            break;
        }
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[MARKER " + SB.getDepthString((double)this.depth, (char)units, (int)2).trim() + "]" + eol);
        out.write("Depth = " + SB.getDepthString((double)this.depth, (char)units, (int)2).trim() + eol);
        out.write("Marker = " + this.name + eol);
        out.write(eol);
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<SeismicMarker>\n");
        String depthString = SB.getDepthString((double)this.depth, (char)units, (int)2);
        out.write((String)ind + "<Depth>" + depthString + "</Depth>\n");
        out.write((String)ind + "<Name>" + this.name + "</Name>\n");
        if (this.colour != null) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind);
        }
        this.audit.writeXML(out, indent);
        out.write("</SeismicMarker>\n");
    }

    public Color getColour() {
        return this.colour;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    void copy(SeismicMarker rhs) {
        this.depth = rhs.depth;
        this.name = rhs.name;
        this.colour = rhs.colour;
        this.audit = rhs.audit;
        this.link = rhs;
    }

    public String getSortEntry() {
        String entry = "" + (int)(this.depth * 100.0);
        while (entry.length() < 7) {
            entry = " " + entry;
        }
        return entry;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    void setAnalyst(Userdef analyst) {
        this.audit.setAnalyst(analyst.getUsrID());
    }
}

