/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import model2_1.AgeConfidence;
import model2_1.Chron;
import model2_1.CompositeStandard;
import model2_1.CompositeStandardEvent;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.IGDUnitBase;
import model2_1.LithostratUnit;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Surface;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class TSCreatorReader {
    private final List<TSCScheme> tscSchemes = new LinkedList<TSCScheme>();
    private final List<TSCCurve> tscCurves = new LinkedList<TSCCurve>();
    private final SBdb ws;

    public List<TSCScheme> getLists() {
        return this.tscSchemes;
    }

    public List<TSCCurve> getCurves() {
        return this.tscCurves;
    }

    private String stripQuotes(String strg) {
        if (strg != null) {
            if (strg.startsWith("\"") && strg.endsWith("\"")) {
                strg = strg.substring(1, strg.length() - 1);
            }
            strg = strg.replaceAll("\"\"", "\"");
        }
        return strg;
    }

    public TSCreatorReader(SBdb ws, String fileName) throws IOException, SBException {
        BufferedReader in;
        File file;
        ZipFile zipFile;
        this.ws = ws;
        if (fileName.indexOf("himem") > 0) {
            int nBytes;
            zipFile = new ZipFile(fileName);
            System.out.println("Extracting zip file....");
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            ZipEntry entry = null;
            while (en.hasMoreElements() && !(entry = en.nextElement()).getName().toLowerCase().endsWith("jar")) {
            }
            if (entry == null) {
                throw new SBException("No jar file found in himem jar file");
            }
            InputStream fis = zipFile.getInputStream(entry);
            file = File.createTempFile("TSCreator-2.1", "jar");
            FileOutputStream fos = new FileOutputStream(file);
            byte[] b = new byte[Short.MAX_VALUE];
            while ((nBytes = fis.read(b, 0, b.length)) > 0) {
                fos.write(b, 0, nBytes);
            }
            fos.close();
            System.out.println("...done");
        } else {
            file = new File(fileName);
        }
        if (file.getName().toLowerCase().endsWith("jar")) {
            zipFile = new ZipFile(file);
            in = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("default_data.txt"))));
        } else {
            in = new BufferedReader(new FileReader(file));
        }
        String buff = in.readLine();
        if (buff.startsWith("format version")) {
            buff = in.readLine();
        }
        RECORDTYPE readingRecord = RECORDTYPE.NONE;
        boolean readingFAD = false;
        boolean readingLAD = false;
        boolean readingSINGLEEVENT = false;
        TSCEventList tscEvent = null;
        TSCBlock tscBlock = null;
        TSCChronBlock tscChronBlock = null;
        TSCSequence tscSequence = null;
        TSCCurve tscCurve = null;
        String precedingSurfaceName = null;
        String chronSeries = "";
        while (buff != null) {
            if (buff.length() > 0) {
                if (buff.charAt(0) != '\t') {
                    String[] tok = buff.split("\t", -1);
                    if (!(tok.length <= 2 || tok[0].equals("FAD") || tok[0].equals("LAD") || tok[0].equals("EVENT"))) {
                        String[] rgb;
                        Object colour;
                        TSCScheme scheme3;
                        Object scheme2;
                        String dType;
                        int nTok = 0;
                        String name = tok[nTok++];
                        if ((dType = tok[nTok++]) == null) continue;
                        if (dType.equals(":") && !name.equalsIgnoreCase("Chart Title") && !name.equalsIgnoreCase("date")) {
                            String schemeName;
                            scheme2 = new TSCScheme();
                            ((TSCScheme)scheme2).name = name;
                            while (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && !(schemeName = tok[nTok++]).contains("METACOLUMN")) {
                                ((TSCScheme)scheme2).columnNames.add(schemeName);
                            }
                            this.tscSchemes.add((TSCScheme)scheme2);
                        }
                        if (dType.equals("event")) {
                            tscEvent = new TSCEventList();
                            tscEvent.name = name;
                            if (tok.length > 3 && tok[nTok++] != null) {
                                tscEvent.author = tok[nTok];
                            }
                            readingRecord = RECORDTYPE.EVENTS;
                            for (TSCScheme scheme3 : this.tscSchemes) {
                                for (String schemeName : scheme3.columnNames) {
                                    if (!schemeName.equals(tscEvent.name)) continue;
                                    scheme3.columns.add(tscEvent);
                                }
                            }
                        } else if (dType.equals("block")) {
                            readingRecord = RECORDTYPE.BLOCK;
                            tscBlock = new TSCBlock();
                            tscBlock.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscBlock.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && ((String)(colour = tok[nTok])).contains("/") && (rgb = ((String)colour).split("/")).length == 3) {
                                tscBlock.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscBlock.title = tok[nTok];
                            }
                            colour = this.tscSchemes.iterator();
                            while (colour.hasNext()) {
                                scheme3 = (TSCScheme)colour.next();
                                for (String schemeName : scheme3.columnNames) {
                                    if (!schemeName.equals(tscBlock.name)) continue;
                                    scheme3.columns.add(tscBlock);
                                }
                            }
                        } else if (dType.equals("chron")) {
                            readingRecord = RECORDTYPE.CHRON;
                            tscChronBlock = new TSCChronBlock();
                            tscChronBlock.name = name;
                            colour = this.tscSchemes.iterator();
                            while (colour.hasNext()) {
                                scheme3 = colour.next();
                                for (String schemeName : scheme3.columnNames) {
                                    if (!schemeName.equals(tscChronBlock.name)) continue;
                                    scheme3.columns.add(tscChronBlock);
                                }
                            }
                        } else if (dType.equals("point")) {
                            readingRecord = RECORDTYPE.POINT;
                            tscCurve = new TSCCurve();
                            tscCurve.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscCurve.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && ((String)(colour = tok[nTok])).contains("/") && (rgb = ((String)colour).split("/")).length == 3) {
                                tscCurve.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscCurve.title = tok[nTok];
                            }
                            this.tscCurves.add(tscCurve);
                        } else if (dType.equals("facies")) {
                            readingRecord = RECORDTYPE.NONE;
                        } else if (dType.equals("sequence") || dType.equals("trend")) {
                            precedingSurfaceName = null;
                            readingRecord = RECORDTYPE.SEQUENCE;
                            tscSequence = new TSCSequence();
                            tscSequence.name = name;
                            if (nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscSequence.width = Float.parseFloat(tok[nTok]);
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0 && ((String)(colour = tok[nTok])).contains("/") && (rgb = ((String)colour).split("/")).length == 3) {
                                tscSequence.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            }
                            if (++nTok < tok.length && tok[nTok] != null && tok[nTok].length() > 0) {
                                tscSequence.title = tok[nTok];
                            }
                            scheme2 = new TSCScheme();
                            ((TSCScheme)scheme2).name = tscSequence.name;
                            ((TSCScheme)scheme2).columnNames.add(tscSequence.name);
                            ((TSCScheme)scheme2).columns.add(tscSequence);
                            this.tscSchemes.add((TSCScheme)scheme2);
                        }
                    } else if (readingRecord == RECORDTYPE.EVENTS) {
                        if (buff.trim().equals("FAD")) {
                            readingFAD = true;
                            readingLAD = false;
                            readingSINGLEEVENT = false;
                        } else if (buff.trim().equals("LAD")) {
                            readingLAD = true;
                            readingFAD = false;
                            readingSINGLEEVENT = false;
                        } else if (buff.trim().equals("EVENT")) {
                            readingSINGLEEVENT = true;
                            readingLAD = false;
                            readingFAD = false;
                        } else {
                            readingRecord = RECORDTYPE.NONE;
                        }
                    } else if (readingRecord == RECORDTYPE.CHRON) {
                        Chron.Builder chronBuilder = new Chron.Builder(ws);
                        chronBuilder.name(this.stripQuotes(buff));
                        chronSeries = chronBuilder.getName();
                    } else {
                        readingRecord = RECORDTYPE.NONE;
                    }
                } else if (readingRecord == RECORDTYPE.EVENTS && readingFAD) {
                    this.parseEvent(buff, tscEvent.FAD);
                } else if (readingRecord == RECORDTYPE.EVENTS && readingLAD) {
                    this.parseEvent(buff, tscEvent.LAD);
                } else if (readingRecord == RECORDTYPE.EVENTS && readingSINGLEEVENT) {
                    this.parseEvent(buff, tscEvent.EVENT);
                } else if (readingRecord == RECORDTYPE.BLOCK) {
                    this.parseBlockEntry(buff, tscBlock);
                } else if (readingRecord == RECORDTYPE.SEQUENCE) {
                    precedingSurfaceName = this.parseSurface(buff, tscSequence, precedingSurfaceName);
                } else if (readingRecord == RECORDTYPE.POINT) {
                    this.parsePoint(buff, tscCurve);
                } else if (readingRecord == RECORDTYPE.CHRON) {
                    this.parseChronEntry(buff, tscChronBlock, chronSeries);
                }
            }
            buff = in.readLine();
        }
        in.close();
    }

    private void parseEvent(String buff, List list) throws SBException {
        String[] toks = buff.split("\t", -1);
        if (toks.length < 3) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        System.out.println("Parsing: " + buff);
        int nTok = 1;
        String name = toks[nTok++];
        name = this.stripQuotes(name);
        double age = 0.0;
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            age = Double.parseDouble(toks[nTok]);
        }
        String comment = null;
        if (toks.length > 4) {
            ++nTok;
            if (toks[++nTok] != null && toks[nTok].length() > 0) {
                comment = this.stripQuotes(toks[nTok]);
            }
        }
        String[] names = name.split("[,;]");
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null || names[i].trim().length() <= 0) continue;
            TSCEvent event = new TSCEvent();
            event.name = names[i].trim();
            event.age = age;
            if (comment != null) {
                event.comment = comment;
            }
            list.add(event);
        }
    }

    private void parseBlockEntry(String buff, TSCBlock tscBlock) throws SBException {
        String[] rgb;
        String colour;
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        System.out.println("Parsing block entry: " + buff);
        TSCBlockEntry entry = new TSCBlockEntry();
        int nTok = 1;
        String name = toks[nTok++];
        entry.name = this.stripQuotes(name);
        if (entry.name == null || entry.name.length() == 0) {
            System.out.println("Skipping null entry in parseBlockEntry");
        }
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            entry.age = Double.parseDouble(toks[nTok]);
        }
        if (toks.length > ++nTok) {
            String lineStyle;
            if ((lineStyle = toks[nTok++]).equalsIgnoreCase("Dotted")) {
                entry.conf = AgeConfidence.POSSIBLE;
            } else if (lineStyle.equalsIgnoreCase("Dashed")) {
                entry.conf = AgeConfidence.PROBABLE;
            }
        }
        if (toks.length > nTok) {
            entry.comment = toks[nTok++];
        }
        if (toks.length > nTok && (colour = toks[nTok++]) != null && colour.length() > 0 && colour.contains("/") && (rgb = colour.trim().split("/")).length == 3) {
            entry.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        tscBlock.entry.add(entry);
    }

    private void parseChronEntry(String buff, TSCChronBlock tscBlock, String series) throws SBException {
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        System.out.println("Parsing chron entry: " + buff);
        TSCChronEntry entry = new TSCChronEntry();
        int nTok = 1;
        String polarityString = toks[nTok++];
        if (!polarityString.equalsIgnoreCase("TOP")) {
            entry.polarity = polarityString.charAt(0);
            String primary = toks[nTok++];
            entry.primary = this.stripQuotes(primary);
        } else {
            entry.name = "TOP";
            ++nTok;
        }
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            entry.age = Double.parseDouble(toks[nTok++]);
        }
        if (nTok < toks.length) {
            String name = toks[nTok++];
            entry.name = this.stripQuotes(name);
        }
        entry.series = series;
        tscBlock.entries.add(entry);
    }

    private String parseSurface(String buff, TSCSequence tscSequence, String precedingName) throws SBException {
        String[] rgb;
        String colour;
        String[] toks = buff.split("\t", -1);
        if (toks.length < 2) {
            System.out.println("Cannot tokenize: " + buff);
            return null;
        }
        TSCSurface surface = new TSCSurface();
        int nTok = 1;
        String name = toks[nTok++];
        surface.name = this.stripQuotes(name);
        System.out.println("parsing: " + buff + ", nTok=" + toks.length);
        if (toks[nTok] != null && toks[nTok].length() > 0) {
            surface.type = toks[nTok];
        }
        if (toks[++nTok] != null && toks[nTok].length() > 0) {
            surface.age = Double.parseDouble(toks[nTok]);
        }
        if (toks[++nTok] != null && toks[nTok].length() > 0) {
            surface.magnitude = toks[nTok];
        }
        if (toks.length > ++nTok) {
            surface.comment = toks[nTok++];
        }
        if (toks.length > nTok && (colour = toks[nTok++]) != null && colour.length() > 0 && colour.contains("/") && (rgb = colour.split("/")).length == 3) {
            surface.colour = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        if (surface.name == null || surface.name.length() == 0) {
            surface.name = precedingName != null ? precedingName : "Surface @ " + surface.age;
        }
        tscSequence.entry.add(surface);
        return surface.name;
    }

    private void parsePoint(String buff, TSCCurve tscCurve) throws SBException {
        String[] toks = buff.split("\t", -1);
        if (toks.length < 3) {
            System.out.println("Cannot tokenize: " + buff);
            return;
        }
        try {
            TSCPoint point = new TSCPoint();
            int nTok = 1;
            if (toks[nTok] != null && toks[nTok].length() > 0) {
                point.age = Double.parseDouble(toks[nTok]);
            }
            if (toks[++nTok] != null && toks[nTok].length() > 0) {
                point.value = Double.parseDouble(toks[nTok]);
            }
            if (toks.length > nTok) {
                point.comment = toks[nTok++];
            }
            tscCurve.points.add(point);
        }
        catch (NumberFormatException ne) {
            System.out.println("Error parsing point in line: " + buff);
        }
    }

    private static enum RECORDTYPE {
        NONE,
        EVENTS,
        BLOCK,
        SEQUENCE,
        POINT,
        CHRON;

    }

    public static class TSCScheme {
        String name;
        boolean hasColumns = false;
        List<String> columnNames = new LinkedList<String>();
        List<TSCColumn> columns = new LinkedList<TSCColumn>();
        int blockCount = -1;
        int sequenceCount = -1;
        private int igdType = 0;

        public String toString() {
            return this.name + " : " + this.columnNames;
        }

        public List<TSCEventList> getEventLists() {
            for (TSCColumn column : this.columns) {
                System.out.println("Column: " + column.name + " : " + (column instanceof TSCBlock ? "block" : "events"));
            }
            LinkedList<TSCEventList> list = new LinkedList<TSCEventList>();
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCEventList)) continue;
                list.add((TSCEventList)column);
            }
            return list;
        }

        public IGDScheme getScheme(SBdb ws) throws SBException, SQLException, InvalidFieldException {
            if (this.igdType == 0) {
                throw new SBException("No IGD type st for selected scheme");
            }
            IGDScheme scheme = ws.addIGDScheme(this.igdType, this.name);
            scheme.loadUnits();
            for (TSCColumn column : this.columns) {
                TSCBlockBase block;
                if (column instanceof TSCBlock) {
                    block = (TSCBlock)column;
                    if (((TSCBlock)block).hier <= 0) continue;
                    double topAge = 0.0;
                    AgeConfidence topConf = AgeConfidence.CONFIDENT;
                    for (TSCBlockEntry entry : ((TSCBlock)block).entry) {
                        block45: {
                            if (entry.name.equals("TOP")) {
                                topAge = entry.age;
                                continue;
                            }
                            Object entryName = entry.name.trim();
                            if (entryName == null || ((String)entryName).length() == 0) {
                                topAge = entry.age;
                                topConf = entry.conf;
                                continue;
                            }
                            IGDUnit unit = scheme.findUnit((String)entryName);
                            if (unit != null) {
                                IGDUnit higher = scheme.findUnit(topAge, entry.age, block.getHier() - 1);
                                if (higher == null) {
                                    entryName = this.makeUniqueName(scheme, (String)entryName, topAge, entry);
                                } else {
                                    switch (entry.name.toLowerCase()) {
                                        case "lt": 
                                        case "lt.": {
                                            entry.name = "Late";
                                            break;
                                        }
                                        case "m": {
                                            entry.name = "Middle";
                                            break;
                                        }
                                        case "e": {
                                            entry.name = "Early";
                                        }
                                    }
                                    entryName = entry.name + " " + higher.getName();
                                }
                                unit = scheme.findUnit((String)entryName);
                                if (unit != null) {
                                    System.out.println("Duplicate unit name found for: " + unit.getName());
                                    topAge = entry.age;
                                    topConf = entry.conf;
                                    continue;
                                }
                            }
                            System.out.println("Inserting unit: " + (String)entryName);
                            try {
                                if (scheme.getIGDType() == 2) {
                                    double[] age = new double[4];
                                    age[0] = age[1] = topAge;
                                    age[2] = age[3] = entry.age;
                                    scheme.addUnit(new LithostratUnit.Builder(ws).colour(((TSCBlock)block).colour).colour(entry.colour).age(age).hier(block.getHier()).name((String)entryName));
                                } else {
                                    IGDUnitBase.Builder unitBuilder = new IGDUnit.Builder(ws).colour(((TSCBlock)block).colour).colour(entry.colour).age(topAge, entry.age).hier(block.getHier()).name((String)entryName);
                                    ((IGDUnit.Builder)unitBuilder).getigdAge(true).setConfidence(topConf);
                                    ((IGDUnit.Builder)unitBuilder).getigdAge(false).setConfidence(entry.conf);
                                    ((IGDUnit.Builder)unitBuilder).comments(entry.comment);
                                    scheme.addUnit(unitBuilder);
                                }
                            }
                            catch (IllegalStateException | InvalidFieldException ils) {
                                if (JOptionPane.showConfirmDialog(null, ils.toString() + "\nIgnore unit and continue reading?", "Error adding unit to scheme", 0, 2) != 1) break block45;
                                throw new SBException("Reading cancelled");
                            }
                        }
                        topAge = entry.age;
                        topConf = entry.conf;
                    }
                    continue;
                }
                if (column instanceof TSCChronBlock) {
                    block = (TSCChronBlock)column;
                    if (((TSCChronBlock)block).hier < 1) continue;
                    double topAge = 0.0;
                    IGDUnitBase.Builder seriesBuilder = null;
                    IGDUnitBase.Builder chronBuilder = null;
                    for (TSCChronEntry entry : ((TSCChronBlock)block).entries) {
                        Chron.Polarity polarity;
                        if (entry.name == null || entry.name.equals("TOP")) {
                            if (topAge != 0.0) continue;
                            topAge = entry.age;
                            continue;
                        }
                        if (!entry.series.isEmpty()) {
                            if (seriesBuilder == null) {
                                seriesBuilder = (Chron.Builder)new Chron.Builder(ws).uAge(topAge).lAge(entry.age).name(entry.series).hier(1);
                            } else if (seriesBuilder.getName().equals(entry.series)) {
                                ((Chron.Builder)seriesBuilder).lAge(entry.age);
                            } else {
                                scheme.addUnit(seriesBuilder);
                                seriesBuilder = (Chron.Builder)new Chron.Builder(ws).uAge(topAge).lAge(entry.age).name(entry.series).hier(1);
                            }
                        }
                        if (!entry.primary.isEmpty()) {
                            if (chronBuilder == null) {
                                chronBuilder = (Chron.Builder)new Chron.Builder(ws).uAge(topAge).lAge(entry.age).name(entry.primary).hier(2);
                            } else if (chronBuilder.getName().equals(entry.primary)) {
                                ((Chron.Builder)chronBuilder).lAge(entry.age);
                            } else {
                                if (!chronBuilder.getName().equalsIgnoreCase("No Data")) {
                                    System.out.println("Adding: " + chronBuilder.getName() + "," + ((Chron.Builder)chronBuilder).getLage());
                                    scheme.addUnit(chronBuilder);
                                }
                                chronBuilder = (Chron.Builder)new Chron.Builder(ws).uAge(topAge).lAge(entry.age).name(entry.primary).hier(2);
                            }
                        } else {
                            chronBuilder = null;
                        }
                        try {
                            polarity = Chron.Polarity.parse(entry.polarity);
                        }
                        catch (Exception e) {
                            polarity = Chron.Polarity.NORMAL;
                        }
                        if (!entry.name.equalsIgnoreCase("No Data")) {
                            Chron.Builder sChronBuilder = new Chron.Builder(ws).polarity(polarity);
                            sChronBuilder.uAge(topAge).lAge(entry.age).hier(3).name(entry.name);
                            scheme.addUnit(sChronBuilder);
                        }
                        topAge = entry.age;
                    }
                    continue;
                }
                if (!(column instanceof TSCSequence)) continue;
                TSCSequence sequence = (TSCSequence)column;
                for (TSCSurface surface : sequence.entry) {
                    Surface.Builder b = new Surface.Builder(ws).name(surface.name).age(surface.age).type(Surface.SurfaceType.parseType(surface.name, Surface.SurfaceType.SB));
                    if (!surface.name.contains(surface.type)) {
                        b.name(surface.name + " " + surface.type);
                    }
                    scheme.addSurface(b);
                }
            }
            return scheme;
        }

        String makeUniqueName(IGDScheme scheme, String entryName, double topAge, TSCBlockEntry entry) throws SQLException {
            IGDUnit unit;
            System.out.println("Duplicate unit name, and no higher level entry found at: " + (String)entryName + " ages(s): " + topAge + " & " + entry.age);
            int uniqueNo = 1;
            while ((unit = scheme.findUnit((String)entryName)) != null && uniqueNo < 100) {
                entryName = entry.name + " (" + uniqueNo++ + ")";
            }
            return entryName;
        }

        public int getBlockCount() {
            if (this.blockCount < 0) {
                this.blockCount = this.initBlockCount();
            }
            return this.blockCount;
        }

        public int getSequenceCount() {
            if (this.sequenceCount < 0) {
                this.sequenceCount = this.initSequenceCount();
            }
            return this.sequenceCount;
        }

        public TSCBlockBase getBlock(int row) {
            int index = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCBlockBase)) continue;
                if (row == index) {
                    return (TSCBlockBase)column;
                }
                ++index;
            }
            return null;
        }

        private int initBlockCount() {
            int count = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCBlockBase)) continue;
                ++count;
            }
            return count;
        }

        private int initSequenceCount() {
            int count = 0;
            for (TSCColumn column : this.columns) {
                if (!(column instanceof TSCSequence)) continue;
                ++count;
            }
            return count;
        }

        public void setIGDType(int igdType) {
            this.igdType = igdType;
        }
    }

    public class TSCEventList
    extends TSCColumn {
        private String author;
        List<TSCEvent> FAD = new LinkedList<TSCEvent>();
        List<TSCEvent> LAD = new LinkedList<TSCEvent>();
        List<TSCEvent> EVENT = new LinkedList<TSCEvent>();

        public String toString() {
            return this.getName() + (String)(this.getAuthor() != null && this.getAuthor().trim().length() > 0 ? " - " + this.getAuthor() : "");
        }

        public boolean needsFilter() {
            for (TSCEvent tscEvent : this.FAD) {
                if (!tscEvent.needsFilter()) continue;
                return true;
            }
            for (TSCEvent tscEvent : this.LAD) {
                if (!tscEvent.needsFilter()) continue;
                return true;
            }
            for (TSCEvent tscEvent : this.EVENT) {
                if (!tscEvent.needsFilter()) continue;
                return true;
            }
            return false;
        }

        public void filterNames() {
            System.out.println("Filtering names....");
            for (TSCEvent tscEvent : this.FAD) {
                tscEvent.filter();
            }
            for (TSCEvent tscEvent : this.LAD) {
                tscEvent.filter();
            }
            for (TSCEvent tscEvent : this.EVENT) {
                tscEvent.filter();
            }
        }

        public void removeBlankEvents() {
            TSCEvent tscEvent;
            Iterator<TSCEvent> it = this.FAD.iterator();
            while (it.hasNext()) {
                tscEvent = it.next();
                if (tscEvent.name != null && !tscEvent.name.isEmpty()) continue;
                it.remove();
            }
            it = this.LAD.iterator();
            while (it.hasNext()) {
                tscEvent = it.next();
                if (tscEvent.name != null && !tscEvent.name.isEmpty()) continue;
                it.remove();
            }
            it = this.EVENT.iterator();
            while (it.hasNext()) {
                tscEvent = it.next();
                if (tscEvent.name != null && !tscEvent.name.isEmpty()) continue;
                it.remove();
            }
        }

        public void getEvents(SBdb ws) throws SQLException, SBException {
            try {
                for (TSCEvent tscEvent : this.FAD) {
                    if (tscEvent.wsEvent != null || (tscEvent.wsEvent = ws.getSBEvent(tscEvent.name)) != null) continue;
                    tscEvent.wsEvent = ws.addSBEvent(new SBEvent.Builder().name(tscEvent.name).isGenerate(true));
                }
                for (TSCEvent tscEvent : this.LAD) {
                    if (tscEvent.wsEvent != null || (tscEvent.wsEvent = ws.getSBEvent(tscEvent.name)) != null) continue;
                    tscEvent.wsEvent = ws.addSBEvent(new SBEvent.Builder().name(tscEvent.name).isGenerate(true));
                }
                for (TSCEvent tscEvent : this.EVENT) {
                    if (tscEvent.wsEvent != null || (tscEvent.wsEvent = ws.getSBEvent(tscEvent.name)) != null) continue;
                    tscEvent.wsEvent = ws.addSBEvent(new SBEvent.Builder().name(tscEvent.name).isGenerate(true).isSingle(true));
                }
            }
            catch (SBPermissionException pe) {
                throw new SBException(pe.getMessage());
            }
        }

        public CompositeStandard getCompositeStandard(List<SBException> exceptions) throws SBException, SQLException {
            CompositeStandardEvent.Builder builder;
            SBEvent dbEvent;
            LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
            Double minAge = null;
            Double maxAge = null;
            for (TSCEvent tscEvent : this.FAD) {
                if (tscEvent.wsEvent == null || (dbEvent = tscEvent.wsEvent.getLink()) == null) continue;
                builder = new CompositeStandardEvent.Builder().event(tscEvent.wsEvent).csu(tscEvent.age);
                if (!tscEvent.wsEvent.isSingle()) {
                    builder.type(SBEvent.EventType.BASE);
                }
                builders.add(builder);
                if (minAge == null || tscEvent.age < minAge) {
                    minAge = tscEvent.age;
                }
                if (maxAge == null || tscEvent.age > maxAge) {
                    maxAge = tscEvent.age;
                }
                if (tscEvent.comment == null) continue;
                builder.comment(tscEvent.comment);
            }
            for (TSCEvent tscEvent : this.LAD) {
                if (tscEvent.wsEvent == null || (dbEvent = tscEvent.wsEvent.getLink()) == null) continue;
                builder = new CompositeStandardEvent.Builder().event(tscEvent.wsEvent).csu(tscEvent.age);
                if (!tscEvent.wsEvent.isSingle()) {
                    builder.type(SBEvent.EventType.TOP);
                }
                builders.add(builder);
                if (minAge == null || tscEvent.age < minAge) {
                    minAge = tscEvent.age;
                }
                if (maxAge == null || tscEvent.age > maxAge) {
                    maxAge = tscEvent.age;
                }
                if (tscEvent.comment == null) continue;
                builder.comment(tscEvent.comment);
            }
            for (TSCEvent tscEvent : this.EVENT) {
                if (tscEvent.wsEvent == null || (dbEvent = tscEvent.wsEvent.getLink()) == null) continue;
                builder = new CompositeStandardEvent.Builder().event(tscEvent.wsEvent).csu(tscEvent.age).type(SBEvent.EventType.SINGLE);
                if (!tscEvent.wsEvent.isSingle()) {
                    builder.type(SBEvent.EventType.TOP);
                }
                builders.add(builder);
                if (minAge == null || tscEvent.age < minAge) {
                    minAge = tscEvent.age;
                }
                if (maxAge == null || tscEvent.age > maxAge) {
                    maxAge = tscEvent.age;
                }
                if (tscEvent.comment == null) continue;
                builder.comment(tscEvent.comment);
            }
            if (minAge == null) {
                minAge = 0.0;
            }
            if (maxAge == null) {
                maxAge = 0.0;
            }
            try {
                return TSCreatorReader.this.ws.addCompositeStandard(this.name, minAge, maxAge, maxAge, maxAge, true, builders, null, 0);
            }
            catch (InvalidFieldException | SBPermissionException e) {
                exceptions.add(new SBException(e.getMessage()));
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }
    }

    public static class TSCBlock
    extends TSCBlockBase {
        String author;
        Color colour;
        List<TSCBlockEntry> entry = new LinkedList<TSCBlockEntry>();
    }

    public static class TSCChronBlock
    extends TSCBlockBase {
        List<TSCChronEntry> entries = new LinkedList<TSCChronEntry>();
    }

    public static class TSCCurve {
        String name;
        Color colour;
        float width;
        String title;
        List<TSCPoint> points = new LinkedList<TSCPoint>();

        public String toString() {
            return this.name;
        }

        public List<TSCPoint> getPoints() {
            return this.points;
        }
    }

    public static class TSCSequence
    extends TSCColumn {
        String author;
        Color colour;
        String title;
        List<TSCSurface> entry = new LinkedList<TSCSurface>();

        public String toString() {
            return this.name;
        }
    }

    public static class TSCEvent {
        String name;
        double age;
        SBEvent wsEvent;
        String comment;

        public String toString() {
            return this.name + " - " + this.age;
        }

        private boolean needsFilter() {
            if (this.name.contains("[") && this.name.contains("]")) {
                return true;
            }
            int index = this.name.indexOf("*");
            return index > 0 && index < this.name.length() && this.name.substring(index + 1).contains("*");
        }

        private void filter() {
            int index = this.name.indexOf("[");
            if (index >= 0 && this.name.substring(index + 1).contains("]")) {
                this.name = this.name.substring(0, index) + this.name.substring(this.name.indexOf(93) + 1);
            }
            if ((index = this.name.indexOf("*")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
            if ((index = this.name.indexOf("*")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
            if ((index = this.name.indexOf("#")) > 0) {
                this.name = this.name.substring(0, index) + this.name.substring(index + 1);
            }
        }
    }

    private static class TSCBlockEntry {
        String name;
        double age;
        String comment;
        Color colour;
        AgeConfidence conf = AgeConfidence.CONFIDENT;

        private TSCBlockEntry() {
        }

        public String toString() {
            return this.name + " - " + this.age;
        }
    }

    private static class TSCChronEntry {
        String series;
        char polarity;
        String primary = "";
        String name;
        double age;

        private TSCChronEntry() {
        }
    }

    private static class TSCSurface {
        String name;
        String type;
        String magnitude;
        double age;
        String comment;
        Color colour;

        private TSCSurface() {
        }

        public String toString() {
            return this.name + " - " + this.age;
        }
    }

    public class TSCPoint {
        double age;
        double value;
        String comment;
    }

    public static class TSCBlockBase
    extends TSCColumn {
        String title;
        int hier = 0;

        public int getHier() {
            return this.hier;
        }

        public void setHier(int i) {
            this.hier = i;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class TSCColumn {
        String name;
        float width;
    }
}

