/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.util.Objects;
import org.jdom2.Element;
import util.DepthUtils;
import util.SBException;

public class TVDepth {
    private double dDepth;
    private Double TVDepth;
    private Float inclination;
    private Float azimuth;
    private Double verticalSection;
    private Double north;
    private Double east;

    public TVDepth(double dDepth, double TVDepth2) {
        this.dDepth = dDepth;
        this.TVDepth = TVDepth2;
    }

    public TVDepth(double dDepth, Double TVDepth2, Float inclination, Float azimuth, Double verticalSection, Double north, Double east) throws SBException {
        this.dDepth = dDepth;
        this.TVDepth = TVDepth2;
        this.inclination = inclination;
        this.azimuth = azimuth;
        this.verticalSection = verticalSection;
        this.north = north;
        this.east = east;
        if (TVDepth2 > dDepth) {
            throw new SBException("TVD depth (" + TVDepth2 + ") is greater than drilled depth (" + dDepth + ")");
        }
    }

    TVDepth(TVDepth rhs) {
        this.dDepth = rhs.dDepth;
        this.TVDepth = rhs.TVDepth;
        this.inclination = rhs.inclination;
        this.azimuth = rhs.azimuth;
        this.verticalSection = rhs.verticalSection;
        this.north = rhs.north;
        this.east = rhs.east;
    }

    TVDepth(Element xml) throws SBException {
        String string = xml.getChildTextNormalize("DrilledDepth");
        if (string != null) {
            this.dDepth = DepthUtils.parseDepthString((String)string);
        }
        if ((string = xml.getChildTextNormalize("TVDepth")) != null) {
            this.TVDepth = DepthUtils.parseDepthString((String)string);
        }
        if ((string = xml.getChildTextNormalize("VerticalSection")) != null) {
            this.verticalSection = DepthUtils.parseDepthString((String)string);
        }
        if ((string = xml.getChildTextNormalize("North")) != null) {
            this.north = DepthUtils.parseDepthString((String)string);
        }
        if ((string = xml.getChildTextNormalize("East")) != null) {
            this.east = DepthUtils.parseDepthString((String)string);
        }
        if ((string = xml.getChildTextNormalize("Inclination")) != null) {
            this.inclination = Float.valueOf(Float.parseFloat(string));
        }
        if ((string = xml.getChildTextNormalize("Azimuth")) != null) {
            this.azimuth = Float.valueOf(Float.parseFloat(string));
        }
    }

    public boolean equals(TVDepth rhs) {
        if (this.TVDepth != null && rhs.TVDepth == null || this.TVDepth == null && rhs.TVDepth != null) {
            return false;
        }
        if (Math.abs(this.TVDepth - rhs.TVDepth) > (double)0.0029f) {
            return false;
        }
        if (this.verticalSection != null && rhs.verticalSection != null && Math.abs(this.verticalSection - rhs.verticalSection) > (double)0.0029f) {
            return false;
        }
        if (this.verticalSection != null && rhs.verticalSection == null || this.verticalSection == null && rhs.verticalSection != null) {
            return false;
        }
        if (this.north != null && rhs.north != null && Math.abs(this.north - rhs.north) > (double)0.0029f) {
            return false;
        }
        if (this.north != null && rhs.north == null || this.north == null && rhs.north != null) {
            return false;
        }
        if (this.east != null && rhs.east != null && Math.abs(this.east - rhs.east) > (double)0.0029f) {
            return false;
        }
        if (this.east != null && rhs.east == null || this.east == null && rhs.east != null) {
            return false;
        }
        if (this.inclination != null && rhs.inclination != null && Math.abs(this.inclination.floatValue() - rhs.inclination.floatValue()) > 0.0029f) {
            return false;
        }
        if (this.inclination != null && rhs.inclination == null || this.inclination == null && rhs.inclination != null) {
            return false;
        }
        if (this.azimuth != null && rhs.azimuth != null && Math.abs(this.azimuth.floatValue() - rhs.azimuth.floatValue()) > 0.0029f) {
            return false;
        }
        return (this.azimuth == null || rhs.azimuth != null) && (this.azimuth != null || rhs.azimuth == null);
    }

    public double getDDepth() {
        return this.dDepth;
    }

    public Double getTVDepth() {
        return this.TVDepth;
    }

    public Double getVS() {
        return this.verticalSection;
    }

    public Float getInclination() {
        return this.inclination;
    }

    public Float getAzumith() {
        return this.azimuth;
    }

    public Double getNorth() {
        return this.north;
    }

    public Double getEast() {
        return this.east;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TVDepth other = (TVDepth)obj;
        return this.equals(other);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.dDepth) ^ Double.doubleToLongBits(this.dDepth) >>> 32);
        hash = 79 * hash + Objects.hashCode(this.TVDepth);
        hash = 79 * hash + Objects.hashCode(this.inclination);
        hash = 79 * hash + Objects.hashCode(this.azimuth);
        hash = 79 * hash + Objects.hashCode(this.verticalSection);
        hash = 79 * hash + Objects.hashCode(this.north);
        hash = 79 * hash + Objects.hashCode(this.east);
        return hash;
    }
}

