/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import model2_1.SBdb;
import model2_1.TWTDepth;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.status.SbugsStatus;

public class TWTList
extends Observable
implements SbugsStatus {
    SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;
    private List<TWTDepth> list = new LinkedList<TWTDepth>();
    Color status = UNKNOWN;

    public TWTList(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.list.size();
    }

    public List<TWTDepth> getList() {
        return this.list;
    }

    public TWTDepth get(int row) {
        return this.list.get(row);
    }

    public double getBaseDD() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        return this.list.get(this.list.size() - 1).getDepth();
    }

    public double getTopDD() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        return this.list.get(0).getDepth();
    }

    public double getTopTWT() {
        Iterator<TWTDepth> it = this.list.iterator();
        if (this.list.isEmpty()) {
            return 0.0;
        }
        double toptwt = this.list.get(0).getTWT();
        while (it.hasNext()) {
            double twt = it.next().getTWT();
            if (!(twt < toptwt)) continue;
            toptwt = twt;
        }
        return toptwt;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        Object string = "(No data)";
        if (!this.list.isEmpty()) {
            String topdepth = util.SB.getDepthString((double)this.list.get(0).getDepth(), (char)'M', (int)2);
            String basedepth = util.SB.getDepthString((double)this.list.get(this.list.size() - 1).getDepth(), (char)'M', (int)2);
            string = topdepth + " - " + basedepth;
        }
        return string;
    }

    public double getBaseTWT() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        Iterator<TWTDepth> it = this.list.iterator();
        double basetwt = 0.0;
        while (it.hasNext()) {
            double twt = it.next().getTWT();
            if (!(twt > basetwt)) continue;
            basetwt = twt;
        }
        return basetwt;
    }

    public TWTDepth getMaxTWT(double dDepth) {
        TWTDepth newTWTDepth = null;
        try {
            if (this.list.size() < 2) {
                return new TWTDepth(dDepth, this.list.size() == 1 ? this.list.get(0).getTWT() : dDepth);
            }
            ListIterator<TWTDepth> it = this.list.listIterator();
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                if (!(twt.getDepth() <= dDepth) || newTWTDepth != null && !(twt.getDepth() > newTWTDepth.getDepth())) continue;
                newTWTDepth = twt;
            }
            if (newTWTDepth == null) {
                return this.getTWT(dDepth);
            }
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        return newTWTDepth;
    }

    public TWTDepth getTWT(double dDepth) {
        TWTDepth newTWTDepth = null;
        try {
            if (this.list.size() < 2) {
                return new TWTDepth(dDepth, this.list.size() == 1 ? this.list.get(0).getTWT() : dDepth * 1000.0);
            }
            double d1 = 0.0;
            double d2 = 0.0;
            double twt1 = 0.0;
            double twt2 = 0.0;
            double vs1 = 0.0;
            double vs2 = 0.0;
            ListIterator<TWTDepth> it = this.list.listIterator();
            while (it.hasNext()) {
                boolean first = !it.hasPrevious();
                TWTDepth twt = it.next();
                if (first && dDepth < twt.getDepth() - 0.001) {
                    return new TWTDepth(dDepth, twt.getTWT());
                }
                if (Math.abs(twt.getDepth() - dDepth) < 0.001) {
                    return twt;
                }
                if (dDepth > d1 && dDepth < twt.getDepth()) {
                    d2 = twt.getDepth();
                    twt2 = twt.getTWT();
                    break;
                }
                if (!it.hasNext()) {
                    d2 = twt.getDepth();
                    twt2 = twt.getTWT();
                    break;
                }
                d1 = twt.getDepth();
                twt1 = twt.getTWT();
            }
            double sa = dDepth - d1;
            newTWTDepth = new TWTDepth(dDepth, sa * (twt2 - twt1) / (d2 - d1) + twt1);
            return newTWTDepth;
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
            return newTWTDepth;
        }
    }

    public float[] getTWTlimits(double fromDepth, double toDepth, boolean limitToSurveyRange) {
        if (this.list.isEmpty()) {
            return new float[]{0.0f, 0.0f};
        }
        float[] limits = new float[2];
        if (limitToSurveyRange) {
            limits[0] = 99999.0f;
            limits[1] = 0.0f;
        } else {
            TWTDepth d1 = this.getTWT(fromDepth);
            TWTDepth d2 = this.getTWT(toDepth);
            limits[0] = (float)Math.min(d1.getTWT(), d2.getTWT());
            limits[1] = (float)Math.max(d1.getTWT(), d2.getTWT());
        }
        for (TWTDepth node : this.list) {
            if (node.getDepth() < fromDepth) continue;
            if (node.getDepth() > toDepth) break;
            if (node.getTWT() < (double)limits[0]) {
                limits[0] = (float)node.getTWT();
            }
            if (!(node.getTWT() > (double)limits[1])) continue;
            limits[1] = (float)node.getTWT();
        }
        return limits;
    }

    public TWTDepth[] getDepths(double twt) {
        if (this.list.size() < 2) {
            return null;
        }
        ListIterator<TWTDepth> it = this.list.listIterator();
        TWTDepth last = null;
        ArrayList<TWTDepth> depths = new ArrayList<TWTDepth>();
        while (it.hasNext()) {
            TWTDepth twtdepth = it.next();
            if (Math.abs(twtdepth.getTWT() - twt) < 0.001) {
                return new TWTDepth[]{twtdepth};
            }
            if (last != null && twt > Math.min(twtdepth.getTWT(), last.getTWT()) && twt <= Math.max(twtdepth.getTWT(), last.getTWT())) {
                try {
                    double twt1 = twtdepth.getTWT();
                    double twt2 = last.getTWT();
                    double d1 = twtdepth.getDepth();
                    double d2 = last.getDepth();
                    double newDD = d1 + (twt - twt1) * ((d2 - d1) / (twt2 - twt1));
                    depths.add(new TWTDepth(newDD, twt));
                }
                catch (SBException e) {
                    StackError.showStackError((String)"Error", (Exception)((Object)e));
                }
            }
            last = twtdepth;
        }
        return depths.toArray(new TWTDepth[depths.size()]);
    }

    public void add(TWTDepth twt, int wellID) throws SBException, SQLException {
        if (this.add(twt)) {
            this.store(wellID, twt);
        }
    }

    public boolean add(TWTDepth twt) throws SBException {
        Iterator<TWTDepth> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(twt.getDepth() * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            TWTDepth compareWith = it.next();
            if (compareWith != twt) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            this.list.add(insertPoint, twt);
            this.isDirty = true;
        }
        return true;
    }

    public void load(int wellID) throws SQLException {
        if (!this.isLoaded) {
            this.clear();
            String sql = "SELECT ddepth, TWT FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_id=" + wellID;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double dDepth = rs.getDouble("ddepth");
                    double TWTDepth2 = rs.getDouble("TWT");
                    TWTDepth twt = new TWTDepth(dDepth, TWTDepth2);
                    this.add(twt);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        this.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(int wellID, TWTDepth tvd) throws SQLException {
        String sql = "INSERT INTO " + this.SB.DBTableName("WELLTWT") + "(well_id,ddepth,twt) VALUES (" + wellID;
        sql = sql + ",?,?)";
        PreparedStatement pstmt = this.SB.getDatabase().prepareStatement(sql);
        pstmt.setDouble(1, tvd.getDepth());
        pstmt.setDouble(2, tvd.getTWT());
        try {
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            Iterator<TWTDepth> it = this.list.iterator();
            this.deleteAll(wellID);
            it = this.list.iterator();
            Statement stmt = this.SB.getDatabase().createStatement();
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                String sql = "INSERT INTO " + this.SB.DBTableName("WELLTWT") + "(well_id,ddepth,twt) VALUES (" + wellID + "," + twt.getDepth() + "," + twt.getTWT() + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.list.size() > 0) {
            Iterator<TWTDepth> it = this.list.iterator();
            out.write("[TWT]" + eol);
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                out.write("Depth/TWT = " + util.SB.getDepthString((double)twt.getDepth(), (char)units, (int)2).trim() + " : " + util.SB.floatString((double)twt.getTWT(), (int)2) + eol);
            }
            out.write(eol);
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        if (this.list.size() > 0) {
            Iterator<TWTDepth> it = this.list.iterator();
            out.write("<TWTList>\n");
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                String depth = util.SB.getDepthString((double)twt.getDepth(), (char)units, (int)2).trim();
                String twtString = util.SB.floatString((double)twt.getTWT(), (int)2);
                out.write((String)ind + "<TWTData>\n");
                if (depth != null && depth.length() > 0) {
                    out.write((String)ind + (String)ind + "<DrilledDepth>" + depth + "</DrilledDepth>\n");
                }
                if (twtString != null && twtString.length() > 0) {
                    out.write((String)ind + (String)ind + "<TWT>" + twtString + "</TWT>\n");
                }
                out.write((String)ind + "</TWTData>\n");
            }
            out.write("</TWTList>\n");
        }
    }
}

