/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import model2_1.AbnScheme;
import model2_1.Audit;
import model2_1.Category;
import model2_1.ImageSet;
import model2_1.SBImage;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Smpdtl;
import model2_1.TaxaMap;
import model2_1.Taxon;
import model2_1.Userdef;
import model2_1.Well;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SortEntry;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class TaxonOcc
extends SBObservable
implements SbugsStatus,
SortEntry {
    static final char OUTSIDECOUNT = '+';
    static final int COARSE_FIELD = 1;
    static final int MEDIUM_FIELD = 2;
    static final int FINE_FIELD = 3;
    static Boolean exportImages = null;
    private final SBdb sbdb;
    TaxonOcc link = null;
    Color status = UNKNOWN;
    private Taxon taxonRef;
    private boolean reworked = false;
    private char identType = (char)80;
    private int specType = 0;
    private ImageSet imageSet = null;
    private Audit audit = new Audit();
    private boolean caved;
    private String subjAbund = "";
    private int coarse;
    private int medium;
    private int fine;
    private boolean marker = false;
    private String preservation = "";
    private String colour = "";
    private String comment = "";
    public static LinkedList<Integer> SPECIESRECORD = new LinkedList();

    public int getSpecID() {
        return this.taxonRef.getSpecID();
    }

    public Taxon getTaxon() {
        return this.taxonRef;
    }

    public boolean getReworked() {
        return this.reworked;
    }

    public boolean isQualified() {
        return this.getReworked() || this.getQuestionable() || this.getCaved();
    }

    public char getIdentType() {
        return this.identType;
    }

    public boolean getQuestionable() {
        return this.identType == '?';
    }

    public boolean getCaved() {
        return this.caved;
    }

    public int getCoarse() {
        return this.coarse;
    }

    public int getMedium() {
        return this.medium;
    }

    public int getFine() {
        return this.fine;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public String getPreservation() {
        return this.preservation;
    }

    public String getColour() {
        return this.colour;
    }

    public String getComment() {
        return this.comment;
    }

    public int getSpecType() {
        return this.specType;
    }

    public String getSpecTypeString() throws SQLException {
        return this.sbdb.getSpecType(this.specType);
    }

    public int getDerivedCount(AbnScheme abn) {
        int total = this.getTotalCount();
        if (total == 0 && this.subjAbund.length() > 0 && abn != null) {
            total = abn.getCount(this.subjAbund);
        }
        return total;
    }

    public float getDerivedCount(AbnScheme abn, SizeFraction fraction, float splitFactor) {
        int count = fraction == null ? this.getDerivedCount(abn) : this.getFractionCount(fraction);
        if (count == 0 && fraction == SizeFraction.MEDIUM && this.subjAbund.length() > 0 && abn != null) {
            count = abn.getCount(this.subjAbund);
        }
        float count2 = count;
        if (splitFactor > 0.0029f) {
            count2 *= splitFactor;
        }
        return count2;
    }

    private int getFractionCount(SizeFraction fraction) {
        switch (fraction) {
            case COARSE: {
                return this.getCoarse();
            }
            case MEDIUM: {
                return this.getMedium();
            }
            case FINE: {
                return this.getFine();
            }
        }
        assert (false);
        return 0;
    }

    public double getDerivedCount(AbnScheme abn, float coarseFactor, float mediumFactor, float fineFactor) {
        double total = this.getTotalCount(coarseFactor, mediumFactor, fineFactor);
        if (total < 0.001 && this.subjAbund.length() > 0 && abn != null) {
            total = abn.getCount(this.subjAbund);
        }
        return total;
    }

    public int getTotalCount() {
        return this.coarse + this.medium + this.fine;
    }

    public double getTotalCount(float coarseFactor, float mediumFactor, float fineFactor) {
        double total = 0.0;
        total += (double)((coarseFactor > 0.0029f ? coarseFactor : 1.0f) * (float)this.coarse);
        total += (double)((mediumFactor > 0.0029f ? mediumFactor : 1.0f) * (float)this.medium);
        return total += (double)((fineFactor > 0.0029f ? fineFactor : 1.0f) * (float)this.fine);
    }

    public String getSubAbund(AbnScheme abn) {
        if (this.subjAbund.length() > 0) {
            return this.subjAbund;
        }
        if (this.getTotalCount() > 0 && abn != null) {
            return abn.getAbr(this.getTotalCount());
        }
        return "+";
    }

    public boolean isOutsideCount() {
        return this.subjAbund.length() == 0 && this.getTotalCount() == 0;
    }

    public boolean isCountingArtifact() {
        try {
            Category cat;
            String catMnem = this.taxonRef.getCatMnem();
            return this.sbdb != null && ((cat = this.sbdb.getCategory(catMnem)).getName().toUpperCase().contains("ABUNDANCE") || cat.getName().toUpperCase().contains("COUNT"));
        }
        catch (Exception ex) {
            System.out.println("Exception from getCategory: " + ex.getMessage());
            return false;
        }
    }

    public String getSubAbund() {
        return this.subjAbund;
    }

    public String getSubAbund(boolean useOutsideTheCount) {
        if (this.subjAbund.length() != 0 || !useOutsideTheCount) {
            return this.subjAbund;
        }
        if (this.getTotalCount() > 0) {
            return "";
        }
        return "+";
    }

    public String getSplitCountString() {
        if (this.getCoarse() == 0 && this.getFine() == 0) {
            return "" + this.getMedium();
        }
        return this.getCoarse() + "/" + this.getMedium() + "/" + this.getFine();
    }

    public String getAllQualifiers() {
        Object qualifierString = "";
        if (this.reworked) {
            qualifierString = (String)qualifierString + "Rw";
        }
        if (this.caved) {
            if (((String)qualifierString).length() > 0) {
                qualifierString = (String)qualifierString + " ";
            }
            qualifierString = (String)qualifierString + "Cv";
        }
        if (this.identType != 'P') {
            if (((String)qualifierString).length() > 0) {
                qualifierString = (String)qualifierString + " ";
            }
            qualifierString = (String)qualifierString + this.identType;
        }
        return qualifierString;
    }

    private static String getModifierConnectionExceptionString(String item) {
        return "Attempt to set TaxonOcc " + item + " when connected to database";
    }

    void setPreservation(String pres) throws SBException, SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException(TaxonOcc.getModifierConnectionExceptionString("preservation"));
        }
        this.preservation = pres;
    }

    void setColour(String colour) throws SBException, SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException(TaxonOcc.getModifierConnectionExceptionString("colour"));
        }
        this.colour = colour;
    }

    void setComment(String comment) throws SBException, SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException(TaxonOcc.getModifierConnectionExceptionString("comment"));
        }
        this.comment = comment;
    }

    void setCaved(boolean caved, boolean override) {
        if (!override && this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set fss caving type in connected database");
        }
        this.caved = caved;
    }

    void setIdentType(char identType, boolean override) {
        if (!override && this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set fss ident type in connected database");
        }
        this.identType = identType;
    }

    void setReworked(boolean reworked, boolean override) {
        if (!override && this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set fss reworking type in connected database");
        }
        this.reworked = reworked;
    }

    void setSpecType(int specTypeID) {
        this.specType = specTypeID;
    }

    void setSubjAbund(String abund) {
        this.subjAbund = abund == null ? "" : abund;
    }

    void setMedium(int count) {
        this.medium = count;
    }

    void setTaxon(Taxon taxon) {
        this.taxonRef = taxon;
    }

    public void setSubjAbund(String abr, boolean rw, boolean cv, boolean questionable) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException(TaxonOcc.getModifierConnectionExceptionString("subj abund"));
        }
        this.subjAbund = abr;
        if (rw) {
            this.reworked = true;
        }
        if (cv) {
            this.caved = true;
        }
        if (questionable) {
            this.identType = (char)63;
        }
    }

    public String toString() {
        Object s = "";
        if (this.taxonRef != null) {
            s = (String)s + this.taxonRef.toString();
        }
        return (String)s + this.toOccString();
    }

    public String toStringNoCat() {
        Object s = "";
        if (this.taxonRef != null) {
            s = (String)s + this.taxonRef.toString(true, false, false);
        }
        return (String)s + this.toOccString();
    }

    public String toAbnString() {
        String s = this.toOccString();
        return s.substring(2);
    }

    private String toOccString() {
        Object s = "";
        if (this.marker) {
            s = (String)s + ", Marker ";
        }
        if (this.reworked) {
            s = (String)s + ", Rw";
        }
        if (this.identType == '?') {
            s = (String)s + ", ?";
        }
        if (this.caved) {
            s = (String)s + ", Caved";
        }
        if (this.isOutsideCount()) {
            s = (String)s + ", +";
        } else {
            if (this.subjAbund != null && this.subjAbund.length() > 0) {
                s = (String)s + ", " + this.subjAbund;
            }
            if (this.coarse != 0 || this.fine != 0) {
                Object splitString = "";
                if (this.coarse > 0) {
                    splitString = (String)splitString + ", " + this.coarse + " coarse";
                }
                if (this.medium > 0) {
                    splitString = (String)splitString + (((String)splitString).isEmpty() ? ", " : " ") + this.medium + " medium";
                }
                if (this.fine > 0) {
                    splitString = (String)splitString + (((String)splitString).isEmpty() ? ", " : " ") + this.fine + " fine";
                }
                s = (String)s + (String)splitString;
            } else if (this.medium != 0) {
                s = (String)s + ", " + this.medium;
            }
        }
        if (this.specType > 0) {
            try {
                s = (String)s + ", " + this.sbdb.getSpecType(this.specType);
            }
            catch (SQLException sqle) {
                s = (String)s + ", type " + this.specType;
            }
        }
        return s;
    }

    public SBImage getImage() throws SQLException {
        if (this.imageSet != null) {
            return this.imageSet.getImage(0);
        }
        return null;
    }

    public void setDataChanged() {
        this.setChanged();
    }

    public boolean hasZipImage() throws SQLException {
        if (this.imageSet == null) {
            return false;
        }
        return !this.imageSet.getImage(0).getZipPath().isEmpty();
    }

    public boolean hasImageSet() throws SQLException {
        if (this.imageSet == null) {
            return false;
        }
        return this.imageSet.getSize() > 0;
    }

    public ImageSet getImageSet() throws SQLException {
        if (this.imageSet == null) {
            this.imageSet = new ImageSet(this.sbdb);
            if (this.sbdb != null && this.sbdb.isConnected()) {
                this.imageSet.load();
            }
        }
        return this.imageSet;
    }

    public void clearImageSet() {
        this.imageSet = null;
    }

    public ImageSet getImageSet(boolean load) throws SQLException {
        if (load) {
            return this.getImageSet();
        }
        return this.imageSet;
    }

    public void setImageSet(ImageSet set) throws SQLException, SBException {
        this.setImageSet(set, false);
    }

    public void setImageSet(ImageSet set, boolean overwrite) throws SQLException, SBException {
        if (!overwrite) {
            this.getImageSet();
        }
        if (set == null || this.imageSet.getID() != set.getID() || overwrite) {
            if (set != null && set.getID() == 0) {
                throw new SBException("Attempt to set unsaved image set in TaxonOcc.setImageSet");
            }
            this.imageSet = set;
        }
    }

    static TaxonOcc load(SBdb sbdb, int wellID, int sampID, int analyID, Taxon taxon, boolean reworked, char identType, int specType) throws SQLException, SBException {
        Builder builder = new Builder(sbdb, taxon, reworked, identType == '?', specType);
        String sql = "SELECT ident_type,status,spec_type_id,abund,coarse,medium,fine,caved,marker,preserv,colour,comments,image_set_id," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE ";
        sql = sql + " well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + taxon.getSpecID();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                String rowstatus;
                String rowident_type = rs.getString("ident_type");
                if (rowident_type == null || rowident_type.length() == 0) {
                    rowident_type = "P";
                }
                if ((rowstatus = rs.getString("status")) == null || rowstatus.length() == 0) {
                    rowstatus = "I";
                }
                int rowSpecType = rs.getInt("spec_type_id");
                if (!rowident_type.equals("" + identType) || !rowstatus.equals(reworked ? "R" : "I") || rowSpecType != specType) continue;
                builder.subjAbund(rs.getString("abund"));
                builder.coarse(rs.getInt("coarse"));
                builder.count(rs.getInt("medium"));
                builder.fine(rs.getInt("fine"));
                builder.caved(SB.getDBChar((ResultSet)rs, (String)"caved") == 'C');
                builder.marker(SB.getDBChar((ResultSet)rs, (String)"marker") == 'Y');
                builder.preservation(rs.getString("preserv"));
                builder.colour(rs.getString("colour"));
                builder.comment(rs.getString("comments"));
                TaxonOcc occ = builder.build();
                int imageID = rs.getInt("image_set_id");
                if (imageID > 0) {
                    occ.imageSet = new ImageSet(sbdb, imageID);
                }
                occ.audit = new Audit(rs);
                TaxonOcc taxonOcc = occ;
                return taxonOcc;
            }
            throw new SBException("Cannot re-retrieve TaxonOcc entry for wellID=" + wellID + ", sampID=" + sampID + ", analyID=" + analyID + ", taxon=" + taxon.toString() + ", specID=" + taxon.getSpecID() + ", reworked=" + reworked + ", identType=" + identType + ", specType=" + specType);
        }
    }

    public TaxonOcc(Statement stmt, SBdb SB2, int wellID, int sampID, int analyID, int specID, boolean reworked, char identType, int specType, String subjAbund, int coarse, int medium, int fine, boolean caved, boolean marker, String preservation, String colour, String comment, AbnScheme abnScheme) throws SQLException, SBException, FileNotFoundException, IOException {
        this.sbdb = SB2;
        this.reworked = reworked;
        if (identType != '\u0000') {
            this.identType = identType;
        }
        this.specType = specType;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        if (coarse + medium + fine == 0 && subjAbund != null && !subjAbund.equals("+")) {
            this.subjAbund = subjAbund;
        }
        this.caved = caved;
        this.marker = marker;
        if (preservation != null) {
            this.preservation = preservation;
        }
        if (colour != null) {
            this.colour = colour;
        }
        if (comment != null) {
            this.comment = comment;
        }
        this.store(stmt, wellID, sampID, analyID, abnScheme, specID);
    }

    static TaxonOcc copyToDatabase(SBdb db, int wellID, int sampID, int analyID, TaxonOcc wsOcc, int specType, AbnScheme abnScheme) throws SBException, SQLException, FileNotFoundException, IOException {
        assert (db.isConnected() && !wsOcc.sbdb.isConnected());
        if (wsOcc.getTaxon().getLink() == null) {
            throw new SBException("Attempt to create taxonocc in database with no valid taxon reference: " + wsOcc.getTaxon() + "," + sampID);
        }
        Builder builder = Builder.copyOf(wsOcc, db, wsOcc.getTaxon().getLink());
        builder.specType = specType;
        builder.audit = new Audit(db, wsOcc.sbdb, builder.audit);
        TaxonOcc dbOcc = builder.build();
        if (wsOcc.getImageSet() != null && wsOcc.getImageSet().getSize() > 0) {
            dbOcc.imageSet = new ImageSet(db, wsOcc.getImageSet());
        }
        dbOcc.store(null, wellID, sampID, analyID, abnScheme);
        return dbOcc;
    }

    static TaxonOcc copyToWorkspace(SBdb ws, Statement dbStmt, TaxonOcc dbOcc) throws SBException, SQLException {
        assert (!ws.isConnected() && dbOcc.sbdb.isConnected());
        Taxon wsTaxon = ws.fillTaxon(dbOcc.sbdb, dbStmt, dbOcc.taxonRef);
        Builder builder = Builder.copyOf(dbOcc, ws, wsTaxon);
        if (dbOcc.specType > 0) {
            builder.specType = ws.getAddSpecType(dbOcc.getSpecTypeString());
        }
        builder.audit.fillWorkspace(dbOcc.sbdb, ws);
        TaxonOcc wsOcc = builder.build();
        if (dbOcc.getImageSet() != null && dbOcc.getImageSet().getID() > 0) {
            try {
                wsOcc.imageSet = new ImageSet(ws, dbOcc.imageSet);
            }
            catch (IOException ioe) {
                throw new SBException("Unexpected IO Exception in workspace", (Throwable)ioe);
            }
        }
        wsOcc.link = dbOcc;
        return wsOcc;
    }

    static TaxonOcc parse(SBdb db, Element xml, ZipFile zip) throws SBException, SQLException {
        String strgID = xml.getChildTextNormalize("SpeciesID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int specID = Integer.parseInt(strgID);
        Taxon taxonRef = db.getTaxon(specID);
        boolean reworked = false;
        boolean transported = false;
        boolean caved = false;
        int identType = 80;
        int specType = 0;
        String strg = xml.getChildTextNormalize("Situation");
        if (strg != null) {
            if (strg.equalsIgnoreCase("Caved")) {
                caved = true;
            } else if (strg.equalsIgnoreCase("Reworked")) {
                reworked = true;
            } else if (strg.equalsIgnoreCase("Transported")) {
                transported = true;
                reworked = true;
            }
        }
        if ((strg = xml.getChildTextNormalize("Reworked")) != null && Boolean.parseBoolean(strg)) {
            reworked = true;
        }
        if ((strg = xml.getChildTextNormalize("Questionable")) != null && Boolean.parseBoolean(strg)) {
            identType = 63;
        }
        if ((strg = xml.getChildTextNormalize("SpeciesType")) != null) {
            specType = db.getAddSpecType(strg);
        }
        Builder builder = new Builder(db, taxonRef, reworked, identType == 63, specType);
        strg = xml.getChildTextNormalize("Caved");
        if (strg != null) {
            caved = Boolean.parseBoolean(strg);
        }
        builder.caved(caved);
        strg = xml.getChildTextNormalize("Marker");
        if (strg != null) {
            builder.marker(Boolean.parseBoolean(strg));
        }
        if ((strg = xml.getChildTextNormalize("Abundance")) != null) {
            builder.subjAbund(strg);
        }
        if ((strg = xml.getChildTextNormalize("SpeciesCount")) != null) {
            if (!builder.getSubAbund().isEmpty()) {
                throw new SBException("Both Species Count and Semi-quantitative data found");
            }
            builder.count(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("SpeciesCountCoarse")) != null) {
            builder.coarse(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("SpeciesCountFine")) != null) {
            builder.fine(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("Preservation")) != null) {
            builder.preservation(strg);
        }
        if ((strg = xml.getChildTextNormalize("Colour")) != null) {
            builder.colour(strg);
        }
        if ((strg = xml.getChildTextNormalize("Comment")) != null) {
            builder.comment(strg);
        }
        if (transported) {
            builder.comment("Transported. " + builder.comment);
        }
        TaxonOcc occ = builder.build();
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("Image"));
        int imageIndex = 0;
        while (it.hasNext()) {
            if (occ.imageSet == null) {
                occ.getImageSet();
            }
            occ.imageSet.insert(imageIndex++, new SBImage(db, (Element)it.next(), zip));
        }
        return occ;
    }

    void delete(int wellID, int sampID, int analyID) throws SQLException, SBException {
        if (this.sbdb.getDatabase() == null) {
            throw new SBException("Attempt to delete fss with null database");
        }
        String sqlcontent = "FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND spec_type_id=" + this.specType + " AND ";
        sqlcontent = this.identType == '?' ? sqlcontent + "ident_type='?'" : sqlcontent + "(ident_type is null OR ident_type=' ' OR ident_type='P')";
        sqlcontent = sqlcontent + " AND ";
        sqlcontent = !this.reworked ? sqlcontent + "(status is null OR status=' ' OR status='I')" : sqlcontent + "status='R'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT image_set_id " + sqlcontent;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int imageSetID = -1;
            if (rs.next()) {
                imageSetID = rs.getInt("image_set_id");
            }
            sql = "DELETE " + sqlcontent;
            int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (imageSetID > 0) {
                ImageSet.deleteWithTypeCheck(this.sbdb, imageSetID, wellID);
                this.imageSet.unstore();
                this.taxonRef.decrementImageSetCount();
            }
            if (nRows != 1) {
                throw new SBException("Failed to delete occurrence: " + this);
            }
        }
    }

    final void store(Statement stmt, int wellID, int iSampID, int analyID, AbnScheme abnScheme) throws SQLException, SBException {
        this.store(stmt, wellID, iSampID, analyID, abnScheme, this.getSpecID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(Statement stmt, int wellID, int iSampID, int analyID, AbnScheme abnScheme, int specID) throws SQLException, SBException {
        if (this.taxonRef != null && this.getSpecID() != specID) {
            throw new SBException("Attempt to store TaxonOcc with incorrect specID");
        }
        if (iSampID == 0) {
            throw new SBException("Attempt to store TAXONOCC entry with null sampleID, specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analy_id=" + analyID);
        }
        if (analyID == 0) {
            throw new SBException("Analyst header blank while attempting to store occurrence for suite : " + analyID);
        }
        if (this.subjAbund != null && this.subjAbund.length() > 0) {
            if (abnScheme != null) {
                if (abnScheme.getIndex(this.subjAbund) < 0) {
                    throw new SBException("Cannot store occurrence entry with semi-quantitative abundance: " + this.subjAbund + " not in scheme: " + abnScheme);
                }
            } else {
                throw new SBException("Cannot store occurrence entry with no abundance scheme specified for suite. Abundance entry is: " + this.subjAbund);
            }
        }
        String sql = "INSERT INTO " + this.sbdb.DBTableName("TAXONOCC") + " (well_id,samp_id,analy_id,spec_id,status,ident_type,spec_type_id";
        if (this.subjAbund != null && this.subjAbund.length() > 0) {
            sql = sql + ",abund";
        }
        if (this.medium > 0) {
            sql = sql + ",medium";
        }
        if (this.caved) {
            sql = sql + ",caved";
        }
        if (this.coarse > 0) {
            sql = sql + ",coarse";
        }
        if (this.fine > 0) {
            sql = sql + ",fine";
        }
        if (this.marker) {
            sql = sql + ",marker";
        }
        if (this.preservation != null && this.preservation.length() > 0) {
            sql = sql + ",preserv";
        }
        if (this.colour != null && this.colour.length() > 0) {
            sql = sql + ",colour";
        }
        if (this.comment != null && this.comment.length() > 0) {
            sql = sql + ",comments";
        }
        if (this.imageSet != null && this.imageSet.getID() > 0) {
            sql = sql + ",image_set_id";
        }
        sql = sql + "," + Audit.sqlFieldString();
        sql = sql + ") VALUES (" + wellID + "," + iSampID + "," + analyID + "," + specID + ",'" + (this.reworked ? "R" : "I") + "','" + this.identType + "'," + this.specType;
        if (this.subjAbund != null && this.subjAbund.length() > 0) {
            sql = sql + ",'" + this.subjAbund + "'";
        }
        if (this.medium > 0) {
            sql = sql + "," + this.medium;
        }
        if (this.caved) {
            sql = sql + ",'C'";
        }
        if (this.coarse > 0) {
            sql = sql + "," + this.coarse;
        }
        if (this.fine > 0) {
            sql = sql + "," + this.fine;
        }
        if (this.marker) {
            sql = sql + ",'Y'";
        }
        if (this.preservation != null && this.preservation.length() > 0) {
            sql = sql + "," + SB.DBString((String)this.preservation);
        }
        if (this.colour != null && this.colour.length() > 0) {
            sql = sql + "," + SB.DBString((String)this.colour);
        }
        if (this.comment != null && this.comment.length() > 0) {
            sql = sql + "," + SB.DBString((String)this.comment);
        }
        if (this.imageSet != null && this.imageSet.getID() > 0) {
            sql = sql + "," + this.imageSet.getID();
        }
        sql = sql + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        if (stmt == null) {
            stmt = this.sbdb.getDatabase().createStatement();
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        } else {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = STORED;
    }

    void update(int wellID, int analyID, boolean reworked, boolean questionable, int specType, boolean caved, boolean marker, int coarse, int medium, int fine, String abund, String preserv, String colour, String comment, ImageSet imageSet, int sampID) throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.sbdb == null) {
            throw new SBException("Attempt to update TaxonOcc record with null database");
        }
        if (sampID == 0) {
            throw new SBException("Attempt to update TaxonOcc record with null sampID: " + this);
        }
        if (this.taxonRef == null) {
            throw new SBException("Attempt to update TaxonOcc record with null taxon ref");
        }
        if (abund != null && abund.length() == 0) {
            abund = null;
        }
        if (coarse + medium + fine > 0) {
            abund = null;
        }
        Audit tempAudit = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET ";
            sql = sql + " ident_type=" + (questionable ? "'?'" : "'P'");
            sql = sql + ",status=" + (reworked ? "'R'" : "'I'");
            sql = sql + ",marker=" + (marker ? "'Y'" : "NULL");
            sql = sql + ",spec_type_id=" + specType;
            sql = sql + ",caved=" + (caved ? "'C'" : "''");
            sql = sql + ",coarse=" + coarse;
            sql = sql + ",medium=" + medium;
            sql = sql + ",fine=" + fine;
            sql = sql + ",abund=" + (abund == null ? "null" : SB.DBString((String)abund));
            sql = sql + ",preserv=" + SB.DBString((String)preserv);
            sql = sql + ",colour=" + SB.DBString((String)colour);
            sql = sql + ",comments=" + SB.DBString((String)comment);
            if (imageSet != null) {
                imageSet.store();
            }
            sql = sql + ",image_set_id=" + (Serializable)(imageSet == null || imageSet.getID() == 0 ? "NULL" : Integer.valueOf(imageSet.getID()));
            sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false);
            int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql = sql + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND ident_type='" + this.identType + "' AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND spec_type_id=" + this.specType));
            if (nRows != 1) {
                throw new SBException("Failed to update occurrence: " + this);
            }
        }
        this.identType = (char)(questionable ? 63 : 80);
        this.reworked = reworked;
        this.specType = specType;
        this.caved = caved;
        this.marker = marker;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.subjAbund = coarse + medium + fine == 0 ? (abund == null ? "" : abund) : "";
        this.preservation = preserv;
        this.colour = colour;
        this.comment = comment;
        this.imageSet = imageSet;
        this.audit = tempAudit;
    }

    public void updateImageSet(int wellID, int analyID, int sampID) throws SQLException, SBException, IOException {
        if (this.imageSet != null) {
            this.imageSet.store();
        }
        if (this.imageSet.getSize() == 0) {
            this.imageSet = null;
        }
        Audit tempAudit = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET image_set_id=" + (Serializable)(this.imageSet == null || this.imageSet.getID() == 0 ? "NULL" : Integer.valueOf(this.imageSet.getID())) + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND ident_type='" + this.identType + "' AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND spec_type_id=" + this.specType;
            int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRows != 1) {
                throw new SBException("Failed to update occurrence: " + this);
            }
        }
        this.audit = tempAudit;
    }

    void increment(int wellID, int sampID, Smpdtl smpdtl, int field, int factor, boolean quant) throws SBException, SQLException {
        Audit tempAudit = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET ";
            if (quant) {
                int rowCount;
                int fieldValue;
                boolean hasAbund = false;
                switch (field) {
                    case 1: {
                        fieldValue = this.coarse;
                        sql = sql + "coarse=" + (this.coarse + factor);
                        if (this.coarse + factor <= 0) break;
                        hasAbund = true;
                        break;
                    }
                    default: {
                        fieldValue = this.medium;
                        sql = sql + "medium=" + (this.medium + factor);
                        if (this.medium + factor <= 0) break;
                        hasAbund = true;
                        break;
                    }
                    case 3: {
                        fieldValue = this.fine;
                        sql = sql + "fine=" + (this.fine + factor);
                        if (this.fine + factor <= 0) break;
                        hasAbund = true;
                    }
                }
                if (fieldValue + factor < 0) {
                    throw new SBException("Cannot decrement TAXONOCC entry to below zero:  specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
                }
                if (hasAbund) {
                    sql = sql + ",abund=NULL";
                }
                if ((rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + smpdtl.getAnalyID() + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType))) != 1) {
                    throw new SBException("Cannot increment TAXONOCC entry: rowCount=" + rowCount + " specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
                }
                switch (field) {
                    case 1: {
                        this.coarse += factor;
                        break;
                    }
                    default: {
                        this.medium += factor;
                        break;
                    }
                    case 3: {
                        this.fine += factor;
                    }
                }
                if (hasAbund) {
                    this.subjAbund = "";
                }
            } else {
                boolean incr;
                AbnScheme sch = this.sbdb.getAbnScheme(smpdtl.getHeader().getAbnSchID(), false);
                if (this.getTotalCount() > 0) {
                    this.coarse = 0;
                    sql = sql + "coarse=" + this.coarse;
                    this.medium = 0;
                    sql = sql + ",medium=" + this.medium;
                    this.fine = 0;
                    sql = sql + ",fine=" + this.fine + ",";
                }
                int index = sch.getIndex(this.subjAbund);
                if (!this.getSubAbund(true).equals("+") && index < 0) {
                    throw new SBException("Incrementing semi-quant abundance: class abr not recognised");
                }
                boolean bl = incr = factor > 0;
                if (index == sch.getNClasses() - 1 && incr) {
                    throw new SBException("Attempt to increment max semi-quant abn");
                }
                this.subjAbund = index <= 0 && !incr ? "+" : sch.getEntry(incr ? index + 1 : index - 1);
                sql = sql + "abund=" + SB.DBString((String)this.subjAbund);
                int rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + smpdtl.getAnalyID() + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType));
                if (rowCount != 1) {
                    throw new SBException("Cannot increment TAXONOCC entry: rowCount=" + rowCount + " specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
                }
            }
            this.audit = tempAudit;
            this.status = STORED;
        }
    }

    void incrementNumeric(int field, int factor, int wellID, int sampID, int analyID) throws SQLException, SBException {
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET ";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int rowCount;
            int fieldValue;
            boolean hasAbund = false;
            switch (field) {
                case 1: {
                    fieldValue = this.coarse;
                    sql = sql + "coarse=" + (this.coarse + factor);
                    if (this.coarse + factor <= 0) break;
                    hasAbund = true;
                    break;
                }
                default: {
                    fieldValue = this.medium;
                    sql = sql + "medium=" + (this.medium + factor);
                    if (this.medium + factor <= 0) break;
                    hasAbund = true;
                    break;
                }
                case 3: {
                    fieldValue = this.fine;
                    sql = sql + "fine=" + (this.fine + factor);
                    if (this.fine + factor <= 0) break;
                    hasAbund = true;
                }
            }
            if (fieldValue + factor < 0) {
                throw new SBException("Cannot decrement TAXONOCC entry to below zero: taxon=" + this.taxonRef);
            }
            if (hasAbund) {
                sql = sql + ",abund=NULL";
            }
            if ((rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType))) != 1) {
                throw new SBException("Cannot increment TAXONOCC entry: rowCount=" + rowCount + ", taxon=" + this.taxonRef);
            }
            switch (field) {
                case 1: {
                    this.coarse += factor;
                    break;
                }
                default: {
                    this.medium += factor;
                    break;
                }
                case 3: {
                    this.fine += factor;
                }
            }
            if (hasAbund) {
                this.subjAbund = "";
            }
        }
    }

    void incrementSubj(boolean incr, int wellID, int sampID, int analyID, int abnSchID) throws SBException, SQLException {
        if (!incr && this.subjAbund.isEmpty()) {
            return;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET ";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit tempAudit = new Audit(this.audit);
            AbnScheme sch = this.sbdb.getAbnScheme(abnSchID, false);
            if (this.getTotalCount() > 0) {
                this.coarse = 0;
                sql = sql + "coarse=" + this.coarse;
                this.medium = 0;
                sql = sql + ",medium=" + this.medium;
                this.fine = 0;
                sql = sql + ",fine=" + this.fine + ",";
            }
            int index = sch.getIndex(this.subjAbund);
            if (!this.getSubAbund(true).equals("+") && index < 0) {
                throw new SBException("Incrementing semi-quant abundance: class abr not recognised");
            }
            if (index == sch.getNClasses() - 1 && incr) {
                throw new SBException("Attempt to increment max semi-quant abn");
            }
            this.subjAbund = index == 0 && !incr ? "" : sch.getEntry(incr ? index + 1 : index - 1);
            sql = sql + "abund=" + (this.subjAbund.isEmpty() ? "NULL" : SB.DBString((String)this.subjAbund));
            int rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType));
            if (rowCount != 1) {
                throw new SBException("Cannot increment TAXONOCC entry: rowCount=" + rowCount + ", taxon=" + this.taxonRef);
            }
        }
    }

    void setSubjAbund(int wellID, Smpdtl smpdtl, String abr) throws SBException, SQLException {
        if (smpdtl.getSample().getSampID() == 0) {
            throw new SBException("Attempt to store TAXONOCC entry with null sampleID, specID=" + this.getSpecTypeString() + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
        }
        if (this.getTotalCount() > 0) {
            throw new SBException("Attempt to set Subj Abundance when counts > 0");
        }
        Audit tempAudit = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET abund=" + SB.DBString((String)abr);
            sql = sql + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + smpdtl.getSample().getSampID() + " AND analy_id=" + smpdtl.getAnalyID() + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType;
            int rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (rowCount != 1) {
                throw new SBException("Cannot set TAXONOCC entry: rowCount=" + rowCount + " specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
            }
            this.subjAbund = abr;
            this.audit = tempAudit;
            this.status = STORED;
        }
    }

    void merge(TaxonOcc rhs, AbnScheme abn) throws SBException {
        if (this.reworked != rhs.reworked) {
            throw new SBException("Attempt to merge reworked & non-reworked occurrences: " + this.toString());
        }
        if (this.identType != rhs.identType) {
            throw new SBException("Attempt to merge questionable/non-questionable occurrences: " + this.toString());
        }
        if (this.specType != rhs.specType) {
            throw new SBException("Attempt to merge different species types: " + this.toString());
        }
        if (rhs.caved) {
            this.caved = true;
        }
        if (rhs.marker) {
            this.marker = true;
        }
        this.medium += rhs.medium;
        this.coarse += rhs.coarse;
        this.fine += rhs.fine;
        if (abn != null) {
            if (this.subjAbund == null) {
                this.subjAbund = "";
            }
            if (rhs.subjAbund == null) {
                rhs.subjAbund = "";
            }
            if (!this.subjAbund.toString().equalsIgnoreCase(rhs.subjAbund.toString())) {
                if (this.subjAbund.length() > 0) {
                    if (rhs.subjAbund.length() > 0) {
                        if (abn == null) {
                            if (this.medium == 0) {
                                throw new SBException("Attempt to merge semi-quantitative occurrences with no abundance scheme specified for: " + this.toString());
                            }
                        } else {
                            int abnIndex1 = abn.getIndex(this.subjAbund.toString());
                            int abnIndex2 = abn.getIndex(rhs.subjAbund.toString());
                            if (abnIndex1 >= 0 && abnIndex2 >= 0) {
                                int tempCount = abn.getLowBound(abnIndex1) + abn.getLowBound(abnIndex2);
                                this.subjAbund = abn.getAbr(tempCount);
                            } else if (abnIndex2 >= 0) {
                                this.subjAbund = rhs.subjAbund;
                            }
                        }
                    }
                } else {
                    this.subjAbund = rhs.subjAbund;
                }
            }
        }
        if (this.medium + this.coarse + this.fine > 0) {
            this.subjAbund = "";
        }
        this.preservation = this.preservation != null && this.preservation.length() > 0 ? this.preservation + " " + rhs.preservation : rhs.preservation;
        this.colour = this.colour != null && this.colour.length() > 0 ? this.colour + " " + rhs.colour : rhs.colour;
        this.comment = this.comment != null && this.comment.length() > 0 ? this.comment + " " + rhs.comment : rhs.comment;
    }

    void setMoved(Audit tempAudit) {
        this.audit.modified = tempAudit.modified;
        this.audit.modifier = tempAudit.modifier;
        this.audit.updated = tempAudit.updated;
        this.audit.updater = tempAudit.updater;
    }

    void deleteImageSet(int wellID, int sampID, int analyID) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET image_set_id=null WHERE well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID + " AND spec_id=" + this.getSpecID() + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND spec_type_id=" + this.specType;
            int rowCount = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (rowCount != 1) {
                throw new SBException("Cannot set TAXONOCC entry: rowCount=" + rowCount + " specID=" + this.getSpecID() + ",taxon=" + this.taxonRef + ",analyID=" + analyID);
            }
            this.imageSet = null;
        }
    }

    public static int loadAll(SBdb SB2, TaxaMap taxa) throws SQLException, SBException {
        int nFss = 0;
        Object sql = "SELECT well_id,samp_id,analy_id,spec_id,status,ident_type,spec_type_id,abund,medium,coarse,fine,caved,marker,preserv,colour,comments,image_set_id," + Audit.sqlFieldString();
        sql = (String)sql + " FROM " + SB2.DBTableName("TAXONOCC");
        sql = SB2.modQuery((String)sql);
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery((String)sql);
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                int specID = rs.getInt("spec_id");
                Taxon taxonRef = SB2.getTaxon(specID);
                if (taxonRef == null) {
                    throw new SBException("Taxon not found when loading TaxonOccs: " + specID);
                }
                String strg = rs.getString("status");
                boolean reworked = false;
                if (strg != null && strg.compareToIgnoreCase("R") == 0) {
                    reworked = true;
                }
                char identType = rs.getString("ident_type").charAt(0);
                int specType = rs.getInt("spec_type_id");
                strg = rs.getString("abund");
                String subjAbund = strg != null ? strg : "";
                int medium = rs.getInt("medium");
                int coarse = rs.getInt("coarse");
                int fine = rs.getInt("fine");
                strg = rs.getString("caved");
                boolean caved = false;
                if (strg != null && (strg.equalsIgnoreCase("C") || strg.equalsIgnoreCase("Y"))) {
                    caved = true;
                }
                strg = rs.getString("marker");
                boolean marker = false;
                if (strg != null && strg.compareToIgnoreCase("Y") == 0) {
                    marker = true;
                }
                String preservation = rs.getString("preserv");
                String colour = rs.getString("colour");
                String comment = rs.getString("comments");
                ImageSet imageSet = null;
                int imageSetID = rs.getInt("image_set_id");
                if (imageSetID > 0) {
                    imageSet = new ImageSet(SB2, imageSetID);
                }
                Audit audit = new Audit(rs);
                Builder builder = new Builder(SB2, taxonRef, reworked, identType != 'P', specType);
                builder.count(coarse, medium, fine).subjAbund(subjAbund).caved(caved).marker(marker).preservation(preservation).colour(colour).comment(comment).imageSet(imageSet);
                builder.audit(audit).status(STORED);
                Well well = SB2.getWell(wellID);
                Sample sample = well.getSample(sampID);
                if (sample == null) {
                    System.out.println("Sample ID not found for sample: " + sampID + " in TxonOcc::loadAll");
                    continue;
                }
                Smpdtl smpdtl = sample.getSmpdtl(analyID);
                if (smpdtl == null) {
                    System.out.println("Sample details null for sample ID: " + sampID + ", analy_id: " + analyID + "  in TxonOcc::loadAll");
                    continue;
                }
                try {
                    smpdtl.insertOccurrence(builder, wellID, false);
                    ++nFss;
                }
                catch (SBException ex) {
                    System.out.println("Error inserting taxonocc record for specID: " + specID + " " + taxonRef + ", sample: " + sample + " ID: " + sampID + ", analy_id: " + analyID + "  in TaxonOcc::loadAll");
                }
            }
        }
        return nFss;
    }

    public static int getNOcc(SBdb db, Well well, Taxon taxon, int i) throws SQLException {
        int nOcc;
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "SELECT count(samp_id) AS nOcc FROM " + db.DBTableName("TAXONOCC") + " WHERE well_id=" + well.getWellID() + " AND spec_id=" + taxon.getSpecID();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    sql = sql + " AND status <> 'R'";
                    break;
                }
                case 2: {
                    sql = sql + " AND status='R'";
                    break;
                }
                case 3: {
                    sql = sql + " AND ident_type='?'";
                }
            }
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            nOcc = 0;
            if (rs.next()) {
                nOcc = rs.getInt("nOcc");
            }
        }
        return nOcc;
    }

    public String getSortEntry() {
        Object specTypeString = "" + this.specType;
        try {
            specTypeString = this.getSpecTypeString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (this.taxonRef.getLink() != null ? this.taxonRef.getLink().toString() : this.taxonRef.toString()) + "-" + this.identType + this.reworked + (String)specTypeString;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public String statusString() {
        if (this.taxonRef != null) {
            return this.taxonRef.toString();
        }
        return "No taxon";
    }

    public Color getStatus() {
        return this.status;
    }

    public void updateStatus(List occurrences) throws SQLException, SBException {
        Iterator it = occurrences.iterator();
        this.status = NOTSTORED;
        MergeStatus m = new MergeStatus(this.status);
        while (it.hasNext()) {
            TaxonOcc fss = (TaxonOcc)((Object)it.next());
            if (this.taxonRef == null) {
                throw new SBException("Taxon reference null in TaxonOcc.updateStatus - analyses in workspace invalid");
            }
            if (this.taxonRef.getLink() == null || this.taxonRef.getLink().getSpecID() != fss.getSpecID() || this.identType != fss.identType || this.reworked != fss.reworked || (this.getSpecTypeString() != null || fss.getSpecTypeString() != null) && (this.getSpecTypeString() == null || !this.getSpecTypeString().equalsIgnoreCase(fss.getSpecTypeString()))) continue;
            m = new MergeStatus(STORED);
            m.compareStringField("subjAbund", this.subjAbund, fss.subjAbund, false);
            m.compareIntField("coarse", this.medium, fss.medium);
            m.compareIntField("count", this.coarse, fss.coarse);
            m.compareIntField("fine", this.fine, fss.fine);
            if (this.caved != fss.caved) {
                this.status = CONFLICT;
                break;
            }
            if (this.marker != fss.marker) {
                this.status = CONFLICT;
                break;
            }
            m.compareStringField("colour", this.colour, fss.colour, false);
            m.compareStringField("comment", this.comment, fss.comment != null ? fss.comment.replaceAll("  ", " ") : null, false);
            m.compareStringField("preservation", this.preservation, fss.preservation, false);
        }
        if (this.status != CONFLICT) {
            this.status = m.getStatus();
        }
    }

    Color getTaxonStatus() {
        if (this.taxonRef == null) {
            return NOTSTORED;
        }
        if (this.taxonRef.getSpecID() == 0) {
            return NOTSTORED;
        }
        return STORED;
    }

    void fillTaxonList(HashMap<Integer, Taxon> taxa) {
        Taxon previousMapping;
        if (this.taxonRef != null && (previousMapping = taxa.put(this.taxonRef.getSpecID(), this.taxonRef)) != null) assert (previousMapping == this.taxonRef);
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write("T " + this.getSpecID() + "\t" + (this.reworked ? (char)'R' : ' ') + (this.identType == '?' ? (char)'?' : ' ') + "\t");
        if (this.subjAbund != null) {
            out.write(this.subjAbund);
        }
        out.write("\t" + this.medium + "\t" + (this.caved ? (char)'C' : ' ') + "\n");
        if (this.preservation != null && this.preservation.length() > 0 || this.colour != null && this.colour.length() > 0 || this.comment != null && this.comment.length() > 0) {
            out.write("A " + this.preservation + "\t" + this.colour + "\t" + this.comment + "\n");
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException, SQLException {
        if (this.reworked) {
            out.write("  Qualifier : Reworked" + eol);
        }
        if (this.identType == '?') {
            out.write("  Qualifier : ?" + eol);
        }
        out.write("  Species id : " + (this.taxonRef != null ? this.taxonRef.getSpecID() : this.getSpecID()) + eol);
        if (this.subjAbund.length() > 0) {
            out.write("  Abundance : " + this.subjAbund + eol);
        }
        if (this.medium > 0) {
            out.write("  Species count : " + this.medium + eol);
        }
        if (this.coarse > 0) {
            out.write("  Species count coarse : " + this.coarse + eol);
        }
        if (this.fine > 0) {
            out.write("  Species count fine : " + this.fine + eol);
        }
        if (this.isOutsideCount()) {
            out.write("  Abundance : +" + eol);
        }
        if (this.caved) {
            out.write("  Flag : Caved" + eol);
        }
        if (this.marker) {
            out.write("  Flag : Marker" + eol);
        }
        if (this.preservation != null && this.preservation.length() > 0) {
            out.write("  Preservation : " + this.preservation + eol);
        }
        if (this.colour != null && this.colour.length() > 0) {
            out.write("  Colour : " + this.colour + eol);
        }
        if (this.comment != null && this.comment.length() > 0) {
            out.write("  Sp Comment : " + this.comment + eol);
        }
        if (this.specType > 0) {
            out.write("  Species type : " + this.sbdb.getSpecType(this.specType) + eol);
        }
        if (this.imageSet != null) {
            Iterator<SBImage> it = this.imageSet.getIterator();
            while (it.hasNext()) {
                SBImage image = it.next();
                out.write("  Image ID : " + image.getImageID() + eol);
            }
        }
    }

    LinkedList<Integer> recordSpecies(int specID) {
        if (SPECIESRECORD == null) {
            SPECIESRECORD = new LinkedList();
        }
        if (!SPECIESRECORD.contains(specID)) {
            SPECIESRECORD.add(specID);
        }
        return SPECIESRECORD;
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        LinkedList<Integer> userIDs;
        block21: {
            userIDs = new LinkedList<Integer>();
            Object ind = new String();
            while (((String)ind).length() < indent) {
                ind = (String)ind + " ";
            }
            out.write((String)ind + "<SpeciesID>" + this.getSpecID() + "</SpeciesID>\n");
            this.recordSpecies(this.getSpecID());
            if (this.taxonRef != null) {
                out.write((String)ind + "<Species>" + SB.getXMLstring((String)this.taxonRef.toString()) + "</Species>\n");
                if (this.taxonRef.getAlphaCode() != null && this.taxonRef.getAlphaCode().length() > 0) {
                    out.write((String)ind + "<SpeciesAlphacode>" + SB.getXMLstring((String)this.taxonRef.getAlphaCode()) + "</SpeciesAlphacode>\n");
                }
            }
            if (this.reworked) {
                out.write((String)ind + "<Reworked>true</Reworked>\n");
            }
            if (this.identType == '?') {
                out.write((String)ind + "<Questionable>true</Questionable>\n");
            }
            if (this.subjAbund != null && this.subjAbund.length() > 0) {
                out.write((String)ind + "<Abundance>" + this.subjAbund + "</Abundance>\n");
            }
            if (this.medium > 0) {
                out.write((String)ind + "<SpeciesCount>" + this.medium + "</SpeciesCount>\n");
            }
            if (this.coarse > 0) {
                out.write((String)ind + "<SpeciesCountCoarse>" + this.coarse + "</SpeciesCountCoarse>\n");
            }
            if (this.fine > 0) {
                out.write((String)ind + "<SpeciesCountFine>" + this.fine + "</SpeciesCountFine>\n");
            }
            if (this.caved) {
                out.write((String)ind + "<Caved>true</Caved>\n");
            }
            if (this.marker) {
                out.write((String)ind + "<Marker>true</Marker>\n");
            }
            if (this.preservation != null && this.preservation.length() > 0) {
                out.write((String)ind + "<Preservation>" + SB.getXMLstring((String)this.preservation) + "</Preservation>\n");
            }
            if (this.colour != null && this.colour.length() > 0) {
                out.write((String)ind + "<Colour>" + SB.getXMLstring((String)this.colour) + "</Colour>\n");
            }
            if (this.comment != null && this.comment.length() > 0) {
                out.write((String)ind + "<Comment>" + SB.getXMLstring((String)this.comment) + "</Comment>\n");
            }
            if (this.specType > 0 && this.getSpecTypeString().length() > 0) {
                out.write((String)ind + "<SpeciesType>" + this.getSpecTypeString() + "</SpeciesType>\n");
            }
            if (this.imageSet != null && this.imageSet.getID() > 0) {
                if (exportImages == null) {
                    exportImages = JOptionPane.showConfirmDialog(null, "Occurrence images found: do you want to export them?", "Export Images", 0) == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                if (exportImages.booleanValue()) {
                    try {
                        this.imageSet.writeXML(out, (String)ind, files, false);
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                        int opt = JOptionPane.showConfirmDialog(null, "Failed to write image file for occurrence: " + this.toString() + "\nDo you want to continue?", "Image Export", 0, 3);
                        if (opt != 1) break block21;
                        throw new SBException("File export cancelled");
                    }
                }
            }
        }
        if (this.audit != null) {
            userIDs = this.audit.writeXML(out, indent);
        }
        return userIDs;
    }

    @Deprecated
    void parseXML(String chars, String element, Taxon taxon) throws ParseException, SQLException {
        if (element.compareTo("Reworked") == 0) {
            if (chars.compareTo("false") != 0) {
                this.reworked = true;
            }
        } else if (element.compareTo("Questionable") == 0) {
            if (chars.compareTo("false") != 0) {
                this.identType = (char)63;
            }
        } else if (element.compareTo("Caved") == 0) {
            if (chars.compareTo("false") != 0) {
                this.caved = true;
            }
        } else if (element.compareTo("Marker") == 0) {
            if (chars.compareTo("false") != 0) {
                this.marker = true;
            }
        } else if (element.compareTo("Preservation") == 0) {
            this.preservation = chars;
        } else if (element.compareTo("Colour") == 0) {
            this.colour = chars;
        } else if (element.compareTo("Comment") == 0) {
            this.comment = chars;
        } else if (element.compareTo("SpeciesCountCoarse") == 0) {
            this.coarse = Integer.parseInt(chars);
        } else if (element.compareTo("SpeciesCountFine") == 0) {
            this.fine = Integer.parseInt(chars);
        } else if (element.compareTo("SpeciesCount") == 0) {
            this.medium = Integer.parseInt(chars);
        } else if (element.compareTo("Abundance") == 0) {
            this.subjAbund = this.subjAbund + chars;
        } else if (element.equalsIgnoreCase("SpeciesType")) {
            this.specType = this.sbdb.getSpecType(chars);
        } else if (element.compareTo("Taxon") == 0) {
            if (taxon != null) {
                taxon.donorString = taxon.donorString + chars;
            }
        } else if (element.compareTo("TaxonAlphacode") == 0) {
            if (taxon != null && taxon.donorString.length() == 0) {
                taxon.donorString = taxon.donorString + chars;
            }
        } else if (element.compareTo("TaxonID") == 0 && taxon != null) {
            throw new ParseException("Cannot set species ID in TaxonOcc.parseXML", 0);
        }
    }

    void setAnalyst(Userdef analyst) {
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public static String getFormString(char form) {
        switch (form) {
            case 'E': {
                return "Entire";
            }
            default: {
                return "Component";
            }
            case 'B': {
                return "Broken";
            }
            case 'F': 
        }
        return "Fragment";
    }

    public static String getGrowthString(char growth) {
        switch (growth) {
            case 'J': {
                return "Juvenile";
            }
        }
        return "Adult";
    }

    private TaxonOcc(Builder builder) {
        this.sbdb = builder.sbdb;
        this.reworked = builder.reworked;
        this.identType = builder.identType;
        this.specType = builder.specType;
        this.taxonRef = builder.taxonRef;
        this.coarse = builder.coarse;
        this.medium = builder.medium;
        this.fine = builder.fine;
        this.subjAbund = builder.subjAbund;
        this.caved = builder.caved;
        this.marker = builder.marker;
        this.preservation = builder.preservation;
        this.colour = builder.colour;
        this.comment = builder.comment;
        this.imageSet = builder.imageSet;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static enum SizeFraction {
        COARSE,
        MEDIUM,
        FINE;

    }

    public static class Builder {
        final Taxon taxonRef;
        boolean reworked = false;
        char identType = (char)80;
        int specType = 0;
        private final SBdb sbdb;
        private ImageSet imageSet = null;
        private Audit audit = new Audit();
        private boolean caved;
        private String subjAbund = "";
        private int coarse;
        private int medium;
        private int fine;
        private boolean marker = false;
        private String preservation = "";
        private String colour = "";
        private String comment = "";
        private Color status = SbugsStatus.NOTSTORED;

        public Builder(SBdb sbdb, Taxon taxon, boolean reworked, boolean questionable, int specType) {
            this.sbdb = sbdb;
            this.taxonRef = taxon;
            this.reworked = reworked;
            this.identType = (char)(questionable ? 63 : 80);
            this.specType = specType < 0 ? 0 : specType;
        }

        static Builder copyOf(TaxonOcc rhs, SBdb sbdb, Taxon taxonRef) {
            Builder builder = new Builder(sbdb, taxonRef, rhs.getReworked(), rhs.getQuestionable(), rhs.getSpecType());
            builder.caved(rhs.caved).marker(rhs.marker).subjAbund(rhs.getSubAbund()).count(rhs.getCoarse(), rhs.getMedium(), rhs.getFine());
            builder.preservation(rhs.preservation).colour(rhs.colour).comment(rhs.comment).audit(new Audit(rhs.audit));
            return builder;
        }

        public Builder coarse(int coarse) {
            this.coarse = coarse;
            return this;
        }

        public Builder fine(int fine) {
            this.fine = fine;
            return this;
        }

        public Builder count(int medium) {
            this.medium = medium;
            return this;
        }

        public Builder count(int coarse, int medium, int fine) {
            this.coarse = coarse > 0 ? coarse : 0;
            this.medium = medium > 0 ? medium : 0;
            this.fine = fine > 0 ? fine : 0;
            return this;
        }

        public Builder subjAbund(String subjAbund) {
            this.subjAbund = subjAbund == null || subjAbund.equals("+") ? "" : subjAbund;
            return this;
        }

        public Builder caved(boolean caved) {
            this.caved = caved;
            return this;
        }

        public Builder marker(boolean marker) {
            this.marker = marker;
            return this;
        }

        public Builder preservation(String preservation) {
            if (preservation != null) {
                this.preservation = preservation;
            }
            return this;
        }

        public Builder colour(String colour) {
            if (colour != null) {
                this.colour = colour;
            }
            return this;
        }

        public Builder comment(String comment) {
            if (comment != null) {
                this.comment = comment;
            }
            return this;
        }

        public Builder imageSet(ImageSet imageSet) {
            this.imageSet = imageSet;
            return this;
        }

        Builder status(Color status) {
            this.status = status;
            return this;
        }

        Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        TaxonOcc build() {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to create TaxonOcc with null model");
            }
            if (this.taxonRef == null) {
                throw new IllegalStateException("Attemp to create TaxonOcc with no Taxon");
            }
            TaxonOcc occ = new TaxonOcc(this);
            if (occ.coarse + occ.medium + occ.fine > 0) {
                occ.subjAbund = "";
            }
            if (occ.status == SbugsStatus.UNKNOWN) {
                occ.status = SbugsStatus.NOTSTORED;
            }
            return occ;
        }

        TaxonOcc build(Statement stmt, int wellID, int sampID, int analyID, AbnScheme abnScheme) throws SBException, SQLException {
            if (this.status == SbugsStatus.CONFLICT) {
                throw new SBException("Cannot build TaxonOcc with database store: status is CONFLICT");
            }
            TaxonOcc occ = this.build();
            occ.store(stmt, wellID, sampID, analyID, abnScheme);
            return occ;
        }

        public void store(Statement stmt, int wellID, int sampID, int analyID, AbnScheme abnScheme) throws SBException, SQLException {
            this.build().store(stmt, wellID, sampID, analyID, abnScheme);
        }

        public static Builder parseOcc(SBdb sbdb, Taxon taxonRef, String buff, HashSet<String> rejects) {
            Builder builder = new Builder(sbdb, taxonRef, false, false, 0);
            if (Builder.parseOcc(builder, buff, rejects)) {
                return builder;
            }
            return null;
        }

        private static boolean parseOcc(Builder builder, String buff, HashSet<String> rejects) {
            boolean entry = false;
            try {
                builder.medium = Integer.parseInt(buff);
                if (builder.medium > 0) {
                    entry = true;
                }
            }
            catch (Exception e) {
                int i;
                if (buff.equalsIgnoreCase("RW")) {
                    builder.reworked = true;
                    builder.medium = 0;
                    builder.subjAbund = "";
                    entry = true;
                }
                if (buff.equalsIgnoreCase("CV")) {
                    builder.caved = true;
                    builder.subjAbund = "";
                    builder.medium = 0;
                    entry = true;
                }
                if (buff.equalsIgnoreCase("?")) {
                    builder.identType = (char)63;
                    builder.subjAbund = "";
                    builder.medium = 0;
                    entry = true;
                }
                if (buff.startsWith("?")) {
                    builder.identType = (char)63;
                    buff = buff.substring(1).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.toUpperCase().startsWith("RW")) {
                    builder.reworked = true;
                    buff = buff.substring(2).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.toUpperCase().startsWith("CV")) {
                    builder.caved = true;
                    buff = buff.substring(2).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.endsWith("?")) {
                    builder.identType = (char)63;
                    buff = buff.substring(0, buff.length() - 1).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.toUpperCase().endsWith("RW")) {
                    builder.reworked = true;
                    buff = buff.substring(0, buff.length() - 2).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.toUpperCase().endsWith("CV")) {
                    builder.caved = true;
                    buff = buff.substring(0, buff.length() - 2).trim();
                    entry = Builder.parseOcc(builder, buff, rejects);
                }
                if (buff.equals("+")) {
                    builder.medium = 0;
                    builder.subjAbund = "";
                    entry = true;
                }
                if (buff.equals("*")) {
                    builder.medium = 0;
                    builder.subjAbund = "";
                    entry = true;
                }
                boolean countFound = false;
                for (i = 0; i < buff.length() && Character.isDigit(buff.charAt(i)); ++i) {
                }
                if (i > 0) {
                    builder.medium = Integer.parseInt(buff.substring(0, i));
                    rejects.add(buff.substring(i));
                    countFound = true;
                } else {
                    int j;
                    for (j = buff.length(); j > 0 && Character.isDigit(buff.charAt(j - 1)); --j) {
                    }
                    if (j < buff.length()) {
                        builder.medium = Integer.parseInt(buff.substring(j));
                        rejects.add(buff.substring(0, j));
                        countFound = true;
                    }
                }
                if (!countFound) {
                    builder.subjAbund = builder.subjAbund + buff;
                }
                entry = true;
            }
            return entry;
        }

        public boolean isMarker() {
            return this.marker;
        }

        public Taxon getTaxon() {
            return this.taxonRef;
        }

        public boolean isReworked() {
            return this.reworked;
        }

        public boolean isQuestionable() {
            return this.identType == '?';
        }

        public boolean isCaved() {
            return this.caved;
        }

        public String getSubAbund() {
            return this.subjAbund;
        }

        public int getCoarse() {
            return this.coarse;
        }

        public int getMedium() {
            return this.medium;
        }

        public int getFine() {
            return this.fine;
        }

        public String getPreservation() {
            return this.preservation;
        }

        public String getColour() {
            return this.colour;
        }

        public String getComment() {
            return this.comment;
        }

        public int getSpecType() {
            return this.specType;
        }

        public String getSpecTypeString() throws SQLException {
            return this.sbdb.getSpecType(this.specType);
        }
    }

    public static enum Caving {
        NOTCAVED("Not caved", "", false),
        CAVED("Caved", "Cv", true);

        private final String name;
        private final String abr;
        private final boolean isQualified;

        private Caving(String name, String abr, boolean isQualified) {
            this.name = name;
            this.abr = abr;
            this.isQualified = isQualified;
        }

        public String toString() {
            return this.name;
        }

        public String getAbr() {
            return this.abr;
        }

        public boolean isQualified() {
            return this.isQualified;
        }
    }

    public static enum Identification {
        POSITIVE("Positive", "", false),
        Q("Questionable", "?", true);

        private final String name;
        private final String abr;
        private final boolean isQualified;

        private Identification(String name, String abr, boolean isQualified) {
            this.name = name;
            this.abr = abr;
            this.isQualified = isQualified;
        }

        public String toString() {
            return this.name;
        }

        public String getAbr() {
            return this.abr;
        }

        public boolean isQualified() {
            return this.isQualified;
        }
    }

    public static enum Situation {
        INSITU("In-situ", "", false),
        RW("Reworked", "Rw", true);

        private final String name;
        private final String abr;
        private final boolean isQualified;

        private Situation(String name, String abr, boolean isQualified) {
            this.name = name;
            this.abr = abr;
            this.isQualified = isQualified;
        }

        public String toString() {
            return this.name;
        }

        public String getAbr() {
            return this.abr;
        }

        public boolean isQualified() {
            return this.isQualified;
        }
    }
}

