/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Set;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.WellEvent;
import model2_1.WellHeader;
import model2_1.WsWell;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellEventBSEEXLS {
    Set dataTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellEventBSEEXLS(SBdb ws, File file, char units, Set dataTypes) throws GridReaderException, SBException, SBPermissionException, SQLException {
        boolean COL_CODE = true;
        int COL_DEPTH = 2;
        int COL_TYPE = 3;
        int COL_EVENT = 4;
        String[] columnNames = new String[]{"code", "well code", "api", "depth", "type", "event"};
        int[] columnType = new int[]{1, 1, 1, 2, 3, 4};
        boolean first = true;
        int[] cols = null;
        this.dataTypes = dataTypes;
        try (GridReader in = null;){
            in = GridReader.getGridReader((String)file.getPath(), null);
            String lastCode = null;
            WsWell well = null;
            while (in.nextRow()) {
                String cell;
                if (first) {
                    LinkedList<String> titles = new LinkedList<String>();
                    while ((cell = in.getNextCell()) != null) {
                        titles.add(cell);
                    }
                    cols = new int[titles.size()];
                    block15: for (int i = 0; i < cols.length; ++i) {
                        for (int j = 0; j < columnNames.length; ++j) {
                            if (!columnNames[j].equalsIgnoreCase((String)titles.get(i))) continue;
                            cols[i] = columnType[j];
                            continue block15;
                        }
                    }
                    first = false;
                    continue;
                }
                if (cols == null) {
                    throw new SBException("No column titles in first row of file/sheet");
                }
                int i = 0;
                String wellCode = null;
                Double depth = null;
                String eventType = null;
                String eventName = null;
                while ((cell = in.getNextCell()) != null) {
                    if (i >= cols.length) {
                        System.out.println("Line for cell: " + cell + " Exceeds titles length");
                        break;
                    }
                    if (cell == null || cell.isEmpty()) {
                        ++i;
                        continue;
                    }
                    switch (cols[i]) {
                        case 1: {
                            wellCode = cell;
                            break;
                        }
                        case 4: {
                            eventName = cell;
                            break;
                        }
                        case 2: {
                            try {
                                depth = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 3: {
                            eventType = cell;
                        }
                    }
                    ++i;
                }
                if (wellCode == null || depth == null) continue;
                if (lastCode == null || !wellCode.equalsIgnoreCase(lastCode)) {
                    well = ws.addWellToWorkspace(0, null);
                    WellHeader wh = well.getHeader();
                    wh.setWellCode(wellCode);
                    wh.setWellUnits(units);
                }
                if (well == null || !well.getWellCode().equalsIgnoreCase(wellCode)) {
                    throw new SBException("Error reading well code at row: " + i);
                }
                lastCode = wellCode;
                well.loadInterps();
                Sample sample = well.getSample(DepthUtils.convToM((double)depth, (char)units), "CU", true);
                if (sample == null) {
                    sample = well.addSample(DepthUtils.convToM((double)depth, (char)units), SampleType.CU, null);
                }
                SBEvent.EventType evType = SBEvent.EventType.getType(eventType);
                SBEvent sbEvent = ws.getSBEvent(eventName);
                if (sbEvent == null) {
                    try {
                        sbEvent = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(true).isSingle(evType == SBEvent.EventType.SINGLE));
                    }
                    catch (SBPermissionException e) {
                        throw new SBException(e.getMessage());
                    }
                }
                WellEvent.Builder eventBuilder = new WellEvent.Builder().sample(sample).event(sbEvent).type(evType);
                well.getAddInterp(ws.getInterp(0)).insertEvent(eventBuilder.build(ws));
            }
            dataTypes.add(16);
            dataTypes.add(1);
        }
    }
}

