/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model2_1.AgeConfidence;
import model2_1.Biocom;
import model2_1.IGDInterval;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.SQPick;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Surface;
import model2_1.WellEvent;
import model2_1.WellHeader;
import model2_1.WellInterp;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellEventEquinorXLS {
    Set dataTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellEventEquinorXLS(SBdb ws, File file, char units, Set dataTypes) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        String unassignesSeqSchemeName;
        IGDScheme seqScheme;
        boolean COL_DEPTH = false;
        boolean COL_EVENT = true;
        int COL_AGE = 2;
        int COL_TYPE = 3;
        int COL_USERNAME = 4;
        int COL_CONFIDENCE = 5;
        int COL_COMMENTS = 6;
        String[] columnNames = new String[]{"Measured Depth", "Datum/Event", "Age", "Event Type", "User Name", "Confidence", "Comments"};
        int[] columnType = new int[]{0, 1, 2, 3, 4, 5, 6};
        boolean dataRows = false;
        int[] cols = null;
        this.dataTypes = dataTypes;
        char discID = 'N';
        String unassignedSchemeName = IGDInterval.getIGDName(3) + " (undefined)";
        IGDScheme scheme = ws.getIGDScheme(unassignedSchemeName, 3);
        if (scheme == null) {
            scheme = ws.addIGDScheme(3, unassignedSchemeName);
        }
        if ((seqScheme = ws.getIGDScheme(unassignesSeqSchemeName = IGDInterval.getIGDName(10) + " (undefined)", 10)) == null) {
            seqScheme = ws.addIGDScheme(10, unassignesSeqSchemeName);
        }
        WsWell well = ws.addWellToWorkspace(0, null);
        WellHeader wh = well.getHeader();
        wh.setWellUnits(units);
        well.loadInterps();
        WellInterp wellInterp = well.getAddInterp(ws.getInterp(0));
        wellInterp.getIntcoms(3);
        boolean hasBiocom = false;
        boolean hasChrono = false;
        boolean hasPicks = false;
        try (GridReader in = null;){
            in = GridReader.getGridReader((String)file.getPath(), null);
            while (in.nextRow()) {
                String cell;
                if (!dataRows) {
                    cell = in.getNextCell();
                    if (cell == null) continue;
                    if (cell.equalsIgnoreCase("Well Name")) {
                        cell = in.getNextCell();
                        wh.setWellName(cell);
                        continue;
                    }
                    if (cell.equalsIgnoreCase("API")) {
                        cell = in.getNextCell();
                        wh.setWellCode(cell);
                        continue;
                    }
                    if (!cell.startsWith(columnNames[0])) continue;
                    LinkedList<String> titles = new LinkedList<String>();
                    titles.add(cell);
                    while ((cell = in.getNextCell()) != null) {
                        titles.add(cell);
                    }
                    cols = new int[titles.size()];
                    block22: for (int i = 0; i < cols.length; ++i) {
                        cols[i] = -1;
                        for (int j = 0; j < columnNames.length; ++j) {
                            if (!((String)titles.get(i)).toUpperCase().startsWith(columnNames[j].toUpperCase())) continue;
                            cols[i] = columnType[j];
                            continue block22;
                        }
                    }
                    dataRows = true;
                    continue;
                }
                if (cols == null) {
                    throw new SBException("No column titles parsed - check sheet format");
                }
                int i = 0;
                Double depth = null;
                String eventType = null;
                String eventName = null;
                String analyst = null;
                String confidence = null;
                String comments = null;
                while ((cell = in.getNextCell()) != null) {
                    if (cell == null || cell.isEmpty()) {
                        ++i;
                        continue;
                    }
                    if (i >= cols.length) {
                        System.out.println("Line for cell: " + cell + " Exceeds titles length");
                        break;
                    }
                    switch (cols[i]) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            try {
                                depth = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 1: {
                            eventName = cell;
                            break;
                        }
                        case 3: {
                            eventType = cell;
                            break;
                        }
                        case 4: {
                            analyst = cell;
                            break;
                        }
                        case 5: {
                            confidence = cell;
                            break;
                        }
                        case 6: {
                            comments = cell;
                            break;
                        }
                    }
                    ++i;
                }
                if (depth == null || eventName == null) continue;
                int analystID = ws.getAddUserID(analyst != null ? analyst : "BIOS");
                Sample sample = well.getSample(DepthUtils.convToM((double)depth, (char)units), "CU", true);
                if (sample == null) {
                    sample = well.addSample(DepthUtils.convToM((double)depth, (char)units), SampleType.CU, null);
                }
                AgeConfidence conf = AgeConfidence.CONFIDENT;
                if (confidence != null) {
                    if (confidence.equalsIgnoreCase("Fair")) {
                        conf = AgeConfidence.PROBABLE;
                    } else if (confidence.equalsIgnoreCase("Poor")) {
                        conf = AgeConfidence.POSSIBLE;
                    }
                }
                if (analyst != null && analyst.equals("CHRON")) {
                    Object builder;
                    if (eventName.contains("00")) {
                        if (eventName.endsWith(" Top")) {
                            eventName = eventName.replace(" Top", "");
                        } else if (eventName.endsWith(" Base")) {
                            eventName = eventName.replace(" Base", "");
                        }
                        Surface surface = seqScheme.getSurface(eventName, null);
                        try {
                            if (surface == null) {
                                surface = seqScheme.addSurface(new Surface.Builder(ws).name(eventName).type(Surface.SurfaceType.parseType(eventName, Surface.SurfaceType.MFS)));
                            }
                            builder = new SQPick.Builder(ws, surface, sample, 3);
                            if (wellInterp.getSQPick(sample) != null) {
                                ((SQPick.Builder)builder).observed(false);
                            }
                            wellInterp.addSQPick(well, (SQPick.Builder)builder);
                            hasPicks = true;
                        }
                        catch (InvalidFieldException | SBPermissionException e) {
                            e.printStackTrace();
                        }
                    } else {
                        boolean zoneAssigned = false;
                        if (eventName.endsWith(" Top")) {
                            eventName = eventName.replace(" Top", "");
                        } else if (eventName.endsWith(" Base")) {
                            String newZoneName = eventName.replace(" Base", "");
                            List<IGDIntervalZone> zones = wellInterp.getIGDList(3);
                            for (IGDIntervalZone zone : zones) {
                                if (!zone.getUppInf().equalsIgnoreCase(newZoneName)) continue;
                                zone.baseSample = sample;
                                zoneAssigned = true;
                            }
                        }
                        if (!zoneAssigned) {
                            builder = new IGDIntervalZone.Builder(ws, 3, sample, sample, 7, scheme.getSchID()).uppInf(eventName);
                            try {
                                wellInterp.addZone((IGDIntervalZone.Builder)builder, well);
                                hasChrono = true;
                            }
                            catch (InvalidFieldException ife) {
                                System.out.println("Error inserting chrono interval: " + ife.toString());
                            }
                        }
                    }
                } else {
                    if (eventName.startsWith("FO ") || eventName.startsWith("LDO ")) {
                        eventType = "Base";
                        eventName = eventName.substring(eventName.indexOf(32) + 1);
                    } else if (eventName.startsWith("LO ") || eventName.startsWith("FDO ")) {
                        eventType = "Top";
                        eventName = eventName.substring(eventName.indexOf(32) + 1);
                    } else {
                        eventType = "Single";
                    }
                    SBEvent.EventType evType = SBEvent.EventType.getType(eventType);
                    SBEvent sbEvent = ws.getSBEvent(eventName);
                    if (sbEvent == null) {
                        try {
                            sbEvent = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(true).isSingle(evType == SBEvent.EventType.SINGLE));
                        }
                        catch (SBPermissionException e) {
                            throw new SBException(e.getMessage());
                        }
                    }
                    WellEvent.Builder eventBuilder = new WellEvent.Builder().sample(sample).event(sbEvent).type(evType).confidence(conf).comments(comments).source(analyst);
                    wellInterp.insertEvent(eventBuilder.build(ws));
                }
                if (comments == null || comments.isEmpty()) continue;
                List<Biocom> biocoms = wellInterp.getComments(discID);
                Biocom biocom = null;
                for (Biocom b : biocoms) {
                    if (b.getSample() != sample) continue;
                    biocom = b;
                    break;
                }
                if (biocom == null || biocom.getTopID() != sample.getSampID()) {
                    biocom = new Biocom.Builder(ws, Discipline.getDisc(discID), analystID, sample, comments.trim()).build();
                    wellInterp.insertBiocom(biocom);
                } else {
                    biocom.setText(biocom.getText() + "\n" + comments.trim());
                }
                if (biocom.getText().length() > 240) {
                    biocom.setText(biocom.getText().substring(0, 240));
                    System.out.println("Biostratigraphic Comments truncated");
                }
                hasBiocom = true;
            }
            dataTypes.add(16);
            dataTypes.add(1);
            if (hasChrono) {
                dataTypes.add(10);
            }
            if (hasBiocom) {
                dataTypes.add(5);
            }
            if (hasPicks) {
                dataTypes.add(14);
            }
        }
    }
}

