/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import model2_1.AgeConfidence;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.CompositeStandard;
import model2_1.CompositeStandardEvent;
import model2_1.EnvScheme;
import model2_1.Fault;
import model2_1.IGDColMap;
import model2_1.IGDHdr;
import model2_1.IGDInterval;
import model2_1.IGDIntervalEnv;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.IGDUnitBase;
import model2_1.Intcom;
import model2_1.InterpHdr;
import model2_1.LOC;
import model2_1.LOCNode;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.SQPick;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Surface;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Well;
import model2_1.WellEvent;
import model2_1.WellEventCompareDepth;
import model2_1.WsWell;
import model2_1.api.Discipline;
import model2_1.wellinterp.BiocomList;
import model2_1.wellinterp.FaultList;
import model2_1.wellinterp.IGDIntervalEnvList;
import model2_1.wellinterp.IGDIntervalZoneList;
import model2_1.wellinterp.InterpEdit;
import model2_1.wellinterp.InterpItem;
import model2_1.wellinterp.InterpList;
import model2_1.wellinterp.InterpListObserver;
import model2_1.wellinterp.InterpListViewer;
import model2_1.wellinterp.SQPickList;
import model2_1.wellinterp.WellEventList;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.SbugsNotifyingCompoundEdit;
import util.exception.StackError;
import util.status.DTMonitor;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class WellInterp
extends SBObservable
implements InterpListObserver {
    private static final Logger LOGGER = Logger.getLogger(WellInterp.class.getName());
    private final SBdb sbdb;
    private InterpHdr interp;
    final int interpID;
    private final HashMap<Integer, List<IGDIntervalZone>> zones = new HashMap();
    private final List<Biocom> comments;
    private final List<IGDIntervalEnv> envs;
    private final List<WellEvent> events;
    private LOC loc;
    private final HashMap<Integer, List<Intcom>> intcoms;
    public static final int[] intcomIgdTypes = new int[]{0, 3, 2, 4, 5};
    private List<IGDHdr> headers;
    HashMap<Integer, IGDColMap> colMap;
    private BiocomList commentsList;
    private IGDIntervalEnvList envList;
    private WellEventList eventList;
    private final FaultList faultList;
    private final SQPickList sqpickList;
    private IGDIntervalZoneList chronostratList;
    private IGDIntervalZoneList lithostratList;
    private IGDIntervalZoneList biozoneList;
    private boolean loaded;

    public InterpHdr getHeader() {
        return this.interp;
    }

    private HashSet<InterpList> getInterpLists() {
        HashSet<InterpList> lists = new HashSet<InterpList>();
        lists.add(this.faultList);
        lists.add(this.sqpickList);
        return lists;
    }

    private InterpList getInterpList(InterpItem t) {
        Class<?> clazz = t.getClass();
        if (clazz == Biocom.class) {
            return this.commentsList;
        }
        if (clazz == IGDIntervalEnv.class) {
            return this.envList;
        }
        if (clazz == WellEvent.class) {
            return this.eventList;
        }
        if (clazz == Fault.class) {
            return this.faultList;
        }
        if (clazz == SQPick.class) {
            return this.sqpickList;
        }
        if (clazz == IGDIntervalZone.class) {
            IGDIntervalZone zone = (IGDIntervalZone)t;
            switch (zone.getIGDType()) {
                case 3: {
                    return this.chronostratList;
                }
                case 2: {
                    return this.lithostratList;
                }
                case 4: {
                    return this.biozoneList;
                }
            }
        }
        return null;
    }

    private InterpList getInterpList(int igdType) {
        switch (igdType) {
            case 19: {
                return this.commentsList;
            }
            case 5: {
                return this.envList;
            }
            case 20: {
                return this.eventList;
            }
            case 24: {
                return this.faultList;
            }
            case 21: {
                return this.sqpickList;
            }
            case 3: {
                return this.chronostratList;
            }
            case 2: {
                return this.lithostratList;
            }
            case 4: {
                return this.biozoneList;
            }
        }
        return null;
    }

    private InterpList getInterpListWithDataType(int dataType) {
        try {
            int igdType = IGDIntervalZone.dType2IGDtype(dataType);
            return this.getInterpList(igdType);
        }
        catch (SBException ex) {
            return null;
        }
    }

    public InterpListViewer getInterpListViewer(int igdType) {
        return this.getInterpListViewer(igdType, 0);
    }

    public InterpListViewer getInterpListViewer(int igdType, final int schID) {
        final InterpList interpList = this.getInterpList(igdType);
        if (schID > 0 && !(interpList instanceof IGDIntervalZoneList) && !(interpList instanceof SQPickList)) assert (false);
        return new InterpListViewer(){

            public InterpItem get(int row) {
                return interpList.getItem(schID, row);
            }

            @Override
            public int size() {
                return interpList.getItems(schID).size();
            }
        };
    }

    @Override
    public void interpListChanged(InterpItem notifier) {
        this.setChanged();
        this.notifyObservers(notifier);
    }

    public void insert(InterpItem t) {
        this.getInterpList(t).insert(t);
    }

    public void delete(Collection<? extends InterpItem> items, int wellID) throws SQLException, SBException, SBPermissionException {
        if (items.isEmpty()) {
            return;
        }
        InterpItem item = items.iterator().next();
        if (item instanceof IGDIntervalZone) {
            int igdType = ((IGDIntervalZone)item).getIGDType();
            for (InterpItem interpItem : items) {
                IGDIntervalZone zone = (IGDIntervalZone)interpItem;
                if (zone.getIGDType() == igdType) continue;
                throw new SBException("Zones for deletion must have the same IGD type");
            }
        }
        if (wellID > 0 && !this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBPermissionException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete " + (String)(items.size() > 1 ? item.getItemDescPlural() : item.getItemDesc() + "from"), "well", true));
        }
        this.getInterpList(item).delete(items, wellID, this.sbdb);
        if (item instanceof IGDIntervalZone) {
            for (InterpItem interpItem : items) {
                IGDIntervalZone iGDIntervalZone = (IGDIntervalZone)interpItem;
                for (Sample sample : this.sbdb.getWell(wellID).getSamples()) {
                    if (!(sample.getDepth() >= iGDIntervalZone.getTopSample().getDepth()) || !(sample.getDepth() <= iGDIntervalZone.getBaseSample().getDepth())) continue;
                    sample.getStratigraphy(this, true);
                }
            }
        }
        this.setChanged();
    }

    public String toString() {
        if (this.interp == null) {
            return "Null Interp";
        }
        return this.interp.toString();
    }

    WellInterp(SBdb SB2, int interpID, HashMap<Integer, InterpHdr> interps, char sectionType, boolean loaded) throws SQLException {
        this.zones.put(3, new LinkedList());
        this.zones.put(2, new LinkedList());
        this.zones.put(4, new LinkedList());
        this.comments = new LinkedList<Biocom>();
        this.envs = new LinkedList<IGDIntervalEnv>();
        this.events = new LinkedList<WellEvent>();
        this.intcoms = new HashMap();
        this.headers = null;
        this.colMap = new HashMap();
        this.loaded = false;
        this.sbdb = SB2;
        this.interpID = interpID;
        this.interp = interps.get(interpID);
        if (this.interp == null) {
            this.interp = new InterpHdr(SB2, interpID);
            interps.put(interpID, this.interp);
        }
        this.loaded = loaded;
        this.faultList = new FaultList(interpID, this);
        this.sqpickList = new SQPickList(interpID, this);
    }

    WellInterp(SBdb ws, WellInterp wellInterp, InterpHdr hdr) {
        this.zones.put(3, new LinkedList());
        this.zones.put(2, new LinkedList());
        this.zones.put(4, new LinkedList());
        this.comments = new LinkedList<Biocom>();
        this.envs = new LinkedList<IGDIntervalEnv>();
        this.events = new LinkedList<WellEvent>();
        this.intcoms = new HashMap();
        this.headers = null;
        this.colMap = new HashMap();
        this.loaded = false;
        this.interpID = wellInterp.interpID;
        this.interp = hdr;
        this.sbdb = ws;
        this.sqpickList = null;
        this.faultList = null;
    }

    public IGDColMap getColMap(int wellID, int igdType) throws SQLException {
        IGDColMap map = this.colMap.get(igdType);
        if (map == null) {
            map = new IGDColMap(this.sbdb, wellID, this.interpID, igdType);
            this.colMap.put(igdType, map);
        }
        return map;
    }

    public void fillWorkspace(WsWell wsWell, boolean checkSamples, InterpItem ... items) throws SQLException, SBException {
        if (items == null || items.length == 0) {
            return;
        }
        assert (wsWell.getInterp(this.interpID) == this);
        if (this.getInterpList(items[0]) == null) {
            throw new IllegalArgumentException("Generic fillWorkspace not implemented for item type " + items[0].getClass().getName());
        }
        try {
            this.getInterpList(items[0]).fill(this.sbdb, wsWell, checkSamples, Arrays.asList(items));
        }
        catch (SBPermissionException pe) {
            throw new SBException("", (Throwable)pe);
        }
    }

    void fillWorkspace(Set<Integer> dataTypes, WellInterp dbInterp, WsWell wsWell, Well well) throws SBException, SQLException, SBPermissionException {
        block9: for (int dType : dataTypes) {
            InterpList interpList;
            if (!SBdb.isInterpDataType(dType)) continue;
            if (!dbInterp.loaded) {
                dbInterp.load(well);
            }
            if ((interpList = this.getInterpListWithDataType(dType)) != null) {
                interpList.fill(this.sbdb, wsWell, !dataTypes.contains(1), dbInterp.getInterpListWithDataType(dType).getItems());
                continue;
            }
            switch (dType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    List<IGDIntervalZone> igdList = dbInterp.getIGDList(IGDInterval.dType2IGDtype(dType));
                    this.fillIntervals(wsWell, !dataTypes.contains(1), igdList.toArray(new IGDIntervalZone[igdList.size()]));
                    continue block9;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.fillBiocoms(wsWell, dbInterp.getComments(SBdb.dt2discID(dType)), !dataTypes.contains(1));
                    continue block9;
                }
                case 15: {
                    this.fillEnvs(wsWell, dbInterp.envs, !dataTypes.contains(1));
                    continue block9;
                }
                case 18: {
                    this.fillIntcoms(wsWell, dbInterp.getAllIntcoms());
                    continue block9;
                }
                case 16: {
                    this.fillEvents(wsWell, !dataTypes.contains(1), dbInterp.getEvents().toArray(new WellEvent[dbInterp.getEvents().size()]));
                    continue block9;
                }
                case 17: {
                    this.fillLOC(dbInterp);
                    continue block9;
                }
                case 14: 
                case 27: {
                    assert (false);
                    continue block9;
                }
            }
            throw new SBException("Can't process data type in WellInterp.fillWorkspace: " + dType);
        }
    }

    private void checkSamples(Sample topSample, Sample baseSample, WsWell wsWell) throws SQLException, SBException {
        if (topSample != null && !wsWell.hasSample(topSample)) {
            wsWell.addSampleCopy(null, topSample);
        }
        if (baseSample != null && !wsWell.hasSample(baseSample)) {
            wsWell.addSampleCopy(null, baseSample);
        }
    }

    public void fillLOC(WellInterp dbInterp) throws SBException, SQLException {
        if (dbInterp.loc != null) {
            this.loc = new LOC(this.sbdb, dbInterp.loc);
        }
    }

    public void fillBiocoms(WsWell wsWell, List<Biocom> dbBiocoms, boolean checkSamples) throws SBException, SQLException {
        assert (wsWell.getInterp(this.interpID) == this);
        for (Biocom biocom : dbBiocoms) {
            if (checkSamples) {
                this.checkSamples(biocom.getTopSample(), biocom.getBaseSample(), wsWell);
            }
            if (this.hasBiocom(biocom)) continue;
            Biocom wsBiocom = Biocom.copyToWorkspace(this.sbdb, biocom, wsWell);
            this.insertBiocom(wsBiocom);
        }
    }

    public void fillEvents(WsWell wsWell, boolean checkSamples, WellEvent ... dbEvents) throws SQLException, SBException {
        assert (wsWell.getInterp(this.interpID) == this);
        for (WellEvent event : dbEvents) {
            if (checkSamples) {
                this.checkSamples(event.getSample(), null, wsWell);
            }
            if (this.hasEvent(event)) continue;
            this.copyToWorkspace(event, wsWell.getLink().getDataModel(), wsWell);
        }
    }

    public void fillEnvs(WsWell wsWell, List<IGDIntervalEnv> envs, boolean checkSamples) throws SQLException, SBException {
        assert (wsWell.getInterp(this.interpID) == this);
        for (IGDIntervalEnv env : envs) {
            if (checkSamples) {
                this.checkSamples(env.getTopSample(), env.getBaseSample(), wsWell);
            }
            if (this.hasEnv(env)) continue;
            try {
                IGDIntervalEnv wsZone = new IGDIntervalEnv(this.sbdb, env, (Well)wsWell);
                this.insertEnv(wsZone);
            }
            catch (SBPermissionException pe) {
                throw new SBException("Unexpected permission exception in workspace", (Throwable)pe);
            }
        }
    }

    public void fillIntervals(WsWell wsWell, boolean checkSamples, IGDIntervalZone ... zones) throws SQLException, SBException {
        assert (wsWell.getInterp(this.interpID) == this);
        for (IGDIntervalZone zone : zones) {
            if (checkSamples) {
                this.checkSamples(zone.getTopSample(), zone.getBaseSample(), wsWell);
            }
            if (this.hasZone(zone, zone.igdType)) continue;
            IGDIntervalZone wsZone = new IGDIntervalZone(this.sbdb, zone, (Well)wsWell);
            this.insertZone(wsZone);
        }
    }

    public void fillIntcoms(WsWell wsWell, List<Intcom> zones) throws SQLException, SBException {
        assert (wsWell.getInterp(this.interpID) == this);
        for (Intcom intcom : zones) {
            Intcom wsIntcom = new Intcom(this.sbdb, intcom);
            this.getIntcoms(wsIntcom.getIGDType());
            this.insert(wsIntcom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinAge(IGDScheme scheme) throws SBException, SQLException {
        double age = -1.0;
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            for (List<IGDIntervalZone> list : this.zones.values()) {
                for (IGDIntervalZone zone : list) {
                    IGDUnit unit;
                    if (zone.getSchID() != scheme.getSchID() || (unit = scheme.findUnit(zone.getUppZone())) == null || !(age < 0.0) && !(unit.getUage() < age)) continue;
                    age = unit.getUage();
                }
            }
        }
        return age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxAge(IGDScheme scheme) throws SBException, SQLException {
        double age = -1.0;
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            for (List<IGDIntervalZone> list : this.zones.values()) {
                for (IGDIntervalZone zone : list) {
                    IGDUnit unit;
                    if (zone.getSchID() != scheme.getSchID()) continue;
                    int zoneID = zone.getLowZone();
                    if (zoneID <= 0) {
                        zoneID = zone.getUppZone();
                    }
                    if ((unit = scheme.findUnit(zoneID)) == null || !(age < 0.0) && !(unit.getLage() > age)) continue;
                    age = unit.getLage();
                }
            }
        }
        return age;
    }

    private void deleteZones(int igdType, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        List<IGDIntervalZone> igdList = this.getIGDList(igdType);
        if (igdList != null) {
            igdList.clear();
        }
        this.setChanged();
    }

    IGDHdr getHeader(int wellID, int schID, boolean create) throws SBException, SQLException {
        if (this.headers == null) {
            this.loadHeaders(wellID);
        }
        Iterator<IGDHdr> it = this.headers.iterator();
        IGDHdr hdr = null;
        while (it.hasNext()) {
            hdr = it.next();
            if (hdr.getSchID() == schID) {
                return hdr;
            }
            hdr = null;
        }
        if (create) {
            throw new SBException("Attempt to create IGD header");
        }
        return hdr;
    }

    void loadHeaders(int wellID) throws SQLException, SBException {
        if (this.headers == null) {
            this.headers = new LinkedList<IGDHdr>();
        }
        IGDHdr.load(this.sbdb, wellID, this.interpID, this.headers);
    }

    synchronized void refreshHeaders(Statement stmt, Well well) throws SQLException, SBException {
        if (this.headers != null) {
            IGDHdr.refresh(stmt, this.sbdb, well.getWellID(), this.interpID, this.headers);
        }
    }

    public void deleteIGDHdr(int wellID, IGDHdr hdr) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete version notes", "well", true));
        }
        hdr.delete(wellID, this.interpID);
        this.headers.remove(hdr);
    }

    public void removeIGDHdr(int schID) {
        if (this.headers != null) {
            Iterator<IGDHdr> it = this.headers.iterator();
            while (it.hasNext()) {
                if (it.next().getSchID() != schID) continue;
                it.remove();
            }
        }
    }

    public IGDHdr updateIGDHdr(int wellID, IGDHdr hdr, String comments, String source, String authorised) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "edit version note", "well", true));
        }
        hdr.delete(wellID, this.interpID);
        this.headers.remove(hdr);
        Audit audit = new Audit();
        audit.created = hdr.getCreated();
        audit.creator = hdr.getCreator();
        IGDHdr newHdr = new IGDHdr(this.sbdb, hdr.getSchID(), source, authorised, comments, audit);
        newHdr.store(wellID, this.interpID);
        this.addHeader(wellID, newHdr);
        return newHdr;
    }

    public IGDHdr addIGDHdr(int wellID, int schID, String comments, String source, String authorised) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add version note", "well", true));
        }
        IGDHdr hdr = new IGDHdr(this.sbdb, schID, source, authorised, comments, new Audit());
        hdr.store(wellID, this.interpID);
        this.addHeader(wellID, hdr);
        return hdr;
    }

    void addHeader(int wellID, IGDHdr hdr) throws SBException, SQLException {
        if (this.getHeader(wellID, hdr.getSchID(), false) != null) {
            throw new SBException("Attempt to add header that already exists");
        }
        this.headers.add(hdr);
    }

    public List<IGDHdr> getHeaders(int wellID) throws SBException, SQLException {
        if (this.headers == null) {
            this.loadHeaders(wellID);
        }
        return this.headers;
    }

    void refresh(Statement stmt, Well well) throws SBException, SQLException {
        if (this.loaded) {
            well.getSamples();
            for (InterpList interpList : this.getInterpLists()) {
                interpList.refresh(this.sbdb, stmt, well);
            }
            this.refreshComments(stmt, well);
            for (Integer igdType : this.zones.keySet()) {
                this.refreshZones(stmt, igdType, well, 0);
            }
            this.refreshHeaders(stmt, well);
            this.refreshEnvs(stmt, well);
            this.refreshEvents(stmt, well);
            this.refreshIntcoms(stmt, well);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Well well) throws SBException, SQLException {
        if (!this.loaded && this.sbdb.isConnected()) {
            LOGGER.log(Level.CONFIG, "{0} : {1} : LOADING...", new Object[]{well, this});
            Iterator<Object> iterator = this.getInterpLists().iterator();
            while (iterator.hasNext()) {
                InterpList interpList;
                InterpList interpList2 = interpList = iterator.next();
                synchronized (interpList2) {
                    interpList.load(well);
                }
            }
            LOGGER.config("Loading interp zones...");
            for (Integer igdType : this.zones.keySet()) {
                this.loadZones(igdType, well);
            }
            LOGGER.config("Loading headers...");
            this.loadHeaders(well.getWellID());
            LOGGER.config("Loading interp comments...");
            this.loadComments('\u0000', well);
            LOGGER.config("Loading interp envs...");
            this.loadEnvs(well);
            LOGGER.config("Loading interp events...");
            this.loadEvents(well);
            LOGGER.config("Loading interval comments...");
            this.loadIntcoms(well);
            this.loaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshEvents(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded) {
            return;
        }
        Object sql = "SELECT ev_id,samp_id,ev_type,updated  FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + this.interpID;
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
        WellEvent notifier = null;
        HashSet<CallSite> keys = new HashSet<CallSite>();
        List<WellEvent> list = this.events;
        synchronized (list) {
            while (rs.next()) {
                int evID = rs.getInt("ev_id");
                int sampID = rs.getInt("samp_id");
                SBEvent.EventType type = SBEvent.EventType.getType(rs.getString("ev_type"));
                String key = sampID + "," + evID + "," + type.name();
                keys.add((CallSite)((Object)key));
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (WellEvent s : this.events) {
                    if (!(s.getSampID() + "," + s.getEvent().getEvID() + "," + s.getTypeObj().name()).equals(key)) continue;
                    found = true;
                    if (time == null || s.getUpdated() != null && !time.after(s.getUpdated())) break;
                    notifier = s = WellEvent.load(this.sbdb, well, this.interpID, evID, sampID, type, s);
                    break;
                }
                if (found) continue;
                WellEvent event = WellEvent.load(this.sbdb, well, this.interpID, evID, sampID, type, null);
                this.insertEvent(event);
                notifier = event;
            }
            if (keys.size() < this.events.size()) {
                Iterator<WellEvent> it = this.events.iterator();
                while (it.hasNext()) {
                    WellEvent s = it.next();
                    if (keys.contains(s.getSampID() + "," + s.getEvent().getEvID() + "," + s.getTypeObj().name())) continue;
                    it.remove();
                    if (notifier != null) continue;
                    notifier = s;
                }
            }
            if (notifier != null) {
                this.setChanged();
                this.notifyObservers(notifier);
            }
        }
        sql = "SELECT updated ";
        sql = (String)sql + " FROM " + this.sbdb.DBTableName("LOC") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + this.interpID;
        sql = this.sbdb.modQuery((String)sql);
        rs = stmt.executeQuery((String)sql);
        boolean doNotify = false;
        if (rs.next()) {
            if (this.loc == null) {
                this.loc = new LOC(this.sbdb, well.getWellID(), this.interpID);
                doNotify = true;
            } else {
                Timestamp time = rs.getTimestamp("updated");
                if (time != null && time.after(this.loc.getUpdated())) {
                    System.out.println("Creating new LOC in wellInterp");
                    this.loc = new LOC(this.sbdb, well.getWellID(), this.interpID);
                    doNotify = true;
                }
            }
        }
        if (doNotify) {
            this.setChanged();
            System.out.println("Notifying in wellInterp.refresh");
            this.notifyObservers((Object)this.loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEvents(Well well) throws SQLException, SBException {
        List<WellEvent> list = this.events;
        synchronized (list) {
            if (!this.events.isEmpty() || this.loaded) {
                assert (false);
                return;
            }
            Object sql = "SELECT ev_id,samp_id,ev_type,disc_id,analyst,qualifier,comments,source,company,confidence,";
            if (this.sbdb.hasEventErrRange()) {
                sql = (String)sql + "depthplus,depthminus,";
            }
            sql = (String)sql + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
                while (rs.next()) {
                    WellEvent.Builder builder = new WellEvent.Builder();
                    builder.event(this.sbdb.getSBEvent(rs.getInt("ev_id")));
                    builder.sample(well.getSample(rs.getInt("samp_id")));
                    builder.type(SBEvent.EventType.getType(rs.getString("ev_type")));
                    String strg = rs.getString("disc_id");
                    if (strg != null) {
                        builder.discID(Discipline.getDisc(strg.charAt(0)));
                    }
                    builder.analyst(rs.getInt("analyst"));
                    builder.qualifier(rs.getString("qualifier"));
                    builder.comments(rs.getString("comments"));
                    builder.source(rs.getString("source"));
                    builder.company(rs.getString("company"));
                    builder.confidence(AgeConfidence.getConfidence(rs.getInt("confidence")));
                    if (this.sbdb.hasEventErrRange()) {
                        double f = rs.getDouble("depthplus");
                        if (!rs.wasNull()) {
                            builder.errPlus(f);
                        }
                        f = rs.getDouble("depthminus");
                        if (!rs.wasNull()) {
                            builder.errMinus(f);
                        }
                    }
                    builder.audit(new Audit(rs));
                    builder.status = SbugsStatus.STORED;
                    try {
                        this.insertEvent(builder.build(this.sbdb));
                    }
                    catch (RuntimeException e) {
                        StackError.showStackError((String)("Error loading well event: " + e.getMessage()), (Exception)e);
                    }
                }
                sql = "SELECT std_id,red,green,blue,linewidth,comments," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("LOC") + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
                rs = stmt.executeQuery((String)(sql = this.sbdb.modQuery((String)sql)));
                if (rs.next()) {
                    int stdID = rs.getInt("std_id");
                    int r = rs.getInt("red");
                    int g = rs.getInt("green");
                    int b = rs.getInt("blue");
                    Color colour = new Color(r, g, b);
                    float lineWidth = rs.getFloat("linewidth");
                    String comment = rs.getString("comments");
                    this.loc = new LOC(this.sbdb, stdID, this.interpID, well.getWellID(), colour, lineWidth, comment, new Audit(rs));
                }
            }
        }
    }

    public WellEvent addEvent(Well well, Sample sample, SBEvent event, SBEvent.EventType eventType, Discipline discID, String analyst, String comment, String qualifier, String source, String company, AgeConfidence confidence, Double errPlus, Double errMinus) throws SBException, SQLException, InvalidFieldException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "add event", "well", true));
        }
        for (WellEvent we : this.getEventsByDepth()) {
            if (we.getSampID() == sample.getSampID() && we.getSbEvent().getEvID() == event.getEvID() && we.getTypeObj() == eventType) {
                throw new InvalidFieldException("Event '" + we + "' already exists");
            }
            if (!(we.getSample().getDepth() > sample.getDepth())) continue;
            break;
        }
        WellEvent.Builder builder = new WellEvent.Builder().type(eventType).sample(sample).event(event).discID(discID).analyst(this.sbdb.getUserID(analyst));
        builder.comments(comment).qualifier(qualifier).source(source).company(company).confidence(confidence);
        if (errPlus != null) {
            builder.errPlus(errPlus);
        }
        if (errMinus != null) {
            builder.errMinus(errMinus);
        }
        WellEvent wellEvent = builder.build(this.sbdb, well.getWellID(), this.interpID);
        this.insertEvent(wellEvent);
        this.setChanged();
        return wellEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellEvent updateEvent(WellEvent original, WellEvent.Builder builder, int wellID) throws InvalidFieldException, SQLException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update event", "well", true));
        }
        for (WellEvent we : this.getEventsByDepth()) {
            if (we != original && we.getSampID() == builder.getSample().getSampID() && we.getSbEvent().getEvID() == builder.getSBEvent().getEvID() && we.getCharType() == builder.getType()) {
                throw new InvalidFieldException("This event already exists");
            }
            if (!(we.getSample().getDepth() > builder.getSample().getDepth())) continue;
            break;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            original.delete(wellID, this.interpID, stmt);
        }
        WellEvent newEvent = builder.build(this.sbdb, wellID, this.interpID);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            newEvent.getAudit().sqlUpdate(this.sbdb, stmt, false);
        }
        List<WellEvent> list = this.events;
        synchronized (list) {
            this.events.remove(original);
            this.insertEvent(newEvent);
        }
        this.setChanged();
        return newEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEvents(Collection<WellEvent> toDelete, int wellID) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, stmt)) {
                    throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete events", "well", true));
                }
                for (WellEvent wellEvent : toDelete) {
                    wellEvent.delete(wellID, this.interpID, stmt);
                }
            }
            this.sbdb.updateAuditTrail("WELLEVENT", "DELETE " + toDelete.size() + " from " + this.sbdb.getWell(wellID) + " (" + this.sbdb.getInterp(this.interpID) + ")");
        }
        List<WellEvent> list = this.events;
        synchronized (list) {
            this.events.removeAll(toDelete);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEvents(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        List<WellEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void insertEvent(WellEvent event) throws SBException {
        if (event == null || event.getSample() == null) {
            throw new IllegalArgumentException("Attempt to insert null event or event with null sample: " + event);
        }
        Iterator<WellEvent> it = this.events.iterator();
        int i = 0;
        List<WellEvent> list = this.events;
        synchronized (list) {
            while (it.hasNext()) {
                WellEvent current = it.next();
                if (event.getSampID() == current.getSampID() && event.getEvent().getEvID() == current.getEvent().getEvID() && event.getTypeObj() == current.getTypeObj() && event.getSampID() > 0 && event.getEvent().getEvID() > 0) {
                    throw new SBException("Attempt to insert duplicate event: " + event);
                }
                if (event.getSortEntry().compareToIgnoreCase(current.getSortEntry()) < 0) {
                    this.events.add(i, event);
                    this.setChanged();
                    return;
                }
                ++i;
            }
            this.events.add(event);
        }
        this.setChanged();
    }

    private void copyToWorkspace(WellEvent dbEvent, SBdb db, Well wsWell) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy WellEvent to workspace when connected");
        }
        WellEvent.Builder builder = WellEvent.Builder.copyOf(dbEvent);
        Audit audit = new Audit(dbEvent.getAudit());
        audit.fillWorkspace(db, this.sbdb);
        builder.audit(audit);
        builder.sample(wsWell.getSample(dbEvent.getSample().getSampID()));
        builder.event(this.sbdb.fillEvent(db, dbEvent.getEvent()));
        int analyst = dbEvent.getAnalyst();
        if (analyst > 0) {
            this.sbdb.fillUser(db, analyst);
            builder.analyst(analyst);
        }
        WellEvent event = builder.build(this.sbdb);
        event.status = SbugsStatus.STORED;
        this.insertEvent(event);
    }

    public List<Fault> getFaults() {
        return this.faultList.getItems();
    }

    public List<WellEvent> getEvents() {
        return this.events;
    }

    public List<WellEvent> getEventsByDepth() {
        this.getEvents();
        Collections.sort(this.events, new WellEventCompareDepth(true));
        return this.events;
    }

    public void deleteLOC(int wellID) throws SQLException, SBException {
        if (this.loc != null && this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete depth/age curve", "well", true));
            }
            this.loc.delete(wellID, this.interpID);
            this.setChanged();
        }
        this.loc = null;
    }

    public LOC getLOC() {
        return this.loc;
    }

    public SbugsCompoundEdit deleteLOCNode(LOCNode node, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (this.loc != null && this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete depth/age node", "well", true));
            }
            SbugsCompoundEdit edit = this.loc.deleteNode(wellID, this.interpID, node);
            this.setChanged();
            return edit;
        }
        return null;
    }

    public LOC.LOCNodeEdit addLOCNode(int bnd, double depth, double csu, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (this.loc != null && this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add depth/age node", "well", true));
            }
            LOC.LOCNodeEdit edit = this.loc.addNode(bnd, depth, csu, wellID, this.interpID);
            this.setChanged();
            return edit;
        }
        return null;
    }

    public void loadLOC(int wellID) throws SQLException, SBException {
        if (this.loc != null) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Object sql = "SELECT std_id,red,green,blue,linewidth,comments," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("LOC") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
            sql = this.sbdb.modQuery((String)sql);
            ResultSet rs = stmt.executeQuery((String)sql);
            if (rs.next()) {
                int stdID = rs.getInt("std_id");
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                Color colour = new Color(r, g, b);
                float lineWidth = rs.getFloat("linewidth");
                String comment = rs.getString("comments");
                this.loc = new LOC(this.sbdb, stdID, this.interpID, wellID, colour, lineWidth, comment, new Audit(rs));
            }
        }
    }

    public void addLOC(Well well, CompositeStandard cmpStd, double csu1, double depth1, double csu2, double depth2) throws SBException, SQLException {
        if (this.loc != null) {
            throw new IllegalArgumentException("Attempt to create new depth/age curve for well interpretation when it already exists");
        }
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "add depth/age curve", "well", true));
        }
        this.loc = new LOC(this.sbdb, cmpStd, well.getWellID(), this.interpID, depth1, depth2, csu1, csu2);
        boolean first = true;
        for (Sample sample : well.getSamples()) {
            if (sample.getAge(this.interpID) == null || !(Math.abs(sample.getAge(this.interpID)) > (double)0.0029f) && !first) continue;
            this.loc.addNode(sample.getDepth(), sample.getAge(this.interpID), 3, well.getWellID(), this.interpID, true);
            first = false;
        }
        this.setChanged();
        this.notifyObservers((Object)this.loc);
    }

    public void deriveLOC(IGDScheme scheme, Well well, CompositeStandard cmpStd) throws SQLException, SBException {
        if (scheme == null) {
            throw new IllegalArgumentException("No Interpretation Scheme selected");
        }
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "derive depth/age curve", "well", true));
        }
        if (this.loc != null) {
            throw new IllegalArgumentException("Attempt to create new depth/age curve for well interpretation when it already exists");
        }
        this.loc = new LOC(this.sbdb, cmpStd != null ? cmpStd.getStdID() : 0, this.interpID, well.getWellID(), Color.BLACK, 1.0f);
        this.loc.store(well.getWellID(), this.interpID);
        if (scheme.getIGDType() == 10) {
            this.deriveLOCfromSQpicks(scheme, well);
        } else {
            this.deriveLOCfromIntervals(scheme, well);
        }
        this.loc.setUncf(well.getWellID(), this.interpID);
        this.setChanged();
        this.notifyObservers((Object)this.loc);
    }

    private void deriveLOCfromIntervals(IGDScheme scheme, Well well) throws SQLException, SBException {
        List<IGDIntervalZone> list = this.getIGDList(scheme.getIGDType(), scheme.getSchID(), 1, IGDIntervalZone.getNHier(scheme.getIGDType(), true));
        double lastDepth = -1.0;
        double lastCsu = -1.0;
        int lastHier = -1;
        class DepthAge {
            double depth;
            double age;

            DepthAge(double d1, double d2) {
                this.depth = d1;
                this.age = d2;
            }
        }
        LinkedList<DepthAge> nodeList = new LinkedList<DepthAge>();
        for (IGDIntervalZone zone : list) {
            if (zone.getSchID() != scheme.getID()) continue;
            IGDUnitBase uppUnit = scheme.findUnitBase(zone.getUppZone());
            IGDUnitBase lowUnit = scheme.findUnitBase(zone.getLowZone());
            if (uppUnit == null) continue;
            if (lowUnit == null) {
                lowUnit = uppUnit;
            }
            if (!(Math.abs(uppUnit.getUage() - uppUnit.getLage()) > 0.0)) continue;
            double lowDepth = zone.getTopSample().getDepth();
            if (uppUnit.getUage() < lastCsu && lowUnit.getLage() >= lastCsu && uppUnit.getHier() == lastHier) {
                nodeList.remove(nodeList.size() - 1);
            } else if (lowDepth > lastDepth || Math.abs(lastCsu - uppUnit.getUage()) > 0.001) {
                nodeList.add(new DepthAge(lowDepth, uppUnit.getUage()));
            }
            lastDepth = zone.getBaseSample().getDepth();
            lastCsu = lowUnit.getLage();
            lastHier = uppUnit.getHier();
            nodeList.add(new DepthAge(lastDepth, lastCsu));
        }
        Iterator it = nodeList.iterator();
        DepthAge last = null;
        while (it.hasNext()) {
            DepthAge d = (DepthAge)it.next();
            this.loc.addNode(d.depth, d.age, 3, well.getWellID(), this.interpID, false);
            last = d;
        }
    }

    private void deriveLOCfromSQpicks(IGDScheme scheme, Well well) throws SQLException {
        List<SQPick> list = this.getSQPicks(scheme.getSchID());
        double lastDepth = -1.0;
        double lastCsu = -1.0;
        for (SQPick pick : list) {
            if (!pick.isObserved()) continue;
            double depth = pick.getSample().getDepth();
            if (depth > lastDepth || Math.abs(lastCsu - pick.getSurface().getAge()) > 0.001) {
                this.loc.addNode(depth, pick.getSurface().getAge(), 3, well.getWellID(), this.interpID, false);
            }
            lastDepth = depth;
            lastCsu = pick.getSurface().getAge();
        }
    }

    public UndoableEdit updateLOCNode(LOCNode node, double depth, double age, int bnd, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update depth/age node", "well", true));
        }
        UndoableEdit edit = null;
        try {
            edit = this.loc.updateNode(depth, age, bnd, node, wellID, this.interpID);
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers((Object)this.loc);
        return edit;
    }

    public UndoableEdit updateLOCDisconf(double oldDepth, double newDepth, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update depth/age node", "well", true));
        }
        UndoableEdit edit = null;
        try {
            edit = this.loc.updateDisconf(oldDepth, newDepth, wellID, this.interpID);
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers((Object)this.loc);
        return edit;
    }

    public UndoableEdit updateLOCNodeBnd(LOCNode node, IGDIntervalZone.Boundary boundary, int wellID) throws SBException, SQLException, InvalidFieldException {
        if (this.getLOC() == null) {
            throw new InvalidFieldException("No LOC");
        }
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update depth/age node boundary", "well", true));
        }
        int bnd = boundary.getBndInt();
        if (node.getBnd() == bnd) {
            return null;
        }
        Iterator<LOCNode> nodeIt = this.loc.getNodeIterator();
        while (nodeIt.hasNext()) {
            LOCNode locNode = nodeIt.next();
            if (locNode != node) continue;
            if (IGDIntervalZone.isDisconformableBnd(bnd)) {
                if (!nodeIt.hasNext()) {
                    throw new InvalidFieldException("Cannot set disconfirmity at last node");
                }
                LOCNode nextNode = nodeIt.next();
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > 2.0) {
                    throw new InvalidFieldException("Unconformity can only be set between horizontal nodes");
                }
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > (double)0.001f) {
                    return this.updateLOCNode(locNode, nextNode.getDepth(), locNode.getAge(), bnd, wellID);
                }
            }
            return this.updateLOCNode(locNode, locNode.getDepth(), locNode.getAge(), bnd, wellID);
        }
        return null;
    }

    public int generateEvents(Well well, List<AnalystHeader> suites, boolean inFDO, boolean inLDO, Set<SampleType> sampleTypes, Double depthFrom, Double depthTo, Set<Discipline> discs, boolean incRW, boolean incCV, boolean incQuestionable, CompositeStandard std, boolean useSynonym, int synSch, List<SBEvent.Builder> nonInserts, boolean insertComments) throws SQLException, SBException, SBPermissionException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(well.getDeniedReason(this.sbdb, "generate events", "well", true));
        }
        well.loadAnalyses();
        if (std != null) {
            std.loadEvents();
        }
        HashMap<Integer, Smpdtl> bases = new HashMap<Integer, Smpdtl>();
        LinkedList<WellEvent> stored = new LinkedList<WellEvent>();
        stored.addAll(this.events);
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        for (Sample sample : well.getSamples()) {
            if (!sampleTypes.contains((Object)sample.getType()) || depthFrom != null && sample.getDepth() < depthFrom || depthTo != null && sample.getDepth() > depthTo) continue;
            for (Object object : sample.analyses) {
                Smpdtl smpdtl = (Smpdtl)((Object)object);
                if (suites != null && !suites.contains(smpdtl.getHeader()) || !discs.contains((Object)smpdtl.getDiscipline())) continue;
                smpdtls.add(smpdtl);
            }
        }
        EnumMap<Discipline, Sample> firstAnalysedSampleForDiscipline = new EnumMap<Discipline, Sample>(Discipline.class);
        EnumMap<Discipline, Sample> lastAnalysedSampleForDiscipline = new EnumMap<Discipline, Sample>(Discipline.class);
        block2: for (Discipline discipline : discs) {
            for (Smpdtl smpdtl : smpdtls) {
                if (smpdtl.getDiscipline() != discipline) continue;
                firstAnalysedSampleForDiscipline.put(discipline, smpdtl.getSample());
                break;
            }
            ListIterator listIterator = smpdtls.listIterator(smpdtls.size());
            while (listIterator.hasPrevious()) {
                Smpdtl smpdtl = (Smpdtl)((Object)listIterator.previous());
                if (smpdtl.getDiscipline() != discipline) continue;
                lastAnalysedSampleForDiscipline.put(discipline, smpdtl.getSample());
                continue block2;
            }
        }
        for (Smpdtl smpdtl : smpdtls) {
            smpdtl.load(well.getWellID());
            Iterator<TaxonOcc> iterator = smpdtl.getOccurIterator();
            while (iterator.hasNext()) {
                SBEvent event;
                Object builder;
                boolean genBase;
                boolean genTop;
                TaxonOcc taxonOcc = iterator.next();
                if (taxonOcc.getReworked() && !incRW || taxonOcc.getCaved() && !incCV || taxonOcc.getQuestionable() && !incQuestionable) continue;
                boolean bl = genTop = std == null;
                if (!inFDO) {
                    genTop = false;
                }
                boolean bl2 = genBase = std == null;
                if (!inLDO) {
                    genBase = false;
                }
                SBEvent topEvent = null;
                SBEvent baseEvent = null;
                if (std != null) {
                    for (CompositeStandardEvent evt : std.getEvents()) {
                        Taxon taxon = evt.getEvent().getTaxon();
                        if (taxon == null || !evt.getEvent().isGenerate() || taxon.getSpecID() != taxonOcc.getSpecID() && (!useSynonym || taxon != this.sbdb.getPreferredTerm(synSch, taxonOcc.getSpecID()))) continue;
                        if (evt.getEvType() == 'F' && inFDO) {
                            genTop = true;
                            topEvent = evt.getEvent();
                            continue;
                        }
                        if (evt.getEvType() != 'L' || !inLDO) continue;
                        genBase = true;
                        baseEvent = evt.getEvent();
                    }
                }
                for (WellEvent wellEvent : stored) {
                    if (wellEvent.getEvent().getSpecID() != taxonOcc.getSpecID() && (!useSynonym || wellEvent.getEvent().getTaxon() == null || wellEvent.getEvent().getTaxon() != this.sbdb.getPreferredTerm(synSch, taxonOcc.getSpecID()))) continue;
                    if (wellEvent.getCharType() == 'F') {
                        genTop = false;
                        continue;
                    }
                    if (wellEvent.getCharType() != 'L') continue;
                    genBase = false;
                }
                String eventName = taxonOcc.getTaxon().toString(false, false);
                if (genTop) {
                    if (topEvent == null && (topEvent = this.sbdb.getSBEventGenerate(taxonOcc.getTaxon().getSpecID())) == null) {
                        builder = new SBEvent.Builder().name(eventName).taxon(taxonOcc.getTaxon());
                        if (insertComments) {
                            ((SBEvent.Builder)builder).desc("Generated from well data");
                        }
                        ((SBEvent.Builder)builder).isGenerate(true).isSingle(false);
                        event = this.sbdb.getSBEvent(eventName);
                        if (event != null) {
                            nonInserts.add((SBEvent.Builder)builder);
                            continue;
                        }
                        topEvent = this.sbdb.addSBEvent((SBEvent.Builder)builder);
                    }
                    builder = new WellEvent.Builder().event(topEvent).sample(smpdtl.getSample()).type(SBEvent.EventType.TOP).discID(Discipline.getDisc(smpdtl.getDiscID())).analyst(this.sbdb.getUserID(smpdtl.getAnalyst()));
                    if (insertComments) {
                        ((WellEvent.Builder)builder).comments((String)(std != null ? "Generated using: " + std : ""));
                    }
                    if (firstAnalysedSampleForDiscipline.get((Object)smpdtl.getDiscipline()) == smpdtl.getSample()) {
                        ((WellEvent.Builder)builder).confidence(AgeConfidence.POSSIBLE);
                    }
                    stored.add(((WellEvent.Builder)builder).build(this.sbdb, well.getWellID(), this.interpID));
                }
                if (!genBase) continue;
                if (baseEvent == null && (baseEvent = this.sbdb.getSBEventGenerate(taxonOcc.getTaxon().getSpecID())) == null) {
                    builder = new SBEvent.Builder().name(eventName).taxon(taxonOcc.getTaxon());
                    if (insertComments) {
                        ((SBEvent.Builder)builder).desc("Generated from well data");
                    }
                    ((SBEvent.Builder)builder).isGenerate(true).isSingle(false);
                    event = this.sbdb.getSBEvent(eventName);
                    if (event != null) {
                        nonInserts.add((SBEvent.Builder)builder);
                        continue;
                    }
                    baseEvent = this.sbdb.addSBEvent((SBEvent.Builder)builder);
                }
                if (bases.get(baseEvent.getEvID()) != null) {
                    bases.remove(baseEvent.getEvID());
                }
                bases.put(baseEvent.getEvID(), smpdtl);
            }
        }
        Set baseSet = bases.entrySet();
        for (Map.Entry entry : baseSet) {
            Smpdtl smpdtl = (Smpdtl)((Object)entry.getValue());
            WellEvent.Builder builder = new WellEvent.Builder().event(this.sbdb.getSBEvent((Integer)entry.getKey())).sample(smpdtl.getSample()).type(SBEvent.EventType.BASE).discID(Discipline.getDisc(smpdtl.getDiscID())).analyst(this.sbdb.getUserID(smpdtl.getAnalyst()));
            if (insertComments) {
                builder.comments((String)(std != null ? "Generated using: " + std : ""));
            }
            if (lastAnalysedSampleForDiscipline.get((Object)smpdtl.getDiscipline()) == smpdtl.getSample()) {
                builder.confidence(AgeConfidence.POSSIBLE);
            }
            stored.add(builder.build(this.sbdb, well.getWellID(), this.interpID));
        }
        int n = stored.size() - this.events.size();
        this.events.clear();
        for (WellEvent wellEvent : stored) {
            this.insertEvent(wellEvent);
        }
        return n;
    }

    public void generateEventsFromComments(List<Biocom> toUse, CompositeStandard cmpStd, Well well) throws SBException, SQLException, InvalidFieldException {
        if (toUse.isEmpty()) {
            return;
        }
        if (!this.comments.containsAll(toUse)) {
            throw new IllegalStateException("Using wrong interp to parse events");
        }
        HashMap<String, CompositeStandardEvent> map = new HashMap<String, CompositeStandardEvent>();
        HashMap<CallSite, CompositeStandardEvent> abrMap = new HashMap<CallSite, CompositeStandardEvent>();
        cmpStd.loadEvents();
        for (CompositeStandardEvent e : cmpStd.getEvents()) {
            String name = e.getEvent().getName().toUpperCase();
            map.put(name, e);
            String[] split = name.split(" ");
            if (split.length != 2) continue;
            abrMap.put((CallSite)((Object)(split[0].charAt(0) + ". " + split[1])), e);
        }
        WellEvent notifier = null;
        for (Biocom biocom : toUse) {
            String[] tokens;
            for (String token : tokens = biocom.getText().split(",")) {
                SBEvent.EventType type;
                String[] smallTokens = (token = token.trim()).split(" ");
                if (smallTokens.length < 2 || (type = SBEvent.EventType.parseType(smallTokens[0])) == null) continue;
                CompositeStandardEvent e = (CompositeStandardEvent)map.get((token = token.substring(smallTokens[0].length()).trim().toUpperCase()).trim());
                if (e == null) {
                    e = (CompositeStandardEvent)abrMap.get(token);
                }
                if (e == null) {
                    for (String key : map.keySet()) {
                        if (!key.startsWith(token)) continue;
                        e = (CompositeStandardEvent)map.get(key);
                        break;
                    }
                }
                if (e == null) {
                    for (String key : abrMap.keySet()) {
                        if (!key.startsWith(token)) continue;
                        e = (CompositeStandardEvent)abrMap.get(key);
                        break;
                    }
                }
                if (e == null) {
                    char[] brackets = new char[]{'(', '[', '{'};
                    boolean wasStripped = false;
                    for (char bracket : brackets) {
                        if (token.indexOf(bracket) <= 0 || token.indexOf(bracket) >= token.length() - 5) continue;
                        token = token.substring(0, token.indexOf(bracket)).trim();
                        wasStripped = true;
                    }
                    if (!wasStripped) continue;
                    e = (CompositeStandardEvent)map.get(token);
                }
                if (e == null) continue;
                notifier = this.addEvent(well, biocom.getSample(), e.getEvent(), type, null, null, "Generated from comments", null, null, null, AgeConfidence.CONFIDENT, null, null);
                System.out.println("Added event: " + notifier);
            }
        }
        if (notifier != null) {
            this.notifyObservers(notifier);
        }
    }

    public List<Intcom> getIntcoms() {
        return this.getIntcoms(0);
    }

    public int getInterpId() {
        return this.interpID;
    }

    public List<Intcom> getAllIntcoms() {
        LinkedList<Intcom> list = new LinkedList<Intcom>();
        for (int i : this.intcoms.keySet()) {
            list.addAll((Collection<Intcom>)this.intcoms.get(i));
        }
        return list;
    }

    public List<Intcom> getIntcoms(int igdType) {
        if (this.intcoms.get(igdType) != null) {
            return this.intcoms.get(igdType);
        }
        for (int i = 0; i < intcomIgdTypes.length && igdType != intcomIgdTypes[i]; ++i) {
            if (i != intcomIgdTypes.length - 1) continue;
            throw new IllegalArgumentException("Illegal Intcom type: " + igdType);
        }
        LinkedList<Intcom> list = new LinkedList<Intcom>();
        this.intcoms.put(igdType, list);
        return list;
    }

    public List<SQPick> getSQPicks() {
        return this.sqpickList.getItems();
    }

    public List<SQPick> getSQPicks(int schID) {
        LinkedList<SQPick> p = new LinkedList<SQPick>();
        for (SQPick pick : this.sqpickList.getItems()) {
            if (pick.getSurface().getSchID() != schID) continue;
            p.add(pick);
        }
        return p;
    }

    synchronized void refreshIntcoms(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded) {
            return;
        }
        for (Map.Entry<Integer, List<Intcom>> entry : this.intcoms.entrySet()) {
            if (entry.getValue() == null) continue;
            List<Intcom> intcomList = entry.getValue();
            int igdType = entry.getKey();
            String sql = "SELECT top_depth,updated FROM " + this.sbdb.DBTableName("INTCMMNTS") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + this.interpID + " AND igd_type=" + igdType;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            Intcom notifier = null;
            HashSet<CallSite> keys = new HashSet<CallSite>();
            while (rs.next()) {
                double topDepth = rs.getDouble("top_depth");
                String key = "" + Math.round(topDepth * 100.0);
                keys.add((CallSite)((Object)key));
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (Intcom o : intcomList) {
                    String oKey = "" + Math.round(o.getTopDepth() * 100.0);
                    if (!oKey.equals(key)) continue;
                    found = true;
                    if (time == null || !time.after(o.getUpdated())) break;
                    notifier = o = Intcom.load(this.sbdb, well.getWellID(), this.interpID, igdType, topDepth, o);
                    break;
                }
                if (found) continue;
                notifier = Intcom.load(this.sbdb, well.getWellID(), this.interpID, igdType, topDepth, null);
                Intcom.insert(intcomList, notifier);
            }
            if (keys.size() < intcomList.size()) {
                Iterator<Intcom> it = intcomList.iterator();
                while (it.hasNext()) {
                    Intcom o = it.next();
                    String oKey = "" + Math.round(o.getTopDepth() * 100.0);
                    if (keys.contains(oKey)) continue;
                    it.remove();
                    if (notifier != null) continue;
                    notifier = o;
                }
            }
            if (notifier == null) continue;
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIntcoms(Well well) throws SQLException {
        int[] nArray = intcomIgdTypes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer igdType = nArray[i];
            if (this.intcoms.get(igdType) == null) {
                this.intcoms.put(igdType, new LinkedList());
            } else assert (false);
            List<Intcom> list = this.intcoms.get(igdType);
            synchronized (list) {
                this.intcoms.get(igdType).clear();
                Intcom.load(this.intcoms.get(igdType), this.sbdb, well.getWellID(), this.interpID, igdType);
                continue;
            }
        }
    }

    private void insertPick(SQPick pick) {
        this.sqpickList.insert(pick);
    }

    public SQPick addSQPick(Well well, Sample sample, Surface surface, String informal, boolean questionable, int bndInt) throws InvalidFieldException, SQLException, SBException, SBPermissionException {
        SQPick.Builder pickBuilder = new SQPick.Builder(this.sbdb, surface, sample, bndInt).informalName(informal).questionable(questionable).observed(true);
        return this.addSQPick(well, pickBuilder);
    }

    public SQPick addSQPick(Well well, SQPick.Builder builder) throws InvalidFieldException, SQLException, SBPermissionException, SBException {
        if (this.sbdb.isConnected() && !well.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(well.getDeniedReason(this.sbdb, "add sequence pick", "well", true));
        }
        SQPick newPick = this.sqpickList.add(well, builder, this.sbdb);
        this.setChanged();
        return newPick;
    }

    public InterpEdit<SQPick> updateSQPick(SQPick original, Well well, SQPick.Builder builder) throws InvalidFieldException, SQLException, SBException, SBPermissionException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(well.getDeniedReason(this.sbdb, "update sequence pick", "well", true));
        }
        InterpEdit<SQPick> edit = this.sqpickList.update(original, well.getWellID(), builder, this.sbdb);
        this.setChanged();
        return edit;
    }

    public InterpEdit<SQPick> updateSQPick(Well well, Sample originalSample, Sample newSample) throws InvalidFieldException, SQLException, SBException, SBPermissionException {
        if (originalSample == newSample) {
            return null;
        }
        SQPick original = null;
        for (SQPick pick : this.getSQPicks()) {
            if (pick.getSample() != originalSample) continue;
            original = pick;
            break;
        }
        if (original == null) {
            throw new InvalidFieldException("No pick found at " + originalSample);
        }
        SQPick.Builder pickBuilder = SQPick.Builder.copyOf(original, newSample);
        return this.updateSQPick(original, well, pickBuilder);
    }

    public BiocomEdit addBiocom(Biocom.Builder builder, int wellID) throws InvalidFieldException, SQLException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add comment", "well", true));
        }
        for (Biocom bc : this.comments) {
            if (bc.getTopID() != builder.getTopSample().getSampID() || bc.getDiscID() != builder.getDiscID() || bc.getAnalyst() != builder.getAnalyst()) continue;
            throw new InvalidFieldException("A comment of this discipline/depth/analyst already exists");
        }
        BiocomEdit edit = new BiocomEdit(wellID, null, builder);
        edit.doEdit();
        return edit;
    }

    final void insertBiocom(Biocom biocom) {
        Iterator<Biocom> en = this.comments.iterator();
        int i = 0;
        while (en.hasNext()) {
            Biocom current = en.next();
            if (current.compareTo(biocom) > 0) {
                this.comments.add(i, biocom);
                return;
            }
            ++i;
        }
        this.comments.add(biocom);
    }

    public Fault addFault(Well well, Sample sample, IGDIntervalZone.Boundary bnd, double faultThrow, String label) throws SQLException, InvalidFieldException, SBPermissionException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(well.getDeniedReason(this.sbdb, "add disconformity", "well", true));
        }
        Fault newFault = this.faultList.add(well, sample, bnd, faultThrow, label, this.sbdb);
        this.setChanged();
        return newFault;
    }

    public Fault updateFault(Well well, Fault original, Sample sample, IGDIntervalZone.Boundary bnd, double faultThrow, String label, boolean updateIntervals) throws SQLException, InvalidFieldException, SBPermissionException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBPermissionException(well.getDeniedReason(this.sbdb, "update fault", "well", true));
        }
        Fault newFault = this.faultList.update(well.getWellID(), original, sample, bnd, faultThrow, label, this.sbdb);
        this.setChanged();
        if (updateIntervals) {
            HashSet<Integer> igdTypes = new HashSet<Integer>();
            for (List<IGDIntervalZone> list : this.zones.values()) {
                for (IGDIntervalZone zone : list) {
                    if (zone.getTopSample() == sample && zone.getTopBndInt() != bnd.getBndInt()) {
                        zone.setTopBnd(this.sbdb, well.getWellID(), this.interpID, zone.igdType, bnd.getBndInt());
                        igdTypes.add(zone.igdType);
                    }
                    if (zone.getBaseSample() != sample || zone.getBaseBndInt() == bnd.getBndInt()) continue;
                    zone.setBaseBnd(this.sbdb, well.getWellID(), this.interpID, zone.igdType, bnd.getBndInt());
                    igdTypes.add(zone.igdType);
                }
            }
            for (Integer igdType : igdTypes) {
                this.setChanged();
                this.notifyObservers(igdType);
            }
        }
        return newFault;
    }

    public boolean checkUpdateDisconfBndType(Fault fault, IGDIntervalZone.Boundary newBnd) {
        for (List<IGDIntervalZone> list : this.zones.values()) {
            for (IGDIntervalZone zone : list) {
                if (zone.getTopSample() == fault.getSample() && zone.getTopBndInt() != newBnd.getBndInt()) {
                    return true;
                }
                if (zone.getBaseSample() != fault.getSample() || zone.getBaseBndInt() == newBnd.getBndInt()) continue;
                return true;
            }
        }
        return false;
    }

    public Biocom updateBiocom(Biocom biocom, int wellID, Discipline discID, Sample topSample, Sample baseSample, String analyst, String dataSource, String text) throws SQLException, InvalidFieldException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update comment", "well", true));
        }
        for (Biocom bc : this.comments) {
            if (bc == biocom || bc.getTopID() != topSample.getSampID() || bc.getDiscipline() != discID || bc.getAnalyst() != this.sbdb.getUser(analyst).getUsrID()) continue;
            throw new InvalidFieldException("A comment of this discipline/depth/analyst already exists");
        }
        biocom.delete(wellID, this.interpID);
        Biocom b = new Biocom.Builder(this.sbdb, discID, this.sbdb.getUser(analyst).getUsrID(), topSample, text).source(dataSource).baseSample(baseSample).build(wellID, this.interpID);
        this.comments.remove(biocom);
        this.insertBiocom(b);
        this.setChanged();
        return biocom;
    }

    public BiocomEdit updateBiocom(Biocom original, Biocom.Builder builder, int wellID) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update comment", "well", true));
        }
        if (original != null && (original.getAnalyst() != builder.getAnalyst() || original.getTopSample().getSampID() != builder.getTopSample().getSampID() || original.getDiscID() != builder.getDiscID())) {
            for (Biocom bc : this.comments) {
                if (bc.getTopID() != builder.getTopSample().getSampID() || bc.getDiscipline() != builder.getDiscipline() || bc.getAnalyst() != builder.getAnalyst()) continue;
                throw new SBException("A comment of this discipline/depth/analyst already exists");
            }
        }
        BiocomEdit edit = new BiocomEdit(wellID, original, builder);
        edit.doEdit();
        return edit;
    }

    public void deleteBiocoms(Collection<Biocom> biocoms, int wellID) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete biostratigraphic comment" + (biocoms.size() > 1 ? "s" : ""), "well", true));
            }
            for (Biocom biocom : biocoms) {
                biocom.delete(wellID, this.interpID);
            }
            this.sbdb.updateAuditTrail("BIOCOM", "DELETE " + biocoms.size() + " from " + this.sbdb.getWell(wellID) + " (" + this.sbdb.getInterp(this.interpID) + ")");
        }
        this.comments.removeAll(biocoms);
        this.setChanged();
    }

    public BiocomEdit deleteBiocom(Biocom biocom, int wellID) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete biostratigraphic comment", "well", true));
        }
        BiocomEdit edit = new BiocomEdit(wellID, biocom, null);
        edit.doEdit();
        String auditComment = biocom.getText().length() < 80 ? biocom.getText() : biocom.getText().substring(0, 77) + "...";
        this.sbdb.updateAuditTrail("BIOCOM", "DELETE '" + auditComment + "' from " + this.sbdb.getWell(wellID) + " (" + this.sbdb.getInterp(this.interpID) + ")");
        this.sbdb.commit();
        return edit;
    }

    private void deleteBiocoms(int wellID, char discID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID + "AND disc_id='" + discID + "'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID) continue;
            this.comments.remove(comment);
        }
        this.setChanged();
    }

    public int getBoundaryAtSample(int igdType, Sample sample) {
        for (IGDIntervalZone zone : this.getIGDList(igdType)) {
            if (zone.getBaseSample() == sample) {
                return zone.getBaseBndInt();
            }
            if (zone.getTopSample() != sample) continue;
            return zone.getTopBndInt();
        }
        for (Fault fault : this.getFaults()) {
            if (fault.getSample() != sample) continue;
            return fault.getBnd().getBndInt();
        }
        return -1;
    }

    public IGDIntervalZone addZone(IGDIntervalZone.Builder builder, Well well) throws InvalidFieldException, SBException, SQLException {
        IGDIntervalZone zone;
        this.checkOverlap(builder, null, true);
        if (this.sbdb != null && this.sbdb.isConnected()) {
            if (!well.canWrite(this.sbdb, null)) {
                throw new SBException(well.getDeniedReason(this.sbdb, "add interval", "well", true));
            }
            zone = builder.build(well.getWellID(), this.interpID);
        } else {
            zone = builder.build();
        }
        this.insertZone(zone);
        for (Sample sample : well.getSamples()) {
            if (!(sample.getDepth() >= builder.topSample.getDepth()) || !(sample.getDepth() <= builder.baseSample.getDepth())) continue;
            sample.getStratigraphy(this, true);
        }
        this.setChanged();
        return zone;
    }

    public IGDIntervalEnv addEnvInterval(IGDIntervalEnv.Builder builder, int wellID) throws InvalidFieldException, SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add environment", "well", true));
        }
        this.checkOverlap(builder.topSample, builder.baseSample, null);
        EnvEdit edit = new EnvEdit(wellID, null, builder);
        edit.doEdit();
        return edit.getEnv();
    }

    public EnvEdit updateEnvInterval(IGDIntervalEnv original, IGDIntervalEnv.Builder builder, int wellID) throws SQLException, InvalidFieldException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update environment", "well", true));
        }
        this.checkOverlap(builder.topSample, builder.baseSample, original);
        EnvEdit edit = new EnvEdit(wellID, original, builder);
        edit.doEdit();
        return edit;
    }

    public UndoableEdit updateEnvBoundary(Sample oldSample, Sample newSample, int wellID) throws SBException, SQLException, InvalidFieldException {
        Object edit;
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update environment", "well", true));
        }
        IGDIntervalEnv moveTop = null;
        IGDInterval moveBase = null;
        for (IGDIntervalEnv env : this.envs) {
            if (env.getTopSample() == oldSample && env.getBaseSample() == oldSample) {
                if (newSample.getDepth() < oldSample.getDepth()) {
                    moveTop = env;
                    break;
                }
                moveBase = env;
                break;
            }
            if (env.getTopSample() == oldSample) {
                moveTop = env;
                continue;
            }
            if (env.getBaseSample() == oldSample) {
                moveBase = env;
            }
            if (moveTop == null || moveBase == null) continue;
            break;
        }
        if (moveTop == null && moveBase == null) {
            System.out.println("Cannot find env interval to update");
            return null;
        }
        if (moveTop != null ^ moveBase != null) {
            edit = moveTop != null ? this.updateEnvInterval(moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID) : this.updateEnvInterval((IGDIntervalEnv)moveBase, IGDIntervalEnv.Builder.copyOf((IGDIntervalEnv)moveBase, moveBase.getTopSample(), newSample), wellID);
        } else {
            boolean moveDown;
            edit = new SbugsCompoundEdit("Update env boundary");
            boolean bl = moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
            if (moveDown) {
                if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                    throw new InvalidFieldException("New top is below base");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, (IGDIntervalEnv)moveBase, IGDIntervalEnv.Builder.copyOf((IGDIntervalEnv)moveBase, moveBase.getTopSample(), newSample))));
            } else {
                if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                    throw new InvalidFieldException("New base is above top");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, (IGDIntervalEnv)moveBase, IGDIntervalEnv.Builder.copyOf((IGDIntervalEnv)moveBase, moveBase.getTopSample(), newSample))));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()))));
            }
            ((SbugsCompoundEdit)edit).doEdits();
        }
        return edit;
    }

    public IGDIntervalZone updateZone(IGDIntervalZone original, IGDIntervalZone.Builder builder, Well well, boolean syncBnd) throws InvalidFieldException, SBException, SQLException {
        return this.updateZone(original, builder, well, syncBnd, false);
    }

    public IGDIntervalZone updateZone(IGDIntervalZone original, IGDIntervalZone.Builder builder, Well well, boolean syncBnd, boolean preserveModified) throws InvalidFieldException, SBException, SQLException {
        IGDScheme scheme;
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "update interval boundary", "well", true));
        }
        boolean boundaryChange = false;
        if (builder.getTopBndInt() != original.getTopBndInt() || builder.getBaseBndInt() != original.getBaseBndInt()) {
            if (builder.topSample.getSampID() == builder.baseSample.getSampID()) {
                if (builder.getTopBndInt() == builder.getBaseBndInt()) {
                    boundaryChange = true;
                }
            } else {
                boundaryChange = true;
            }
        }
        this.checkOverlap(builder, original, false);
        builder.audit.created = original.getCreated();
        builder.audit.creator = original.getCreator();
        if (preserveModified) {
            builder.audit.modified = original.getModified();
            builder.audit.modifier = original.getModifier();
        }
        original.delete(well.getWellID(), this.interpID, null);
        IGDIntervalZone zone = builder.build(well.getWellID(), this.interpID);
        this.sbdb.commit();
        this.removeZone(original);
        this.insertZone(zone);
        for (Sample sample : well.getSamples()) {
            if (!(sample.getDepth() >= zone.getTopSample().getDepth() && sample.getDepth() <= zone.getBaseSample().getDepth()) && (!(sample.getDepth() >= original.getTopSample().getDepth()) || !(sample.getDepth() <= original.getBaseSample().getDepth()))) continue;
            sample.getStratigraphy(this, true);
        }
        if (boundaryChange && (scheme = this.sbdb.getIGDScheme(builder.getSchID())) != null && scheme.toString().toLowerCase().contains("confidence")) {
            boundaryChange = false;
        }
        if (boundaryChange) {
            List<IGDIntervalZone> list = this.getIGDList(builder.igdType);
            for (IGDIntervalZone z : list) {
                if (z.getSchemeName().toLowerCase().contains("confidence") || z.getSchID() != builder.getSchID() && !syncBnd) continue;
                if (z.getTopID() == builder.topSample.getSampID() && z.getTopBndInt() != builder.getTopBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setTopBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getTopBndInt());
                    if (z.isSpotZone()) {
                        z.setBaseBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getTopBndInt());
                    }
                }
                if (z.getBaseID() == builder.topSample.getSampID() && z.getBaseBndInt() != builder.getTopBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setBaseBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getTopBndInt());
                    if (z.isSpotZone()) {
                        z.setTopBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getTopBndInt());
                    }
                }
                if (z.getBaseID() == builder.baseSample.getSampID() && z.getBaseBndInt() != builder.getBaseBndInt() && (!z.isSpotZone() || z.isSpotZone() && z.getTopBndInt() == z.getBaseBndInt())) {
                    z.setBaseBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getBaseBndInt());
                    if (z.isSpotZone()) {
                        z.setTopBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getBaseBndInt());
                    }
                }
                if (z.getTopID() != builder.baseSample.getSampID() || z.getTopBndInt() == builder.getBaseBndInt() || z.isSpotZone() && (!z.isSpotZone() || z.getTopBndInt() != z.getBaseBndInt())) continue;
                z.setTopBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getBaseBndInt());
                if (!z.isSpotZone()) continue;
                z.setBaseBnd(this.sbdb, well.getWellID(), this.interpID, builder.igdType, builder.getBaseBndInt());
            }
        }
        this.setChanged();
        return zone;
    }

    public UndoableEdit updateIntervalBoundary(Sample oldSample, Sample newSample, int wellID, int igdType, int schID) throws InvalidFieldException, SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update interval boundary", "well", true));
        }
        boolean moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
        Iterator<IGDIntervalZone> it = this.getIGDList(igdType, schID).iterator();
        IGDIntervalZone[] moveTops = new IGDIntervalZone[IGDIntervalZone.getNHier(igdType, true)];
        IGDIntervalZone[] moveBases = new IGDIntervalZone[IGDIntervalZone.getNHier(igdType, true)];
        while (it.hasNext()) {
            IGDIntervalZone zone = it.next();
            if (zone.getTopSample() == oldSample && (zone.getTopSample() != zone.getBaseSample() || !moveDown) && zone.getBaseSample().getDepth() >= newSample.getDepth()) {
                moveTops[zone.getHier() - 1] = zone;
            }
            if (zone.getBaseSample() != oldSample || zone.getTopSample() == zone.getBaseSample() && !moveDown || !(zone.getTopSample().getDepth() <= newSample.getDepth())) continue;
            moveBases[zone.getHier() - 1] = zone;
        }
        SbugsNotifyingCompoundEdit edit = new SbugsNotifyingCompoundEdit("Update interval boundary", (SBObservable)this, (Object)igdType);
        try {
            for (int i = 0; i < moveTops.length; ++i) {
                IGDIntervalZone moveTop = moveTops[i];
                IGDIntervalZone moveBase = moveBases[i];
                if (moveTop == null && moveBase == null) continue;
                if (moveTop != null ^ moveBase != null) {
                    if (moveTop != null) {
                        edit.addEdit((UndoableEdit)((Object)this.updateInterval(moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID, false)));
                        continue;
                    }
                    edit.addEdit((UndoableEdit)((Object)this.updateInterval(moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), wellID, false)));
                    continue;
                }
                IGDIntervalZone.Builder firstBuilder = null;
                IGDIntervalZone firstZone = null;
                IGDIntervalZone.Builder secondBuilder = null;
                IGDIntervalZone secondZone = null;
                if (moveDown) {
                    if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                        throw new InvalidFieldException("New top is below base");
                    }
                    firstZone = moveTop;
                    firstBuilder = IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample());
                    secondZone = moveBase;
                    secondBuilder = IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample);
                } else {
                    if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                        throw new InvalidFieldException("New base is above top");
                    }
                    firstZone = moveBase;
                    firstBuilder = IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample);
                    secondZone = moveTop;
                    secondBuilder = IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample());
                }
                this.checkOverlap(firstBuilder, firstZone, false);
                ZoneEdit firstEdit = new ZoneEdit(wellID, firstZone, firstBuilder, false);
                firstEdit.redo();
                edit.addEdit((UndoableEdit)((Object)firstEdit));
                this.checkOverlap(secondBuilder, secondZone, false);
                ZoneEdit secondEdit = new ZoneEdit(wellID, secondZone, secondBuilder, false);
                secondEdit.redo();
                edit.addEdit((UndoableEdit)((Object)secondEdit));
            }
            this.notifyObservers(igdType);
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            if (edit.canRedo()) {
                edit.undo();
            }
            throw e;
        }
        edit.end();
        return edit;
    }

    private ZoneEdit updateInterval(IGDIntervalZone original, IGDIntervalZone.Builder builder, int wellID, boolean notify) throws SQLException, InvalidFieldException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update interval", "well", true));
        }
        this.checkOverlap(builder, original, false);
        Boolean topSample = null;
        if (builder.topSample != original.getTopSample()) {
            topSample = true;
        } else if (builder.getBaseSample() != original.getBaseSample()) {
            topSample = false;
        }
        if (topSample != null) {
            List<IGDIntervalZone> list = this.getIGDList(original.igdType, original.igdType == 4 ? original.getSchID() : 0);
            for (IGDIntervalZone zone : list) {
                int builderBnd;
                if (zone == original) continue;
                Sample builderSample = topSample != false ? builder.topSample : builder.baseSample;
                int n = builderBnd = topSample != false ? builder.getTopBndInt() : builder.getBaseBndInt();
                if (zone.getTopSample() == builderSample && zone.getTopBndInt() != builderBnd) {
                    if (topSample.booleanValue()) {
                        builder.topBnd(zone.getTopBndInt());
                    } else {
                        builder.baseBnd(zone.getTopBndInt());
                    }
                }
                if (zone.getBaseSample() != builderSample || zone.getBaseBndInt() == builderBnd) continue;
                if (topSample.booleanValue()) {
                    builder.topBnd(zone.getBaseBndInt());
                    continue;
                }
                builder.baseBnd(zone.getBaseBndInt());
            }
        }
        ZoneEdit edit = new ZoneEdit(wellID, original, builder, notify);
        edit.doEdit();
        return edit;
    }

    public void checkOverlap(IGDIntervalZone.Builder zone, IGDIntervalZone original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        List<IGDIntervalZone> list = this.getIGDList(zone.igdType, 0);
        WellInterp.checkOverlap(list, zone, original, checkBoundaries);
    }

    public static IGDIntervalZone checkOverlap(List<IGDIntervalZone> zones, IGDIntervalZone.Builder zone, IGDIntervalZone original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        if (zone.topSample == null || zone.baseSample == null) {
            throw new SBException("Zone passed to checkOverlap has null top/base sample: " + zone);
        }
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (IGDIntervalZone compareWith : zones) {
            if (compareWith == original || compareWith.getHier() != zone.getHier()) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            if (zone.igdType == 4 && zone.getSchID() != compareWith.getSchID()) continue;
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting interval : " + zone.getName() + " " + sbe.getMessage() + " " + compareWith.toString());
            }
            if (!checkBoundaries) continue;
            if (cBD == nzTD && compareWith.getBaseBndInt() != zone.getTopBndInt()) {
                throw new InvalidFieldException(zone.toString() + " New interval boundary clashes with: " + compareWith.toString());
            }
            if (cTD != nzBD || compareWith.getTopBndInt() == zone.getBaseBndInt()) continue;
            throw new InvalidFieldException(zone.toString() + " New interval boundary clashes with: " + compareWith.toString());
        }
        return zone.build();
    }

    public static IGDIntervalEnv checkOverlap(List<IGDIntervalEnv> zones, IGDIntervalEnv.Builder zone, IGDIntervalEnv original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        if (zone.topSample == null || zone.baseSample == null) {
            throw new SBException("Zone passed to checkOverlap has null top/base sample: " + zone);
        }
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (IGDIntervalEnv compareWith : zones) {
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting interval : " + zone.toString() + " " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
        return zone.build();
    }

    public void checkOverlap(Sample topSample, Sample baseSample, IGDIntervalEnv original) throws InvalidFieldException {
        int nzTD = (int)(topSample.getDepth('M') * 100.0);
        int nzBD = (int)(baseSample.getDepth('M') * 100.0);
        for (IGDIntervalEnv compareWith : this.envs) {
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting palaeoenvironment: " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
    }

    private void checkOverlap(Intcom.Builder intcomBuilder, Intcom original) throws InvalidFieldException {
        int nzTD = (int)(intcomBuilder.getTopDepth() * 100.0);
        int nzBD = (int)(intcomBuilder.getBaseDepth() * 100.0);
        for (Intcom intcom : this.intcoms.get(intcomBuilder.igdType)) {
            Intcom compareWith = intcom;
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.getTopDepth() * 100.0);
            int cBD = (int)(compareWith.getBaseDepth() * 100.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                String compareWithString = compareWith.toString().length() > 90 ? compareWith.toString().substring(0, 89) + "..." : compareWith.toString();
                throw new InvalidFieldException("Error inserting interval: " + sbe.getMessage() + " " + compareWithString);
            }
        }
    }

    public void deleteZones(Well well, Collection<IGDIntervalZone> toDelete) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!well.canWrite(this.sbdb, stmt)) {
                    throw new SBException(well.getDeniedReason(this.sbdb, "delete intervals", "well", true));
                }
                for (IGDIntervalZone zone : toDelete) {
                    zone.delete(well.getWellID(), this.interpID, stmt);
                }
            }
            this.sbdb.updateAuditTrail("IGDINTERVAL", "DELETE " + toDelete.size() + " from " + well + " (" + this.sbdb.getInterp(this.interpID) + ")");
        }
        for (IGDIntervalZone zone : toDelete) {
            this.removeZone(zone);
            for (Sample sample : well.getSamples()) {
                if (!(sample.getDepth() >= zone.getTopSample().getDepth()) || !(sample.getDepth() <= zone.getBaseSample().getDepth())) continue;
                sample.getStratigraphy(this, true);
            }
        }
    }

    public void deleteEnvs(Collection<IGDIntervalEnv> toDelete, int wellID) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete environment" + (toDelete.size() > 1 ? "s" : ""), "well", true));
            }
            for (IGDIntervalEnv env : toDelete) {
                env.delete(wellID, this.interpID);
            }
            this.sbdb.updateAuditTrail("ENV", "DELETE " + toDelete.size() + " from " + this.sbdb.getWell(wellID) + " (" + this.sbdb.getInterp(this.interpID) + ")");
        }
        this.envs.removeAll(toDelete);
        this.setChanged();
    }

    private void deleteEnvs(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.envs.clear();
        this.setChanged();
    }

    private void removeZone(IGDIntervalZone zone) {
        List<IGDIntervalZone> list = this.getIGDList(zone.igdType, 0);
        if (list.remove(zone)) {
            this.setChanged();
        }
    }

    public void insertEnv(IGDIntervalEnv.Builder builder) {
        this.insertEnv(builder.build());
    }

    final void insertEnv(IGDIntervalEnv zone) {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv insertPoint = this.envs.get(i);
            if (zone.topSample == null) break;
            if (!(zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M'))) continue;
            this.envs.add(i, zone);
            return;
        }
        this.envs.add(zone);
    }

    private static void insertZone(List<IGDIntervalZone> zones, IGDIntervalZone zone) {
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalZone insertPoint = zones.get(i);
            if (zone.topSample == null) break;
            if (insertPoint.topSample == null) continue;
            if (zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M')) {
                zones.add(i, zone);
                return;
            }
            if (zone.topSample.getDepth('M') != insertPoint.topSample.getDepth('M') || zone.getHier() > insertPoint.getHier()) continue;
            zones.add(i, zone);
            return;
        }
        zones.add(zone);
    }

    final void insertZone(IGDIntervalZone zone) {
        List<IGDIntervalZone> list = this.getIGDList(zone.igdType, 0);
        if (list == null) {
            throw new IllegalArgumentException("Unrecognised IGD type in interval: '" + zone.toString() + "'");
        }
        WellInterp.insertZone(list, zone);
    }

    public void insert(Intcom zone) {
        Intcom.insert(this.intcoms.get(zone.getIGDType()), zone);
    }

    synchronized void refreshComments(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded || this.comments == null) {
            return;
        }
        Object sql = "SELECT usamp_id,disc_id,analyst,updated ";
        sql = (String)sql + " FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + this.interpID;
        sql = this.sbdb.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        Biocom doNotify = null;
        HashSet<CallSite> keyIDs = new HashSet<CallSite>();
        while (rs.next()) {
            int sampID = rs.getInt("usamp_id");
            Discipline discID = Discipline.getDisc(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
            int analystID = rs.getInt("analyst");
            keyIDs.add((CallSite)((Object)("" + discID.getChar() + sampID + analystID)));
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Biocom b : this.comments) {
                if (b.getTopID() != sampID || b.getDiscipline() != discID || b.getAnalyst() != analystID) continue;
                found = true;
                if (time == null || b.getUpdated() != null && !time.after(b.getUpdated())) break;
                doNotify = b = Biocom.load(this.sbdb, well, this.interpID, sampID, discID, analystID, b);
                break;
            }
            if (found) continue;
            doNotify = Biocom.load(this.sbdb, well, this.interpID, sampID, discID, analystID, null);
            this.insertBiocom(doNotify);
        }
        if (keyIDs.size() < this.comments.size()) {
            Iterator<Biocom> it = this.comments.iterator();
            while (it.hasNext()) {
                Biocom b = it.next();
                if (keyIDs.contains("" + b.getDiscID() + b.getTopID() + b.getAnalyst())) continue;
                it.remove();
                if (doNotify != null) continue;
                doNotify = b;
            }
        }
        if (doNotify != null) {
            this.setChanged();
            this.notifyObservers(doNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComments(char discID, Well well) throws SQLException, SBException {
        List<Biocom> list = this.comments;
        synchronized (list) {
            String sql = "SELECT usamp_id,lsamp_id,disc_id,analyst,comments,source," + Audit.sqlFieldString();
            sql = sql + " FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + this.interpID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                Iterator<Biocom> en = this.comments.iterator();
                while (en.hasNext()) {
                    Biocom comment = en.next();
                    if (comment.getDiscID() != discID) continue;
                    en.remove();
                }
                well.getSamples();
                while (rs.next()) {
                    int topID = rs.getInt("usamp_id");
                    int baseID = rs.getInt("lsamp_id");
                    if (baseID == topID) {
                        baseID = 0;
                    }
                    Discipline d = Discipline.getDisc(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                    int analyst = rs.getInt("analyst");
                    String text = rs.getString("comments");
                    if (text == null) {
                        text = "";
                    }
                    String source = rs.getString("source");
                    Sample topSample = well.getSample(topID);
                    Sample baseSample = null;
                    if (baseID > 0) {
                        baseSample = well.getSample(baseID);
                    }
                    if (topSample != null) {
                        try {
                            Biocom.Builder builder = new Biocom.Builder(this.sbdb, d, analyst, topSample, text);
                            builder.source(source).baseSample(baseSample).audit(new Audit(rs)).status(SbugsStatus.STORED);
                            this.insertBiocom(builder.build());
                        }
                        catch (IllegalStateException e) {
                            StackError.showStackError((String)("Error loading comment: " + e.getMessage()), (Exception)e);
                        }
                        continue;
                    }
                    System.out.println("Error Loading: " + text + ", Sample ID: " + topID);
                }
            }
        }
    }

    boolean hasBiocom(Biocom biocom) throws SBException {
        for (Biocom current : this.comments) {
            if (biocom.getTopID() != current.getTopID() || biocom.getDiscID() != current.getDiscID() || biocom.getAnalyst() != current.getAnalyst()) continue;
            return true;
        }
        return false;
    }

    boolean hasZone(IGDIntervalZone zone, int igdType) throws SBException {
        for (IGDIntervalZone current : this.getIGDList(igdType)) {
            if (zone.getTopID() != current.getTopID() || zone.getSchID() != current.getSchID() || zone.getHier() != current.getHier()) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvent(WellEvent event) {
        for (WellEvent current : this.events) {
            if (current.getEvent().getEvID() != event.getEvent().getEvID() || current.getTypeObj() != event.getTypeObj() || event.getSampID() != current.getSampID()) continue;
            return true;
        }
        return false;
    }

    synchronized void refreshZones(Statement stmt, int igdType, Well well, int schemeID) throws SQLException, SBException {
        if (!this.loaded) {
            return;
        }
        String sql = "SELECT top_id,sch_id,hier,updated FROM " + this.sbdb.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
        if (schemeID > 0) {
            sql = sql + " AND sch_id=" + schemeID;
        }
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        IGDIntervalZone notifier = null;
        HashSet<CallSite> keys = new HashSet<CallSite>();
        List<IGDIntervalZone> zones = this.getIGDList(igdType);
        if (zones == null) {
            return;
        }
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int schID = rs.getInt("sch_id");
            int hier = rs.getInt("hier");
            String key = topID + "|" + schID + "|" + hier;
            keys.add((CallSite)((Object)key));
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDIntervalZone o : zones) {
                if (!key.equals(o.getTopID() + "|" + o.getSchID() + "|" + o.getHier())) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                notifier = o = IGDIntervalZone.load(this.sbdb, igdType, topID, schID, this.interpID, well, hier, o);
                break;
            }
            if (found) continue;
            IGDIntervalZone zone = IGDIntervalZone.load(this.sbdb, igdType, topID, schID, this.interpID, well, hier, null);
            this.insertZone(zone);
            notifier = zone;
        }
        if (keys.size() < zones.size()) {
            Iterator<IGDIntervalZone> it = zones.iterator();
            while (it.hasNext()) {
                IGDIntervalZone zone = it.next();
                if (schemeID != 0 && zone.getSchID() != schemeID || keys.contains(zone.getTopID() + "|" + zone.getSchID() + "|" + zone.getHier())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = zone;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadZones(int igdType, Well well) throws SQLException, SBException {
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            if (!this.getIGDList(igdType, 0).isEmpty()) {
                this.getIGDList(igdType, 0).clear();
            }
            well.getSamples();
            String sql = "SELECT hier,top_id,base_id," + (igdType == 2 ? "" : "top_analy,base_analy,") + "top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,sep," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE igd_type=" + igdType + " AND interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int hier = rs.getInt("hier");
                    int topID = rs.getInt("top_id");
                    int baseID = rs.getInt("base_id");
                    if (baseID == 0) {
                        System.out.println("Warning: baseID null in IGD for topID: " + topID + ", wellID: " + well.getWellID() + ", interpID: " + this.interpID + ", type: " + igdType);
                        baseID = topID;
                    }
                    int topAnalyst = igdType == 2 ? 0 : rs.getInt("top_analy");
                    int baseAnalyst = igdType == 2 ? 0 : rs.getInt("base_analy");
                    int topBnd = rs.getInt("top_bnd");
                    int baseBnd = rs.getInt("base_bnd");
                    int schID = rs.getInt("sch_id");
                    String strg = rs.getString("q_uzone");
                    boolean qUzone = strg != null && strg.charAt(0) == 'Y';
                    int uppZone = rs.getInt("upp_zone");
                    if (uppZone < 0) {
                        uppZone = 0;
                    }
                    String uppInf = rs.getString("upp_inf");
                    strg = rs.getString("q_lzone");
                    boolean qLzone = strg != null && strg.charAt(0) == 'Y';
                    int lowZone = rs.getInt("low_zone");
                    if (lowZone < 0) {
                        lowZone = 0;
                    }
                    String lowInf = rs.getString("low_inf");
                    String sep = rs.getString("sep");
                    IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.sbdb, igdType, well.getSample(topID), well.getSample(baseID), hier, schID);
                    builder.topAnalyst(topAnalyst).baseAnalyst(baseAnalyst).topBnd(topBnd).baseBnd(baseBnd);
                    builder.uppZone(uppZone).uppInf(uppInf).lowZone(lowZone).lowInf(lowInf).qUzone(qUzone).qLzone(qLzone).sep(sep).audit(new Audit(rs));
                    builder.status = SbugsStatus.STORED;
                    try {
                        this.insertZone(builder.build());
                    }
                    catch (IllegalStateException ise) {
                        if (ise.getMessage().startsWith("Reset Units: ")) {
                            try {
                                StackError.showStackError((String)("Error building interval in well " + well.getWellName() + " - edit and re-save interval to reset this error."), (Exception)ise);
                                builder.uppZone(0).lowZone(0);
                                this.insertZone(builder.build());
                            }
                            catch (IllegalStateException ise2) {
                                StackError.showStackError((String)("Error building Interval in well " + well.getWellName() + " (well_id=" + well.getWellID() + ", top_id=" + topID + ", base_id=" + baseID + ",upp_zone=" + uppZone + ",upp_inf='" + uppInf + "') :"), (Exception)ise2);
                            }
                            continue;
                        }
                        StackError.showStackError((String)("Error building Interval in well " + well.getWellName() + " (well_id=" + well.getWellID() + ", top_id=" + topID + ", base_id=" + baseID + ",upp_zone=" + uppZone + ",upp_inf='" + uppInf + "') :"), (Exception)ise);
                    }
                }
            }
        }
    }

    synchronized void refreshEnvs(Statement stmt, Well well) throws SQLException, SBException {
        if (!this.loaded) {
            return;
        }
        Object sql = "SELECT top_id,updated ";
        sql = (String)sql + " FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE  interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
        IGDIntervalEnv notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("top_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDIntervalEnv o : this.envs) {
                if (key != o.getTopID()) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                notifier = o = IGDIntervalEnv.load(this.sbdb, o.getTopID(), this.interpID, well, o);
                break;
            }
            if (found) continue;
            IGDIntervalEnv zone = IGDIntervalEnv.load(this.sbdb, key, this.interpID, well, null);
            this.insertEnv(zone);
            notifier = zone;
        }
        if (keys.size() < this.envs.size()) {
            Iterator<IGDIntervalEnv> it = this.envs.iterator();
            while (it.hasNext()) {
                IGDIntervalEnv env = it.next();
                if (keys.contains(env.getTopID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = env;
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadEnvs(Well well) throws SQLException {
        List<IGDIntervalEnv> list = this.envs;
        synchronized (list) {
            this.envs.clear();
            String sql = "SELECT top_id,base_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE  interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int topID = rs.getInt("top_id");
                    int baseID = rs.getInt("base_id");
                    int schID = rs.getInt("envsch_id");
                    EnvScheme scheme = null;
                    if (schID > 0) {
                        scheme = this.sbdb.getEnvScheme(schID);
                    }
                    int up = rs.getInt("up");
                    int ud = rs.getInt("ud");
                    int lp = rs.getInt("lp");
                    int ld = rs.getInt("ld");
                    int qual = rs.getInt("qual");
                    Sample topSample = well.getSample(topID);
                    Sample baseSample = well.getSample(baseID);
                    IGDIntervalEnv.Builder builder = new IGDIntervalEnv.Builder(this.sbdb, topSample, baseSample, schID).up(up).ud(ud).lp(lp).ld(ld).qual(qual).audit(new Audit(rs));
                    builder.status = IGDIntervalEnv.STORED;
                    try {
                        this.insertEnv(builder.build());
                    }
                    catch (IllegalStateException sbe) {
                        if (!sbe.getMessage().startsWith("Attempt to build env interval")) throw sbe;
                        StackError.showStackError((String)("Error building Environent Interval for section: " + well.getWellName() + "/" + well.getWellCode() + " (Version: " + this.toString() + ") interval reset: check interval at: " + topSample.toString() + " - " + baseSample.toString()), (Exception)sbe);
                        do {
                            if (ld == 0) {
                                ld = lp;
                            }
                            if (lp == 0) {
                                lp = up;
                            }
                            if (ud == 0) {
                                ud = up;
                            }
                            if (up != 0) continue;
                            up = 1;
                        } while (ld == 0 || lp == 0 || ud == 0 || up == 0);
                        builder.up(up).ud(ud).lp(lp).ld(ld);
                        this.insertEnv(builder.build());
                    }
                }
                return;
            }
        }
    }

    void sortByDepth(int igdType) throws SBException {
        boolean swap = true;
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < igd.size(); ++i) {
                IGDInterval zone = igd.get(i);
                IGDInterval prevZone = igd.get(i - 1);
                if (zone.topSample == null || prevZone.topSample == null) {
                    throw new SBException("Null sample encountered during IGD sort");
                }
                if (!(zone.topSample.getDepth('M') < prevZone.topSample.getDepth('M'))) continue;
                igd.add(i - 1, (IGDIntervalZone)zone);
                igd.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    public List<Biocom> getComments() {
        return this.comments;
    }

    public List<Biocom> getComments(char discID) {
        LinkedList<Biocom> discList = new LinkedList<Biocom>();
        for (Biocom biocom : this.comments) {
            if (biocom.getDiscID() != discID) continue;
            discList.add(biocom);
        }
        return discList;
    }

    public List<IGDIntervalEnv> getEnvs() {
        return this.envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGDIntervalZone> getIGDList(int igdType) {
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            return this.zones.get(igdType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIGDListSize(int igdType) {
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            if (this.zones.get(igdType) != null) {
                return this.zones.get(igdType).size();
            }
        }
        return 0;
    }

    public List<IGDIntervalZone> getIGDList(int igdType, int schID, boolean deriveSequenceIntervals) throws SQLException, SBException {
        if (igdType == 10 && deriveSequenceIntervals) {
            LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
            IGDScheme scheme = this.sbdb.getIGDScheme(schID);
            for (IGDUnit unit : scheme.getUnits()) {
                Surface s1 = scheme.findSurface(unit.getUage(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                Surface s2 = scheme.findSurface(unit.getLage(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                if (s1 == null || s2 == null) continue;
                SQPick p1 = null;
                SQPick p2 = null;
                for (SQPick pp : this.getSQPicks(schID)) {
                    if (pp.getSurface().getSurfaceID() == s1.getSurfaceID()) {
                        p1 = pp;
                        continue;
                    }
                    if (pp.getSurface().getSurfaceID() != s2.getSurfaceID()) continue;
                    p2 = pp;
                }
                if (p1 == null || p2 == null) continue;
                IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.sbdb, igdType, p1.getSample(), p2.getSample(), unit.getHier(), schID).topBnd(p1.getBndInt()).baseBnd(p2.getBndInt());
                builder.uppZone(unit.getUnitID()).lowZone(unit.getUnitID()).uppInf(p1.getInfName()).lowInf(p2.getInfName());
                try {
                    list.add(builder.build());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return list;
        }
        return this.getIGDList(igdType, schID);
    }

    public List<IGDIntervalZone> getIGDList(int igdType, int schID) {
        LinkedList<IGDIntervalZone> list;
        if (igdType == 10) {
            return null;
        }
        if (schID > 0) {
            list = new LinkedList();
            for (IGDIntervalZone zone : this.getIGDList(igdType)) {
                if (zone.getSchID() != schID) continue;
                list.add(zone);
            }
        } else {
            list = this.getIGDList(igdType);
        }
        return list;
    }

    public List<IGDIntervalZone> getBiozones(int schID, Discipline disc) throws SQLException {
        LinkedList<IGDIntervalZone> igdList = new LinkedList<IGDIntervalZone>(this.getIGDList(4, schID));
        if (schID > 0) {
            return igdList;
        }
        Set<Integer> schemes = this.getBiozoneSchemes(disc);
        ListIterator it = igdList.listIterator();
        while (it.hasNext()) {
            IGDIntervalZone zone = (IGDIntervalZone)it.next();
            if (schemes.contains(zone.getSchID())) continue;
            it.remove();
        }
        return igdList;
    }

    public List<IGDIntervalZone> getBiozones(int schID, Discipline disc, int minHier, int maxHier) throws SBException, SQLException {
        List<IGDIntervalZone> biozones = this.getBiozones(schID, disc);
        WellInterp.filterIGDList(biozones, minHier, maxHier);
        return biozones;
    }

    private static void filterIGDList(List<IGDIntervalZone> list, int minHier, int maxHier) throws SBException {
        LinkedList<IGDIntervalZone> filteredList = new LinkedList<IGDIntervalZone>();
        for (int hier = maxHier; hier >= minHier; --hier) {
            for (IGDIntervalZone zone : list) {
                if (zone.getHier() != hier) continue;
                boolean toAdd = true;
                for (IGDIntervalZone zoneInList : filteredList) {
                    if (zoneInList.checkDepthBracketing(zone)) continue;
                    toAdd = false;
                    break;
                }
                if (!toAdd) continue;
                WellInterp.insertZone(filteredList, zone);
            }
        }
        list.clear();
        list.addAll(filteredList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData(int igdType) {
        InterpList interpList = this.getInterpList(igdType);
        if (interpList != null) {
            return interpList.hasData();
        }
        switch (igdType) {
            case 21: {
                assert (false);
                return false;
            }
            case 2: 
            case 3: 
            case 4: {
                return !this.getIGDList(igdType, 0).isEmpty();
            }
            case 20: {
                List<WellEvent> list = this.events;
                synchronized (list) {
                    return !this.events.isEmpty();
                }
            }
            case 5: {
                return !this.envs.isEmpty();
            }
            case 19: {
                return !this.comments.isEmpty();
            }
            case 22: {
                return !this.getIntcoms().isEmpty();
            }
        }
        System.out.println("WellInterp.hasData: Given data type did not match");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        for (InterpList interpList : this.getInterpLists()) {
            if (!interpList.hasData()) continue;
            return true;
        }
        Iterator<List<Intcom>> iterator = this.zones;
        synchronized (iterator) {
            for (List<IGDIntervalZone> list : this.zones.values()) {
                if (list.isEmpty()) continue;
                return true;
            }
        }
        for (List<Intcom> list : this.intcoms.values()) {
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return this.loc != null || !this.envs.isEmpty() || !this.comments.isEmpty() || !this.events.isEmpty();
    }

    public List<IGDIntervalZone> getIGDList(int igdType, int schID, int minHier, int maxHier) throws SBException, SQLException {
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        list.addAll(this.getIGDList(igdType, schID));
        WellInterp.filterIGDList(list, minHier, maxHier);
        return list;
    }

    @Deprecated
    public List<IGDIntervalZone> getIGDList(int igdType, int schID, int hier) throws SBException, SQLException {
        if (hier == 0) {
            return this.getIGDList(igdType, schID);
        }
        IGDScheme scheme = null;
        if (schID > 0) {
            this.sbdb.getIGDScheme(schID);
        }
        LinkedList list = new LinkedList();
        for (IGDIntervalZone zone : this.getIGDList(igdType, schID)) {
            double lAge;
            double uAge;
            IGDUnit unit;
            if (zone.getUppZone() <= 0) continue;
            if (scheme == null || scheme.getSchID() != schID) {
                scheme = this.sbdb.getIGDScheme(zone.getSchID());
            }
            if ((unit = scheme.findUnit(uAge = scheme.findUnit(zone.getUppZone()).getUage(), lAge = zone.getLowZone() > 0 ? scheme.findUnit(zone.getLowZone()).getLage() : scheme.findUnit(zone.getUppZone()).getLage(), hier)) == null) continue;
        }
        LinkedList<IGDIntervalZone> zoneList = new LinkedList<IGDIntervalZone>();
        for (IGDIntervalZone.Builder builder : list) {
            zoneList.add(builder.build());
        }
        return zoneList;
    }

    public List<IGDScheme> getSequenceSchemes() throws SQLException {
        LinkedList<IGDScheme> list = new LinkedList<IGDScheme>();
        for (SQPick pick : this.getSQPicks()) {
            IGDScheme scheme;
            if (pick.getSurface().getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((IGDScheme)itS.next()).getSchID() != pick.getSurface().getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.sbdb.getIGDScheme(pick.getSurface().getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    public EnvScheme getEnvScheme() throws SQLException, SBException {
        if (this.envs == null || this.envs.isEmpty()) {
            return null;
        }
        return this.sbdb.getEnvScheme(this.envs.get(0).getSchID());
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException, SBException {
        this.sbdb.getEnvSchemes();
        LinkedList<EnvScheme> list = new LinkedList<EnvScheme>();
        for (IGDIntervalEnv env : this.getEnvs()) {
            EnvScheme scheme;
            if (env.getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((EnvScheme)itS.next()).getID() != env.getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.sbdb.getEnvScheme(env.getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    public List<IGDScheme> getIGDSchemes(int igdType) throws SQLException {
        if (igdType == 10) {
            return this.getSequenceSchemes();
        }
        this.sbdb.getIGDSchemes(igdType);
        LinkedList<IGDScheme> list = new LinkedList<IGDScheme>();
        for (IGDIntervalZone zone : this.getIGDList(igdType)) {
            IGDScheme scheme;
            if (zone.getSchID() <= 0) continue;
            boolean found = false;
            Iterator itS = list.iterator();
            while (itS.hasNext()) {
                if (((IGDScheme)itS.next()).getSchID() != zone.getSchID()) continue;
                found = true;
                break;
            }
            if (found || (scheme = this.sbdb.getIGDScheme(zone.getSchID())) == null) continue;
            list.add(scheme);
        }
        return list;
    }

    public Set<Integer> getBiozoneSchemes(Discipline disc) throws SQLException {
        List<IGDScheme> schemes = this.getIGDSchemes(4);
        if (disc != null) {
            ListIterator<IGDScheme> it = schemes.listIterator();
            while (it.hasNext()) {
                IGDScheme scheme = it.next();
                if (scheme.getDiscipline() == disc) continue;
                it.remove();
            }
        }
        HashSet<Integer> IDs = new HashSet<Integer>();
        for (IGDScheme scheme : schemes) {
            IDs.add(scheme.getID());
        }
        return IDs;
    }

    boolean sampleIsUsed(int sampOrDonorID, Set dataTypes) throws SBException {
        if (sampOrDonorID == 0) {
            return false;
        }
        Iterator it = dataTypes.iterator();
        while (it.hasNext()) {
            int columnType = (Integer)it.next();
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    if (!this.sampleInComments(sampOrDonorID, SBdb.dt2discID(columnType))) break;
                    return true;
                }
                case 10: 
                case 11: 
                case 12: {
                    if (!this.sampleInIGD(sampOrDonorID, IGDInterval.dType2IGDtype(columnType))) break;
                    return true;
                }
                case 15: {
                    if (!this.sampleInEnv(sampOrDonorID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    void writeDEX(FileWriter out, char units, String eol, Set dataTypes) throws IOException, SBException, SQLException {
        Iterator en = dataTypes.iterator();
        while (en.hasNext()) {
            int columnType = (Integer)en.next();
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.writeDEXComments(out, eol, SBdb.dt2discID(columnType));
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.writeDEXIGDIntervals(out, units, eol, IGDInterval.dType2IGDtype(columnType));
                    break;
                }
                case 15: {
                    this.writeDEXEnvIntervals(out, units, eol);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Integer> writeXML(BufferedWriter out, char units, int ind, Set<Integer> dataTypes) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String indStrg = SB.getXMLIndent((int)ind);
        out.write(indStrg + "<WellInterpretationID>" + this.interpID + "</WellInterpretationID>\n");
        block12: for (int dataType : dataTypes) {
            InterpList interpList = this.getInterpListWithDataType(dataType);
            if (interpList != null) {
                userIDs.addAll(interpList.writeXML(out, ind, Discipline.getDisc(SBdb.dt2discID(dataType)), units));
                continue;
            }
            switch (dataType) {
                case 14: 
                case 27: {
                    assert (false);
                    continue block12;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    userIDs.addAll(this.writeXMLComments(out, ind, SBdb.dt2discID(dataType), units));
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    userIDs.addAll(this.writeXMLIGDIntervals(out, units, ind, IGDInterval.dType2IGDtype(dataType)));
                    break;
                }
                case 15: {
                    userIDs.addAll(this.writeXMLEnvIntervals(out, ind, units));
                    break;
                }
                case 18: {
                    this.writeXMLIntcom(out, ind, units);
                    break;
                }
                case 17: {
                    this.writeXMLloc(out, ind, units);
                    break;
                }
                case 16: {
                    List<WellEvent> list = this.events;
                    synchronized (list) {
                        for (WellEvent event : this.events) {
                            event.writeXML(out, ind, units);
                        }
                        break;
                    }
                }
                default: {
                    if (!SBdb.isInterpDataType(dataType)) continue block12;
                    System.out.println("WellInterp.writeXML:Cannot write XML for data type: " + dataType);
                }
            }
        }
        return userIDs;
    }

    WellInterp(SBdb db, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        this.zones.put(3, new LinkedList());
        this.zones.put(2, new LinkedList());
        this.zones.put(4, new LinkedList());
        this.comments = new LinkedList<Biocom>();
        this.envs = new LinkedList<IGDIntervalEnv>();
        this.events = new LinkedList<WellEvent>();
        this.intcoms = new HashMap();
        this.headers = null;
        this.colMap = new HashMap();
        this.loaded = false;
        this.sbdb = db;
        String strg = xml.getChildTextNormalize("WellInterpretationID");
        if (strg != null) {
            this.interpID = Integer.parseInt(strg);
        } else {
            assert (false);
            this.interpID = 0;
        }
        this.interp = db.getInterp(this.interpID);
        if (this.interp == null) {
            try {
                this.interp = db.addInterp(xml.getAttributeValue("Description"), this.interpID);
            }
            catch (InvalidFieldException ife) {
                throw new SBException("Unexpected InvalidFieldException: " + ife.getMessage(), (Throwable)ife);
            }
        }
        this.sqpickList = new SQPickList(this.interpID, this);
        this.faultList = new FaultList(this.interpID, this);
        for (InterpList interpList : this.getInterpLists()) {
            interpList.parseXML(xml, this.sbdb, well, dataTypes);
        }
        Iterator it = xml.getContent((Filter)new ElementFilter("BiostratigraphicComment")).iterator();
        while (it.hasNext()) {
            Biocom biocom = Biocom.parse(db, well, (Element)it.next(), dataTypes);
            if (biocom.getText() == null || biocom.getText().length() <= 0) continue;
            this.comments.add(biocom);
        }
        it = xml.getContent((Filter)new ElementFilter("IGDInterval")).iterator();
        while (it.hasNext()) {
            IGDIntervalZone zone = new IGDIntervalZone(db, well, (Element)it.next());
            dataTypes.add(IGDInterval.igdType2dType(zone.getIGDType()));
            this.insertZone(zone);
        }
        it = xml.getContent((Filter)new ElementFilter("EnvironmentInterval")).iterator();
        while (it.hasNext()) {
            try {
                IGDIntervalEnv env = IGDIntervalEnv.parse(db, well, (Element)it.next());
                dataTypes.add(15);
                this.insertEnv(env);
            }
            catch (IllegalStateException | SBException ex) {
                LOGGER.log(Level.WARNING, "Error parsing environment interval: " + well.getWellName() + "," + this.toString());
            }
        }
        it = xml.getContent((Filter)new ElementFilter("IntervalComment")).iterator();
        while (it.hasNext()) {
            Intcom intcom = new Intcom(db, (Element)it.next());
            dataTypes.add(18);
            this.getIntcoms(intcom.getIGDType());
            this.insert(intcom);
        }
        Element el = xml.getChild("LOC");
        if (el != null) {
            this.loc = new LOC(db, el);
            dataTypes.add(17);
        }
        it = xml.getContent((Filter)new ElementFilter("WellEvent")).iterator();
        while (it.hasNext()) {
            WellEvent.Builder eventBuilder = WellEvent.parse(db, well, (Element)it.next());
            dataTypes.add(16);
            this.insertEvent(eventBuilder.build(db));
        }
    }

    void writeDEXComments(FileWriter out, String eol, char discID) throws IOException, SBException, SQLException {
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID) continue;
            comment.writeDEX(out, eol);
        }
    }

    private LinkedList<Integer> writeXMLComments(BufferedWriter out, int indent, char discID, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID || comment.getText().trim().isEmpty()) continue;
            userIDs.addAll(comment.writeXML(out, indent, units));
        }
        return userIDs;
    }

    void writeXMLIntcom(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.intcoms.get(0) == null) {
            return;
        }
        for (int i : this.intcoms.keySet()) {
            for (Intcom intcom : this.intcoms.get(i)) {
                intcom.writeXML(out, indent, units);
            }
        }
    }

    void writeXMLloc(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        if (this.loc == null) {
            return;
        }
        this.loc.writeXML(out, indent, units);
    }

    private boolean sampleInComments(int sampOrDonorID, char discID) throws SBException {
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID) continue;
            if (comment.getTopSample() == null) {
                throw new SBException("Sample null in comment : " + comment);
            }
            if (comment.getTopSample().getSampID() != sampOrDonorID && (comment.getBaseSample() == null || comment.getBaseSample().getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void writeDEXIGDIntervals(FileWriter out, char units, String eol, int igdType) throws IOException, SBException, SQLException {
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (IGDIntervalZone zone : igd) {
            zone.writeDEX(out, eol, units, SB.df);
            out.write(eol);
        }
    }

    LinkedList<Integer> writeXMLIGDIntervals(BufferedWriter out, char units, int ind, int igdType) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (IGDIntervalZone zone : igd) {
            userIDs.addAll(zone.writeXML(out, ind, units, this.sbdb));
        }
        return userIDs;
    }

    void writeDEXEnvIntervals(FileWriter out, char units, String eol) throws IOException, SBException, SQLException {
        for (IGDIntervalEnv env : this.envs) {
            env.writeDEX(out, eol, units, SB.df);
            out.write(eol);
        }
    }

    LinkedList<Integer> writeXMLEnvIntervals(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        for (IGDIntervalEnv env : this.envs) {
            userIDs.addAll(env.writeXML(out, indent, units));
        }
        return userIDs;
    }

    boolean sampleInIGD(int sampOrDonorID, int igdType) throws SBException {
        List<IGDIntervalZone> igd = this.getIGDList(igdType, 0);
        for (IGDIntervalZone zone : igd) {
            if (zone.topSample.getSampID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    private boolean sampleInEnv(int sampOrDonorID) throws SBException {
        for (IGDIntervalEnv zone : this.envs) {
            if (zone.topSample.getSampID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getSampID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void refreshDataRange(int wellID, int dType, DTMonitor monitor) throws SQLException, SBException {
        monitor.setStatus(DTMonitor.UNKNOWN);
        ArrayList<Double> depths = new ArrayList<Double>();
        String sql = null;
        boolean fourDepths = true;
        switch (dType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                Discipline disc = Discipline.getDisc(SBdb.dt2discID(dType));
                for (Biocom biocom : this.comments) {
                    if (biocom.getDiscipline() != disc) continue;
                    depths.add(biocom.getSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("BCMMNTS") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.usamp_id AND s.well_id=b.well_id AND b.disc_id='" + disc.getChar() + "' AND interp_id=" + this.interpID;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                int igdType = IGDInterval.dType2IGDtype(dType);
                for (IGDIntervalZone zone : this.getIGDList(igdType)) {
                    depths.add(zone.getTopSample().getDepth());
                    depths.add(zone.getBaseSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName(igdType == 2 ? "IGD_LSTRAT" : "IGD") + " i WHERE s.well_id=" + wellID + " AND i.well_id=" + wellID + " AND i.igd_type=" + igdType + " AND (s.samp_id=i.top_id OR s.samp_id=i.base_id) AND interp_id=" + this.interpID;
                break;
            }
            case 14: {
                for (SQPick pick : this.getSQPicks()) {
                    depths.add(pick.getSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("SQPICK") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
                break;
            }
            case 27: {
                for (Fault fault : this.getFaults()) {
                    depths.add(fault.getSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("FAULTS") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
                break;
            }
            case 15: {
                for (IGDIntervalEnv env : this.envs) {
                    depths.add(env.getTopSample().getDepth());
                    depths.add(env.getBaseSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("IGD_ENV") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.top_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
                break;
            }
            case 18: {
                if (this.intcoms.get(0) != null) {
                    for (Intcom intcom : this.intcoms.get(0)) {
                        depths.add(intcom.getTopDepth());
                        depths.add(intcom.getBaseDepth());
                    }
                }
                sql = "SELECT max(top_depth) as maxtop,max(base_depth) as maxbot,min(base_depth) as minbot,min(top_depth) as mintop FROM " + this.sbdb.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + this.interpID + " AND igd_type=0";
                break;
            }
            case 16: {
                for (WellEvent event : this.events) {
                    depths.add(event.getSample().getDepth());
                }
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("EVENTS") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
                break;
            }
            case 17: {
                if (this.loc != null) {
                    depths.add(this.loc.getTopDepth());
                    depths.add(this.loc.getBaseDepth());
                }
                sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE well_id=" + wellID + " AND interp_id=" + this.interpID;
                fourDepths = false;
                break;
            }
            case 29: {
                sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot,min(s.base_depth) as minbot,min(s.top_depth) as mintop FROM " + this.sbdb.DBTableName("samples") + " s," + this.sbdb.DBTableName("SBSSR") + " b WHERE s.well_id=" + wellID + " AND s.samp_id=b.samp_id AND s.well_id=b.well_id AND interp_id=" + this.interpID;
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        if (sql != null) {
            Well.refreshRange(this.sbdb, monitor, depths, fourDepths, sql);
        }
        if (monitor.getDepthFrom() > 99990.0 && monitor.getDepthTo() < -99990.0) {
            monitor.setDepthFrom(0.0);
            monitor.setDepthTo(0.0);
            monitor.setHasData(false);
        }
    }

    void getIGDschemes(List dataTypes, List igdSchemes, List envSchemes) throws SBException, SQLException {
        Iterator dtIt = dataTypes.iterator();
        while (dtIt.hasNext()) {
            int columnType = (Integer)dtIt.next();
            switch (columnType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    List<IGDIntervalZone> igdList = this.getIGDList(IGDInterval.dType2IGDtype(columnType), 0);
                    for (IGDIntervalZone zone : igdList) {
                        if (zone.getSchID() <= 0) continue;
                        Iterator sch = igdSchemes.iterator();
                        boolean found = false;
                        while (sch.hasNext()) {
                            IGDScheme scheme = (IGDScheme)sch.next();
                            if (scheme.getSchID() != zone.getSchID()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        try {
                            igdSchemes.add(new IGDScheme(this.sbdb, zone.getSchID()));
                        }
                        catch (SBException sb) {
                            sb.printStackTrace();
                            throw new SBException("Zone: " + zone + ", " + sb.getMessage());
                        }
                    }
                    break;
                }
                case 15: {
                    for (IGDIntervalEnv env : this.envs) {
                        if (env.getSchID() <= 0) continue;
                        Iterator sch = envSchemes.iterator();
                        boolean found = false;
                        while (sch.hasNext()) {
                            EnvScheme scheme = (EnvScheme)sch.next();
                            if (scheme.getID() != env.getSchID()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        envSchemes.add(new EnvScheme(this.sbdb, env.getSchID()));
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unloadData(int dType) throws SBException {
        InterpList interpList = this.getInterpListWithDataType(dType);
        if (interpList != null) {
            interpList.unload(Discipline.getDisc(SBdb.dt2discID(dType)));
        }
        switch (dType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                Discipline disc = Discipline.getDisc(SBdb.dt2discID(dType));
                Iterator<Biocom> it = this.comments.iterator();
                while (it.hasNext()) {
                    if (it.next().getDiscipline() != disc) continue;
                    it.remove();
                }
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.getIGDList(IGDInterval.dType2IGDtype(dType), 0).clear();
                if (this.intcoms.get(IGDInterval.dType2IGDtype(dType)) == null) break;
                this.intcoms.remove(IGDInterval.dType2IGDtype(dType));
                break;
            }
            case 15: {
                this.envs.clear();
                if (this.intcoms.get(5) == null) break;
                this.intcoms.remove(5);
                break;
            }
            case 16: {
                List<WellEvent> list = this.events;
                synchronized (list) {
                    this.events.clear();
                    break;
                }
            }
            case 17: {
                this.loc = null;
                break;
            }
            case 18: {
                this.intcoms.clear();
            }
        }
    }

    public Intcom addIntcom(Well well, Intcom.Builder builder) throws InvalidFieldException, SQLException, SBException {
        Intcom intcom;
        this.checkOverlap(builder, null);
        if (this.sbdb.isConnected()) {
            if (!well.canWrite(this.sbdb, null)) {
                throw new SBException(well.getDeniedReason(this.sbdb, "add interval comment", "well", true));
            }
            intcom = builder.build(well.getWellID(), this.interpID);
        } else {
            intcom = builder.build();
        }
        this.insert(intcom);
        this.setChanged();
        return intcom;
    }

    public Intcom updateIntcom(Intcom original, int wellID, double topDepth, double baseDepth, String comment) throws InvalidFieldException, SQLException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "update interval comment", "well", true));
        }
        Intcom.Builder builder = new Intcom.Builder(this.sbdb, original.getIGDType(), topDepth).baseDepth(baseDepth).comments(comment);
        this.checkOverlap(builder, original);
        original.delete(wellID, this.interpID);
        Intcom intcom = builder.build(wellID, this.interpID);
        this.intcoms.get(original.getIGDType()).remove(original);
        this.insert(intcom);
        this.setChanged();
        return intcom;
    }

    public void deleteIntcoms(int wellID, Collection<Intcom> toDelete) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
                throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete interval comments", "well", true));
            }
            for (Intcom intcom : toDelete) {
                intcom.delete(wellID, this.interpID);
            }
            this.sbdb.updateAuditTrail("INTCOM", "DELETE " + toDelete.size() + " from " + this.sbdb.getWell(wellID) + " (" + this.sbdb.getInterp(this.interpID) + ")");
        }
        for (Intcom intcom : toDelete) {
            this.intcoms.get(intcom.getIGDType()).remove(intcom);
        }
        this.setChanged();
    }

    private void deleteIntcoms(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("INTCMMNTS") + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.intcoms.clear();
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStratigraphy(double depth) throws SBException {
        Object strat = "";
        int hier = 0;
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            for (IGDIntervalZone zone : this.zones.get(3)) {
                if (!(zone.getTopSample().getDepth() <= depth) || !(zone.getBaseSample().getDepth() >= depth) || zone.getHier() <= hier) continue;
                strat = zone.toString();
                hier = zone.getHier();
            }
            hier = 0;
            HashMap<Integer, Integer> hierMap = new HashMap<Integer, Integer>();
            HashMap<Integer, String> bzStringMap = new HashMap<Integer, String>();
            for (IGDIntervalZone zone : this.zones.get(4)) {
                int n = hier = hierMap.get(zone.getSchID()) != null ? (Integer)hierMap.get(zone.getSchID()) : 0;
                if (!(zone.getTopSample().getDepth() <= depth) || !(zone.getBaseSample().getDepth() >= depth) || zone.getHier() <= hier) continue;
                bzStringMap.put(zone.getSchID(), zone.toString());
                hierMap.put(zone.getSchID(), zone.getHier());
            }
            for (String bzString : bzStringMap.values()) {
                if (!((String)strat).isEmpty()) {
                    strat = (String)strat + ", ";
                }
                strat = (String)strat + bzString;
            }
        }
        return strat;
    }

    void store(WellInterp wellInterp, int wellID, Set<Integer> dataTypes, SBdb ws) throws SBException, SQLException {
        block12: for (int dType : dataTypes) {
            switch (dType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.storeComments(wellInterp, wellID, SBdb.dt2discID(dType));
                    continue block12;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.storeZones(wellInterp.getIGDList(IGDInterval.dType2IGDtype(dType)), wellID, dType);
                    continue block12;
                }
                case 13: {
                    throw new SBException("Attempt by wellInterp to store DTSEQUENCE type");
                }
                case 15: {
                    this.storeEnvs(wellInterp.getEnvs(), wellID);
                    continue block12;
                }
                case 18: {
                    this.storeIntcom(wellInterp, wellID, dataTypes);
                    continue block12;
                }
                case 14: {
                    this.storeSqpicks(wellInterp, wellID);
                    continue block12;
                }
                case 17: {
                    this.storeLOC(wellInterp, wellID);
                    continue block12;
                }
                case 16: {
                    this.storeEvents(wellInterp, wellID, ws);
                    continue block12;
                }
                case 27: {
                    this.faultList.store(wellInterp.faultList, wellID, null, this.sbdb);
                    continue block12;
                }
                case 29: {
                    continue block12;
                }
            }
            if (!SBdb.isInterpDataType(dType)) continue;
            assert (false);
            System.out.println("Cannot store interpeted data type: " + dType);
        }
    }

    public void storeComments(WellInterp wsWellInterp, int wellID, char discID) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "store comments", "well", true));
        }
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store comments in workspace");
        }
        for (Biocom wsBiocom : wsWellInterp.getComments()) {
            if (wsBiocom.getDiscID() != discID) continue;
            Biocom dbBiocom = null;
            for (Biocom db : this.comments) {
                if (!wsBiocom.isFuncEquivalent(db)) continue;
                dbBiocom = db;
                break;
            }
            if (dbBiocom != null) {
                if (wsBiocom.getStatus() != Biocom.PARTSTORED) continue;
                Biocom dbNewBiocom = Biocom.copyToDatabase(wsBiocom, this.sbdb);
                dbBiocom.update(dbNewBiocom, wellID, this.interpID);
                this.setChanged();
                continue;
            }
            dbBiocom = Biocom.copyToDatabase(wsBiocom, this.sbdb);
            dbBiocom.store(wellID, this.interpID);
            this.insertBiocom(dbBiocom);
            wsBiocom.status = Biocom.STORED;
            this.setChanged();
        }
    }

    public void storeZones(List<IGDIntervalZone> wsZones, int wellID, int dType) throws SBException, SQLException {
        assert (this.sbdb.isConnected());
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "store intervals", "well", true));
        }
        LinkedList<IGDIntervalZone> toStore = new LinkedList<IGDIntervalZone>();
        LinkedList<IGDIntervalZone> toCheck = new LinkedList<IGDIntervalZone>(this.getIGDList(IGDInterval.dType2IGDtype(dType)));
        for (IGDIntervalZone wsZone : wsZones) {
            IGDIntervalZone dbZone = null;
            for (IGDIntervalZone db : this.getIGDList(IGDInterval.dType2IGDtype(dType))) {
                if (!wsZone.isFuncEquivalent(db)) continue;
                dbZone = db;
                break;
            }
            if (dbZone != null) {
                if (wsZone.getStatus() != SbugsStatus.PARTSTORED) continue;
                dbZone.update(wsZone, wellID, this.interpID);
                wsZone.status = IGDInterval.STORED;
                this.setChanged();
                continue;
            }
            dbZone = new IGDIntervalZone(this.sbdb, wsZone);
            try {
                WellInterp.checkOverlap(toCheck, IGDIntervalZone.Builder.copyOf(dbZone), null, true);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            toCheck.add(dbZone);
            toStore.add(dbZone);
        }
        for (IGDIntervalZone zone : toStore) {
            zone.store(wellID, this.interpID);
            zone.status = IGDInterval.STORED;
        }
        for (IGDIntervalZone zone : toStore) {
            this.insertZone(zone);
            this.setChanged();
        }
    }

    public void storeEnvs(List<IGDIntervalEnv> envs, int wellID) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "store comments", "well", true));
        }
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store comments in workspace");
        }
        LinkedList<IGDIntervalEnv> toStore = new LinkedList<IGDIntervalEnv>();
        ArrayList<IGDIntervalEnv> toCheck = new ArrayList<IGDIntervalEnv>();
        if (this.envs != null) {
            toCheck.addAll(this.envs);
        }
        for (IGDIntervalEnv iGDIntervalEnv : envs) {
            IGDIntervalEnv dbZone = null;
            for (IGDIntervalEnv db : this.getEnvs()) {
                if (!iGDIntervalEnv.isFuncEquivalent(db)) continue;
                dbZone = db;
                break;
            }
            if (dbZone != null) {
                if (iGDIntervalEnv.getStatus() != SbugsStatus.PARTSTORED) continue;
                dbZone.update(iGDIntervalEnv, wellID, this.interpID);
                iGDIntervalEnv.status = IGDInterval.STORED;
                this.setChanged();
                continue;
            }
            dbZone = new IGDIntervalEnv(this.sbdb, iGDIntervalEnv);
            try {
                WellInterp.checkOverlap(toCheck, IGDIntervalEnv.Builder.copyOf(dbZone), null, true);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            toCheck.add(dbZone);
            toStore.add(dbZone);
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (IGDIntervalEnv zone : toStore) {
                zone.store(stmt, wellID, this.interpID);
                zone.status = IGDInterval.STORED;
            }
        }
        for (IGDIntervalEnv iGDIntervalEnv : toStore) {
            this.insertEnv(iGDIntervalEnv);
            this.setChanged();
        }
    }

    void storeIntcom(WellInterp wsWellInterp, int wellID, Set<Integer> dataTypes) throws SBException, SQLException {
        for (int igdType : intcomIgdTypes) {
            if (igdType != 0 && !dataTypes.contains(IGDInterval.igdType2dType(igdType)) || wsWellInterp.intcoms.get(igdType) == null) continue;
            this.getIntcoms(igdType);
            for (Intcom ws : wsWellInterp.intcoms.get(igdType)) {
                Intcom dbIntcom = null;
                for (Intcom db : this.intcoms.get(igdType)) {
                    if (!db.getSortEntry().equals(ws.getSortEntry())) continue;
                    dbIntcom = db;
                    break;
                }
                if (dbIntcom != null) {
                    System.out.println("WellInterp.storeIntcom:attempt to udpate");
                    continue;
                }
                dbIntcom = new Intcom(ws, this.sbdb);
                dbIntcom.store(wellID, this.interpID);
                this.insert(dbIntcom);
                this.setChanged();
            }
        }
    }

    void storeSqpicks(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        this.sqpickList.store(wsWellInterp.sqpickList, wellID, null, this.sbdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEvents(WellInterp wsWellInterp, int wellID, SBdb ws) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "store events", "well", true));
        }
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy WellEvent to datavase when not connected");
        }
        List<WellEvent> list = this.events;
        synchronized (list) {
            for (WellEvent wsEvent : wsWellInterp.events) {
                WellEvent dbEvent = null;
                for (WellEvent dbE : this.events) {
                    if (!wsEvent.isFuncEquivalent(dbE)) continue;
                    dbEvent = dbE;
                    break;
                }
                if (dbEvent != null) {
                    System.out.println("WellInterp.storeEvents:attempt to udpate");
                    continue;
                }
                if (wsEvent.getEvent().getLink() != null) {
                    WellEvent.Builder builder = WellEvent.Builder.copyOf(wsEvent);
                    builder.audit(new Audit(this.sbdb, ws, wsEvent.getAudit()));
                    builder.sample(wsEvent.getSample().getLink());
                    builder.event(wsEvent.getEvent().getLink());
                    if (wsEvent.getAnalyst() > 0) {
                        builder.analyst(ws.getUser(wsEvent.getAnalyst()).getLink().getUsrID());
                    }
                    WellEvent event = builder.build(this.sbdb, wellID, this.interpID);
                    this.insertEvent(event);
                    continue;
                }
                System.out.println("WellInterp.storeEvents:Can't store unlinked event: " + ws);
            }
        }
    }

    void storeLOC(WellInterp wsWellInterp, int wellID) throws SBException, SQLException {
        if (wsWellInterp.loc == null) {
            return;
        }
        if (this.loc != null) {
            if (wsWellInterp.loc.equals(this.loc)) {
                return;
            }
            this.loc.delete(wellID, this.interpID);
        }
        this.loc = new LOC(wsWellInterp.loc, this.sbdb);
        this.loc.store(wellID, this.interpID);
        this.setChanged();
    }

    public void updateSQPickStatus(DTMonitor monitor, Well link, char wellUnits) throws SBException, SQLException {
        if (monitor == null) {
            throw new SBException("Data type monitor null in updateSQPickStatus");
        }
        monitor.setStatus(SbugsStatus.UNKNOWN);
        for (SQPick pick : this.getSQPicks()) {
            monitor.setHasData(true);
            if (link != null && link.getWellID() != 0) {
                pick.updateStatus(link.getInterp(this.interpID).getSQPicks());
            } else {
                pick.updateStatus(this.getSQPicks());
            }
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)pick.getStatus()));
        }
    }

    public void copy(InterpItem item, Well well, WellInterp newWellInterp) throws SQLException, SBException, InvalidFieldException {
        InterpList interpList = newWellInterp.getInterpList(item);
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "copy " + interpList.getItemDescriptor(), "well", true));
        }
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to copy " + interpList.getItemDescriptor() + ": new version is the same as original version");
        }
        interpList.insertStoredCopy(item, well.getWellID(), newWellInterp.sbdb);
        newWellInterp.setChanged();
    }

    public void move(InterpItem item, Well well, WellInterp newWellInterp) throws SQLException, SBException {
        InterpList interpList = this.getInterpList(item);
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "move " + interpList.getItemDescriptor(), "well", true));
        }
        item.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        interpList.remove(item);
        InterpList newInterpList = newWellInterp.getInterpList(item);
        newInterpList.insert(item);
        this.setChanged();
        newWellInterp.setChanged();
    }

    private boolean hasEnv(IGDIntervalEnv env) {
        for (IGDIntervalEnv current : this.envs) {
            if (env.getTopID() != current.getTopID()) continue;
            return true;
        }
        return false;
    }

    public void moveBiocom(Well well, Biocom biocom, WellInterp newWellInterp) throws SQLException, SBException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "move comment", "well", true));
        }
        biocom.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.comments.remove(biocom);
        this.setChanged();
        newWellInterp.insertBiocom(biocom);
        newWellInterp.setChanged();
    }

    public void copyBiocom(Well well, Biocom biocom, WellInterp newWellInterp) throws SQLException, SBException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "copy comment", "well", true));
        }
        newWellInterp.insertBiocom(Biocom.Builder.copyOf(biocom, newWellInterp.sbdb).build(well.getWellID(), newWellInterp.interpID));
        newWellInterp.setChanged();
    }

    public void copyIntcom(Well well, Intcom intcom, WellInterp newWellInterp, boolean deleteOriginal) throws SQLException, SBException, InvalidFieldException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move interval comment: new version is the same as original version");
        }
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "copy interval comment", "well", true));
        }
        if (!this.intcoms.get(intcom.getIGDType()).contains(intcom)) {
            throw new IllegalArgumentException("Illegal attempt to move interval comment: comment is not in version");
        }
        Intcom.Builder builder = Intcom.Builder.copyOf(intcom);
        newWellInterp.checkOverlap(builder, null);
        if (deleteOriginal) {
            intcom.move(well.getWellID(), this.interpID, newWellInterp.interpID);
            this.intcoms.get(intcom.getIGDType()).remove(intcom);
            this.setChanged();
        } else {
            intcom = builder.build(well.getWellID(), newWellInterp.interpID);
        }
        newWellInterp.insert(intcom);
        newWellInterp.setChanged();
    }

    public void copyLOC(int wellID, WellInterp newWellInterp, boolean deleteOriginal) throws SQLException, SBException {
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move LOC: new version is the same as original version");
        }
        if (this.loc == null || newWellInterp.getLOC() != null && !newWellInterp.getLOC().getNodes().isEmpty()) {
            throw new IllegalArgumentException("Illegal attempt to move LOC: original is null or new interp already contains LOC");
        }
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "copy depth/age curve", "well", true));
        }
        LOC copy = new LOC(this.loc);
        copy.store(wellID, newWellInterp.getHeader().getInterpID());
        newWellInterp.loc = copy;
        if (deleteOriginal) {
            this.deleteLOC(wellID);
        }
        newWellInterp.setChanged();
        this.setChanged();
    }

    public void moveZone(Well well, IGDIntervalZone zone, WellInterp newWellInterp) throws SQLException, SBException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "move interval", "well", true));
        }
        zone.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.removeZone(zone);
        this.setChanged();
        newWellInterp.insertZone(zone);
        newWellInterp.setChanged();
    }

    public void moveEnv(Well well, IGDIntervalEnv zone, WellInterp newWellInterp) throws SQLException, SBException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "move environment", "well", true));
        }
        zone.move(well.getWellID(), this.interpID, newWellInterp.interpID);
        this.envs.remove(zone);
        this.setChanged();
        newWellInterp.insertEnv(zone);
        newWellInterp.setChanged();
    }

    public void copyZone(int wellID, IGDIntervalZone zone, WellInterp newWellInterp) throws SQLException, SBException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "copy interval", "well", true));
        }
        newWellInterp.insertZone(IGDIntervalZone.Builder.copyOf(zone).build(wellID, newWellInterp.interpID));
        newWellInterp.setChanged();
    }

    public void copyEnv(Well well, IGDIntervalEnv zone, WellInterp newWellInterp) throws SQLException, SBException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, "copy environment", "well", true));
        }
        newWellInterp.insertEnv(IGDIntervalEnv.Builder.copyOf(zone).build(well.getWellID(), newWellInterp.interpID, null));
        newWellInterp.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEvent(Well well, WellEvent event, WellInterp newWellInterp, boolean deleteOriginal) throws SBException, SQLException, InvalidFieldException {
        if (!well.canWrite(this.sbdb, null)) {
            throw new SBException(well.getDeniedReason(this.sbdb, (deleteOriginal ? "move" : "copy") + " event", "well", true));
        }
        if (newWellInterp == this) {
            throw new IllegalArgumentException("Illegal attempt to move event: new version is the same as original version");
        }
        List<WellEvent> list = this.events;
        synchronized (list) {
            if (!this.events.contains(event)) {
                throw new IllegalArgumentException("Illegal attempt to move event: event is not in version");
            }
            for (WellEvent we : newWellInterp.getEventsByDepth()) {
                if (we.getSampID() == event.getSample().getSampID() && we.getSbEvent().getEvID() == event.getEvent().getEvID() && we.getCharType() == event.getCharType()) {
                    throw new InvalidFieldException("Event '" + we + "' already exists");
                }
                if (!(we.getSample().getDepth() > event.getSample().getDepth())) continue;
                break;
            }
            if (deleteOriginal) {
                event.move(well.getWellID(), this.interpID, newWellInterp.interpID);
                this.events.remove(event);
                this.setChanged();
            } else {
                WellEvent.Builder builder = WellEvent.Builder.copyOf(event).event(event.getEvent()).sample(event.getSample()).analyst(event.getAnalyst());
                event = builder.build(this.sbdb, well.getWellID(), newWellInterp.getHeader().getInterpID());
            }
            newWellInterp.insertEvent(event);
            newWellInterp.setChanged();
        }
    }

    public SQPick getSQPick(Sample sample) {
        for (SQPick pick : this.getSQPicks()) {
            if (pick.getSample() != sample) continue;
            return pick;
        }
        return null;
    }

    public void setColMap(int wellID, int igdType, IGDColMap colmap) throws SBPermissionException, SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBPermissionException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add column map", "well", true));
        }
        colmap.store(this.sbdb, wellID, this.interpID, igdType);
        this.colMap.remove(igdType);
        this.colMap.put(igdType, colmap);
        this.setChanged();
    }

    public void setChanged(IGDIntervalZone zone) {
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        for (InterpList interpList : this.getInterpLists()) {
            hasChanged |= interpList.mergeSamples(donor, target);
        }
        Iterator<Biocom> iterator = this.zones;
        synchronized (iterator) {
            for (List<IGDIntervalZone> list : this.zones.values()) {
                for (IGDIntervalZone zone : list) {
                    if (!zone.mergeSamples(donor, target)) continue;
                    hasChanged = true;
                }
            }
        }
        if (this.envs != null) {
            for (IGDIntervalEnv iGDIntervalEnv : this.envs) {
                if (!iGDIntervalEnv.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        iterator = this.events;
        synchronized (iterator) {
            for (WellEvent wellEvent : this.events) {
                if (!wellEvent.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (this.comments != null) {
            for (Biocom biocom : this.comments) {
                if (!biocom.mergeSamples(donor, target)) continue;
                hasChanged = true;
            }
        }
        if (hasChanged) {
            this.setChanged();
        }
    }

    void deleteLinkData(int dType, int wellID) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete interpreted data", "well", true));
        }
        boolean hasChanged = false;
        switch (dType) {
            case 14: 
            case 27: {
                hasChanged |= this.getInterpList(IGDInterval.dType2IGDtype(dType)).deleteAll(wellID, null, this.sbdb);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.deleteZones(dType, wellID);
                break;
            }
            case 16: {
                this.deleteEvents(wellID);
                break;
            }
            case 15: {
                this.deleteEnvs(wellID);
                break;
            }
            case 3: {
                this.deleteBiocoms(wellID, 'M');
                break;
            }
            case 9: {
                this.deleteBiocoms(wellID, 'A');
                break;
            }
            case 7: {
                this.deleteBiocoms(wellID, 'P');
                break;
            }
            case 5: {
                this.deleteBiocoms(wellID, 'N');
                break;
            }
            case 18: {
                this.deleteIntcoms(wellID);
                break;
            }
            case 17: {
                this.deleteLOC(wellID);
                break;
            }
            default: {
                throw new SBException("Interp tried to delete unrecognised data type: " + dType);
            }
        }
        if (hasChanged) {
            this.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int hasSampleIGD(Sample sample) throws SBException {
        for (InterpList list : this.getInterpLists()) {
            int n = list.hasData(sample.getSampID());
            if (n <= 0) continue;
            return n;
        }
        int sampID = sample.getSampID();
        Object object = this.zones;
        synchronized (object) {
            for (Integer igdType : this.zones.keySet()) {
                List<IGDIntervalZone> list = this.zones.get(igdType);
                for (IGDInterval iGDInterval : list) {
                    if (iGDInterval.getTopSample() == sample || iGDInterval.getBaseSample() == sample) {
                        return IGDInterval.igdType2dType(igdType);
                    }
                    if (sampID > 0 && iGDInterval.getTopID() > 0 && sampID == iGDInterval.getTopID()) {
                        return IGDInterval.igdType2dType(igdType);
                    }
                    if (sampID <= 0 || iGDInterval.getBaseID() <= 0 || sampID != iGDInterval.getBaseID()) continue;
                    return IGDInterval.igdType2dType(igdType);
                }
            }
        }
        for (Biocom biocom : this.comments) {
            if (biocom.getTopSample() == sample || biocom.getBaseSample() == sample) {
                return SBdb.did2comType(biocom.getDiscID());
            }
            if (sampID > 0 && biocom.getTopID() > 0 && sampID == biocom.getTopID()) {
                return SBdb.did2comType(biocom.getDiscID());
            }
            if (sampID <= 0 || biocom.getBaseID() <= 0 || sampID != biocom.getBaseID()) continue;
            return SBdb.did2comType(biocom.getDiscID());
        }
        object = this.events;
        synchronized (object) {
            for (WellEvent event : this.events) {
                if (event.getSample() == sample) {
                    return 16;
                }
                if (event.getSampID() <= 0 || sampID <= 0 || event.getSampID() != sampID) continue;
                return 16;
            }
        }
        if (this.envs != null) {
            for (IGDIntervalEnv iGDIntervalEnv : this.envs) {
                if (iGDIntervalEnv.getTopID() != sampID && iGDIntervalEnv.getBaseID() != sampID) continue;
                return 15;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getZoneTypes() {
        HashMap<Integer, List<IGDIntervalZone>> hashMap = this.zones;
        synchronized (hashMap) {
            return this.zones.keySet();
        }
    }

    public String checkEventPicked(SBEvent event) {
        if (!this.getEvents().isEmpty()) {
            boolean picked = false;
            Object msg = "This taxon is already linked to events:\n\n";
            for (WellEvent e : this.getEvents()) {
                if (e.getEvent().getEvID() != event.getEvID()) continue;
                msg = (String)msg + e.toString() + "\n";
                picked = true;
            }
            if (picked) {
                return msg;
            }
        }
        return null;
    }

    public class BiocomEdit
    extends SbugsEdit {
        final Biocom originalComment;
        final int wellID;
        Biocom.Builder builder;
        Biocom newComment;
        final String presentationName;

        private BiocomEdit(int wellID, Biocom originalComment, Biocom.Builder builder) {
            this.originalComment = originalComment;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalComment != null && builder != null ? "update comment" : (originalComment != null ? "delete comment" : "new comment");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newComment != null) {
                    this.deleteActionDB(this.newComment);
                }
                if (this.originalComment != null) {
                    this.insertActionDB(this.originalComment);
                }
                WellInterp.this.sbdb.commit();
                WellInterp.this.setChanged();
                WellInterp.this.notifyObservers(this.originalComment != null ? this.originalComment : this.newComment);
            }
            catch (Exception e) {
                WellInterp.this.sbdb.doRollback();
                throw new RuntimeException("Error undoing biocom edit", e);
            }
            if (this.newComment != null) {
                this.deleteActionModel(this.newComment);
            }
            if (this.originalComment != null) {
                this.insertActionModel(this.originalComment);
            }
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalComment != null) {
                    this.deleteActionDB(this.originalComment);
                }
                if (!(built = this.buildNewComment()) && this.newComment != null) {
                    this.insertActionDB(this.newComment);
                }
                WellInterp.this.sbdb.commit();
            }
            catch (SQLException e) {
                WellInterp.this.sbdb.doRollback();
                throw new RuntimeException("Error redoing biocom edit", e);
            }
            if (this.originalComment != null) {
                this.deleteActionModel(this.originalComment);
            }
            if (this.newComment != null) {
                this.insertActionModel(this.newComment);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.newComment != null ? this.newComment : this.originalComment);
            super.redo();
        }

        private boolean buildNewComment() throws SQLException {
            if (this.builder == null) {
                return false;
            }
            this.newComment = this.builder.build(this.wellID, WellInterp.this.interpID);
            this.builder = null;
            return true;
        }

        private void insertActionDB(Biocom bc) throws SQLException {
            bc.store(this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(Biocom bc) {
            WellInterp.this.insertBiocom(bc);
        }

        private void deleteActionDB(Biocom bc) throws SQLException {
            bc.delete(this.wellID, WellInterp.this.interpID);
        }

        private void deleteActionModel(Biocom bc) {
            WellInterp.this.comments.remove(bc);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public Biocom getBiocom() {
            return this.newComment;
        }
    }

    public class EnvEdit
    extends SbugsEdit {
        final IGDIntervalEnv originalEnv;
        final int wellID;
        IGDIntervalEnv.Builder builder;
        IGDIntervalEnv newEnv;
        final String presentationName;

        private EnvEdit(int wellID, IGDIntervalEnv originalEnv, IGDIntervalEnv.Builder builder) {
            this.originalEnv = originalEnv;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalEnv != null && builder != null ? "update environment" : (originalEnv != null ? "delete environment" : "new environment");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newEnv != null) {
                    this.deleteActionDB(this.newEnv);
                }
                if (this.originalEnv != null) {
                    this.insertActionDB(this.originalEnv);
                }
                WellInterp.this.sbdb.commit();
            }
            catch (Exception e) {
                WellInterp.this.sbdb.doRollback();
                throw new RuntimeException("Error undoing environment edit", e);
            }
            if (this.newEnv != null) {
                this.deleteActionModel(this.newEnv);
            }
            if (this.originalEnv != null) {
                this.insertActionModel(this.originalEnv);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.originalEnv != null ? this.originalEnv : this.newEnv);
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalEnv != null) {
                    this.deleteActionDB(this.originalEnv);
                }
                if (!(built = this.buildNewEnv()) && this.newEnv != null) {
                    this.insertActionDB(this.newEnv);
                }
                WellInterp.this.sbdb.commit();
            }
            catch (Exception e) {
                WellInterp.this.sbdb.doRollback();
                throw new RuntimeException("Error redoing environment edit", e);
            }
            if (this.originalEnv != null) {
                this.deleteActionModel(this.originalEnv);
            }
            if (this.newEnv != null) {
                this.insertActionModel(this.newEnv);
            }
            WellInterp.this.setChanged();
            WellInterp.this.notifyObservers(this.newEnv != null ? this.newEnv : this.originalEnv);
            super.redo();
        }

        private boolean buildNewEnv() throws SQLException, SBException {
            if (this.builder == null) {
                return false;
            }
            this.newEnv = this.builder.build(this.wellID, WellInterp.this.interpID, null);
            this.builder = null;
            return true;
        }

        private void insertActionDB(IGDIntervalEnv env) throws SQLException, SBException {
            env.store(null, this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(IGDIntervalEnv env) {
            WellInterp.this.insertEnv(env);
        }

        private void deleteActionDB(IGDIntervalEnv env) throws SQLException {
            env.delete(this.wellID, WellInterp.this.interpID);
        }

        private void deleteActionModel(IGDIntervalEnv env) {
            WellInterp.this.envs.remove(env);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public IGDIntervalEnv getEnv() {
            return this.newEnv;
        }
    }

    public class ZoneEdit
    extends SbugsEdit {
        final IGDIntervalZone originalZone;
        final int wellID;
        IGDIntervalZone.Builder builder;
        IGDIntervalZone newZone;
        final String presentationName;
        boolean notifyObservers = true;

        private ZoneEdit(int wellID, IGDIntervalZone originalZone, IGDIntervalZone.Builder builder, boolean notifyObservers) {
            this(wellID, originalZone, builder);
            this.notifyObservers = notifyObservers;
        }

        private ZoneEdit(int wellID, IGDIntervalZone originalZone, IGDIntervalZone.Builder builder) {
            this.originalZone = originalZone;
            this.builder = builder;
            this.wellID = wellID;
            String s = originalZone != null && builder != null ? "update interval" : (originalZone != null ? "delete interval" : "new interval");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newZone != null) {
                    this.deleteActionDB(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionDB(this.originalZone);
                }
                WellInterp.this.sbdb.commit();
                if (this.newZone != null) {
                    this.deleteActionModel(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionModel(this.originalZone);
                }
            }
            catch (Exception e) {
                WellInterp.this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error undoing interval edit", e);
            }
            WellInterp.this.setChanged();
            if (this.notifyObservers) {
                WellInterp.this.notifyObservers(this.originalZone != null ? this.originalZone : this.newZone);
            }
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalZone != null) {
                    this.deleteActionDB(this.originalZone);
                }
                if (!(built = this.buildNewZone()) && this.newZone != null) {
                    this.insertActionDB(this.newZone);
                }
                WellInterp.this.sbdb.commit();
                if (this.originalZone != null) {
                    this.deleteActionModel(this.originalZone);
                }
                if (this.newZone != null) {
                    this.insertActionModel(this.newZone);
                }
            }
            catch (Exception e) {
                WellInterp.this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error redoing interval edit", e);
            }
            WellInterp.this.setChanged();
            if (this.notifyObservers) {
                WellInterp.this.notifyObservers(this.newZone != null ? this.newZone : this.originalZone);
            }
            super.redo();
        }

        private boolean buildNewZone() throws SQLException, SBException {
            if (this.builder == null) {
                return false;
            }
            this.newZone = this.builder.build(this.wellID, WellInterp.this.interpID);
            this.builder = null;
            return true;
        }

        private void insertActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            zone.store(this.wellID, WellInterp.this.interpID);
        }

        private void insertActionModel(IGDIntervalZone zone) throws SBException {
            WellInterp.this.insertZone(zone);
        }

        private void deleteActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            zone.delete(this.wellID, WellInterp.this.interpID, null);
        }

        private void deleteActionModel(IGDIntervalZone zone) {
            if (!WellInterp.this.getIGDList(zone.igdType).remove(zone)) {
                System.out.println("WARNING: did deleteActionModel did not work");
            }
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public IGDIntervalZone getZone() {
            return this.newZone;
        }
    }
}

