/*
 * Decompiled with CFR 0.152.
 */
package model2_1.taxa;

import java.util.HashSet;
import java.util.List;
import model2_1.Genus;
import model2_1.taxa.GenusListener;
import util.listener.AbstractPublisher;

public class GenusUpdatePublisher
extends AbstractPublisher<Genus, GenusListener> {
    private boolean genusDetailsUpdated;
    private boolean genusDeleted;
    private final HashSet<Integer> speciesAdded = new HashSet();
    private final HashSet<Integer> speciesRemoved = new HashSet();

    public GenusUpdatePublisher(Genus genus) {
        super((Object)genus);
    }

    public void setGenusDetailsUpdated() {
        this.genusDetailsUpdated = true;
    }

    public void speciesAdded(int specID) {
        this.speciesAdded.add(specID);
    }

    public void speciesRemoved(int specID) {
        this.speciesRemoved.add(specID);
    }

    public void setGenusDeleted() {
        this.genusDeleted = true;
    }

    public void notifyListeners() {
        List listeners = this.getListeners();
        if (listeners == null) {
            return;
        }
        Genus genus = (Genus)this.getSubject();
        for (GenusListener l : listeners) {
            if (this.genusDetailsUpdated) {
                l.onGenusDetailsUpdated(genus);
            }
            if (!this.speciesAdded.isEmpty() || !this.speciesRemoved.isEmpty()) {
                l.onGenusSpeciesListUpdated(genus, this.speciesAdded, this.speciesRemoved);
            }
            if (!this.genusDeleted) continue;
            l.onGenusDelete(genus);
        }
        this.genusDetailsUpdated = false;
        this.genusDeleted = false;
        this.speciesAdded.clear();
        this.speciesRemoved.clear();
    }
}

