/*
 * Decompiled with CFR 0.152.
 */
package model2_1.wellinterp;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import model2_1.IGDIntervalZone;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.api.Discipline;
import model2_1.wellinterp.InterpEdit;
import model2_1.wellinterp.InterpItem;
import model2_1.wellinterp.InterpListObserver;
import model2_1.wellinterp.RefreshKey;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public abstract class InterpList<T extends InterpItem> {
    final int interpID;
    private final List<T> items = new CopyOnWriteArrayList<T>();
    private final InterpListObserver observer;

    public InterpList(int interpID, InterpListObserver observer) {
        this.interpID = interpID;
        this.observer = observer;
    }

    void notifyObserver(T t) {
        this.observer.interpListChanged((InterpItem)t);
    }

    public List<T> getItems() {
        return new LinkedList<T>(this.items);
    }

    public Iterator<T> getItemIterator() {
        return this.items.iterator();
    }

    public List<T> getItems(int schID) {
        if (schID > 0) {
            LinkedList<InterpItem> itemsOfSch = new LinkedList<InterpItem>();
            for (InterpItem t : this.items) {
                if (t.getSchID() != schID) continue;
                itemsOfSch.add(t);
            }
            return itemsOfSch;
        }
        return this.getItems();
    }

    public T getItemAt(int row) {
        return (T)((InterpItem)this.items.get(row));
    }

    public T getItem(int schID, int row) {
        if (schID > 0) {
            int i = -1;
            for (InterpItem t : this.items) {
                if (t.getSchID() == schID) {
                    ++i;
                }
                if (i != row) continue;
                return (T)t;
            }
        }
        return this.getItemAt(row);
    }

    public int size() {
        return this.items.size();
    }

    public abstract void load(Well var1) throws SQLException;

    public void reload(Well well) throws SQLException {
        this.items.clear();
        this.load(well);
    }

    public abstract InterpEdit<T> add();

    public boolean store(InterpList<T> wsInterpList, int wellID, Discipline discID, SBdb db) throws SBException, SQLException {
        if (!db.getWell(wellID).canWrite(db, null)) {
            throw new SBException(db.getWell(wellID).getDeniedReason(db, "store " + this.getItemDescriptor(), "well", true));
        }
        if (!db.isConnected()) {
            throw new IllegalStateException("Attempt to store " + this.getItemDescriptor() + " in workspace");
        }
        boolean changed = false;
        for (InterpItem wsT : wsInterpList.getItems()) {
            if (discID != null && wsT.getDiscipline() != discID) continue;
            InterpItem dbT = null;
            for (InterpItem t : this.getItems()) {
                if (!wsT.isFuncEquivalent(t)) continue;
                dbT = t;
                break;
            }
            if (dbT != null) {
                System.out.println("Storing " + this.getItemDescriptor() + " - attempt to udpate");
                continue;
            }
            dbT = this.copyToDatabase(wsT, wellID, db);
            this.insert(dbT);
            changed = true;
        }
        return changed;
    }

    abstract T copyToDatabase(T var1, int var2, SBdb var3) throws SQLException, SBException;

    public void insert(T t) {
        Iterator<T> it = this.items.iterator();
        int i = 0;
        while (it.hasNext()) {
            IGDIntervalZone zone;
            InterpItem current = (InterpItem)it.next();
            if (t.getSample() == null) {
                throw new IllegalStateException("Can't insert item with no linked sample");
            }
            if (t.getSample().getDepth() < current.getSample().getDepth()) {
                this.items.add(i, t);
                return;
            }
            if (t instanceof IGDIntervalZone && t.getSample().getDepth() == current.getSample().getDepth() && (zone = (IGDIntervalZone)t).getHier() <= ((IGDIntervalZone)current).getHier()) {
                this.items.add(i, t);
                return;
            }
            ++i;
        }
        this.items.add(t);
    }

    public abstract void insertStoredCopy(T var1, int var2, SBdb var3) throws SQLException, SBException, InvalidFieldException;

    public void delete(Collection<T> toDelete, int wellID, SBdb sbdb) throws SQLException, SBException, SBPermissionException {
        if (sbdb.isConnected()) {
            for (InterpItem t : toDelete) {
                t.delete(wellID, this.interpID, null);
            }
            sbdb.updateAuditTrail(this.getAuditType(), "DELETE " + toDelete.size() + " from " + sbdb.getWell(wellID) + " (" + sbdb.getInterp(this.interpID) + ")");
        }
        this.items.removeAll(toDelete);
    }

    public boolean deleteAll(int wellID, Discipline discID, SBdb sbdb) throws SQLException {
        if (this.items.isEmpty()) {
            return false;
        }
        String sql = "DELETE FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE interp_id=" + this.interpID + " AND well_id=" + wellID;
        if (discID != null) {
            sql = sql + "AND disc_id='" + discID + "'";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        if (discID != null) {
            ListIterator<T> it = this.items.listIterator();
            while (it.hasNext()) {
                InterpItem item = (InterpItem)it.next();
                if (discID != item.getDiscipline()) continue;
                it.remove();
            }
        } else {
            this.items.clear();
        }
        return true;
    }

    public abstract String getItemDescriptor();

    abstract String getAuditType();

    abstract String getTableName();

    public void remove(T t) {
        this.items.remove(t);
    }

    public void unload(Discipline disc) {
        if (disc != null) {
            for (InterpItem t : this.getItems()) {
                if (t.getDiscipline() != disc) continue;
                this.remove(t);
            }
        } else {
            this.items.clear();
        }
    }

    public void refresh(SBdb sbdb, Statement stmt, Well well) throws SQLException, SBException {
        String sql = sbdb.modQuery(this.getRefreshQueryString(sbdb, well.getWellID(), this.interpID));
        ResultSet rs = stmt.executeQuery(sql);
        InterpItem notifier = null;
        HashSet<String> keyIDs = new HashSet<String>();
        while (rs.next()) {
            RefreshKey<InterpItem> refreshKey = this.getRefreshKey(rs);
            keyIDs.add(refreshKey.getKey());
            Timestamp resultUpdatedTime = rs.getTimestamp("updated");
            boolean found = false;
            for (InterpItem t : this.items) {
                if (!refreshKey.matches(t)) continue;
                found = true;
                if (resultUpdatedTime == null || t.getUpdated() != null && !resultUpdatedTime.after(t.getUpdated())) break;
                notifier = this.load(refreshKey, t, sbdb, well, this.interpID);
                break;
            }
            if (found) continue;
            notifier = this.load(refreshKey, null, sbdb, well, this.interpID);
            this.insert(notifier);
        }
        if (keyIDs.size() < this.items.size()) {
            LinkedList<InterpItem> toRemove = new LinkedList<InterpItem>();
            for (InterpItem t : this.items) {
                if (keyIDs.contains(this.getRefreshKeyString(t))) continue;
                toRemove.add(t);
                if (notifier != null) continue;
                notifier = t;
            }
            this.items.removeAll(toRemove);
        }
        if (notifier != null) {
            this.notifyObserver(notifier);
        }
    }

    abstract String getRefreshQueryString(SBdb var1, int var2, int var3);

    abstract RefreshKey<T> getRefreshKey(ResultSet var1) throws SQLException;

    abstract String getRefreshKeyString(T var1);

    abstract T load(RefreshKey<T> var1, T var2, SBdb var3, Well var4, int var5) throws SQLException, SBException;

    SBdb initLoad(Well well) throws SQLException {
        if (this.size() > 0) {
            throw new IllegalStateException(this.getItemDescriptor() + "s already loaded");
        }
        well.getSamples();
        return well.getDataModel();
    }

    public void fill(SBdb sbdb, WsWell wsWell, boolean checkSamples, List<T> dbItems) throws SBException, SQLException, SBPermissionException {
        for (InterpItem dbT : dbItems) {
            Object baseSample;
            if (checkSamples) {
                Sample topSample = dbT.getSample();
                if (topSample != null && !wsWell.hasSample(topSample)) {
                    wsWell.addSampleCopy(null, topSample);
                }
                if ((baseSample = dbT.getBaseSample()) != null && !wsWell.hasSample((Sample)baseSample)) {
                    wsWell.addSampleCopy(null, (Sample)baseSample);
                }
            }
            boolean hasItem = false;
            baseSample = this.items.iterator();
            while (baseSample.hasNext()) {
                InterpItem item = (InterpItem)baseSample.next();
                if (!this.getRefreshKeyString(dbT).equals(this.getRefreshKeyString(item))) continue;
                hasItem = true;
                break;
            }
            if (hasItem) continue;
            InterpItem wsT = this.copyToWorkspace(dbT, sbdb, wsWell);
            this.insert(wsT);
        }
    }

    abstract T copyToWorkspace(T var1, SBdb var2, WsWell var3) throws SQLException, SBException;

    public boolean hasData() {
        return !this.items.isEmpty();
    }

    public int hasData(int sampID) {
        for (InterpItem item : this.items) {
            if (item.getSample().getSampID() == sampID) {
                return this.getDataType(item);
            }
            if (item.getBaseSample() == null || item.getBaseSample().getSampID() != sampID) continue;
            return this.getDataType(item);
        }
        return 0;
    }

    abstract int getDataType(T var1);

    public final boolean mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        for (InterpItem item : this.items) {
            hasChanged |= item.mergeSamples(donor, target);
        }
        return hasChanged;
    }

    public boolean containsAll(Collection<T> itemsToCheck) {
        return this.items.containsAll(itemsToCheck);
    }

    public final void parseXML(Element xml, SBdb sbdb, WsWell well, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        Iterator it = xml.getContent((Filter)new ElementFilter(this.getXmlElementFilterName())).iterator();
        while (it.hasNext()) {
            T item = this.parseXmlItem(sbdb, well, (Element)it.next(), dataTypes);
            if (item == null) continue;
            this.items.add(item);
            dataTypes.add(this.getDataType(item));
        }
    }

    abstract String getXmlElementFilterName();

    abstract T parseXmlItem(SBdb var1, WsWell var2, Element var3, Set<Integer> var4) throws SQLException, SBException, ParseException;

    public final List<Integer> writeXML(BufferedWriter out, int indent, Discipline discipline, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        for (InterpItem t : this.getItems()) {
            if (discipline != null && t.getDiscipline() != discipline) continue;
            userIDs.addAll(t.writeXML(out, indent, units));
        }
        return userIDs;
    }

    public void writeDEX(FileWriter out, String eol, Discipline discipline, char units) throws IOException, SQLException, SBException {
        for (InterpItem t : this.getItems()) {
            if (discipline != null && t.getDiscipline() != discipline) continue;
            t.writeDEX(out, eol, units, SB.df);
        }
    }

    public Set<Integer> getSchemeIDs() {
        HashSet<Integer> schIDs = new HashSet<Integer>();
        for (InterpItem t : this.items) {
            if (t.getSchID() <= 0) continue;
            schIDs.add(t.getSchID());
        }
        return schIDs;
    }
}

