/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sblicense;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import com.stratadata.sblicense.LicenseException;
import com.stratadata.sblicense.SbugsLicenseHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class SbugsLicense {
    private static final Logger LOGGER = Logger.getLogger(SbugsLicense.class.getName());
    public static final String LIC_FAIL_STRING = "StrataBugs licence no longer available.";
    private static final int COUNT = 1;
    private final SbugsLicenseHandler handler;
    private RlmHandle rlmHandle;
    private RlmLicense license;
    private boolean licenseIsServed = false;
    private Date licenseBeatfailure;
    private static SbugsLicense sbugsLicense;

    private SbugsLicense(SbugsLicenseHandler h) {
        this.handler = h;
    }

    public static SbugsLicense getInstance() {
        return sbugsLicense;
    }

    public static void initLicense(SbugsLicenseHandler p) {
        sbugsLicense = new SbugsLicense(p);
        sbugsLicense.getRlmLicence();
    }

    private void getRlmLicence() {
        int tries = 0;
        while (tries++ < 2) {
            try {
                LOGGER.info("Getting RLM handle ...");
                boolean hasRLMLicense = false;
                String rlmLicenseServer = System.getenv("RLM_LICENSE");
                if (rlmLicenseServer == null) {
                    rlmLicenseServer = System.getenv("STRATADATA_LICENSE");
                }
                if (rlmLicenseServer == null) {
                    LOGGER.info("No environment variable for RLM License Server found");
                } else {
                    LOGGER.log(Level.INFO, "Environment variable for RLM License Server found: {0}", rlmLicenseServer);
                    hasRLMLicense = true;
                }
                String rlmLicensePath = "";
                String libraryPath = SbugsLicense.getProgramDataPath();
                String localPath = ".";
                try {
                    localPath = new File(".").getCanonicalPath();
                }
                catch (IOException e) {
                    this.handler.showError("Unable to obtain current working directory: " + e.getMessage());
                }
                if (Files.exists(Paths.get(libraryPath, new String[0]), new LinkOption[0])) {
                    LOGGER.log(Level.INFO, "Checking for license files in Library path: {0}", libraryPath);
                    hasRLMLicense = this.checkForLicenseFiles(libraryPath);
                    if (hasRLMLicense) {
                        rlmLicensePath = libraryPath;
                    }
                }
                if (!hasRLMLicense) {
                    LOGGER.log(Level.INFO, "Checking for license in current directory: {0}", localPath);
                    hasRLMLicense = this.checkForLicenseFiles(localPath);
                    if (hasRLMLicense) {
                        rlmLicensePath = ".";
                    }
                }
                this.rlmHandle = new RlmHandle(rlmLicensePath, "", "");
                if (this.rlmHandle == null) {
                    this.handler.printInfo("Null handle returned from RLMHandle");
                    this.handler.forceSystemExit(-1);
                }
            }
            catch (UnsatisfiedLinkError e) {
                this.handler.showError("Cannot load RLM library: " + e.getMessage());
                this.handler.forceSystemExit(-1);
            }
            catch (RlmException e) {
                this.handler.showError("Error fetching licence handle: " + e.getMessage());
                this.handler.forceSystemExit(-1);
            }
            try {
                this.license = new RlmLicense(this.rlmHandle, this.handler.getProduct(), this.handler.getVersion(), 1);
                this.handler.printInfo("License expiration date: " + this.license.getExpiration());
                this.handler.printInfo("Maximum share: " + this.license.getMaxShare());
                this.handler.printInfo("License is roaming: " + this.license.isRoaming());
                this.handler.printInfo("Licence host: " + this.license.getHostID());
                this.handler.printInfo("Licence file path: " + this.license.getLFPath());
                break;
            }
            catch (RlmException e) {
                String[] hostIDs;
                Object hostID = "";
                for (String s : hostIDs = this.rlmHandle.getAllHostIDs(1)) {
                    hostID = (String)hostID + s;
                    hostID = (String)hostID + " ";
                }
                hostIDs = this.rlmHandle.getAllHostIDs(3);
                if (((String)hostID).length() > 0) {
                    hostID = (String)hostID + "/ ";
                }
                for (String s : hostIDs) {
                    hostID = (String)hostID + s;
                    hostID = (String)hostID + " ";
                }
                if (this.handler.handleLicenseServerError((Exception)((Object)e), (String)hostID)) continue;
                this.handler.forceSystemExit(1);
            }
        }
    }

    public static boolean checkRLMlicense() {
        return SbugsLicense.getInstance().checkInstanceRLMlicence();
    }

    private boolean checkForLicenseFiles(String path) {
        File[] files;
        FileFilter logFilefilter = new FileFilter(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".lic");
            }
        };
        File directory = new File(path);
        for (File f : files = directory.listFiles(logFilefilter)) {
            LOGGER.log(Level.INFO, "Found license file: {0}", f.getName());
        }
        return files.length != 0;
    }

    public static String getProgramDataPath() {
        String path = System.getProperty("os.name").startsWith("Mac") ? System.getProperty("user.home") + "/Library/Application Support/StrataData" : System.getenv("PROGRAMDATA") + "\\StrataData";
        return path;
    }

    private boolean checkInstanceRLMlicence() {
        try {
            if (this.license.getServer() != null && !this.license.getServer().isEmpty()) {
                if (!this.licenseIsServed) {
                    this.handler.printInfo("License server: " + this.license.getServer());
                }
                this.licenseIsServed = true;
            }
            if (this.license.getAttrHealth() == 0) {
                this.licenseBeatfailure = null;
                return true;
            }
            if (!this.licenseIsServed) {
                return false;
            }
            if (this.licenseBeatfailure == null) {
                this.licenseBeatfailure = new Date();
                this.handler.printInfo("Missed licence check from server at: " + String.valueOf(this.licenseBeatfailure));
            } else if (this.licenseBeatfailure.getTime() < System.currentTimeMillis() - this.handler.getLicenseMaxTimeout() * 1000L) {
                this.licenseBeatfailure = null;
                this.license.checkin();
                this.getRlmLicence();
            } else {
                this.handler.printInfo("Missed further licence check from server at: " + String.valueOf(new Date()));
            }
            return true;
        }
        catch (RlmException rlmx) {
            this.handler.showInfo("Exception when checking RLM licence: " + rlmx.toString());
            LOGGER.log(Level.WARNING, "Exception when checking RLM licence", rlmx);
            return false;
        }
    }

    public static void checkExit() {
        if (SbugsLicense.getInstance() == null) {
            return;
        }
        SbugsLicense.getInstance().checkInstanceExit();
    }

    private void checkInstanceExit() {
        if (this.license != null) {
            this.license.checkin();
            this.license = null;
        }
        if (this.rlmHandle != null) {
            this.rlmHandle.close();
            this.rlmHandle = null;
        }
    }

    public static boolean isCloseToExpiry() {
        return SbugsLicense.getInstance().license.daysToExpiration() > 0 && SbugsLicense.getInstance().license.daysToExpiration() < 30;
    }

    public static int getDaysToExpiration() {
        return SbugsLicense.getInstance().license.daysToExpiration();
    }

    public static String getExpiration() {
        return SbugsLicense.getInstance().license.getExpiration();
    }

    public static boolean isRoaming() {
        return SbugsLicense.getInstance().license.isRoaming();
    }

    public static boolean canRoam() {
        return SbugsLicense.getInstance().license.getMaxRoam() > 0 && SbugsLicense.getInstance().license.getMaxRoamCount() > 0 && SbugsLicense.getInstance().license.getIssuer().equalsIgnoreCase("user_roam");
    }

    public static int getMaxRoamDays() throws LicenseException {
        Vector vec = SbugsLicense.getInstance().rlmHandle.getAvailableProducts(SbugsLicense.getInstance().handler.getProduct(), SbugsLicense.getInstance().handler.getVersion());
        if (vec == null || vec.isEmpty()) {
            throw new LicenseException("Cannot find roaming license");
        }
        RlmAvailableProduct rlmProduct = (RlmAvailableProduct)vec.get(0);
        return rlmProduct.getMaxRoam();
    }

    public static String getCustomer() {
        return SbugsLicense.getInstance().license.getCustomer();
    }

    public static boolean isDemoLicense() {
        int type = SbugsLicense.getInstance().license.getType();
        switch (type) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static String getHostType() {
        String hostID = SbugsLicense.getInstance().license.getHostID();
        if (hostID.startsWith("SENTINEL")) {
            hostID = "dongle";
        } else if (hostID.isEmpty()) {
            hostID = "server";
        }
        return hostID;
    }

    public static void roamLicense(String nDays, File jarFilePath) throws IOException {
        File installedAppFile;
        SbugsLicense.getInstance().license.checkin();
        String[] commands = null;
        if (System.getenv("PROGRAMFILES") != null && jarFilePath.getPath().contains(System.getenv("PROGRAMFILES")) && (installedAppFile = new File(System.getenv("PROGRAMFILES") + File.separator + "StrataBugs" + File.separator + "StrataBugs.exe")).exists()) {
            commands = new String[]{installedAppFile.getPath()};
        }
        if (commands == null) {
            String installRoot = jarFilePath.getParent();
            if (new File(installRoot + File.separator + "jre").exists()) {
                commands = new String[]{installRoot + File.separator + "jre" + File.separator + "bin" + File.separator + "java", "-cp", jarFilePath.getName(), "jsbugs.userconnect.DialogRLMRoamExec"};
            } else {
                String msg = "Cannot find java runtime folder (jre). Licence not checked in/out";
                JOptionPane.showMessageDialog(null, msg);
                LOGGER.log(Level.WARNING, msg);
                return;
            }
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        Map<String, String> env = pb.environment();
        env.put("RLM_ROAM", nDays);
        Process process = pb.start();
        LOGGER.log(Level.CONFIG, "Process info: " + process.info().toString());
    }

    private static int parseJarFileVersion(File f, String jarFileRoot) {
        int localJarVersion = 0;
        String appJarVersionStrg = f.getName().substring(jarFileRoot.length());
        for (int i = 0; i < appJarVersionStrg.length(); ++i) {
            if (Character.isDigit(appJarVersionStrg.charAt(i))) continue;
            appJarVersionStrg = appJarVersionStrg.substring(0, i);
            try {
                localJarVersion = Integer.parseInt(appJarVersionStrg);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "Can't parse installed application version string: {0}", appJarVersionStrg);
            }
            break;
        }
        return localJarVersion;
    }
}

