/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.logging.Level;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.PolarStereographic;

class EnvelopeReprojector {
    EnvelopeReprojector() {
    }

    static GeneralBounds transform(CoordinateOperation operation, Bounds envelope) throws TransformException {
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(crs, sourceCRS)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
        MathTransform mt = operation.getMathTransform();
        GeneralPosition centerPt = new GeneralPosition(mt.getTargetDimensions());
        GeneralBounds transformed = CRS.transform(mt, envelope, centerPt);
        EnvelopeReprojector.expandOnAxisExtremCrossing(envelope, sourceCRS, mt, transformed);
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        if (targetCRS == null) {
            return transformed;
        }
        MapProjection sourceProjection = CRS.getMapProjection(sourceCRS);
        GeneralBounds generalEnvelope = EnvelopeReprojector.toGeneralEnvelope(envelope);
        EnvelopeReprojector.expandOnPolarOrigin(sourceCRS, mt, transformed, targetCRS, sourceProjection, generalEnvelope);
        MapProjection targetProjection = CRS.getMapProjection(targetCRS);
        if (targetProjection instanceof PolarStereographic && sourceCRS instanceof GeographicCRS) {
            EnvelopeReprojector.expandOnPolarQuadrands(envelope, sourceCRS, mt, transformed, generalEnvelope);
        }
        if (targetProjection instanceof Orthographic && sourceCRS instanceof GeographicCRS) {
            EnvelopeReprojector.expandOnOrthographicQuadrants(envelope, transformed, targetCRS, mt);
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        GeneralBounds transformedSingularities = EnvelopeReprojector.expandSingularityPoints(mt, centerPt, transformed, generalEnvelope, targetCS);
        if (transformedSingularities != null) {
            return transformedSingularities;
        }
        if (targetProjection != null) {
            EnvelopeReprojector.getProjectionCenterLonLat(targetCRS, centerPt);
            if (EnvelopeReprojector.isPole(centerPt, DefaultGeographicCRS.WGS84)) {
                EnvelopeReprojector.includePoles(envelope, sourceCRS, centerPt, transformed, targetCRS, targetProjection);
            }
            if (targetProjection instanceof AzimuthalEquidistant.Abstract) {
                EnvelopeReprojector.expandOnAntimeridian(envelope, sourceCRS, centerPt, transformed, targetCRS);
            }
        }
        return transformed;
    }

    private static void expandOnOrthographicQuadrants(Bounds sourceEnvelope, GeneralBounds transformed, CoordinateReferenceSystem targetCRS, MathTransform mt) throws TransformException {
        GeneralPosition centerPt = new GeneralPosition(2);
        EnvelopeReprojector.getProjectionCenterLonLat(targetCRS, centerPt);
        GeneralPosition targetPt = new GeneralPosition(mt.getTargetDimensions());
        GeneralPosition sourcePt = new GeneralPosition(mt.getSourceDimensions());
        double o1 = centerPt.getOrdinate(0);
        if (sourceEnvelope.getMinimum(0) <= o1 && sourceEnvelope.getMaximum(0) >= o1) {
            sourcePt.setOrdinate(0, o1);
            sourcePt.setOrdinate(1, Math.max(sourceEnvelope.getMinimum(1), centerPt.getOrdinate(1) - 90.0));
            mt.transform((Position)sourcePt, (Position)targetPt);
            transformed.add(targetPt);
            sourcePt.setOrdinate(0, o1);
            sourcePt.setOrdinate(1, Math.min(centerPt.getOrdinate(1) + 90.0, sourceEnvelope.getMaximum(1)));
            mt.transform((Position)sourcePt, (Position)targetPt);
            transformed.add(targetPt);
        }
        double o2 = centerPt.getOrdinate(1);
        if (sourceEnvelope.getMinimum(1) <= o2 && sourceEnvelope.getMaximum(1) >= o2) {
            sourcePt.setOrdinate(0, Math.max(sourceEnvelope.getMinimum(0), centerPt.getOrdinate(0) - 90.0));
            sourcePt.setOrdinate(1, o2);
            mt.transform((Position)sourcePt, (Position)targetPt);
            transformed.add(targetPt);
            sourcePt.setOrdinate(0, Math.min(centerPt.getOrdinate(0) + 90.0, sourceEnvelope.getMaximum(0)));
            sourcePt.setOrdinate(1, o2);
            mt.transform((Position)sourcePt, (Position)targetPt);
            transformed.add(targetPt);
        }
    }

    private static void expandOnAntimeridian(Bounds envelope, CoordinateReferenceSystem sourceCRS, GeneralPosition centerPt, GeneralBounds transformed, CoordinateReferenceSystem targetCRS) {
        EnvelopeReprojector.getProjectionCenterLonLat(targetCRS, centerPt);
        try {
            Bounds geoEnvelope;
            MathTransform geoToTarget;
            if (sourceCRS instanceof GeographicCRS) {
                geoToTarget = CRS.findMathTransform(sourceCRS, targetCRS);
                geoEnvelope = envelope;
            } else {
                MathTransform mtWgs84 = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
                geoToTarget = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
                geoEnvelope = CRS.transform(mtWgs84, envelope, null);
            }
            double nagativeMeridian = -centerPt.getOrdinate(1);
            if (geoEnvelope.getMinimum(1) <= nagativeMeridian && geoEnvelope.getMaximum(1) >= nagativeMeridian) {
                EnvelopeReprojector.expandOnMeridian(transformed, geoToTarget, geoEnvelope, nagativeMeridian - 1.0E-6, 50);
                EnvelopeReprojector.expandOnMeridian(transformed, geoToTarget, geoEnvelope, nagativeMeridian + 1.0E-6, 50);
            }
        }
        catch (FactoryException | TransformException e) {
            CRS.LOGGER.log(Level.FINE, "Failed to transform from source to WGS84 to further enlarge the envelope on extreme points, proceeding without expansion", e);
        }
    }

    private static void includePoles(Bounds envelope, CoordinateReferenceSystem sourceCRS, GeneralPosition centerPt, GeneralBounds transformed, CoordinateReferenceSystem targetCRS, MapProjection targetProjection) {
        try {
            Bounds geoEnvelope;
            MathTransform geoToTarget;
            if (sourceCRS instanceof GeographicCRS) {
                geoToTarget = CRS.findMathTransform(sourceCRS, targetCRS);
                geoEnvelope = envelope;
            } else {
                MathTransform mtWgs84 = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
                geoToTarget = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
                geoEnvelope = CRS.transform(mtWgs84, envelope, null);
            }
            EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
            if (targetProjection instanceof PolarStereographic || targetProjection instanceof LambertAzimuthalEqualArea) {
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
            }
        }
        catch (FactoryException | TransformException e) {
            CRS.LOGGER.log(Level.FINE, "Failed to transform from source to WGS84 to further enlarge the envelope on extreme points, proceeding without expansion", e);
        }
    }

    private static GeneralBounds expandSingularityPoints(MathTransform mt, GeneralPosition centerPt, GeneralBounds transformed, GeneralBounds generalEnvelope, CoordinateSystem targetCS) {
        Position sourcePt = null;
        GeneralPosition targetPt = null;
        int dimension = targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
                if (targetPt == null) {
                    try {
                        mt = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension >= mt.getSourceDimensions()) {
                            CRS.unexpectedException("transform", (Exception)((Object)exception));
                        }
                        return transformed;
                    }
                    targetPt = new GeneralPosition(mt.getSourceDimensions());
                    for (int j = 0; j < dimension; ++j) {
                        targetPt.setOrdinate(j, centerPt.getOrdinate(j));
                    }
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    sourcePt = mt.transform(targetPt, sourcePt);
                }
                catch (Exception e) {
                    continue;
                }
                if (!generalEnvelope.contains(sourcePt)) continue;
                transformed.add(targetPt);
            } while (testMax = !testMax);
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt.getOrdinate(i));
        }
        return null;
    }

    private static void expandOnPolarQuadrands(Bounds envelope, CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralBounds transformed, GeneralBounds generalEnvelope) throws TransformException {
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        for (int i = 0; i < sourceCS.getDimension(); ++i) {
            int lon;
            CoordinateSystemAxis axis = sourceCS.getAxis(i);
            if (!CRS.equalsIgnoreMetadata(DefaultCoordinateSystemAxis.LONGITUDE, axis)) continue;
            double minLon = envelope.getMinimum(i);
            double maxLon = envelope.getMaximum(i);
            Position lower = generalEnvelope.getLowerCorner();
            Position upper = generalEnvelope.getUpperCorner();
            Position2D dest = new Position2D();
            if (maxLon - minLon >= 360.0) {
                for (lon = -180; lon <= 180; lon += 90) {
                    EnvelopeReprojector.addLowerUpperPoints(mt, transformed, i, lower, upper, dest, lon);
                }
                continue;
            }
            for (lon = -180; lon <= 180; lon += 90) {
                if (!(minLon < (double)lon) || !(maxLon > (double)lon)) continue;
                EnvelopeReprojector.addLowerUpperPoints(mt, transformed, i, lower, upper, dest, lon);
            }
        }
    }

    private static void expandOnPolarOrigin(CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralBounds transformed, CoordinateReferenceSystem targetCRS, MapProjection sourceProjection, GeneralBounds generalEnvelope) throws TransformException {
        ParameterValue fn;
        double originY;
        ParameterValue fe;
        double originX;
        Position2D origin;
        if ((sourceProjection instanceof PolarStereographic || sourceProjection instanceof LambertAzimuthalEqualArea) && EnvelopeReprojector.isPole(origin = new Position2D(originX = (fe = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_EASTING.getName().getCode())).doubleValue(), originY = (fn = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_NORTHING.getName().getCode())).doubleValue()), sourceCRS)) {
            if (generalEnvelope.contains(origin)) {
                if (targetCRS instanceof GeographicCRS) {
                    Position lowerCorner = transformed.getLowerCorner();
                    if (CRS.getAxisOrder(targetCRS) == CRS.AxisOrder.NORTH_EAST) {
                        lowerCorner.setOrdinate(1, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(1, 180.0);
                        transformed.add(lowerCorner);
                    } else {
                        lowerCorner.setOrdinate(0, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(0, 180.0);
                        transformed.add(lowerCorner);
                    }
                } else {
                    Position lc = transformed.getLowerCorner();
                    Position uc = transformed.getUpperCorner();
                    for (int j = -180; j < 180; ++j) {
                        EnvelopeReprojector.expandEnvelopeByLongitude(j, lc, transformed, targetCRS);
                        EnvelopeReprojector.expandEnvelopeByLongitude(j, uc, transformed, targetCRS);
                    }
                }
            } else {
                Position uc;
                Position lc;
                if (generalEnvelope.getMinimum(0) < originX && generalEnvelope.getMaximum(0) > originX) {
                    lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(0, originX);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(0, originX);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
                if (generalEnvelope.getMinimum(1) < originY && generalEnvelope.getMaximum(1) > originY) {
                    lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(1, originY);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(1, originY);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
            }
        }
    }

    private static void expandOnAxisExtremCrossing(Bounds envelope, CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralBounds transformed) throws TransformException {
        CoordinateSystem cs;
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralPosition sourcePt = null;
            Position targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min && v1 < max;
                boolean bl = b2 = v2 > min && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform((Position)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform((Position)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getMedian(i));
            }
        }
    }

    private static void expandOnMeridian(GeneralBounds target, MathTransform geoToTarget, Bounds geoEnvelope, double antimeridian, int numPoints) throws TransformException {
        double minLon = geoEnvelope.getMinimum(0);
        double maxLon = geoEnvelope.getMaximum(0);
        double[] points = new double[numPoints * 2];
        double lon = minLon;
        double delta = (maxLon - minLon) / (double)(numPoints - 1);
        int i = 0;
        while (i < points.length) {
            points[i++] = lon;
            points[i++] = antimeridian;
            lon = minLon + delta * (double)i / 2.0;
        }
        geoToTarget.transform(points, 0, points, 0, numPoints);
        Position2D dp = new Position2D();
        int i2 = 0;
        while (i2 < points.length) {
            dp.setOrdinate(0, points[i2++]);
            dp.setOrdinate(1, points[i2++]);
            target.add(dp);
        }
    }

    private static void addLowerUpperPoints(MathTransform mt, GeneralBounds transformed, int axis, Position lower, Position upper, Position dest, double ordinate) throws TransformException {
        lower.setOrdinate(axis, ordinate);
        mt.transform(lower, dest);
        transformed.add(dest);
        upper.setOrdinate(axis, ordinate);
        mt.transform(upper, dest);
        transformed.add(dest);
    }

    private static GeneralBounds toGeneralEnvelope(Bounds envelope) {
        GeneralBounds generalEnvelope = envelope instanceof GeneralBounds ? (GeneralBounds)envelope : new GeneralBounds(envelope);
        return generalEnvelope;
    }

    private static boolean isPole(Position point, CoordinateReferenceSystem crs) {
        GeographicCRS geographic;
        Position2D result;
        block5: {
            result = new Position2D();
            try {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(crs);
                if (projectedCRS != null) {
                    geographic = projectedCRS.getBaseCRS();
                    MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)projectedCRS, (CoordinateReferenceSystem)geographic);
                    mt.transform(point, (Position)result);
                    break block5;
                }
                if (crs instanceof GeographicCRS) {
                    result = point;
                    geographic = (GeographicCRS)crs;
                    break block5;
                }
                return false;
            }
            catch (MismatchedDimensionException | FactoryException | TransformException e) {
                return false;
            }
        }
        double EPS = 1.0E-6;
        if (CRS.getAxisOrder((CoordinateReferenceSystem)geographic) == CRS.AxisOrder.NORTH_EAST) {
            return Math.abs(result.getOrdinate(0) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(0) + 90.0) < 1.0E-6;
        }
        return Math.abs(result.getOrdinate(1) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(1) + 90.0) < 1.0E-6;
    }

    private static void expandEnvelopeByLongitude(double longitude, Position input, GeneralBounds transformed, CoordinateReferenceSystem sourceCRS) {
        try {
            MathTransform mt = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
            Position2D pos = new Position2D(sourceCRS);
            mt.transform(input, (Position)pos);
            pos.setOrdinate(0, longitude);
            mt.inverse().transform((Position)pos, (Position)pos);
            transformed.add(pos);
        }
        catch (Exception e) {
            CRS.LOGGER.log(Level.FINER, "Tried to expand target envelope to include longitude " + longitude + " but failed. This is not necesseraly and issue, this is a best effort attempt to handle the polar stereographic pole singularity during reprojection", e);
        }
    }

    private static GeneralPosition getProjectionCenterLonLat(CoordinateReferenceSystem crs, GeneralPosition centerPt) {
        centerPt.setOrdinate(0, 0.0);
        centerPt.setOrdinate(1, 0.0);
        MapProjection projection = CRS.getMapProjection(crs);
        if (projection == null) {
            return centerPt;
        }
        for (GeneralParameterValue gpv : projection.getParameterValues().values()) {
            if (!(gpv instanceof ParameterValue)) continue;
            ParameterValue pv = (ParameterValue)gpv;
            ReferenceIdentifier pvName = pv.getDescriptor().getName();
            if (MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LATITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LONGITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(0, pv.doubleValue());
                continue;
            }
            if (!MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().equals(pvName)) continue;
            centerPt.setOrdinate(0, pv.doubleValue());
        }
        return centerPt;
    }

    private static void expandEnvelopeOnExtremePoints(GeneralPosition centerPt, GeneralBounds transformed, MathTransform geoToTarget, Bounds geoEnvelope) throws TransformException {
        double centerLat;
        GeneralPosition workPoint = new GeneralPosition(centerPt.getDimension());
        double centerLon = centerPt.getOrdinate(0);
        double minLon = geoEnvelope.getMinimum(0);
        double maxLon = geoEnvelope.getMaximum(0);
        double minLat = geoEnvelope.getMinimum(1);
        double maxLat = geoEnvelope.getMaximum(1);
        if (minLon <= centerLon && centerLon <= maxLon) {
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, minLat);
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, maxLat);
        }
        if (minLat <= (centerLat = centerPt.getOrdinate(1)) && centerLat <= maxLat) {
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, minLon, centerLat);
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, maxLon, centerLat);
        }
    }

    private static void includeTransformedPoint(GeneralBounds envelope, MathTransform mt, GeneralPosition workPoint, double x, double y) throws TransformException {
        workPoint.setOrdinate(0, x);
        workPoint.setOrdinate(1, y);
        mt.transform((Position)workPoint, (Position)workPoint);
        envelope.add(workPoint);
    }

    private static double rollLongitude(double x) {
        double rolled = x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
        return rolled;
    }
}

