/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.ModelVersion;
import java.sql.SQLException;
import java.sql.Statement;
import model2_1.SBdb;

public abstract class CopySource {
    abstract String DBTableName(String var1);

    abstract Statement createStatement() throws SQLException;

    abstract boolean hasUser(int var1) throws SQLException;

    abstract String getDBTypeName();

    abstract String getSchema();

    abstract String getTablePrefix();

    abstract boolean isSQLServer();

    abstract ModelVersion getModelVersion();

    abstract int getTableRowCount(Statement var1, String var2) throws SQLException;

    abstract int getTableRowCount(Statement var1, String var2, String var3) throws SQLException;

    static CopySource newInstance(Object sourceDB) {
        if (sourceDB instanceof model3.SBdb) {
            return new V3Source((model3.SBdb)sourceDB);
        }
        if (sourceDB instanceof SBdb) {
            return new V2Source((SBdb)sourceDB);
        }
        throw new IllegalArgumentException("Cannot create copy source from object: " + String.valueOf(sourceDB));
    }

    private static class V3Source
    extends CopySource {
        final model3.SBdb sbdb;

        public V3Source(model3.SBdb sbdb) {
            this.sbdb = sbdb;
        }

        @Override
        String DBTableName(String tableName) {
            return this.sbdb.DBTableName(tableName);
        }

        @Override
        Statement createStatement() throws SQLException {
            return this.sbdb.getDatabase().createStatement();
        }

        @Override
        boolean hasUser(int usrID) throws SQLException {
            return this.sbdb.getUser(usrID) != null;
        }

        @Override
        boolean isSQLServer() {
            return this.sbdb.getDBType() == DBType.MSSQLSERVER;
        }

        @Override
        ModelVersion getModelVersion() {
            return ModelVersion.V3_0_0;
        }

        @Override
        String getDBTypeName() {
            return this.sbdb.getDBType().getName();
        }

        @Override
        String getSchema() {
            return this.sbdb.getSchema();
        }

        @Override
        int getTableRowCount(Statement sourceStmt, String tableName) throws SQLException {
            return this.sbdb.getTableRowCount(sourceStmt, tableName);
        }

        @Override
        int getTableRowCount(Statement sourceStmt, String tableName, String query) throws SQLException {
            return this.sbdb.getTableRowCount(sourceStmt, tableName);
        }

        @Override
        String getTablePrefix() {
            return this.sbdb.getTablePrefix();
        }
    }

    private static class V2Source
    extends CopySource {
        final SBdb sbdb;

        public V2Source(SBdb sourceDB) {
            this.sbdb = sourceDB;
        }

        @Override
        String DBTableName(String tableName) {
            return this.sbdb.DBTableName(tableName);
        }

        @Override
        Statement createStatement() throws SQLException {
            return this.sbdb.getDatabase().createStatement();
        }

        @Override
        boolean hasUser(int usrID) throws SQLException {
            return this.sbdb.getUser(usrID) != null;
        }

        @Override
        boolean isSQLServer() {
            return this.sbdb.getDBType() == SBdb.DBType.MSSQLSERVER;
        }

        @Override
        ModelVersion getModelVersion() {
            return ModelVersion.v2_1;
        }

        @Override
        String getDBTypeName() {
            return this.sbdb.getDBType().getName();
        }

        @Override
        String getSchema() {
            return this.sbdb.getSchema();
        }

        @Override
        int getTableRowCount(Statement sourceStmt, String tableName) throws SQLException {
            return this.sbdb.getTableRowCount(sourceStmt, tableName);
        }

        @Override
        int getTableRowCount(Statement sourceStmt, String tableName, String query) throws SQLException {
            return this.sbdb.getTableRowCount(sourceStmt, tableName, query);
        }

        @Override
        String getTablePrefix() {
            return this.sbdb.getTablePrefix();
        }
    }
}

