/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconnect;

import com.stratadata.model3.db.DBDriverType;
import com.stratadata.model3.db.ModelVersion;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import util.SB;

public class ConnectionParameters {
    private static final String cryptKey = "SBPREFPW";
    private final ModelVersion modelVersion;
    private int maxConnectionPoolSize = 3;
    private boolean disableConnectionPool = false;
    private String name;
    private DBDriverType driverType;
    private String driverName;
    private String hostName;
    boolean autoServer = false;
    int autoServerPort = 0;
    boolean backupPrompt = false;
    String backupLocation = null;
    int backupZip = 0;
    private String sbchartODBC;
    private String instanceName;
    private boolean instanceLogin;
    private String UID;
    private String pwd;
    private String sbUID;
    private String sbPwd;
    private GCPProxy GCPproxy = null;
    boolean isSingle = false;
    boolean isDefault = false;
    boolean SQLServerIntegratedSecurity = false;
    boolean SQLServerActiveDirectory = false;
    boolean SQLServerInteractive = false;
    boolean encrypt;
    String oldName;

    public ConnectionParameters(ModelVersion version) {
        this.modelVersion = version;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    public boolean isConnectionPoolDisabled() {
        return this.disableConnectionPool;
    }

    public void setDisableConnectionPool(boolean disableConnectionPool) {
        this.disableConnectionPool = disableConnectionPool;
    }

    public DBDriverType getDriverType() {
        return this.driverType;
    }

    public void setDriverType(DBDriverType driverType) {
        this.driverType = driverType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    void setDriverName(String driverName) {
        this.driverName = driverName != null ? driverName.toLowerCase() : null;
    }

    public String getHostName() {
        return this.hostName;
    }

    void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostServerName() {
        if (this.driverType == DBDriverType.H2) {
            if (this.autoServer) {
                return this.hostName + ";AUTO_SERVER=TRUE" + (String)(this.autoServerPort > 0 ? ";AUTO_SERVER_PORT=" + this.autoServerPort : "");
            }
            return this.hostName + ";AUTO_SERVER=FALSE";
        }
        return this.hostName;
    }

    public String getSbchartODBC() {
        return this.sbchartODBC;
    }

    void setSbchartODBC(String sbchartODBC) {
        this.sbchartODBC = sbchartODBC;
    }

    public boolean doBackup() {
        return this.backupPrompt;
    }

    public String getBackupLocation() {
        if (this.backupLocation == null) {
            return "";
        }
        return this.backupLocation;
    }

    public void setBackupLocation(String l) {
        this.backupLocation = l;
    }

    public int getBackupCompressed() {
        return this.backupZip;
    }

    public void setBackupCompressed(int b) {
        this.backupZip = b;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceNameWithSec() {
        Object s = null;
        if (this.instanceName != null) {
            s = this.instanceName;
        }
        if (this.SQLServerIntegratedSecurity) {
            if (s == null) {
                s = "";
            }
            s = (String)s + ";integratedSecurity=true";
        } else if (this.SQLServerActiveDirectory) {
            if (s == null) {
                s = "";
            }
            if (!((String)s).contains("ActiveDirectoryIntegrated")) {
                s = (String)s + ";Authentication=ActiveDirectoryIntegrated";
            }
        } else if (this.SQLServerInteractive) {
            if (s == null) {
                s = "";
            }
            if (!((String)s).contains("ActiveDirectoryInteractive")) {
                s = (String)s + ";Authentication=ActiveDirectoryInteractive";
            }
        }
        return s;
    }

    public boolean hasInstanceLogin() {
        return this.instanceLogin;
    }

    public void setInstanceLogin(boolean b) {
        this.instanceLogin = b;
    }

    public String getUID() {
        return this.UID;
    }

    void setUID(String uId) {
        this.UID = uId;
    }

    public String getPWD() {
        return this.pwd;
    }

    void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getSbUID() {
        return this.sbUID;
    }

    public void setSbUID(String sbUID) {
        this.sbUID = sbUID;
    }

    public String getSbPwd() {
        return this.sbPwd;
    }

    public void setSbPwd(String sbPwd) {
        this.sbPwd = sbPwd;
    }

    public void setGCPProxy(String s) {
        try {
            this.GCPproxy = GCPProxy.valueOf(s);
            this.encrypt = false;
        }
        catch (IllegalArgumentException e) {
            this.GCPproxy = null;
        }
    }

    public GCPProxy getGCPProxy() {
        return this.GCPproxy;
    }

    public boolean getSQLServerIntegratedSecurity() {
        return this.SQLServerIntegratedSecurity;
    }

    public boolean SQLServerActiveDirectory() {
        return this.SQLServerActiveDirectory;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public static List<ConnectionParameters> getConnections(ModelVersion version) {
        LinkedList<ConnectionParameters> connections = new LinkedList<ConnectionParameters>();
        Preferences rootPref = RegistryPreferencesHelper.getPreferences((ModelVersion)version);
        try {
            String[] sbConnections;
            String defaultConnection = rootPref.get("sbdsn", null);
            for (String s : sbConnections = rootPref.childrenNames()) {
                String px;
                if ("webservices".equals(s)) continue;
                ConnectionParameters parms = new ConnectionParameters(version);
                parms.name = s;
                Preferences pref = rootPref.node(s);
                parms.UID = pref.get("uid", null);
                String pwd = pref.get("pwd", null);
                try {
                    parms.pwd = pwd != null ? SB.crypt((boolean)false, (String)cryptKey, (String)pwd) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                parms.instanceLogin = pref.getBoolean("instancelogin", true);
                parms.hostName = pref.get("host", null);
                parms.sbchartODBC = pref.get("sbchartodbc", null);
                parms.driverName = pref.get("driver", null);
                if (parms.driverName == null) continue;
                parms.driverType = DBDriverType.getDriverType((String)parms.driverName);
                parms.instanceName = pref.get("instance", null);
                parms.isSingle = pref.getBoolean("issingle", false);
                parms.SQLServerIntegratedSecurity = pref.getBoolean("sqlintsec", false);
                parms.SQLServerActiveDirectory = pref.getBoolean("sqlad", false);
                parms.SQLServerInteractive = pref.getBoolean("sqli", false);
                parms.sbUID = pref.get("sbuid", null);
                parms.autoServer = pref.getBoolean("autoserver", false);
                parms.backupPrompt = pref.getBoolean("backup", false);
                parms.backupLocation = pref.get("backuplocation", null);
                parms.backupZip = pref.getInt("backupzip", -1);
                if (parms.backupZip < 0) {
                    boolean b = pref.getBoolean("backupzip", false);
                    parms.backupZip = b ? 3 : 0;
                }
                parms.autoServerPort = pref.getInt("autoserverport", 0);
                String sbPwd = pref.get("sbpwd", null);
                try {
                    parms.sbPwd = sbPwd != null ? SB.crypt((boolean)false, (String)cryptKey, (String)sbPwd) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s.equalsIgnoreCase(defaultConnection)) {
                    parms.isDefault = true;
                }
                parms.GCPproxy = (px = pref.get("gcpproxy", null)) != null ? GCPProxy.valueOf(px) : null;
                parms.setMaxConnectionPoolSize(pref.getInt("maxconnectionpoolsize", ConnectionParameters.getDefaultConnectionPoolSize(parms.driverType)));
                parms.setDisableConnectionPool(pref.getBoolean("disableconnectionpool", false));
                parms.encrypt = pref.getBoolean("encrypt", false);
                connections.add(parms);
            }
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        return connections;
    }

    private static int getDefaultConnectionPoolSize(DBDriverType type) {
        if (type == null) {
            return 2;
        }
        switch (type) {
            case H2: 
            case POSTGRESQL: {
                return 2;
            }
            case ORACLE: 
            case ORACLE_OCI: 
            case MYSQL: 
            case SQLSERVER: {
                return 3;
            }
        }
        return 2;
    }

    public void clear() {
        Preferences rootPref = RegistryPreferencesHelper.getPreferences((ModelVersion)this.modelVersion);
        if (rootPref != null) {
            try {
                if (rootPref.nodeExists(this.name)) {
                    Preferences node = rootPref.node(this.name);
                    node.removeNode();
                }
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void putSBLogin() throws BackingStoreException {
        Preferences rootPref = RegistryPreferencesHelper.getPreferences((ModelVersion)this.modelVersion);
        Preferences pref = rootPref.node(this.name);
        if (this.sbUID != null && this.sbUID.length() > 0) {
            pref.put("sbuid", this.sbUID);
        } else {
            pref.remove("sbuid");
        }
        if (this.sbPwd != null && this.sbPwd.length() > 0) {
            pref.put("sbpwd", SB.crypt((boolean)true, (String)cryptKey, (String)this.sbPwd));
        } else {
            pref.remove("sbpwd");
        }
        pref.flush();
    }

    public void putPreferences(boolean storeUID) throws BackingStoreException {
        Preferences rootPref = RegistryPreferencesHelper.getPreferences((ModelVersion)this.modelVersion);
        rootPref.put("sbdsn", this.name);
        if (this.oldName != null) {
            rootPref.node(this.oldName).removeNode();
            this.oldName = null;
        }
        Preferences pref = rootPref.node(this.name);
        if (this.driverName != null && this.driverName.length() > 0) {
            pref.put("driver", this.driverName);
        } else {
            pref.remove("driver");
        }
        if (this.hostName != null && this.hostName.length() > 0) {
            pref.put("host", this.hostName);
        } else {
            pref.remove("host");
        }
        if (this.sbchartODBC != null && this.sbchartODBC.length() > 0) {
            pref.put("sbchartodbc", this.sbchartODBC);
        } else {
            pref.remove("sbchartodbc");
        }
        if (this.instanceName != null && this.instanceName.length() > 0) {
            pref.put("instance", this.instanceName);
        } else {
            pref.remove("instance");
        }
        if (storeUID) {
            if (this.UID != null && this.UID.length() > 0) {
                pref.put("uid", this.UID);
            } else {
                pref.remove("uid");
            }
            if (this.pwd != null && this.pwd.length() > 0) {
                pref.put("pwd", SB.crypt((boolean)true, (String)cryptKey, (String)this.pwd));
            } else {
                pref.remove("pwd");
            }
        } else {
            pref.remove("uid");
            pref.remove("pwd");
        }
        pref.putBoolean("instancelogin", this.instanceLogin);
        if (this.isSingle) {
            pref.putBoolean("issingle", true);
        } else {
            pref.putBoolean("issingle", false);
        }
        pref.putBoolean("sqlintsec", this.SQLServerIntegratedSecurity);
        pref.putBoolean("sqlad", this.SQLServerActiveDirectory);
        pref.putBoolean("sqli", this.SQLServerInteractive);
        pref.putBoolean("autoserver", this.autoServer);
        pref.putInt("autoserverport", this.autoServerPort);
        pref.putBoolean("backup", this.backupPrompt);
        if (this.backupLocation != null) {
            pref.put("backuplocation", this.backupLocation);
            pref.putInt("backupzip", this.backupZip);
        }
        if (this.GCPproxy != null) {
            pref.put("gcpproxy", this.GCPproxy.abr);
            this.encrypt = false;
        }
        pref.putInt("maxconnectionpoolsize", this.getMaxConnectionPoolSize());
        pref.putBoolean("disableconnectionpool", this.isConnectionPoolDisabled());
        pref.putBoolean("encrypt", this.encrypt);
        pref.flush();
    }

    public String toString() {
        return this.name;
    }

    public ModelVersion getModelVersion() {
        return this.modelVersion;
    }

    public ConnectionParameters copy() {
        ConnectionParameters parms = new ConnectionParameters(this.modelVersion);
        parms.copy(this);
        return parms;
    }

    public void copy(ConnectionParameters rhs) {
        this.name = rhs.name + " - copy";
        this.UID = rhs.UID;
        String pwd = rhs.pwd;
        this.instanceLogin = rhs.instanceLogin;
        this.hostName = rhs.hostName;
        this.sbchartODBC = rhs.sbchartODBC;
        this.driverName = rhs.driverName;
        this.driverType = rhs.driverType;
        this.instanceName = rhs.instanceName;
        this.isSingle = rhs.isSingle;
        this.SQLServerIntegratedSecurity = rhs.SQLServerIntegratedSecurity;
        this.SQLServerActiveDirectory = rhs.SQLServerActiveDirectory;
        this.sbUID = rhs.sbUID;
        this.autoServer = rhs.autoServer;
        this.backupPrompt = rhs.backupPrompt;
        this.backupLocation = rhs.backupLocation;
        this.backupZip = rhs.backupZip;
        this.autoServerPort = rhs.autoServerPort;
        this.sbPwd = rhs.sbPwd;
        this.isDefault = rhs.isDefault;
        this.GCPproxy = rhs.GCPproxy;
        this.maxConnectionPoolSize = rhs.maxConnectionPoolSize;
        this.disableConnectionPool = rhs.disableConnectionPool;
    }

    public static enum GCPProxy {
        UK("UK"),
        US("US"),
        SA("SA"),
        EU("EU");

        private final String abr;

        private GCPProxy(String abr) {
            this.abr = abr;
        }

        public String getInstance() {
            switch (this.ordinal()) {
                default: {
                    return "calcium-anagram-274811:europe-west2:stratadata=tcp:5432";
                }
                case 1: {
                    return "calcium-anagram-274811:us-central1:stratadata-us=tcp:5432";
                }
                case 2: {
                    return "calcium-anagram-274811:southamerica-east1:stratadata-sa=tcp:5432";
                }
                case 3: 
            }
            return "calcium-anagram-274811:europe-west6:stratadata-eu1=tcp:5432";
        }

        public String toString() {
            return this.abr;
        }
    }
}

