/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconnect;

import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconnect.DialogConnection;
import com.stratadata.sbconnect.DialogConnectionManager;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import model3.SBdb;
import util.exception.StackError;

public class DialogConnect
extends JDialog {
    boolean needsToShow = true;
    private boolean inInitCombo = false;
    private final boolean forceExit;
    private final Frame parent;
    private final ModelVersion modelVersion;
    ConnectionParameters parms;
    private JButton jButtonConnect;
    private JButton jButtonExit;
    private JButton jButtonHelp;
    private JButton jButtonManageConnections;
    private JCheckBox jCheckBoxRemember;
    private JCheckBox jCheckBoxSilent;
    private JComboBox jComboBoxDataSource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPasswordField jPasswordField;
    private JSeparator jSeparator1;
    private JTextField jTextFieldLoginName;

    public DialogConnect(Frame parent, boolean modal, boolean forceExit, ModelVersion version) {
        super(parent, modal);
        this.parent = parent;
        this.forceExit = forceExit;
        if (version == null) {
            version = SBdb.MODEL_VERSION;
        }
        this.modelVersion = version;
        this.initComponents();
        this.init();
    }

    public DialogConnect(Frame parent, boolean modal) {
        this(parent, modal, true, SBdb.MODEL_VERSION);
    }

    public DialogConnect(Frame parent, ModelVersion version) {
        this(parent, true, false, version);
    }

    private void init() {
        this.setTitle(this.modelVersion.toString() + " Connect");
        this.getRootPane().setDefaultButton(this.jButtonConnect);
        List<ConnectionParameters> sbConns = ConnectionParameters.getConnections(this.modelVersion);
        if (sbConns.isEmpty()) {
            DialogConnection dialog = new DialogConnection(this.parent, true, sbConns, null, this.modelVersion);
            SBDialog.centreWindow(dialog);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                System.exit(0);
            }
            this.parms = dialog.getParameters();
        } else if (sbConns.size() == 1) {
            this.parms = sbConns.get(0);
        }
        this.initCombo();
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (this.parms.getUID() != null && !this.parms.getUID().isEmpty()) {
            this.enableFields(!this.parms.isSingle);
            if (!this.parms.isSingle) {
                this.jTextFieldLoginName.setText(this.parms.getUID());
                this.jPasswordField.setText(this.parms.getPWD());
            }
            this.jCheckBoxRemember.setSelected(true);
        }
    }

    public ConnectionParameters getParms() {
        return this.parms;
    }

    private void initCombo() {
        ConnectionParameters selected;
        this.inInitCombo = true;
        this.jComboBoxDataSource.removeAllItems();
        List<ConnectionParameters> sbConns = ConnectionParameters.getConnections(this.modelVersion);
        ConnectionParameters defaultParms = null;
        for (ConnectionParameters p : sbConns) {
            this.jComboBoxDataSource.addItem(p);
            if (!p.isDefault) continue;
            defaultParms = p;
        }
        if (defaultParms != null) {
            this.jComboBoxDataSource.setSelectedItem(defaultParms);
        }
        if ((selected = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem()) != null) {
            this.jTextFieldLoginName.setEnabled(!selected.isSingle);
            this.jPasswordField.setEnabled(!selected.isSingle);
            this.jTextFieldLoginName.setEnabled(selected.hasInstanceLogin());
            this.jPasswordField.setEnabled(selected.hasInstanceLogin());
        }
        this.inInitCombo = false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDataSource = new JComboBox();
        this.jButtonManageConnections = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonConnect = new JButton();
        this.jButtonExit = new JButton();
        this.jCheckBoxRemember = new JCheckBox();
        this.jCheckBoxSilent = new JCheckBox();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldLoginName = new JTextField();
        this.jPasswordField = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setIconImage(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.windowClosing(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jLabel1.setText(bundle.getString("label.connection"));
        this.jComboBoxDataSource.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDataSourceActionPerformed(evt);
            }
        });
        this.jButtonManageConnections.setText(bundle.getString("DialogConnect.jButtonManageConnections"));
        this.jButtonManageConnections.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonManageConnections.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonManageConnectionsActionPerformed(evt);
            }
        });
        this.jButtonConnect.setFont(this.jButtonConnect.getFont().deriveFont(this.jButtonConnect.getFont().getStyle() | 1));
        this.jButtonConnect.setText(bundle.getString("DialogConnect.jButtonConnect"));
        this.jButtonConnect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonConnectActionPerformed(evt);
            }
        });
        this.jButtonExit.setText(bundle.getString("button.exit"));
        this.jButtonExit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExitActionPerformed(evt);
            }
        });
        this.jCheckBoxRemember.setText(bundle.getString("DialogConnect.jCheckBoxRemember"));
        this.jCheckBoxSilent.setText(bundle.getString("DialogConnect.jCheckBoxSilent"));
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnect this$0;
            {
                DialogConnect dialogConnect = this$0;
                Objects.requireNonNull(dialogConnect);
                this.this$0 = dialogConnect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DialogConnect.jPanel1.border.title"), 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel2.setText(bundle.getString("label.username"));
        this.jLabel3.setText(bundle.getString("label.password"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldLoginName).addComponent(this.jPasswordField)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLoginName, -2, 20, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jPasswordField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 62, Short.MAX_VALUE).addComponent(this.jButtonConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExit)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxSilent).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jCheckBoxRemember, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDataSource, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonManageConnections).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(0, this.jButtonExit, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDataSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonManageConnections).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxRemember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSilent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonExit).addComponent(this.jButtonHelp).addComponent(this.jButtonConnect)).addGap(20, 20, 20)));
        this.pack();
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        if (this.forceExit) {
            System.exit(0);
        }
        this.parms = null;
        this.dispose();
    }

    private void jButtonConnectActionPerformed(ActionEvent evt) {
        char[] passwordChars;
        if (this.jComboBoxDataSource.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "No data source selected", this.getTitle(), 2);
        }
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (this.jTextFieldLoginName.getText().length() > 0) {
            this.parms.setUID(this.jTextFieldLoginName.getText().trim());
        }
        if ((passwordChars = this.jPasswordField.getPassword()).length > 0) {
            Object pwd = "";
            for (int i = 0; i < passwordChars.length; ++i) {
                pwd = (String)pwd + passwordChars[i];
            }
            this.parms.setPwd((String)pwd);
        }
        try {
            this.parms.isDefault = true;
            this.parms.putPreferences(this.parms.isSingle ? true : this.jCheckBoxRemember.isSelected());
            RegistryPreferencesHelper.putSilent((boolean)this.jCheckBoxSilent.isSelected());
            this.dispose();
        }
        catch (BackingStoreException ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jComboBoxDataSourceActionPerformed(ActionEvent evt) {
        if (this.inInitCombo) {
            return;
        }
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (!this.parms.isSingle && this.parms.hasInstanceLogin()) {
            this.enableFields(true);
            this.jTextFieldLoginName.setText(this.parms.getUID());
            this.jPasswordField.setText(this.parms.getPWD());
        } else {
            this.enableFields(false);
            this.jTextFieldLoginName.setText("");
            this.jPasswordField.setText("");
        }
        if (this.parms.getUID() == null || this.parms.getUID().isEmpty()) {
            this.jCheckBoxRemember.setSelected(false);
        } else {
            this.jCheckBoxRemember.setSelected(true);
        }
    }

    private void enableFields(boolean b) {
        this.jTextFieldLoginName.setEnabled(b);
        this.jPasswordField.setEnabled(b);
        this.jCheckBoxRemember.setEnabled(b);
    }

    private void jButtonManageConnectionsActionPerformed(ActionEvent evt) {
        DialogConnectionManager dialog = new DialogConnectionManager((Window)this, true, this.modelVersion);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.hasChanged) {
            this.initCombo();
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.jButtonExitActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp("howtologin.html");
    }
}

