/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconnect;

import com.stratadata.model3.db.DBDriverType;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.SwingTextFieldUtils;
import java.awt.CardLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogConnection
extends SBDialog {
    private static final String NO_OPTIONS_PANEL = "blank";
    private final ModelVersion modelVersion;
    private final List<ConnectionParameters> sbConns;
    private final DefaultComboBoxModel<DBDriverType> comboModel = new DefaultComboBoxModel<DBDriverType>(DBDriverType.values());
    private ConnectionParameters parameters;
    private ButtonGroup buttonGroupSQLServer;
    private JButton jButtonCancel;
    private JButton jButtonFile;
    private JButton jButtonFileAccess;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAutoServer;
    private JCheckBox jCheckBoxBackup;
    private JCheckBox jCheckBoxDisableConnectionPool;
    private JCheckBox jCheckBoxEncrypt;
    private JCheckBox jCheckBoxEncryptPG;
    private JCheckBox jCheckBoxRequiresCredentials;
    private JCheckBox jCheckBoxShowAdvancedOptions;
    private JComboBox<String> jComboBoxGcpProxy;
    private JComboBox<DBDriverType> jComboBoxJDBCdriver;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelDSN;
    private JLabel jLabelSchema;
    private JPanel jPanel1;
    private JPanel jPanelAdvancedOptions;
    private JPanel jPanelOptions;
    private JPanel jPanelOptionsAccess;
    private JPanel jPanelOptionsH2;
    private JPanel jPanelOptionsPostgres;
    private JPanel jPanelOptionsSQLServer;
    private JPasswordField jPasswordField;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButtonSQLAD;
    private JRadioButton jRadioButtonSQLEntraMFA;
    private JRadioButton jRadioButtonSQLIntegratedSecurity;
    private JRadioButton jRadioButtonSQLpw;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerConnectionPoolSize;
    private JTextArea jTextAreaDSN;
    private JTextField jTextFieldAutoServerPort;
    private JTextField jTextFieldLoginName;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSchema;

    public DialogConnection(Window parent, boolean modal, List<ConnectionParameters> sbConns, ConnectionParameters parms, ModelVersion modelVersion) {
        super(parent, modal);
        this.sbConns = sbConns;
        this.parameters = parms;
        this.modelVersion = modelVersion;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jPanelOptions.add(DBDriverType.H2.name(), this.jPanelOptionsH2);
        this.jPanelOptions.add(DBDriverType.POSTGRESQL.name(), this.jPanelOptionsPostgres);
        this.jPanelOptions.add(DBDriverType.SQLSERVER.name(), this.jPanelOptionsSQLServer);
        this.jPanelOptions.add(NO_OPTIONS_PANEL, new JPanel());
        if (!this.modelVersion.equals((Object)ModelVersion.V3_0_0)) {
            this.jComboBoxGcpProxy.setEnabled(false);
        }
        this.setTitle(String.valueOf(this.modelVersion) + " StrataBugs Connection : " + (this.parameters == null ? "Add" : this.parameters.getName()));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.parameters != null) {
            this.jTextFieldName.setText(this.parameters.getName());
            this.jTextAreaDSN.setText(this.parameters.getHostName());
            this.jTextFieldSchema.setText(this.parameters.getInstanceName());
            if (this.parameters.isSingle) {
                this.jTextFieldLoginName.setText(this.parameters.getUID());
                this.jPasswordField.setText(this.parameters.getPWD());
            }
            this.jComboBoxJDBCdriver.setSelectedItem(this.parameters.getDriverType());
            if (this.parameters.SQLServerIntegratedSecurity) {
                this.jRadioButtonSQLIntegratedSecurity.setSelected(true);
            } else if (this.parameters.SQLServerActiveDirectory) {
                this.jRadioButtonSQLAD.setSelected(true);
            } else if (this.parameters.SQLServerInteractive) {
                this.jRadioButtonSQLEntraMFA.setSelected(true);
            } else {
                this.jRadioButtonSQLpw.setSelected(true);
            }
            this.jCheckBoxAutoServer.setSelected(this.parameters.autoServer);
            this.jTextFieldAutoServerPort.setText("" + this.parameters.autoServerPort);
            this.jTextFieldAutoServerPort.setEnabled(this.parameters.autoServer);
            this.jLabel6.setEnabled(this.parameters.autoServer);
            this.jCheckBoxBackup.setSelected(this.parameters.backupPrompt);
            if (this.parameters.getGCPProxy() != null) {
                this.jComboBoxGcpProxy.setSelectedItem(this.parameters.getGCPProxy().toString());
            } else {
                this.jComboBoxGcpProxy.setSelectedIndex(0);
                this.jCheckBoxEncryptPG.setSelected(this.parameters.encrypt);
            }
            if (this.parameters.getDriverType() == DBDriverType.SQLSERVER) {
                this.jCheckBoxEncrypt.setSelected(this.parameters.encrypt);
            }
            this.jSpinnerConnectionPoolSize.setValue(this.parameters.getMaxConnectionPoolSize());
            this.jCheckBoxDisableConnectionPool.setSelected(this.parameters.isConnectionPoolDisabled());
        }
        this.jComboBoxJDBCdriverActionPerformed(null);
        if (this.parameters != null) {
            this.jCheckBoxRequiresCredentials.setSelected(this.parameters.hasInstanceLogin());
        }
        this.jPanelAdvancedOptions.setVisible(this.jCheckBoxShowAdvancedOptions.isSelected());
        this.pack();
    }

    public void initParms(String name, String serverDSN, DBType dbType) {
        this.jTextFieldName.setText(name);
        this.jTextAreaDSN.setText(serverDSN);
        this.jComboBoxJDBCdriver.setSelectedItem(dbType.getName());
    }

    private void initComponents() {
        this.jPanelOptionsH2 = new JPanel();
        this.jCheckBoxBackup = new JCheckBox();
        this.jCheckBoxAutoServer = new JCheckBox();
        this.jButtonFile = new JButton();
        this.jTextFieldAutoServerPort = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanelOptionsPostgres = new JPanel();
        this.jLabel7 = new JLabel();
        this.jComboBoxGcpProxy = new JComboBox();
        this.jCheckBoxEncryptPG = new JCheckBox();
        this.jPanelOptionsSQLServer = new JPanel();
        this.jRadioButtonSQLAD = new JRadioButton();
        this.jRadioButtonSQLIntegratedSecurity = new JRadioButton();
        this.jRadioButtonSQLpw = new JRadioButton();
        this.jCheckBoxEncrypt = new JCheckBox();
        this.jRadioButtonSQLEntraMFA = new JRadioButton();
        this.jPanelOptionsAccess = new JPanel();
        this.jButtonFileAccess = new JButton();
        this.buttonGroupSQLServer = new ButtonGroup();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLoginName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabelDSN = new JLabel();
        this.jLabelSchema = new JLabel();
        this.jTextFieldSchema = new JTextField();
        this.jComboBoxJDBCdriver = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDSN = new JTextArea();
        this.jPanelOptions = new JPanel();
        this.jPanelAdvancedOptions = new JPanel();
        this.jLabel8 = new JLabel();
        this.jSpinnerConnectionPoolSize = new JSpinner();
        this.jCheckBoxDisableConnectionPool = new JCheckBox();
        this.jCheckBoxShowAdvancedOptions = new JCheckBox();
        this.jCheckBoxRequiresCredentials = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jCheckBoxBackup.setText(bundle.getString("DialogConnection.jPanelOptions.h2.jCheckBoxBackup"));
        this.jCheckBoxAutoServer.setText(bundle.getString("DialogConnection.jPanelOptions.h2.jCheckBoxAutoServer"));
        this.jCheckBoxAutoServer.setToolTipText(bundle.getString("DialogConnection.jPanelOptions.h2.jCheckBoxAutoServer.tooltip"));
        this.jCheckBoxAutoServer.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxAutoServerActionPerformed(evt);
            }
        });
        this.jButtonFile.setText(bundle.getString("DialogConnection.jPanelOptions.h2.access.file.button"));
        this.jButtonFile.setToolTipText(bundle.getString("DialogConnection.jPanelOptions.h2.file.button.tooltip"));
        this.jButtonFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFileActionPerformed(evt);
            }
        });
        this.jTextFieldAutoServerPort.setText("0");
        this.jTextFieldAutoServerPort.setToolTipText("Port number on which to start autoserver (leave 0 for default port). May need to be set for firewall.");
        this.jTextFieldAutoServerPort.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAutoServerPortKeyTyped(evt);
            }
        });
        this.jLabel6.setText(bundle.getString("DialogConnection.jPanelOptions.h2.jTextFieldAutoServerPort.label"));
        GroupLayout jPanelOptionsH2Layout = new GroupLayout(this.jPanelOptionsH2);
        this.jPanelOptionsH2.setLayout(jPanelOptionsH2Layout);
        jPanelOptionsH2Layout.setHorizontalGroup(jPanelOptionsH2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsH2Layout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsH2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxBackup, -1, -1, Short.MAX_VALUE).addGroup(jPanelOptionsH2Layout.createSequentialGroup().addGroup(jPanelOptionsH2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFile).addGroup(jPanelOptionsH2Layout.createSequentialGroup().addComponent(this.jCheckBoxAutoServer).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAutoServerPort, -2, 44, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelOptionsH2Layout.setVerticalGroup(jPanelOptionsH2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelOptionsH2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonFile).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelOptionsH2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAutoServer, -2, 16, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldAutoServerPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBackup, -2, 25, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsH2Layout.linkSize(1, this.jLabel6, this.jTextFieldAutoServerPort);
        this.jLabel7.setText(bundle.getString("DialogConnection.jPanelOptions.postgres.jComboBoxGcpProxy.label"));
        this.jComboBoxGcpProxy.setModel(new DefaultComboBoxModel<String>(new String[]{"<unset>", "UK", "US", "SA", "EU"}));
        this.jComboBoxGcpProxy.setToolTipText(bundle.getString("DialogConnection.jPanelOptions.postgres.jComboBoxGcpProxy.tooltip"));
        this.jCheckBoxEncryptPG.setText("Encrypt connection");
        this.jCheckBoxEncryptPG.setToolTipText("Use this option if connecting outside of a LAN or VPN, and no proxy");
        GroupLayout jPanelOptionsPostgresLayout = new GroupLayout(this.jPanelOptionsPostgres);
        this.jPanelOptionsPostgres.setLayout(jPanelOptionsPostgresLayout);
        jPanelOptionsPostgresLayout.setHorizontalGroup(jPanelOptionsPostgresLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsPostgresLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsPostgresLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsPostgresLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxGcpProxy, -2, 90, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jCheckBoxEncryptPG, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelOptionsPostgresLayout.setVerticalGroup(jPanelOptionsPostgresLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsPostgresLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsPostgresLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxGcpProxy, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxEncryptPG).addContainerGap(12, Short.MAX_VALUE)));
        this.buttonGroupSQLServer.add(this.jRadioButtonSQLAD);
        this.jRadioButtonSQLAD.setText("EntraID (Active Directory for Azure)");
        this.buttonGroupSQLServer.add(this.jRadioButtonSQLIntegratedSecurity);
        this.jRadioButtonSQLIntegratedSecurity.setText("Integrated security");
        this.buttonGroupSQLServer.add(this.jRadioButtonSQLpw);
        this.jRadioButtonSQLpw.setText("Username and password");
        this.jCheckBoxEncrypt.setText("Encrypt connection");
        this.jCheckBoxEncrypt.setToolTipText("Use this option if connecting outside of a LAN or VPN");
        this.buttonGroupSQLServer.add(this.jRadioButtonSQLEntraMFA);
        this.jRadioButtonSQLEntraMFA.setText("Entra ID with MFA");
        this.jRadioButtonSQLEntraMFA.setToolTipText("Use EntraID with multi-factor authentication");
        GroupLayout jPanelOptionsSQLServerLayout = new GroupLayout(this.jPanelOptionsSQLServer);
        this.jPanelOptionsSQLServer.setLayout(jPanelOptionsSQLServerLayout);
        jPanelOptionsSQLServerLayout.setHorizontalGroup(jPanelOptionsSQLServerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsSQLServerLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsSQLServerLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonSQLAD, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonSQLIntegratedSecurity, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonSQLpw, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxEncrypt, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonSQLEntraMFA, -2, 207, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsSQLServerLayout.setVerticalGroup(jPanelOptionsSQLServerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsSQLServerLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSQLpw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSQLIntegratedSecurity, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSQLAD).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSQLEntraMFA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxEncrypt).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsSQLServerLayout.linkSize(1, this.jCheckBoxEncrypt, this.jRadioButtonSQLAD, this.jRadioButtonSQLEntraMFA, this.jRadioButtonSQLIntegratedSecurity, this.jRadioButtonSQLpw);
        this.jButtonFileAccess.setText(bundle.getString("DialogConnection.jPanelOptions.h2.access.file.button"));
        this.jButtonFileAccess.setToolTipText(bundle.getString("DialogConnection.jPanelOptions.access.file.button.tooltip"));
        this.jButtonFileAccess.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFileAccessActionPerformed(evt);
            }
        });
        GroupLayout jPanelOptionsAccessLayout = new GroupLayout(this.jPanelOptionsAccess);
        this.jPanelOptionsAccess.setLayout(jPanelOptionsAccessLayout);
        jPanelOptionsAccessLayout.setHorizontalGroup(jPanelOptionsAccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsAccessLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonFileAccess).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsAccessLayout.setVerticalGroup(jPanelOptionsAccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsAccessLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonFileAccess).addContainerGap(-1, Short.MAX_VALUE)));
        this.jRadioButton2.setText("jRadioButton2");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Single Login Details", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel1.setText("<html>If all users connect to the database using the same<br> credentials, you may enter them here:</html>");
        this.jLabel3.setText(bundle.getString("label.username"));
        this.jLabel4.setText(bundle.getString("label.password"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField).addComponent(this.jTextFieldLoginName)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLoginName, -2, -1, -2)).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap(12, Short.MAX_VALUE)));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(bundle.getString("DialogConnection.name.label"));
        this.jTextFieldName.setText("SBUGS3-0");
        this.jTextFieldName.setToolTipText("Enter a recognisable name for the data source.");
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText(bundle.getString("button.ok"));
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText(bundle.getString("DialogConnection.driver.label"));
        this.jLabelDSN.setHorizontalAlignment(11);
        this.jLabelDSN.setText(bundle.getString("DialogConnection.dsn.label"));
        this.jLabelSchema.setHorizontalAlignment(11);
        this.jLabelSchema.setText(bundle.getString("DialogConnection.schema.label"));
        this.jComboBoxJDBCdriver.setModel(this.comboModel);
        this.jComboBoxJDBCdriver.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxJDBCdriverActionPerformed(evt);
            }
        });
        this.jTextAreaDSN.setColumns(20);
        this.jTextAreaDSN.setLineWrap(true);
        this.jTextAreaDSN.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaDSN);
        this.jPanelOptions.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DialogConnection.jPanelOptions.border.title"), 0, 0, UIManager.getFont("TitledBorder.titleFont"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelOptions.setLayout(new CardLayout());
        this.jPanelAdvancedOptions.setBorder(BorderFactory.createTitledBorder("Advanced Options"));
        this.jLabel8.setText("Maximum connection pool size");
        this.jSpinnerConnectionPoolSize.setModel(new SpinnerNumberModel(3, 2, 10, 1));
        this.jCheckBoxDisableConnectionPool.setText("Disable connection pooling");
        GroupLayout jPanelAdvancedOptionsLayout = new GroupLayout(this.jPanelAdvancedOptions);
        this.jPanelAdvancedOptions.setLayout(jPanelAdvancedOptionsLayout);
        jPanelAdvancedOptionsLayout.setHorizontalGroup(jPanelAdvancedOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAdvancedOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAdvancedOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCheckBoxDisableConnectionPool, -1, -1, Short.MAX_VALUE).addGroup(jPanelAdvancedOptionsLayout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerConnectionPoolSize, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelAdvancedOptionsLayout.setVerticalGroup(jPanelAdvancedOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAdvancedOptionsLayout.createSequentialGroup().addGroup(jPanelAdvancedOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jSpinnerConnectionPoolSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDisableConnectionPool)));
        this.jCheckBoxShowAdvancedOptions.setText("Show Advanced Options");
        this.jCheckBoxShowAdvancedOptions.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnection this$0;
            {
                DialogConnection dialogConnection = this$0;
                Objects.requireNonNull(dialogConnection);
                this.this$0 = dialogConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxShowAdvancedOptionsActionPerformed(evt);
            }
        });
        this.jCheckBoxRequiresCredentials.setText("Requires credentials for database connection");
        this.jCheckBoxRequiresCredentials.setToolTipText("Check on if this server requires username and password to connect");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelAdvancedOptions, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelDSN).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jLabelSchema)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldSchema).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldName).addComponent(this.jComboBoxJDBCdriver, 0, 234, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.jPanelOptions, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jCheckBoxShowAdvancedOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jCheckBoxRequiresCredentials, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBoxJDBCdriver, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDSN).addComponent(this.jScrollPane1, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSchema, -2, -1, -2).addComponent(this.jLabelSchema)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelOptions, -2, 159, -2).addGap(24, 24, 24).addComponent(this.jCheckBoxRequiresCredentials).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelAdvancedOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK).addComponent(this.jCheckBoxShowAdvancedOptions)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String existingName;
        String connectionName = this.jTextFieldName.getText().trim();
        if (connectionName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Connection name is blank", this.getTitle(), 2);
            this.jTextFieldName.requestFocusInWindow();
            return;
        }
        if (connectionName.contains("/") || connectionName.contains(".")) {
            JOptionPane.showMessageDialog(this, "Connection name cannot contain the following characters:\n\\ .", this.getTitle(), 2);
            this.jTextFieldName.requestFocus();
            return;
        }
        String string = existingName = this.parameters != null ? this.parameters.getName() : "";
        if (ConnectionParameters.getConnections(this.modelVersion).stream().filter(parms -> !parms.getName().equalsIgnoreCase(existingName)).anyMatch(parms -> parms.getName().equalsIgnoreCase(connectionName))) {
            JOptionPane.showMessageDialog(this, "A connection with this name already exists", this.getTitle(), 2);
            return;
        }
        String hostName = this.jTextAreaDSN.getText().trim().replaceAll("\n", "").replaceAll("\r", "");
        if (hostName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Server/Data Source name is blank", this.getTitle(), 2);
            this.jTextAreaDSN.requestFocusInWindow();
            return;
        }
        String instanceName = this.jTextFieldSchema.getText().trim();
        DBDriverType driverType = (DBDriverType)this.jComboBoxJDBCdriver.getSelectedItem();
        if (instanceName.isEmpty() && driverType != DBDriverType.H2) {
            JOptionPane.showMessageDialog(this, "No database name specifed", this.getTitle(), 2);
            return;
        }
        if (this.parameters == null) {
            this.parameters = new ConnectionParameters(this.modelVersion);
        } else {
            this.parameters.oldName = this.parameters.getName();
        }
        this.parameters.setName(connectionName);
        this.parameters.setHostName(hostName);
        this.parameters.setInstanceName(instanceName);
        this.parameters.setDriverType(driverType);
        this.parameters.setDriverName(this.parameters.getDriverType().name());
        this.parameters.backupPrompt = this.parameters.getDriverType() == DBDriverType.H2 ? this.jCheckBoxBackup.isSelected() : false;
        this.parameters.setInstanceLogin(this.jCheckBoxRequiresCredentials.isSelected());
        this.parameters.setUID(this.jTextFieldLoginName.getText());
        char[] passwordChars = this.jPasswordField.getPassword();
        Object pwd = "";
        for (int i = 0; i < passwordChars.length; ++i) {
            pwd = (String)pwd + passwordChars[i];
        }
        this.parameters.setPwd((String)pwd);
        this.parameters.isSingle = !this.jTextFieldLoginName.getText().isEmpty() || this.jPasswordField.getPassword().length != 0;
        this.parameters.autoServer = this.jCheckBoxAutoServer.isSelected();
        try {
            this.parameters.autoServerPort = Integer.parseInt(this.jTextFieldAutoServerPort.getText());
        }
        catch (NumberFormatException e) {
            this.parameters.autoServerPort = 0;
        }
        if (this.parameters.getDriverType() == DBDriverType.POSTGRESQL) {
            this.parameters.encrypt = this.jCheckBoxEncryptPG.isSelected();
            String selected = this.jComboBoxGcpProxy.getSelectedItem().toString();
            this.parameters.setGCPProxy(selected);
        } else if (this.parameters.getDriverType() == DBDriverType.SQLSERVER) {
            this.parameters.encrypt = this.jCheckBoxEncrypt.isSelected();
            this.parameters.SQLServerIntegratedSecurity = this.jRadioButtonSQLIntegratedSecurity.isSelected();
            this.parameters.SQLServerActiveDirectory = this.jRadioButtonSQLAD.isSelected();
            this.parameters.SQLServerInteractive = this.jRadioButtonSQLEntraMFA.isSelected();
        }
        this.parameters.setMaxConnectionPoolSize((Integer)this.jSpinnerConnectionPoolSize.getValue());
        this.parameters.setDisableConnectionPool(this.jCheckBoxDisableConnectionPool.isSelected());
        try {
            this.parameters.putPreferences(this.parameters.isSingle);
            Iterator<ConnectionParameters> it = this.sbConns.iterator();
            while (it.hasNext()) {
                ConnectionParameters p = it.next();
                if (!p.getName().equalsIgnoreCase(this.parameters.getName())) continue;
                it.remove();
                break;
            }
            this.sbConns.add(this.parameters);
            this.setOK();
        }
        catch (BackingStoreException ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp("howtologin.html");
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void selectFile() {
        File file;
        SbugsFileFilter filter = null;
        DBDriverType type = (DBDriverType)this.jComboBoxJDBCdriver.getSelectedItem();
        switch (type) {
            case H2: {
                filter = new SbugsFileFilter("db", "H2 databases (*.db)");
            }
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (this.jTextAreaDSN.getText().length() > 0) {
            file = new File(this.jTextAreaDSN.getText());
            if (file.exists()) {
                jFileChooser.setSelectedFile(file);
            } else {
                jFileChooser.setSelectedFile(new File(System.getProperty("user.dir")));
            }
        } else {
            jFileChooser.setSelectedFile(new File(System.getProperty("user.dir")));
        }
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.showOpenDialog(this);
        if (jFileChooser.getSelectedFile() != null) {
            file = jFileChooser.getSelectedFile();
            String filePath = file.getPath();
            if (filePath.endsWith(".mv.db") || filePath.endsWith(".h2.db")) {
                filePath = filePath.substring(0, filePath.length() - 6);
            }
            this.jTextAreaDSN.setText(filePath);
        }
    }

    private void jComboBoxJDBCdriverActionPerformed(ActionEvent evt) {
        DBDriverType type = (DBDriverType)this.jComboBoxJDBCdriver.getSelectedItem();
        if (type == null) {
            return;
        }
        String optionalPanelName = switch (type) {
            case DBDriverType.H2, DBDriverType.POSTGRESQL, DBDriverType.SQLSERVER -> type.name();
            default -> NO_OPTIONS_PANEL;
        };
        this.jCheckBoxRequiresCredentials.setSelected(type != DBDriverType.H2);
        CardLayout cl = (CardLayout)this.jPanelOptions.getLayout();
        cl.show(this.jPanelOptions, optionalPanelName);
        ((TitledBorder)this.jPanelOptions.getBorder()).setTitle(String.valueOf(type) + " Options");
        this.jPanelOptions.repaint();
    }

    private void jTextFieldAutoServerPortKeyTyped(KeyEvent evt) {
        if (SwingTextFieldUtils.intFieldVal(this.jTextFieldAutoServerPort, 5, evt, false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxAutoServerActionPerformed(ActionEvent evt) {
        this.jTextFieldAutoServerPort.setEnabled(this.jCheckBoxAutoServer.isSelected());
        this.jLabel6.setEnabled(this.jCheckBoxAutoServer.isSelected());
    }

    private void jButtonFileAccessActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void jCheckBoxShowAdvancedOptionsActionPerformed(ActionEvent evt) {
        this.jPanelAdvancedOptions.setVisible(this.jCheckBoxShowAdvancedOptions.isSelected());
        this.pack();
    }

    public ConnectionParameters getParameters() {
        return this.parameters;
    }
}

