/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.io;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.FilePathUtils;
import util.SbugsFileFilter;

public class FileChooserUtils {
    public static final FileNameExtensionFilter EXCEL_FILTER = new FileNameExtensionFilter("Excel Workbook (*.xlsx)", "xlsx");
    public static final FileNameExtensionFilter CSV_FILTER = new FileNameExtensionFilter("Comma separated value (*.csv)", "csv");
    public static final FileNameExtensionFilter TEXT_FILTER = new FileNameExtensionFilter("Text file (*.txt)", "txt");
    public static final FileNameExtensionFilter LEGACY_EXCEL_FILTER = new FileNameExtensionFilter("Excel 97-2003 Workbook (*.xls)", "xls");
    public static final FileNameExtensionFilter SBG_FILTER = new FileNameExtensionFilter("StrataBugs SBG/XML", "sbg");
    public static final FileNameExtensionFilter JSON_FILTER = new FileNameExtensionFilter("JSON - JavaScript Object Notation (.json)", "json");
    public static final FileNameExtensionFilter SHAPFEILE_FILTER = new FileNameExtensionFilter("Shapefile", "shp");
    public static final FileNameExtensionFilter IMAGE_FILTER = new FileNameExtensionFilter("JPEG/TIFF images", "jpg", "jpeg", "tif", "tiff");

    public static File chooseReadableFile(Component parent, FileNameExtensionFilter filter, File initialDirectory) {
        File[] files = FileChooserUtils.chooseReadableFiles(parent, filter, initialDirectory, false);
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static File[] chooseReadableFiles(Component parent, final FileNameExtensionFilter filter, File initialDirectory, boolean multipleSelection) {
        File[] files;
        if (System.getProperty("os.name").startsWith("Mac")) {
            Window parentWindow = SwingUtilities.getWindowAncestor(parent);
            FileDialog nativeFc = parentWindow instanceof Dialog ? new FileDialog((Dialog)parentWindow, "Choose File", 0) : new FileDialog((Frame)parentWindow, "Choose File", 0);
            if (initialDirectory != null && initialDirectory.exists()) {
                nativeFc.setDirectory(initialDirectory.getPath());
            }
            nativeFc.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String ext : filter.getExtensions()) {
                        if (!name.toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }
            });
            nativeFc.setMultipleMode(multipleSelection);
            nativeFc.setVisible(true);
            files = nativeFc.getFiles();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(filter);
            fc.setMultiSelectionEnabled(multipleSelection);
            if (initialDirectory != null && initialDirectory.exists()) {
                fc.setCurrentDirectory(initialDirectory);
            }
            fc.setFileSelectionMode(0);
            int result = fc.showOpenDialog(parent);
            if (result != 0) {
                return null;
            }
            if (multipleSelection) {
                files = fc.getSelectedFiles();
            } else {
                File file = fc.getSelectedFile();
                files = new File[]{file};
            }
        }
        if (files == null) {
            return null;
        }
        for (File file : files) {
            String confirmText;
            int response;
            if (!file.exists()) {
                JOptionPane.showMessageDialog(parent, "StrataBugs can't file the specified file : " + file.getPath(), "File not found", 1);
                return null;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(parent, "StrataBugs can't read from the specified file : " + file.getPath(), "Error reading file", 1);
                return null;
            }
            String fname = file.getName();
            if (FilePathUtils.isFileExtension((String)fname, (String[])filter.getExtensions()) || (response = JOptionPane.showConfirmDialog(parent, confirmText = "The file extension of the file " + fname + " was not one of the expected extensions (" + StringUtils.join((Object[])filter.getExtensions(), (String)", ") + ").\r\nAre you sure you would like to read from " + fname + "?", "Unexpected file extension", 0, 3)) == 0) continue;
            return null;
        }
        return files;
    }

    public static File saveAsGridDataDialog(Component parent, String lastFileExported) {
        return FileChooserUtils.saveAsDialogWithFilters(parent, lastFileExported, (String)null, EXCEL_FILTER, CSV_FILTER, LEGACY_EXCEL_FILTER);
    }

    public static File saveAsGridDataDialog(Component parent, String lastFileExported, String defaultName) {
        return FileChooserUtils.saveAsDialogWithFilters(parent, lastFileExported, defaultName, EXCEL_FILTER, CSV_FILTER, LEGACY_EXCEL_FILTER);
    }

    public static File saveAsExcelWorkbookDialog(Component parent, String lastFileExported, String defaultName) {
        return FileChooserUtils.saveAsDialogWithFilters(parent, lastFileExported, defaultName, EXCEL_FILTER, LEGACY_EXCEL_FILTER);
    }

    public static File saveAsDialogWithFilters(Component parent, String lastFileExported, FileNameExtensionFilter ... filters) {
        return FileChooserUtils.saveAsDialogWithFilters(parent, lastFileExported, null, filters);
    }

    public static File saveAsDialogWithFilters(Component parent, String lastFileExported, String defaultName, FileNameExtensionFilter ... filters) {
        JFileChooser fc = new JFileChooser();
        String selectedExtension = FileChooserUtils.getSelectedExtension(lastFileExported, filters).toLowerCase();
        if (lastFileExported != null) {
            Object f = new File(lastFileExported);
            if (!((File)f).isDirectory()) {
                f = ((File)f).getParentFile();
            }
            fc.setCurrentDirectory((File)f);
        }
        for (FileNameExtensionFilter filter : filters) {
            fc.addChoosableFileFilter(filter);
            for (String ext : filter.getExtensions()) {
                if (!ext.toLowerCase().equals(selectedExtension)) continue;
                fc.setFileFilter(filter);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)defaultName)) {
            fc.setSelectedFile(new File(defaultName));
        }
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(0);
        int result = fc.showSaveDialog(parent);
        if (result == 0) {
            FileNameExtensionFilter filter;
            String path = fc.getSelectedFile().getPath();
            if (fc.getFileFilter() instanceof FileNameExtensionFilter && (filter = (FileNameExtensionFilter)fc.getFileFilter()).getExtensions().length > 0) {
                boolean found = false;
                String pathExt = FilePathUtils.getFileExtension((String)path).toLowerCase();
                for (String ext : filter.getExtensions()) {
                    if (!ext.toLowerCase().equals(pathExt)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    path = FilePathUtils.appendExtensionIfNeccesary((String)path, (String)filter.getExtensions()[0]);
                }
            }
            return new File(path);
        }
        return null;
    }

    public static String getSelectedExtension(String lastFilePath, FileNameExtensionFilter[] filters) {
        String defaultExtension = filters[0].getExtensions()[0];
        if (lastFilePath == null || lastFilePath.isEmpty()) {
            return defaultExtension;
        }
        String lastExtension = FilePathUtils.getFileExtension((String)lastFilePath).toLowerCase();
        if (lastExtension == null || lastExtension.isEmpty()) {
            return defaultExtension;
        }
        lastExtension = lastExtension.toLowerCase();
        for (FileNameExtensionFilter filter : filters) {
            for (String ext : filter.getExtensions()) {
                if (!lastExtension.equals(ext.toLowerCase())) continue;
                return ext;
            }
        }
        return defaultExtension;
    }

    public static File chooseFileToWrite(SBdb db, Component parent, String lastValWin, String lastValUnx, String[] extensions, String[] descriptions, String defaultFileName) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter useThis = null;
        for (int i = 0; i < extensions.length; ++i) {
            SbugsFileFilter sbugsFileFilter = new SbugsFileFilter(extensions[i], descriptions[i]);
            jFileChooser.addChoosableFileFilter((FileFilter)sbugsFileFilter);
            if (i != 0) continue;
            useThis = sbugsFileFilter;
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter((FileFilter)useThis);
        File file = null;
        try {
            file = new File(Lastval.getString((SBdb)db, (String)lastValWin, (String)lastValUnx));
        }
        catch (SQLException sbugsFileFilter) {
            // empty catch block
        }
        if (file == null || file.getParent() == null || !file.getParentFile().exists()) {
            file = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(file);
            if (defaultFileName != null) {
                jFileChooser.setSelectedFile(new File(defaultFileName));
            }
        }
        catch (Exception sbugsFileFilter) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(parent)) {
            String extension;
            file = jFileChooser.getSelectedFile();
            SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
            if (filter != null) {
                extension = filter.getExtension();
            } else if (file.exists()) {
                String path = file.getPath();
                extension = path.substring(path.indexOf(".") + 1);
            } else {
                extension = extensions[0];
            }
            if (!file.getName().endsWith("." + extension)) {
                file = new File(file.getPath() + "." + extension);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                return null;
            }
            try {
                Lastval.putString((SBdb)db, (String)lastValWin, (String)lastValUnx, (String)file.getPath());
                db.commit();
            }
            catch (Exception exception) {}
        } else {
            return null;
        }
        return file;
    }
}

