/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.db.DBType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import model3.ConnectionProvider;

public abstract class SbugsQuery {
    private static final Query_AgeFormationZoneNearTD QUERY_TD = new Query_AgeFormationZoneNearTD();
    private static final Query_EventNearTD_M QUERY_EVENT_TD_M = new Query_EventNearTD_M();
    private static final Query_EventNearTD_F QUERY_EVENT_TD_F = new Query_EventNearTD_F();
    private static final Query_DeepestEvent QUERY_DEEPEST_EVENT = new Query_DeepestEvent();
    private static final Query_Lithostrat QUERY_LITHOSTRAT = new Query_Lithostrat();

    public abstract String getDescription();

    public abstract String getQuery(ConnectionProvider var1, String ... var2);

    Collection<DBType> getSupportedDBTypes() {
        return Collections.EMPTY_SET;
    }

    public boolean supportsPlatform(DBType type) {
        Collection<DBType> supportedDBTypes = this.getSupportedDBTypes();
        return supportedDBTypes.isEmpty() || supportedDBTypes.contains(type);
    }

    public String toString() {
        return this.getDescription();
    }

    public static List<SbugsQuery> getAllQueries() {
        return List.of(QUERY_LITHOSTRAT, QUERY_TD, QUERY_EVENT_TD_M, QUERY_EVENT_TD_F, QUERY_DEEPEST_EVENT);
    }

    public static SbugsQuery getQuery_AgeFormationZoneNearTD() {
        return QUERY_TD;
    }

    public static SbugsQuery getQuery_EventNearTD_M() {
        return QUERY_EVENT_TD_M;
    }

    public static SbugsQuery getQuery_EventNearTD_F() {
        return QUERY_EVENT_TD_F;
    }

    public static SbugsQuery getQuery_DeepestEvent() {
        return QUERY_DEEPEST_EVENT;
    }

    public static SbugsQuery getQuery_Lithostrat() {
        return QUERY_LITHOSTRAT;
    }

    private static class Query_Lithostrat
    extends SbugsQuery {
        private Query_Lithostrat() {
        }

        @Override
        public String getDescription() {
            return "Chronostrat/age at formation";
        }

        @Override
        public String getQuery(ConnectionProvider db, String ... params) {
            String unitName = params[0];
            String projectName = null;
            if (params.length > 1) {
                projectName = params[1];
            }
            String sql = "SELECT ip.DESCRIP as Version,w.well_name,nvl(s1.base_depth,s1.top_depth) as top,nvl(s2.base_depth,s2.top_depth) as base,ic.upp_inf as InformalUpper, ic.low_inf as InformalLower,dc.u_age, dc.L_AGE, dc.NAME \nFROM " + db.DBTableName("samples") + " s1, " + db.DBTableName("samples") + " s2, " + db.DBTableName("igd_lstrat") + " ic, " + db.DBTableName("wells") + " w, " + db.DBTableName("igd_dict_lstrat") + " dc, " + db.DBTableName("interp") + " ip ";
            if (projectName != null) {
                sql = sql + ", " + db.DBTableName("sbwllst") + " wl, " + db.DBTableName("sbwlmb") + " wb ";
            }
            sql = sql + "\nWHERE ic.igd_type=3 and ip.INTERP_ID=ic.INTERP_ID \nAND ic.TOP_ID=s1.SAMP_ID and ic.BASE_ID=s2.SAMP_ID ";
            if (projectName != null) {
                sql = sql + "\nAND wl.ID=wb.ID and wl.NAME='" + projectName + "' AND w.WELL_ID=wb.WELL_ID ";
            }
            sql = sql + "\nAND  s1.well_id=ic.well_id and s2.well_id=ic.well_id and ic.well_id=w.well_id  \nAND ic.UPP_ZONE(+)=dc.UNIT_ID \nAND nvl(s1.base_depth,s1.top_depth)<= (SELECT nvl(s3.base_depth,s3.top_depth) FROM " + db.DBTableName("samples") + " s3, " + db.DBTableName("IGD_LSTRAT") + " il, " + db.DBTableName("IGD_DICT_LSTRAT") + " d WHERE il.upp_zone=d.UNIT_ID \nAND d.name='" + unitName + "' AND il.well_id=w.WELL_ID AND s3.WELL_ID=il.WELL_ID AND s3.SAMP_ID=il.TOP_ID) AND nvl(s2.base_depth,s2.top_depth)>=(SELECT nvl(s3.base_depth,s3.top_depth) FROM " + db.DBTableName("samples") + " s3, " + db.DBTableName("IGD_LSTRAT") + " il, " + db.DBTableName("IGD_DICT_LSTRAT") + " d WHERE il.upp_zone=d.UNIT_ID \nAND d.name='" + unitName + "' and il.well_id=w.WELL_ID AND s3.WELL_ID=il.WELL_ID AND s3.SAMP_ID=il.TOP_ID ) \nORDER BY well_name, top, base";
            return sql;
        }

        @Override
        public Collection<DBType> getSupportedDBTypes() {
            return Set.of(DBType.ORACLE);
        }
    }

    private static class Query_AgeFormationZoneNearTD
    extends SbugsQuery {
        private Query_AgeFormationZoneNearTD() {
        }

        @Override
        public String getDescription() {
            return "Age/formation/zone within 30m of TD";
        }

        @Override
        public String getQuery(ConnectionProvider db, String ... params) {
            return "SELECT w.well_name as Well_Name, w.td as TD, i.upp_inf AS Interval_Upper, i.low_inf AS Interval_Lower, s1.base_depth as Top_Depth, s2.base_depth as Base_Depth\nFROM %s w, igd i, %s s1, %s s2\nWHERE s1.well_id=w.well_id AND s2.well_id=w.well_id\nAND i.top_id=s1.samp_id and i.base_id=s2.samp_id\nAND (s1.base_depth >= w.td-30 or s2.base_depth >= w.td-30)".formatted(db.DBTableName("WELLS"), db.DBTableName("SAMPLES"), db.DBTableName("SAMPLES"));
        }
    }

    private static class Query_EventNearTD_M
    extends SbugsQuery {
        private Query_EventNearTD_M() {
        }

        @Override
        public String getDescription() {
            return "Bioevents within 30m of TD (base depth, metres)";
        }

        @Override
        public String getQuery(ConnectionProvider db, String ... params) {
            return "SELECT w.well_name as Well_Name, w.td AS TD, e.ev_type AS EventType, ed.name AS Event, s.base_depth AS Depth \nFROM " + db.DBTableName("wells") + " w, " + db.DBTableName("events") + " e, " + db.DBTableName("eventdic") + " ed, " + db.DBTableName("samples") + " s \nWHERE w.well_id=e.well_id AND s.well_id=w.well_id AND e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND s.base_depth >= w.td-30 ";
        }

        @Override
        public Collection<DBType> getSupportedDBTypes() {
            return Set.of(DBType.ACCESS, DBType.ORACLE, DBType.H2);
        }
    }

    private static class Query_EventNearTD_F
    extends SbugsQuery {
        private Query_EventNearTD_F() {
        }

        @Override
        public String getDescription() {
            return "Bioevents within 100ft of TD (top depth, feet)";
        }

        @Override
        public String getQuery(ConnectionProvider db, String ... params) {
            return "SELECT w.well_name as Well_Name, w.td/.3048 AS TD, e.ev_type AS EventType, ed.name AS Event, s.top_depth/.3048 AS Depth\nFROM %s w, %s e, %s ed, %s s\nWHERE w.well_id=e.well_id AND s.well_id=w.well_id AND e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND s.top_depth >= w.td-33".formatted(db.DBTableName("WELLS"), db.DBTableName("EVENTS"), db.DBTableName("EVENTDIC"), db.DBTableName("SAMPLES"));
        }
    }

    private static class Query_DeepestEvent
    extends SbugsQuery {
        private Query_DeepestEvent() {
        }

        @Override
        public String getDescription() {
            return "Deepest bioevent(s) in default version (by well selection)";
        }

        @Override
        public String getQuery(ConnectionProvider db, String ... params) {
            String wellName = params[0];
            String sampleDepthField = (SystemPreferences.getInstance().useSampleTops() ? "top" : "base") + "_depth";
            return "SELECT w.well_name as Well_Name, w.td as TD, e.ev_type as EventType, ed.name AS Event, s." + sampleDepthField + "/0.3048 as DepthF," + sampleDepthField + " as DepthM\nFROM " + db.DBTableName("wells") + " w, " + db.DBTableName("events") + " e, " + db.DBTableName("eventdic") + " ed, " + db.DBTableName("samples") + " s \nINNER JOIN (SELECT e.well_id as well_id, max(s." + sampleDepthField + ") as maxd \n    FROM " + db.DBTableName("samples") + " s, " + db.DBTableName("events") + " e \n    WHERE e.well_id=s.well_id and e.samp_id=s.samp_id and e.interp_id=0 \n    GROUP BY e.well_id ) ss ON s.well_id=ss.well_id AND s." + sampleDepthField + "=ss.maxd\nWHERE w.well_id=e.well_id AND s.well_id=w.well_id AND e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND e.interp_id=0 \nAND w.well_name like '" + wellName + "%'";
        }
    }
}

