/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ScriptUtilities {
    public static final String COMMENT_REGEX = "/\\*(?:.|[\\n\\r])*?\\*/";
    private static final Set<String> UPDATE_KEYWORDS = Set.of("INSERT ", "UPDATE ", "DELETE ", "DROP ", "TRUNCATE ", "ALTER TABLE ");

    private ScriptUtilities() {
    }

    public static List<String> getStatements(String script) {
        script = script.replaceAll(COMMENT_REGEX, "");
        List<String> statements = List.of(script.split(";"));
        return statements.stream().map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toList());
    }

    public static boolean isUpdate(String sql) {
        return UPDATE_KEYWORDS.stream().anyMatch(keyword -> sql.toUpperCase().contains((CharSequence)keyword));
    }
}

