/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.ui;

import com.stratadata.util.preferences.RegistryPreferencesHelper;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import util.exception.StackError;

public class HelpUtils {
    private static final String WWW_HELP_PATH = "http://www.stratadata.co.uk/StrataBugs/v3.0/help/";
    private static final String WWW_BLOG_PATH = "http://www.stratadata.co.uk/blog/index.php/";
    private static final String WWW_ADMIN_PATH = "https://www.stratadata.co.uk/site/admin/";
    private static String helpRoot = "http://www.stratadata.co.uk/StrataBugs/v3.0/help/";
    private static final String blogRoot = "http://www.stratadata.co.uk/blog/index.php";

    private HelpUtils() {
    }

    public static void openHelp(String page) {
        try {
            if (helpRoot.startsWith("file:///")) {
                String file = helpRoot.substring("file:///".length()) + page;
                if (!new File(file).exists()) {
                    JOptionPane.showMessageDialog(null, "Help page '" + file + "' does not exist.", "StrataBugs Help", 2);
                    return;
                }
            } else if (!helpRoot.startsWith("http://127.0.0.1:8082/resource/jar:file:/") && helpRoot.startsWith("jar:file:/")) {
                Runtime.getRuntime().exec("\"C:\\Program Files\\Mozilla firefox\\firefox.exe\"  \"" + helpRoot + page + " \"");
                return;
            }
            URL url = new URL(helpRoot + page);
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (HeadlessException | IOException | URISyntaxException ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void openBlog(String permalink) {
        try {
            URL url = URI.create(WWW_BLOG_PATH + permalink).toURL();
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (IOException | URISyntaxException e) {
            StackError.showStackError((String)"Error opening blog post", (Throwable)e);
        }
    }

    public static void openAdminSupport(String page) {
        try {
            URI uri = URI.create(WWW_ADMIN_PATH + page);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | RuntimeException e) {
            StackError.showStackError((String)"Error opening page", (Throwable)e);
        }
    }

    public static HelpLocation initHelp() {
        String userHelpPath = RegistryPreferencesHelper.getHelpPathPreference();
        if (!StringUtils.isEmpty((CharSequence)userHelpPath)) {
            if (userHelpPath.startsWith("http://")) {
                helpRoot = userHelpPath;
                return HelpLocation.IE;
            }
            if (userHelpPath.startsWith("jar:file:")) {
                helpRoot = userHelpPath;
                return HelpLocation.FF;
            }
            String filePath = userHelpPath.substring("file:///".length());
            if (new File(filePath).exists()) {
                helpRoot = userHelpPath;
                return HelpLocation.LOCAL;
            }
            RegistryPreferencesHelper.getPreferences().remove("help_path");
        }
        return HelpLocation.WEB;
    }

    public static void setHelpLocation(HelpLocation location) {
        switch (location.ordinal()) {
            case 3: {
                helpRoot = WWW_HELP_PATH;
                System.out.println("Help location URL set to: " + helpRoot);
                RegistryPreferencesHelper.getPreferences().remove("help_path");
                break;
            }
            case 2: {
                JFileChooser fc = new JFileChooser();
                File file = new File(".");
                fc.setCurrentDirectory(file);
                fc.setFileSelectionMode(1);
                fc.setDialogTitle("Select folder containing html help files");
                fc.setApproveButtonText("Select");
                if (fc.showOpenDialog(null) != 0) break;
                helpRoot = "file:///" + fc.getSelectedFile().getPath() + File.separatorChar;
                System.out.println("Help location URL set to: " + helpRoot);
                RegistryPreferencesHelper.putHelpPathPreference((String)helpRoot);
                break;
            }
            case 1: {
                File ffFile = new File("").getAbsoluteFile();
                helpRoot = "jar:file:///" + ffFile.getPath().replace(File.separatorChar, '/') + "/jsbugs_help.zip!/help/";
                System.out.println("Help location URL set to: " + helpRoot);
                RegistryPreferencesHelper.putHelpPathPreference((String)helpRoot);
                break;
            }
            case 0: {
                File ieFile = new File("").getAbsoluteFile();
                helpRoot = "http://127.0.0.1:8082/resource/jar:file:/" + ieFile.getPath().replace(File.separatorChar, '/') + "/jsbugs_help.zip!/help/";
                System.out.println("Help location URL set to: " + helpRoot);
                RegistryPreferencesHelper.putHelpPathPreference((String)helpRoot);
            }
        }
    }

    public static enum HelpLocation {
        IE,
        FF,
        LOCAL,
        WEB;

    }
}

