/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;

public class ColourUtils {
    public static String DBColourString(Color colour, boolean useAlpha, boolean includeQuotes) {
        if (colour == null) {
            return "NULL";
        }
        String strg = (includeQuotes ? "'" : "") + String.format("#%06x", colour.getRGB() & 0xFFFFFF);
        if (useAlpha) {
            strg = strg + String.format("%02x", colour.getAlpha() & 0xFF);
        }
        if (includeQuotes) {
            strg = strg + "'";
        }
        return strg;
    }

    public static Color getDBColour(String c) {
        if (c != null && !c.isEmpty()) {
            if (c.startsWith("#") && c.length() > 7 || !c.startsWith("#") && c.length() > 6) {
                String alphaString = c.substring(c.length() - 2, c.length());
                int alpha = Integer.parseInt(alphaString, 16);
                c = c.substring(0, c.length() - 2);
                Color solid = Color.decode(c);
                return new Color(solid.getRed(), solid.getGreen(), solid.getBlue(), alpha);
            }
            return Color.decode(c);
        }
        return Color.BLACK;
    }

    @Deprecated
    public static String getColourString(Color colour) {
        int red = colour.getRed();
        int green = colour.getGreen();
        int blue = colour.getBlue();
        return red + "," + green + "," + blue;
    }

    @Deprecated
    public static Color getColour(String colour) {
        if (colour.startsWith("#")) {
            return ColourUtils.getDBColour(colour);
        }
        String[] split = colour.split(",");
        assert (split.length == 3);
        int r = Integer.parseInt(split[0]);
        int g = Integer.parseInt(split[1]);
        int b = Integer.parseInt(split[2]);
        return new Color(r, g, b);
    }

    public static Color removeAlpha(Color c) {
        if (c.getAlpha() == 0) {
            return c;
        }
        Color destination = Color.WHITE;
        float[] components = c.getRGBComponents(null);
        float[] destComponents = destination.getRGBColorComponents(null);
        float alpha = components[3];
        float red1 = components[0] * alpha + destComponents[0] * (1.0f - alpha);
        float green1 = components[1] * alpha + destComponents[1] * (1.0f - alpha);
        float blue1 = components[2] * alpha + destComponents[2] * (1.0f - alpha);
        return new Color(red1, green1, blue1);
    }

    public static boolean isSimilarColour(Color colour1, Color colour2) {
        int redDiff = Math.abs(colour1.getRed() - colour2.getRed());
        int greenDiff = Math.abs(colour1.getGreen() - colour2.getGreen());
        int blueDiff = Math.abs(colour1.getBlue() - colour2.getBlue());
        if (redDiff > 40 || blueDiff > 40 || greenDiff > 40) {
            return false;
        }
        return redDiff + blueDiff + greenDiff < 100;
    }

    public static Color getGreyColour(Color colour) {
        float r = colour.getRed();
        float g = colour.getGreen();
        float b = colour.getBlue();
        float grey = r * 0.2126f + g * 0.7152f + b * 0.0722f;
        int gr = (int)grey;
        return new Color(gr, gr, gr);
    }

    public static Color getLighterColour(Color baseColour) {
        return ColourUtils.getLighterColour(baseColour, 0.5f);
    }

    public static Color getLighterColour(Color baseColour, float factor) {
        if (factor < 0.0f || factor > 1.0f) {
            throw new IllegalArgumentException("Invalid colour density factor: " + factor);
        }
        if (factor == 1.0f) {
            return baseColour;
        }
        float fInverse = 1.0f - factor;
        float[] result = new float[]{(float)baseColour.getRed() * factor + 255.0f * fInverse, (float)baseColour.getGreen() * factor + 255.0f * fInverse, (float)baseColour.getBlue() * factor + 255.0f * fInverse};
        for (int i = 0; i < 3; ++i) {
            if (!(result[i] > 255.0f)) continue;
            result[i] = 255.0f;
        }
        return new Color((int)result[0], (int)result[1], (int)result[2]);
    }

    public static Color getSBColorFromInt(int intColour) {
        Color colour = new Color(intColour);
        return new Color(colour.getBlue(), colour.getGreen(), colour.getRed());
    }

    @Deprecated
    public static int getSBIntFromColor(Color colour) {
        Color newColour = new Color(colour.getBlue(), colour.getGreen(), colour.getRed());
        return newColour.getRGB();
    }

    public static Color getContrastingColour(Color baseColor) {
        int newRed = 255 - baseColor.getRed();
        int newGreen = 255 - baseColor.getGreen();
        int newBlue = 255 - baseColor.getBlue();
        return new Color(newRed, newGreen, newBlue);
    }
}

