/*
 * Decompiled with CFR 0.152.
 */
package util;

public class DoubleRange {
    private final double min;
    private final double max;

    public DoubleRange(double min, double max) {
        if (min > max) {
            this.max = min;
            this.min = max;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public boolean isInRange(double value) {
        return value >= this.min && value <= this.max;
    }

    public double getMidPoint() {
        return this.min + (this.max - this.min) / 2.0;
    }

    public boolean overlapsThisRange(DoubleRange other) {
        if (this.isInRange(other.getMin()) || this.isInRange(other.getMax())) {
            return true;
        }
        return other.getMin() <= this.min && other.getMax() >= this.max;
    }

    public DoubleRange getOverlappingRange(DoubleRange other) {
        if (!this.overlapsThisRange(other)) {
            return null;
        }
        return new DoubleRange(Math.max(this.min, other.getMin()), Math.min(other.getMax(), this.max));
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(other.min)) {
            return false;
        }
        return Double.doubleToLongBits(this.max) == Double.doubleToLongBits(other.max);
    }

    public String toString() {
        return this.min + "d -> " + this.max + "d";
    }
}

