/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MoveableRect
extends Rectangle2D.Float {
    private static int BORDER = 5;
    public static int MIN_WIDTH = 10;
    public static int MIN_HEIGHT = 10;

    public MoveableRect(Rectangle2D.Float rect) {
        super(rect.x, rect.y, rect.width, rect.height);
    }

    public MoveableRect(float x, float y, float width, float height) {
        super(x, y, width, height);
    }

    public int getCursorStyle(Point2D.Float p) {
        if (!this.contains(p)) {
            return 0;
        }
        if (this.isTopBorder(p) && this.isLeftBorder(p)) {
            return 6;
        }
        if (this.isTopBorder(p) && this.isRightBorder(p)) {
            return 7;
        }
        if (this.isBaseBorder(p) && this.isLeftBorder(p)) {
            return 4;
        }
        if (this.isBaseBorder(p) && this.isRightBorder(p)) {
            return 5;
        }
        if (this.isTopBorder(p)) {
            return 8;
        }
        if (this.isLeftBorder(p)) {
            return 10;
        }
        if (this.isRightBorder(p)) {
            return 11;
        }
        if (this.isBaseBorder(p)) {
            return 9;
        }
        return 13;
    }

    private boolean isTopBorder(Point2D.Float p) {
        return p.y > this.y && p.y < this.y + (float)BORDER;
    }

    private boolean isBaseBorder(Point2D.Float p) {
        return p.y > this.y + this.height - (float)BORDER && p.y < this.y + this.height;
    }

    private boolean isLeftBorder(Point2D.Float p) {
        return p.x > this.x && p.x < this.x + (float)BORDER;
    }

    private boolean isRightBorder(Point2D.Float p) {
        return p.x > this.x + this.width - (float)BORDER && p.x < this.x + this.width;
    }

    public float getMinWidth() {
        return MIN_WIDTH;
    }

    public float getMinHeight() {
        return MIN_HEIGHT;
    }
}

