/*
 * Decompiled with CFR 0.152.
 */
package util;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SbugsInputVerifier
extends InputVerifier {
    private final float MIN_VALUE;
    private final float MAX_VALUE;
    private float initialValue;

    public SbugsInputVerifier(float min, float max, float initialValue) {
        this.MIN_VALUE = min;
        this.MAX_VALUE = max;
        this.initialValue = initialValue < this.MIN_VALUE || initialValue > this.MAX_VALUE ? min : initialValue;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextField label = (JTextField)input;
        boolean valid = false;
        try {
            float scale = Float.parseFloat(label.getText());
            if (scale >= this.MIN_VALUE && scale <= this.MAX_VALUE) {
                this.initialValue = scale;
                valid = true;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        if (!valid) {
            label.setText("" + this.initialValue);
        }
        return true;
    }
}

