/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.Writer;
import util.ITextWriter;
import util.TextTableMaker;

public class TextWriter
implements ITextWriter {
    private static String NEWLINE = "\r\n";
    private TextTableMaker tableMaker = new TextTableMaker(NEWLINE);
    private final Writer w;

    public TextWriter(Writer w) {
        this.w = w;
    }

    protected Writer getWriter() {
        return this.w;
    }

    @Override
    public void write(Object o) throws IOException {
        if (o != null) {
            this.w.write(o.toString());
        }
    }

    @Override
    public void writeLine(Object o) throws IOException {
        this.write(o);
        this.writeLine();
    }

    @Override
    public void writeLine() throws IOException {
        this.write(NEWLINE);
    }

    @Override
    public void writeHeader(Object o) throws IOException {
        if (o != null) {
            String s = o.toString();
            int len = s.length();
            this.writeLine(o);
            this.writeLine(new String(new char[len]).replace("\u0000", "-"));
        }
    }

    @Override
    public void writeHR() throws IOException {
        this.writeLine(new String(new char[80]).replace("\u0000", "-"));
    }

    @Override
    public void writeTable(Object[][] data) throws IOException {
        this.write(this.tableMaker.buildTable(data));
    }
}

