/*
 * Decompiled with CFR 0.152.
 */
package util.events;

import java.util.List;
import java.util.Objects;

public class DataChangedEvent {
    private final ChangeType changeType;
    private final Class klass;
    private final Object obj;

    public DataChangedEvent(ChangeType type, Class klass, Object obj) {
        this.changeType = type;
        this.klass = klass;
        this.obj = obj;
    }

    public ChangeType getType() {
        return this.changeType;
    }

    public Class getChangeClass() {
        return this.klass;
    }

    public Object getChangeObj() {
        return this.obj;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("DataChangeEvent ");
        switch (this.changeType.ordinal()) {
            case 0: {
                sb.append("added ");
                break;
            }
            case 1: {
                sb.append("deleted ");
                break;
            }
            case 2: {
                sb.append("updated ");
            }
        }
        if (this.klass != null) {
            if (this.obj != null && this.obj instanceof List) {
                sb.append(((List)this.obj).size()).append(" ").append(this.klass.getName()).append("s");
            } else {
                sb.append(this.klass.getName());
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode((Object)this.changeType);
        hash = 97 * hash + Objects.hashCode(this.klass);
        hash = 97 * hash + Objects.hashCode(this.obj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataChangedEvent other = (DataChangedEvent)obj;
        if (this.changeType != other.changeType) {
            return false;
        }
        if (!Objects.equals(this.klass, other.klass)) {
            return false;
        }
        return Objects.equals(this.obj, other.obj);
    }

    public static enum ChangeType {
        Addition,
        Deletion,
        Update;

    }
}

