/*
 * Decompiled with CFR 0.152.
 */
package util.exception;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import util.exception.SqlCache;

public class StackError {
    private static boolean HAS_GUI = true;
    private static final int TRACE_LINES = 15;

    private StackError() {
    }

    public static void setNoGui() {
        HAS_GUI = false;
    }

    public static boolean hasGui() {
        return HAS_GUI;
    }

    public static void showStackError(String msg, Throwable ex) {
        msg = StackError.prepareMessage((String)msg);
        if (ex instanceof SQLException) {
            StackError.showStackError((String)msg, (SQLException)ex);
            return;
        }
        if (ex instanceof RuntimeException) {
            msg = (String)msg + "An internal error has occurred. Please copy this message to StrataData\n\n";
        }
        String fullMessage = (String)msg + ex.toString();
        if (ex.getCause() != null) {
            fullMessage = fullMessage + "\nCause: " + ex.getCause().getMessage();
        }
        fullMessage = fullMessage + "\n\nTrace: ";
        StackTraceElement[] trace = ex.getStackTrace();
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 15; ++i) {
            fullMessage = fullMessage + "\n" + String.valueOf(trace[i]);
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        if (StackError.hasGui()) {
            JOptionPane.showMessageDialog(null, fullMessage, "SBugs Error", 0);
        }
        Logger.getLogger(StackError.class.getName()).log(Level.SEVERE, (String)msg, ex);
    }

    public static void showStackError(String msg, SQLException ex) {
        String fullMessage = msg + ex.getMessage() + "\nSQL: " + SqlCache.SQL + "\n\nTrace: ";
        StackTraceElement[] trace = ex.getStackTrace();
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 15; ++i) {
            fullMessage = fullMessage + "\n" + String.valueOf(trace[i]);
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        if (StackError.hasGui()) {
            JOptionPane.showMessageDialog(null, fullMessage, "SBugs SQL Error", 0);
        }
        Logger.getLogger(StackError.class.getName()).log(Level.SEVERE, msg, ex);
    }

    private static String prepareMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        if (!((String)(msg = ((String)msg).trim())).isEmpty()) {
            msg = (String)msg + "\n";
        }
        return msg;
    }

    public static void showStackError(Exception ex) {
        StackError.showStackError(null, ex);
    }
}

