/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import util.gridreader.CSVReader;
import util.gridreader.GridReaderException;
import util.gridreader.TableData;
import util.gridreader.TableRow;
import util.gridreader.XLSGridReader;

public class TableReader {
    private char delimiter = (char)44;

    public TableData readTableData(File file) throws FileNotFoundException, IOException, GridReaderException {
        List<List<String>> data = this.readTabularData(file);
        return this.buildTableDataWithHeaders(data);
    }

    public TableData readTableDataWithoutHeaders(File file) throws FileNotFoundException, IOException, GridReaderException {
        List<List<String>> data = this.readTabularData(file);
        return this.buildTableDataWithoutHeaders(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> readTabularData(File file) throws FileNotFoundException, IOException, GridReaderException {
        List<List<String>> data = null;
        if (file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".xlsx")) {
            try (XLSGridReader r = null;){
                r = new XLSGridReader(file.getPath());
                r.setSheet(null);
                data = this.readXLSData(r);
            }
        }
        try (FileReader r = new FileReader(file);){
            data = this.readCSVTableData(r);
        }
        return data;
    }

    public List<List<String>> readCSVTableData(Reader r) throws IOException {
        return this.readCSV(new CSVReader(Character.valueOf(this.delimiter)), r);
    }

    private List<List<String>> readCSV(CSVReader csvReader, Reader r) throws IOException {
        List<List<String>> data = csvReader.readData(r);
        return data;
    }

    private TableData buildTableDataWithHeaders(List<List<String>> data) {
        if (data.isEmpty()) {
            return null;
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (int i = 1; i < data.size(); ++i) {
            rows.add(new TableRow(data.get(i)));
        }
        return new TableData(data.get(0), rows);
    }

    private TableData buildTableDataWithoutHeaders(List<List<String>> data) {
        if (data.isEmpty()) {
            return null;
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (int i = 0; i < data.size(); ++i) {
            rows.add(new TableRow(data.get(i)));
        }
        return new TableData(null, rows);
    }

    private List<List<String>> readXLSData(XLSGridReader r) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        while (r.nextRow()) {
            String cell;
            ArrayList<String> row = new ArrayList<String>();
            while ((cell = r.getNextCell()) != null) {
                row.add(cell);
            }
            data.add(row);
        }
        return data;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }
}

