/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class XLSGridReader
extends GridReader {
    private String fileName;
    FileInputStream file;
    private final Workbook wb;
    private Sheet sheet;
    private Row row;
    private int nRow;
    private int nCol;

    XLSGridReader(String fileName, Integer sheetNumber) throws GridReaderException {
        try {
            this.fileName = fileName;
            this.file = new FileInputStream(fileName);
            this.wb = WorkbookFactory.create((InputStream)this.file);
            if (sheetNumber != null) {
                this.sheet = this.wb.getSheetAt(sheetNumber.intValue());
                if (this.sheet == null) {
                    throw new GridReaderException("Workbook sheet number: " + sheetNumber + " not found", null);
                }
                System.out.println("Parsing workbook sheet: " + this.wb.getSheetName(0));
            }
        }
        catch (IOException ioe) {
            throw new GridReaderException("Error opening file", ioe);
        }
    }

    XLSGridReader(String fileName) throws GridReaderException {
        this(fileName, null);
    }

    public List<String> getSheets() {
        LinkedList<String> sheets = new LinkedList<String>();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            sheets.add(this.wb.getSheetName(i));
        }
        return sheets;
    }

    public void setSheet(String sheetName) throws GridReaderException {
        this.sheet = sheetName != null ? this.wb.getSheet(sheetName) : this.wb.getSheetAt(0);
        if (this.sheet == null) {
            throw new GridReaderException("Workbook sheet: " + sheetName + " not found", null);
        }
        System.out.println("Parsing workbook sheet: " + this.sheet.getSheetName());
    }

    @Override
    public boolean nextRow() {
        if (this.nRow > this.sheet.getLastRowNum()) {
            return false;
        }
        this.row = this.sheet.getRow(this.nRow);
        ++this.nRow;
        this.nCol = 0;
        return true;
    }

    @Override
    public String getNextCell() {
        return this.getNextCell(true);
    }

    @Override
    public String getNextCell(boolean ignoreZeros) {
        if (this.row == null) {
            return null;
        }
        if (this.nCol >= this.row.getLastCellNum()) {
            return null;
        }
        Cell cell = this.row.getCell(this.nCol);
        ++this.nCol;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            default: {
                return cell.getStringCellValue().replace('\u00a0', ' ').trim();
            }
            case BLANK: 
            case ERROR: {
                return "";
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    return "" + date.getTime();
                }
                double num = cell.getNumericCellValue();
                if (Math.abs(num) > 1.0E-4) {
                    if (Math.abs(num - (double)((long)num)) > 0.0) {
                        return "" + num;
                    }
                    return "" + (long)num;
                }
                if (ignoreZeros) {
                    return "";
                }
                return "0";
            }
            case FORMULA: {
                try {
                    double fnum = cell.getNumericCellValue();
                    if (Math.abs(fnum) > 1.0E-4) {
                        if (fnum - (double)((long)fnum) > 0.0) {
                            return "" + fnum;
                        }
                        return "" + (long)fnum;
                    }
                }
                catch (IllegalStateException e) {
                    try {
                        return cell.getStringCellValue();
                    }
                    catch (IllegalStateException ex) {
                        return "";
                    }
                }
                return "";
            }
            case BOOLEAN: 
        }
        return "" + cell.getBooleanCellValue();
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void rewind() {
        this.nRow = 0;
    }
}

