/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.awt.Color;
import java.util.Objects;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import util.gridwriter.CellDataFormat;

public class CellFormat {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_TOP = 1;
    public static final int BORDER_BOTTOM = 2;
    public static final int BORDER_LEFT = 4;
    public static final int BORDER_RIGHT = 8;
    public static final int BORDER_ALL = 15;
    public static final short ALIGN_GENERAL = 0;
    public static final short ALIGN_LEFT = 1;
    public static final short ALIGN_CENTER = 2;
    public static final short ALIGN_RIGHT = 3;
    public static final short ALIGN_FILL = 4;
    public static final short ALIGN_JUSTIFY = 5;
    public static final short VERTICAL_TOP = 0;
    public static final short VERTICAL_CENTER = 1;
    public static final short VERTICAL_BOTTOM = 2;
    public static final short VERTICAL_JUSTIFY = 3;
    private Color fillColour = null;
    private CellDataFormat dataFormat = null;
    private int border = 0;
    private short textRotation = 0;
    private boolean bold = false;
    private HorizontalAlignment alignment = HorizontalAlignment.GENERAL;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
    private boolean wrap = false;

    public CellFormat setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public CellFormat setVerticalAlignment(VerticalAlignment alignment) {
        this.verticalAlignment = alignment;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public CellFormat setWrap(boolean b) {
        this.wrap = b;
        return this;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public CellFormat setBorder(int border) {
        this.border = border;
        return this;
    }

    public int getBorder() {
        return this.border;
    }

    public CellFormat setFillColour(Color color) {
        this.fillColour = color;
        return this;
    }

    public Color getFillColour() {
        return this.fillColour;
    }

    public CellFormat setDataFormat(CellDataFormat format) {
        this.dataFormat = format;
        return this;
    }

    public CellDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CellFormat setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public boolean getBold() {
        return this.bold;
    }

    public short getTextRotation() {
        return this.textRotation;
    }

    public CellFormat setTextRotation(short textRotation) {
        if (textRotation > 90 || textRotation < -90) {
            throw new IllegalArgumentException("Text rotation must be a value from -90 to 90.");
        }
        this.textRotation = textRotation;
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + Objects.hashCode(this.fillColour);
        hash = 19 * hash + Objects.hashCode((Object)this.dataFormat);
        hash = 19 * hash + this.border;
        hash = 19 * hash + this.textRotation;
        hash = 19 * hash + (this.bold ? 1 : 0);
        hash = 19 * hash + this.alignment.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellFormat other = (CellFormat)obj;
        if (this.border != other.border) {
            return false;
        }
        if (this.textRotation != other.textRotation) {
            return false;
        }
        if (this.bold != other.bold) {
            return false;
        }
        if (!Objects.equals(this.fillColour, other.fillColour)) {
            return false;
        }
        return this.dataFormat == other.dataFormat;
    }
}

