/*
 * Decompiled with CFR 0.152.
 */
package util.listener;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class WeakListenerList<T> {
    private static final Object MAP_VALUE = new Object();
    private Map<T, Object> weakListeners;

    public void addListener(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.weakListeners == null) {
            this.weakListeners = Collections.synchronizedMap(new WeakHashMap());
        }
        this.weakListeners.put(t, MAP_VALUE);
    }

    public void deleteListener(T t) {
        if (this.weakListeners == null) {
            return;
        }
        this.weakListeners.remove(t);
    }

    public void clearListeners() {
        if (this.weakListeners == null) {
            return;
        }
        this.weakListeners.clear();
    }

    public List<T> getListeners() {
        if (this.weakListeners == null) {
            return Collections.EMPTY_LIST;
        }
        return new LinkedList<T>(this.weakListeners.keySet());
    }

    public Stream<T> stream() {
        if (this.weakListeners == null) {
            return Stream.empty();
        }
        return this.weakListeners.keySet().stream();
    }

    public void notify(Consumer<? super T> consumer) {
        this.stream().forEach(consumer);
    }
}

