/*
 * Decompiled with CFR 0.152.
 */
package util.process;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import util.InvalidFieldException;
import util.SBException;
import util.process.ProcessMessage;
import util.process.SbugsProcessStep;

public abstract class SbugsProcess<T extends SbugsProcessStep> {
    private boolean isValidated = false;
    private boolean mainProcessComplete;
    private boolean postProcessComplete;
    private final Map<T, ProcessMessage<T>> messageMap = new HashMap<T, ProcessMessage<T>>();
    private ProcessResult result;

    public void go() throws InvalidFieldException, SQLException, SBException {
        if (this.result != null) {
            throw new IllegalStateException("Process has ended");
        }
        if (!this.isValidated) {
            boolean isValid = this.validate();
            if (!isValid) {
                return;
            }
            this.isValidated = true;
        }
        if (!this.mainProcessComplete) {
            try {
                this.process();
                if (this.getCurrentMessage() != null) {
                    return;
                }
                this.mainProcessComplete = true;
            }
            catch (RuntimeException | SQLException | SBException e) {
                this.result = ProcessResult.FAIL;
                throw e;
            }
        }
        if (!this.postProcessComplete) {
            this.postProcess();
            if (this.getCurrentMessage() != null) {
                return;
            }
            this.postProcessComplete = true;
        }
        this.result = ProcessResult.SUCCESS;
    }

    protected abstract boolean validate() throws InvalidFieldException, SQLException, SBException;

    protected abstract void process() throws SQLException, SBException;

    protected void postProcess() throws SQLException, SBException {
        this.postProcessComplete = true;
    }

    protected void addProcessMessage(String message, String title, T type) {
        this.messageMap.put(type, new ProcessMessage<T>(message, title, type));
    }

    public boolean isReady() {
        return this.result == null;
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public ProcessMessage getCurrentMessage() {
        for (ProcessMessage<T> m : this.messageMap.values()) {
            if (m.getResponse() != null) continue;
            return m;
        }
        return null;
    }

    public boolean hasResponse(T messageType) {
        ProcessMessage<T> message = this.messageMap.get(messageType);
        if (message != null) {
            return message.getResponse() != null;
        }
        return false;
    }

    public ProcessMessage.Response getResponse(T messageType) {
        ProcessMessage<T> message = this.messageMap.get(messageType);
        if (message != null) {
            return message.getResponse();
        }
        return null;
    }

    public void setResponse(ProcessMessage.Response response) {
        ProcessMessage message = this.getCurrentMessage();
        if (message == null) {
            throw new IllegalStateException("Can't set response when there is no current message");
        }
        message.setResponse(response);
        if (response == ProcessMessage.Response.CANCEL) {
            this.result = ProcessResult.FAIL;
        }
    }

    public ProcessResult getResult() {
        return this.result;
    }

    public static enum ProcessResult {
        SUCCESS,
        FAIL;

    }
}

